{u_sequence_melting.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit U_sequence_melting;

interface

uses math, shellapi,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TSequence_melting = class(TForm)
    edGC: TEdit;
    lbGC: TLabel;
    lbFA: TLabel;
    edFA: TEdit;
    lbSalt: TLabel;
    edSalt: TEdit;
    Button1: TButton;
    lbLength: TLabel;
    edLength: TEdit;
    lbMelting: TLabel;
    edMelting: TEdit;
    btHelp: TButton;
    procedure edFAKeyPress(Sender: TObject; var Key: Char);
    procedure edFAChange(Sender: TObject);
    procedure btHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Sequence_melting: TSequence_melting;

implementation
uses u_biotools;

{$R *.dfm}

procedure TSequence_melting.edFAKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TSequence_melting.edFAChange(Sender: TObject);
begin
if (edSalt.text<>'') and (edFA.text<>'') and (strtofloat2(edSalt.text)>0) then
   edMelting.text:=long_seq_melting(strtofloat2(edSalt.text),strtofloat2(edGC.text),strtofloat2(edFA.text),strtoint(edLength.text))
else
   edMelting.text:='';
end;

procedure TSequence_melting.btHelpClick(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\sequence_melting.html'),Nil,Nil,SW_NORMAL)
end;

end.
