procedure base_composition(seqname:shortstring;sl:string;p1,p2:integer);
var t,t2:byte;
    i:integer;
    compt:array[1..124] of integer;
    flagok:boolean;

begin
with frmMain do
begin
dynform:=tfrmResults.create(application);
with dynform do
    begin
    rxresults.clear;
    flagstop:=false;

    frmProgress.caption:='Determining base composition...';
    frmProgress.label1.caption:='Please wait...';
    frmProgress.btnCancel.visible:=true;
    application.processmessages;
    frmProgress.progressbar1.position:=0;
    frmProgress.show;

    // base frequence
    for t:=1 to 5 do
        compt[t]:=0;
    for i:=1 to length(sl) do
        begin
        flagok:=false;
        for t:=1 to 4 do
            if sl[i]=base[t] then
               begin
               inc(compt[t]);
               flagok:=true;
               end;
        if not flagok then
           inc(compt[5]);
        application.processmessages;
        if flagstop then
           begin
           frmProgress.hide;
           exit;
           end;
        frmProgress.progressbar1.position:=round(i/length(sl)*33);
        end;

    caption:='Base composition';
    rxresults.lines.add('Base composition of: '+seqname+'   '+date_time);
    rxresults.lines.add('');

    rxresults.lines.add(format('Selection: %d > %d',[p1,p2]));
    rxresults.lines.add('Length: '+inttostr(length(sl)));

    rxresults.lines.add('');
    rxresults.lines.add('Nucleotide''s frequencies:');
    rxresults.lines.add('--------------------------');
    rxresults.lines.add('');
    for t:=1 to 5 do
        rxresults.lines.add(base[t]+': '+inttostr(compt[t])+'   '+FloatToStrF(compt[t]*100/length(sl),ffgeneral,4,4)+'%');

    //dinucleotide frequence
    for t:=1 to 24 do
        compt[t]:=0;
    for i:=1 to length(sl)-1 do
        begin
        inc(compt[pos(sl[i],base)*5+pos(sl[i+1],base)]);
        application.processmessages;
        if flagstop then
           begin
           frmProgress.hide;
           exit;
           end;
        frmProgress.progressbar1.position:=round(33+i/length(sl)*33);
        end;

    rxresults.lines.add('');
    rxresults.lines.add('Dinucleotide frequencies:');
    rxresults.lines.add('-------------------------');
    rxresults.lines.add('');

    for i:=1 to 4 do
        for t:=1 to 4 do
            rxresults.lines.add(base[i]+base[t]+'    '+inttostr(compt[i*5+t])+'  '+FloatToStrF(compt[i*5+t]*100/(length(sl) div 2),ffgeneral,4,4)+'%');

    //trinucl. frequence
    for t:=1 to 124 do
        compt[t]:=0;
    for i:=1 to length(sl)-2 do
        begin
        inc(compt[pos(sl[i],base)*25+pos(sl[i+1],base)*5+pos(sl[i+2],base)]);
        application.processmessages;
        if flagstop then
           begin
           frmProgress.hide;
           exit;
           end;
        frmProgress.progressbar1.position:=round(66+i/length(sl)*33);
        end;

    rxresults.lines.add('');
    rxresults.lines.add('Trinucleotide frequencies:');
    rxresults.lines.add('--------------------------');
    rxresults.lines.add('');

    for i:=1 to 4 do
        for t:=1 to 4 do
            for t2:=1 to 4 do
                rxresults.lines.add(base[i]+base[t]+base[t2]+'    '+inttostr(compt[i*25+t*5+t2])+'  '+FloatToStrF(compt[i*25+t*5+t2]*100/(length(sl) div 2),ffgeneral,4,4)+'%');

    frmProgress.hide;
    show;
    end;
    end;//with
end;
