{local_alignment.pas - AnnHyb
 	Copyright (C) 1997-2004 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

Copyright (C) 1997-2004 Olivier Friard

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit local_alignment;

interface
uses math,StrUtils,classes,sysutils;
procedure loc_al(s1,s2:string;var sl:tstringlist);
//s1 seq longue
//s2 seq courte

implementation

uses forms,u_biotools;

function match_iub(c1,c2:char):boolean;
type str4=string[4];

const code:array[1..25] of str4=('A','CGT','C','AGT','','','G','ACT','',
      '','TG','','CA','ACGT','','','','AG','CG','T','U','ACG','AT','','CT');
begin
if (c1=c2) (*or (pos(c1,code[ord(c2)-64])<>0) or (pos(c2,code[ord(c1)-64])<>0)*) then
   match_iub:=true
else
   match_iub:=false;
end;

procedure loc_al(s1,s2:string;var sl:tstringlist);
var n:array of array of integer;
    l1,l2:shortstring;
    i,j,a,b,c,maxi,mi,mj,i2,j2,ni,nj:integer;
    k:string;

const matchW=10;
      mismatchW=-9;
      gapW=-20;

label suite,results;

begin
ni:=length(s1);
nj:=length(s2);

setlength(n,ni+1,nj+1);

for i:=0 to ni do
    for j:=0 to nj do
        n[i,j]:=0;

maxi:=-100000;
for i:=1 to length(s1) do
    for j:=1 to length(s2) do
        begin
        application.processmessages;

        if match_iub(s1[i],s2[j]) then
              a:=n[i-1,j-1]+matchW
        else
              a:=n[i-1,j-1]+mismatchW;

        b:=n[i,j-1]+gapW;
        c:=n[i-1,j]+gapW;
        //local alignment
        n[i,j]:=max(max(0,a),max(b,c));
        if n[i,j]>maxi then
           begin
           maxi:=n[i,j];
           mi:=i;
           mj:=j;
           end;
        end;

if maxi=0 then //seq not found
   begin
   sl.add('0');
   exit;
   end;

//print matrix
(*
for i:=0 to length(s1) do
    begin
    s:='';
    for j:=0 to length(s2) do
        begin
        s:=s+inttostr(n[i,j])+'  ';
        end;
    memo1.lines.add(s);
    end;
*)

//search all max scores
for i2:=1 to length(s1) do
    for j2:=1 to length(s2) do
        if (n[i2,j2]=maxi) then
            begin
            mi:=i2;
            mj:=j2;
            //backtracking
            i:=mi;
            j:=mj;

            l1:=s1[i];
            l2:=s2[j];

            suite:
            if (i=1) or (j=1) or (n[i,j]=0) then
                begin
                results:

                l1:=reversestring(l1);
                l2:=reversestring(l2);

                sl.add(inttostr(i-j+1)); //position of seq 2 on seq 1

                sl.add(floattostr2(maxi/min(length(s1),length(s2))/matchW*100)); //score %

                sl.add(trim(DupeString(' ',i-j)+copy(s2,1,j-1)+l2+copy(s2,mj+1,maxint)));

                k:=copy(DupeString(' ',j-i)+copy(s1,1,i-1)+l1+copy(s1,mi+1,maxint),i-j+1,length(trim(DupeString(' ',i-j)+copy(s2,1,j-1)+l2+copy(s2,mj+1,2147483647))));
                sl.add(k);

                continue;
                end;

            a:=n[i-1,j-1];
            b:=n[i,j-1];
            c:=n[i-1,j];

            if (a=0) and (b=0) and (c=0) then
                goto results;

            if ((n[i,j]=n[i-1,j-1]+matchW) and (match_iub(s1[i],s2[j])))
               or ((n[i,j]=n[i-1,j-1]+mismatchW) and (not match_iub(s1[i],s2[j]))) then
                begin
                i:=i-1;
                j:=j-1;
                l1:=l1+s1[i];
                l2:=l2+s2[j];
                goto suite;
                end;

            if n[i,j]=n[i,j-1]+gapW then
                begin
                j:=j-1;
                insert('-',l1,length(l1));
                l2:=l2+s2[j];
                goto suite;
                end;

            if n[i,j]=n[i-1,j]+gapW then
                begin
                i:=i-1;
                l1:=l1+s1[i];
                insert('-',l2,length(l2));
                goto suite;
                end;
            end;//screen maxi

end;//loc_al
end.
