{save_load_xml.pas - AnnHyb
 	Copyright (C) 1997-2008 Olivier Friard

  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}


unit save_load_xml;

interface
procedure save_xml(s:string);
procedure load_xml(s:string);

implementation
uses u_projectinformation,variants,seq,u_annhyb,XMLIntf,sysutils,dialogs,comCtrls,classes,u_biotools,u_options;

procedure save_xml;
var XMLnode,XMLnode1,XMLnode2,XMLoligonucleotides,
    XMLsequences,XMLsequence,
    XMLMAs,XMLMA:IXMLNode;
    i:integer;
    sl:tstringlist;

begin
with frmMain do
   begin
   XMLDoc.DocumentElement:=XMLDoc.createElement('annhyb','');
   XMLNode1:=XMLDoc.DocumentElement.addchild('project');
   XMLNode2:=XMLNode1.addchild('description');
   XMLNode2.settext(frmProjectDescription.mm_projectDescription.text);
   if numoligo>0 then
      begin
      XMLoligonucleotides:=XMLDOC.DocumentElement.addchild('oligonucleotides');
      for i:=0 to tv.Items.Count-1 do
          if tv.Items[i].imageindex=c_oligo then
              begin
              //calcul_param(pTo(tv.Items[i].Data)^.seq,l,nb_degen,dblmw,dblmec,dblgc);
              XMLNode1:=XMLoligonucleotides.addchild('oligo');
              XMLnode2:=XMLNode1.addchild('oligo_name');
              XMLnode2.settext(pTo(tv.Items[i].Data)^.name);
              XMLnode2:=XMLNode1.addchild('oligo_seq');
              XMLnode2.settext(pTo(tv.Items[i].Data)^.seq);
              XMLnode2:=XMLNode1.addchild('oligo_notes');
              XMLnode2.settext(pTo(tv.Items[i].Data)^.notes);
              XMLnode2:=XMLNode1.addchild('oligo_salt_concentration');
              XMLnode2.settext(floattostr2(pTo(tv.Items[i].Data)^.salt));
              XMLnode2:=XMLNode1.addchild('oligo_concentration');
              XMLnode2.settext(floattostr2(pTo(tv.Items[i].Data)^.conc));
              end;
      end;
   if numseq>0 then
      begin
      XMLsequences:=XMLDOC.DocumentElement.addchild('sequences');
      for i:=0 to tv.Items.Count-1 do
          if tv.Items[i].imageindex=c_sequence then
             begin
             XMLsequence:=XMLsequences.addchild('sequence');
             XMLnode:=XMLsequence.addchild('sequence_name');
             XMLnode.settext(pSq(tv.Items[i].Data)^.name);
             if trim(pSq(tv.Items[i].Data)^.longname)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_longname');
                XMLnode.settext(pSq(tv.Items[i].Data)^.longname);
                end;
             if trim(pSq(tv.Items[i].Data)^.descrip)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_description');
                XMLnode.settext(pSq(tv.Items[i].Data)^.descrip);
                end;
             if trim(pSq(tv.Items[i].Data)^._type)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_type');
                XMLnode.settext(pSq(tv.Items[i].Data)^._type);
                end;
             if trim(pSq(tv.Items[i].Data)^.creator)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_author');
                XMLnode.settext(pSq(tv.Items[i].Data)^.creator);
                end;
             if trim(pSq(tv.Items[i].Data)^.creationdate)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_creation_date');
                XMLnode.settext(pSq(tv.Items[i].Data)^.creationdate);
                end;
             if trim(pSq(tv.Items[i].Data)^.hrsf)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_header');
                sl:=tstringlist.create;
                sl.text:=pSq(tv.Items[i].Data)^.hrsf;
                XMLnode.settext(sl.text);
                sl.free;
                end;
             if trim(pSq(tv.Items[i].Data)^.features)<>'' then
                begin
                XMLnode:=XMLsequence.addchild('sequence_features');
//                sss:=pSq(tv.Items[i].Data)^.features;
                XMLnode.settext(pSq(tv.Items[i].Data)^.features);
                end;
             XMLnode:=XMLsequence.addchild('sequence_seq');
             XMLnode.settext(pSq(tv.Items[i].Data)^.seq);
             end;
      end;
   if numMA>0 then
      begin
      XMLMAs:=XMLDOC.DocumentElement.addchild('multi-alignments');
      for i:=0 to tv.Items.Count-1 do
          if tv.Items[i].imageindex=c_al then
             begin
             XMLMA:=XMLMAs.addchild('multi-alignment');
             XMLnode:=XMLMA.addchild('ma_name');
             XMLnode.settext(pAl(tv.Items[i].Data)^.name);
             XMLnode:=XMLMA.addchild('ma_seq_name');
             XMLnode.settext(pAl(tv.Items[i].Data)^.namel.text);
             XMLnode:=XMLMA.addchild('ma_seq_seq');
             XMLnode.settext(pAl(tv.Items[i].Data)^.seql.text);
             end;
     end;
   xmldoc.Encoding:='ISO-8859-15';
//   xmldoc.Encoding:=xetUTF_8;
   xmldoc.version:='1.0';
   xmldoc.StandAlone:='yes';
   xmldoc.SaveToFile(s);
   end; //with
end; //save_xml

procedure DomToTree(XmlNode:IXMLNode);

function load_text(v:variant):string;
var s:string;
    sl:tstringlist;
    j:integer;
begin
sl:=tstringlist.Create;
try sl.text:=v;
except sl.Text:='';
end;
s:='';
if sl.count>0 then
    for j:=0 to sl.Count-1 do
        s:=s+sl[j]+CRLF;
sl.free;
load_text:=s;
end; //load text

var i,l,j:integer;
    TNode:TTreeNode;
    sl:tstringlist;
//    s:string;
begin
if XmlNode.NodeType <> ntElement then
   Exit;

//project description
if XmlNode.NodeName='project' then
    if XmlNode.HasChildNodes then
      for i:=0 to xmlNode.ChildNodes.Count-1 do
          if xmlNode.ChildNodes[i].NodeName='description' then
             if xmlNode.ChildNodes[i].NodeValue<>Null then
                 frmProjectDescription.mm_projectDescription.text:=load_text(xmlNode.ChildNodes[i].NodeValue)
             else
                 frmProjectDescription.mm_projectDescription.text:='';

if XmlNode.NodeName='oligo' then
   begin
   inc(nb_oligo);
   new(o[nb_oligo]);
   o[nb_oligo]^.name:='';
   o[nb_oligo]^.seq:='';
   o[nb_oligo]^.salt:=strtoint(frmPreferences.defaut_sel.text)*1e-3;
   o[nb_oligo]^.conc:=strtoint(frmPreferences.defaut_amorces.text)*1e-9;
   //cherche section Oligo
   for l:=0 to frmMain.tv.items.count-1 do
       if frmMain.tv.items[l].text='Oligo' then
          break;
   if XmlNode.HasChildNodes then
      for i:=0 to xmlNode.ChildNodes.Count-1 do
          begin
          if xmlNode.ChildNodes[i].NodeName='oligo_name' then
              if xmlNode.ChildNodes[i].NodeValue<>Null then
                  o[nb_oligo]^.name:=xmlNode.ChildNodes[i].NodeValue
              else
                  o[nb_oligo]^.name:='';
          if xmlNode.ChildNodes[i].NodeName='oligo_seq' then
              if xmlNode.ChildNodes[i].NodeValue<>Null then
                  o[nb_oligo]^.seq:=xmlNode.ChildNodes[i].NodeValue
              else
                  o[nb_oligo]^.seq:='';
          if xmlNode.ChildNodes[i].NodeName='oligo_notes' then
             if xmlNode.ChildNodes[i].NodeValue<>Null then
                 o[nb_oligo]^.notes:=load_text(xmlNode.ChildNodes[i].NodeValue)
             else
                 o[nb_oligo]^.notes:='';
          if xmlNode.ChildNodes[i].NodeName='oligo_salt_concentration' then
             o[nb_oligo]^.salt:=strtofloat2(xmlNode.ChildNodes[i].NodeValue);
          if xmlNode.ChildNodes[i].NodeName='oligo_concentration' then
             o[nb_oligo]^.conc:=strtofloat2(xmlNode.ChildNodes[i].NodeValue);
          end;
   o[nb_oligo]^.found_seq:='';
   o[nb_oligo]^.found_ma:='';
   o[nb_oligo]^.view:=0; //none

   tnode:=frmMain.tv.Items.AddchildObject(frmMain.tv.Items[l],o[nb_oligo]^.name,o[nb_oligo]);
   tnode.makevisible;
   tnode.imageindex:=c_oligo;
   end;//oligo

if XmlNode.NodeName='sequence' then
   begin
   inc(nb_seq);
   new(sq[nb_seq]);
   sq[nb_seq]^.name:='';
   sq[nb_seq]^.longname:='';
   sq[nb_seq]^.descrip:='';
   sq[nb_seq]^._type:='';
   sq[nb_seq]^.creator:='';
   sq[nb_seq]^.creationdate:='';
   sq[nb_seq]^.hrsf:='';
   sq[nb_seq]^.features:='';
   sq[nb_seq]^.seq:='';
   sq[nb_seq]^.seqrtf:='';
   //position
   for l:=0 to frmMain.tv.items.count-1 do
       if frmMain.tv.items[l].text='Sequence' then
          break;
   if XmlNode.HasChildNodes then
      for i:=0 to xmlNode.ChildNodes.Count-1 do
          begin
          if xmlNode.ChildNodes[i].NodeName='sequence_name' then
             try sq[nb_seq]^.name:=xmlNode.ChildNodes[i].NodeValue; except sq[nb_seq]^.name:=''; end;
          if xmlNode.ChildNodes[i].NodeName='sequence_longname' then
              try sq[nb_seq]^.longname:=xmlNode.ChildNodes[i].NodeValue; except sq[nb_seq]^.longname:=''; end;
          if xmlNode.ChildNodes[i].NodeName='sequence_description' then
             sq[nb_seq]^.descrip:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='sequence_type' then
             sq[nb_seq]^._type:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='sequence_author' then
             sq[nb_seq]^.creator:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='sequence_creation_date' then
             sq[nb_seq]^.creationdate:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='sequence_header' then
             begin
//             sq[nb_seq]^.hrsf:=load_text(xmlNode.ChildNodes[i].NodeValue);
             sl:=tstringlist.Create;
             try sl.text:=xmlNode.ChildNodes[i].NodeValue; except sl.Text:=''; end;
             s:='';
             if sl.count>0 then
                for j:=0 to sl.Count-1 do
                    if sl[j]<>'comments' then
                       s:=s+sl[j]+CRLF;
             sq[nb_seq]^.hrsf:=s;
             sl.free;
             end;
          if xmlNode.ChildNodes[i].NodeName='sequence_features' then
             sq[nb_seq]^.features:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='sequence_seq' then
             sq[nb_seq]^.seq:=xmlNode.ChildNodes[i].NodeValue;
          end;
   sq[nb_seq]^.seqrtf:=sq[nb_seq]^.seq;
   frmMain.format_gcg(sq[nb_seq]^.seqrtf,1);
   tnode:=frmMain.tv.Items.AddchildObject(frmMain.tv.Items[l],sq[nb_seq]^.name,sq[nb_seq]);
   tnode.makevisible;
   tnode.imageindex:=c_sequence;
   end;

if XmlNode.NodeName='multi-alignment' then
   begin
   inc(nb_align);
   new(al[nb_align]);
   //position
   for l:=0 to frmMain.tv.items.count-1 do
       if frmMain.tv.items[l].text='Multiple alignment' then
          break;
   if XmlNode.HasChildNodes then
      for i:=0 to xmlNode.ChildNodes.Count-1 do
          begin
          if xmlNode.ChildNodes[i].NodeName='ma_name' then
             al[nb_align]^.name:=xmlNode.ChildNodes[i].NodeValue;
          if xmlNode.ChildNodes[i].NodeName='ma_seq_name' then
             begin
             al[nb_align]^.namel:=tstringlist.create;
             al[nb_align]^.namel.text:=xmlNode.ChildNodes[i].NodeValue;
             end;
          if xmlNode.ChildNodes[i].NodeName='ma_seq_seq' then
             begin
             al[nb_align]^.seql:=tstringlist.create;
             al[nb_align]^.seql.text:=xmlNode.ChildNodes[i].NodeValue;
             end;
          end;
          
   //add empty row to found Tstringlist
   al[nb_align]^.found:=tstringlist.create;
   for i:=0 to al[nb_align]^.namel.Count-1 do
       al[nb_align]^.found.add('');
   al[nb_align]^.consensus:=consensus(al[nb_align]^,80);
   tnode:=frmMain.tv.Items.AddchildObject(frmMain.tv.Items[l],al[nb_align]^.name,al[nb_align]);
   tnode.makevisible;
   tnode.imageindex:=c_al;
   end;

// add each child node
if XmlNode.HasChildNodes then
   for i:=0 to xmlNode.ChildNodes.Count-1 do
       DomToTree(xmlNode.ChildNodes.Nodes[I]);
end; //domtotree

procedure load_xml(s:string);
begin
with frmMain do
   begin
   XMLDoc.LoadFromFile(s);
   domToTree(XMLDoc.DocumentElement);
   end; //with
end; //load_xml

end.
