{u_sequenceattributes.pas - AnnHyb
 	Copyright (C) 1997-2005 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_SequenceAttributes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TfrmSequenceAttributes = class(TForm)
    s_name: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    s_description: TEdit;
    Label3: TLabel;
    s_type: TComboBox;
    Label4: TLabel;
    s_creator: TEdit;
    Label5: TLabel;
    s_creation_date: TDateTimePicker;
    Label6: TLabel;
    s_comments: TMemo;
    Button1: TButton;
    Button3: TButton;
    Label7: TLabel;
    s_longname: TEdit;
    s_checksum: TEdit;
    Label8: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var frmSequenceAttributes: TfrmSequenceAttributes;

implementation

uses u_features, u_annhyb;

{$R *.DFM}

procedure TfrmSequenceAttributes.FormActivate(Sender: TObject);
begin
s_name.setfocus;
end;

procedure TfrmSequenceAttributes.Button1Click(Sender: TObject);
var flag_name_already_used:boolean;
    i:integer;
begin
flag_name_already_used:=false;
with frmMain do
     for i:=0 to tv.Items.Count-1 do
         if (tv.Items[i]<>tv.selected) and (tv.Items[i].imageindex=c_sequence)
            and (ansiuppercase(s_name.text)=ansiuppercase(tv.Items[i].text)) then
               begin
               flag_name_already_used:=true;
               break;
               end;

if flag_name_already_used then
    begin
    showmessage('This name is already in use! Please choose an another name for this sequence');
    s_name.setfocus;
    end
else
    modalresult:=mrOK;
end;

end.
