{u_annhyb.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard

  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ TODO : add support for MSF alignment format }

{ TODO : print enthalpy and entropy }
{ TODO 1 : grer mismatch pour calcul Tm }
{ TODO : add Tm determination for oligo containing Inosine }
{ TODO : vrifier oligo doublons lors d'un "append project" }
{ TODO : verify multi alignment printing }


unit u_annhyb;
interface

uses u_results,u_translate,u_codon_usage,util,u_export_seq,save_load_xml,u_save_load_rsf,u_biotools,mmsystem,math,seq,inifiles,
     local_alignment,strutils,shellapi,printers,u_dimerloop,u_info,
     u_aboutbox,SysUtils, WinTypes, WinProcs, Messages, Classes,
     Graphics, Controls,forms, Dialogs, StdCtrls, Menus, Buttons, ComCtrls,
     OleCtrls,ScktComp, ExtCtrls, CheckLst,clipbrd, ColorGrd, ImgList,
     IdBaseComponent,IdComponent, IdTCPConnection, IdTCPClient,
     IdHTTP, IdException, RxRichEd, xmldom,XMLIntf, msxmldom, XMLDoc,
     dateutils, ToolWin,filectrl,ShlObj;

const version_date='April 14, 2012';
      version_number='4.946';
      version_type='';

type TfrmMain = class(TForm)
    MainMenu1: TMainMenu;
    mi_file: TMenuItem;
    mi_OpenProject: TMenuItem;
    mi_exit: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    mi_edit: TMenuItem;
    mi_copy: TMenuItem;
    mi_cut: TMenuItem;
    mi_paste: TMenuItem;
    od: TOpenDialog;
    SaveDialog1: TSaveDialog;
    N5: TMenuItem;
    pc: TPageControl;
    tb_oligo: TTabSheet;
    mi_NewProject: TMenuItem;
    seqtab: TTabSheet;
    mi_ExportOligo: TMenuItem;
    Tools1: TMenuItem;
    Retrievefromserver1: TMenuItem;
    Read2: TMenuItem;
    mi_Testoligofordimers: TMenuItem;
    Revertsequence1: TMenuItem;
    mi_ExportOligoData: TMenuItem;
    PrintDialog1: TPrintDialog;
    mi_PrintOligo: TMenuItem;
    Translatesequence1: TMenuItem;
    Restrictionanalysis1: TMenuItem;
    Ss1: TMenuItem;
    Searchforsequence1: TMenuItem;
    FindORF1: TMenuItem;
    Codonusage1: TMenuItem;
    Contents1: TMenuItem;
    Searchforprimers1: TMenuItem;
    Cryptdecryptsequence1: TMenuItem;
    Checkfornewversion1: TMenuItem;
    N7: TMenuItem;
    mi_Selectall: TMenuItem;
    StatusBar1: TStatusBar;
    Goto1: TMenuItem;
    N11: TMenuItem;
    Readclipboard1: TMenuItem;
    calcTm1: TMenuItem;
    Highlightsequence1: TMenuItem;
    N13: TMenuItem;
    PM_seq: TPopupMenu;
    UPPERcase1: TMenuItem;
    lowercase1: TMenuItem;
    UPPERcaseexceptg1: TMenuItem;
    N4: TMenuItem;
    Copy2: TMenuItem;
    Cut2: TMenuItem;
    Paste2: TMenuItem;
    Groupevery3bases1: TMenuItem;
    mi_RemoveOligo: TMenuItem;
    N6: TMenuItem;
    N14: TMenuItem;
    mi_recent: TMenuItem;
    N16: TMenuItem;
    Ungroup1: TMenuItem;
    il_16: TImageList;
    MainToolBar: TToolBar;
    tb_new: TToolButton;
    pm_tb_new: TPopupMenu;
    tb_open: TToolButton;
    tb_saveproject: TToolButton;
    ToolButton6: TToolButton;
    tb_copy: TToolButton;
    tb_cut: TToolButton;
    tb_paste: TToolButton;
    ToolButton9: TToolButton;
    Oligonucleotide3: TMenuItem;
    Sequence4: TMenuItem;
    tb_align_oligo: TToolButton;
    IdHTTP1: TIdHTTP;
    fd: TFontDialog;
    tb_retrieve: TToolButton;
    Splitter1: TSplitter;
    mmHeader: TMemo;
    mi_oligo: TMenuItem;
    Sequence6: TMenuItem;
    N15: TMenuItem;
    N19: TMenuItem;
    N20: TMenuItem;
    N10: TMenuItem;
    pmGCG: TPopupMenu;
    Copy4: TMenuItem;
    pmHeader: TPopupMenu;
    Copy5: TMenuItem;
    N3: TMenuItem;
    Copyallcharacters1: TMenuItem;
    pmtv: TPopupMenu;
    Font3: TMenuItem;
    mi_SaveProject: TMenuItem;
    N21: TMenuItem;
    mo_ExportMultiSequences: TMenuItem;
    pmTm: TPopupMenu;
    mo_breslauer1986: TMenuItem;
    mo_allawi1997: TMenuItem;
    Quicksearchforsequence1: TMenuItem;
    pm_tv: TPopupMenu;
    mi_tv_remove: TMenuItem;
    N12: TMenuItem;
    mi_RemoveAllSequence: TMenuItem;
    Quicksearcholigoinsequences1: TMenuItem;
    N22: TMenuItem;
    N23: TMenuItem;
    mi_search_SequenceHeader: TMenuItem;
    mo_ExportSequence: TMenuItem;
    N26: TMenuItem;
    pm_searchresults: TPopupMenu;
    mo_ViewAllResults: TMenuItem;
    N1: TMenuItem;
    mi_EditSequence: TMenuItem;
    Splitter3: TSplitter;
    rxgcgseq: TRxRichEdit;
    N27: TMenuItem;
    mi_tv_Moveup: TMenuItem;
    mi_tv_Movedown: TMenuItem;
    Selectsubsequence1: TMenuItem;
    N28: TMenuItem;
    N29: TMenuItem;
    mi_Printoligolist: TMenuItem;
    lb_copyright: TLabel;
    N31: TMenuItem;
    Workspace2: TMenuItem;
    ools1: TMenuItem;
    tb_up: TToolButton;
    tb_down: TToolButton;
    il_color: TImageList;
    Splitter4: TSplitter;
    ed_seq_name: TEdit;
    ed_seq_longname: TEdit;
    ed_seq_descrip: TEdit;
    ed_seq_type: TEdit;
    ed_seq_checksum: TEdit;
    ed_seq_creator: TEdit;
    ed_seq_creationdate: TEdit;
    pa_infoseq: TPanel;
    tabSeqlist: TTabSheet;
    lvSeq: TListView;
    tabOligolist: TTabSheet;
    lbSeqName: TLabel;
    lbLongName: TLabel;
    lbDescr: TLabel;
    lbtype: TLabel;
    lbChecksum: TLabel;
    lbCreationDate: TLabel;
    lbAuthor: TLabel;
    PCRproduct1: TMenuItem;
    Melting1: TMenuItem;
    mi_AddSelectedSeqFeatures1: TMenuItem;
    N32: TMenuItem;
    mi_NewOligo: TMenuItem;
    mi_ImportOligo: TMenuItem;
    N33: TMenuItem;
    mi_newSequence: TMenuItem;
    mi_OpenSequence: TMenuItem;
    mi_saveprojectAs: TMenuItem;
    Search1: TMenuItem;
    pm_seqlist: TPopupMenu;
    mi_PrintSequenceslist2: TMenuItem;
    pm_oligolist: TPopupMenu;
    Printoligolist2: TMenuItem;
    tabMA: TTabSheet;
    reName: TRxRichEdit;
    re: TRxRichEdit;
    sbv: TScrollBar;
    sbh: TScrollBar;
    mi_MA: TMenuItem;
    mi_ImportMA: TMenuItem;
    mi_PrintMA: TMenuItem;
    mi_EditSequenceAttributes: TMenuItem;
    pm_lvannotations: TPopupMenu;
    PCRproduct2: TMenuItem;
    Editfeatures1: TMenuItem;
    N35: TMenuItem;
    Clearresults1: TMenuItem;
    Uncheckallresults1: TMenuItem;
    Checkallresults1: TMenuItem;
    mi_CloseProject: TMenuItem;
    tabMAList: TTabSheet;
    mi_Exportoligolist: TMenuItem;
    lvMA: TListView;
    mi_exportSequencelist2: TMenuItem;
    N36: TMenuItem;
    mi_ExportFeatures: TMenuItem;
    split_ma: TSplitter;
    edLength: TEdit;
    lbLength: TLabel;
    N37: TMenuItem;
    Quicksearcholigoinmultialignment2: TMenuItem;
    XMLDoc: TXMLDocument;
    Alignoligoinmultialignment1: TMenuItem;
    N38: TMenuItem;
    mi_AppendProject: TMenuItem;
    mi_cleanMA: TMenuItem;
    pm_reName: TPopupMenu;
    Removesequence1: TMenuItem;
    recipient_tv: TPanel;
    tv: TTreeView;
    Panel2: TPanel;
    Panel3: TPanel;
    lbName: TLabel;
    lbSeq1: TLabel;
    lbIUB: TLabel;
    lbRevComp1: TLabel;
    lbRevcomp3: TLabel;
    lbSeq2: TLabel;
    Label1: TLabel;
    lbRevComp4: TLabel;
    lbLength1: TLabel;
    lbMW: TLabel;
    lbGC: TLabel;
    lbGCGChecksum: TLabel;
    lbMEC: TLabel;
    lbLength2: TLabel;
    unite_mec: TLabel;
    lbTM1: TLabel;
    lbTM2: TLabel;
    lbTmAlgo: TLabel;
    lbPrimers2: TLabel;
    lbPrimers1: TLabel;
    lbSalt2: TLabel;
    lbSalt1: TLabel;
    lbSearchResults: TLabel;
    rev: TEdit;
    ed_oligo_name: TEdit;
    seq: TEdit;
    seq_iupac: TEdit;
    len: TEdit;
    mw: TEdit;
    gc: TEdit;
    gcgchecksum: TEdit;
    mec: TEdit;
    melt: TEdit;
    ed_oligo_cc: TEdit;
    ed_oligo_salt_cc: TEdit;
    lvAlign: TListView;
    cbColor: TComboBoxEx;
    dock_oligolist: TPanel;
    panel_oligolist: TPanel;
    lv_oligo: TListView;
    N24: TMenuItem;
    mi_Clearhighlightedregions1: TMenuItem;
    N25: TMenuItem;
    mi_CheckAllOligo: TMenuItem;
    mi_UncheckAllOligo: TMenuItem;
    mi_InverseOligoChecking: TMenuItem;
    N30: TMenuItem;
    mi_RemoveFeaturesFromAllSequences: TMenuItem;
    mi_Features: TMenuItem;
    mi_mainmenu_Removefeaturesfromallsequences: TMenuItem;
    mi_RemoveFeaturesFromSelectedSequence: TMenuItem;
    mi_Removeallfeatures: TMenuItem;
    N39: TMenuItem;
    Removeselectedsequencefromaligment1: TMenuItem;
    pn_ma_info: TPanel;
    Splitter2: TSplitter;
    Label2: TLabel;
    ed_ma_position: TEdit;
    lb_ma_name: TLabel;
    ed_ma_name: TEdit;
    N8: TMenuItem;
    Editsequenceattributes1: TMenuItem;
    ToolButton1: TToolButton;
    ToolButton3: TToolButton;
    N40: TMenuItem;
    mo_ViewAllAlignments: TMenuItem;
    mo_viewalignment: TMenuItem;
    mo_web: TMenuItem;
    tb_tools: TToolButton;
    pm_tb_tools: TPopupMenu;
    mi_print: TMenuItem;
    mi_sequence: TMenuItem;
    Sequenceslist1: TMenuItem;
    pmi_restriction_analysis: TMenuItem;
    pmi_translate_sequence: TMenuItem;
    pmi_Reverse_complement_sequence: TMenuItem;
    pmi_Find_ORF: TMenuItem;
    pmi_Base_composition: TMenuItem;
    pmi_Codon_usage: TMenuItem;
    pmi_Crypt_Decrypt_sequence: TMenuItem;
    pmi_PCR_product: TMenuItem;
    pmi_Melting_temperature: TMenuItem;
    sb: TSpeedButton;
    mi_export: TMenuItem;
    mi_ExportOligoList2: TMenuItem;
    mi_print2: TMenuItem;
    mi_Export1: TMenuItem;
    mi_Exportsequencelist1: TMenuItem;
    N41: TMenuItem;
    mi_preferences: TMenuItem;
    SpeedButton1: TSpeedButton;
    mi_Projectinformation: TMenuItem;
    N2: TMenuItem;
    mi_AddSelectedSeqFeatures: TMenuItem;
    mi_ExportFeatures2: TMenuItem;
    N9: TMenuItem;
    mi_InsertSeq: TMenuItem;
    mi_DeleteSeq: TMenuItem;
    mi_cropSeq: TMenuItem;
    N17: TMenuItem;
    il_24: TImageList;
    N18: TMenuItem;
    mi_tv_copy: TMenuItem;
    mi_tv_cut: TMenuItem;
    mi_tv_paste: TMenuItem;
    N34: TMenuItem;
    Crop1: TMenuItem;
    ToolButton5: TToolButton;
    pmi_dimer_hairpin: TMenuItem;
    N42: TMenuItem;
    N43: TMenuItem;
    Goto2: TMenuItem;
    N44: TMenuItem;
    N45: TMenuItem;
    mi_RemoveMA: TMenuItem;
    N46: TMenuItem;
    edConsensus: TEdit;
    Label3: TLabel;
    N47: TMenuItem;
    mi_Consensus: TMenuItem;
    Memo1: TMemo;
    lbHomol: TLabel;
    edHomol: TEdit;
    Label4: TLabel;
    Removesequencesfrommultialignment1: TMenuItem;
    N48: TMenuItem;
    mi_Addselectedsequenceinfeatures2: TMenuItem;
    ConvertselectedsequencetpUPPERcase1: TMenuItem;
    Convertselectedsequencetolowercase1: TMenuItem;
    N49: TMenuItem;
    tb_help: TToolButton;
    tb_print: TToolButton;
    pm_print: TPopupMenu;
    Oligo1: TMenuItem;
    Sequences1: TMenuItem;
    PrintOligos1: TMenuItem;
    Printoligolist1: TMenuItem;
    Printsequences1: TMenuItem;
    Printsequencelist1: TMenuItem;
    tb_edit: TToolButton;
    tb_annotations: TToolButton;
    N50: TMenuItem;
    lbSequenceHeader: TLabel;
    pa_sequenceAnnotations: TPanel;
    lvAnnotations: TListView;
    lbSequenceAnnotations: TLabel;
    Exportconsensussequence1: TMenuItem;
    procedure PlaySound(WavFileName: String);
    procedure mi_ExitClick(Sender: TObject);
    procedure seqChange(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ed_oligo_salt_ccChange(Sender: TObject);
    procedure ed_oligo_ccChange(Sender: TObject);
    procedure mi_copyClick(Sender: TObject);
    procedure mi_pasteClick(Sender: TObject);
    procedure informationsClick(Sender: TObject);
    procedure Exportoligonucleotidedata1Click(Sender: TObject);
    procedure create(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure close_(Sender: TObject; var Action: TCloseAction);
    procedure pcChange(Sender: TObject);
    procedure mi_TestoligofordimersClick(Sender: TObject);
    procedure Retrievefromserver3Click(Sender: TObject);
    procedure Oligonucleotide1Click(Sender: TObject);
    procedure mi_OpenSequenceClick(Sender: TObject);
    procedure new_oligoClick(Sender: TObject);
    procedure mi_newSequenceClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure revChange(Sender: TObject);
    procedure Memo2Change(Sender: TObject);
    procedure mi_alignPrimersClick(Sender: TObject);
    procedure Checkfornewversion1Click(Sender: TObject);
    procedure mi_SelectallClick(Sender: TObject);
    procedure Goto1Click(Sender: TObject);
    procedure m1Click(Sender: TObject);
    procedure calcTm1Click(Sender: TObject);
    procedure EditFeaturesClick(Sender: TObject);
    procedure prefClick(Sender: TObject);
    procedure Viewsequenceattributes1Click(Sender: TObject);
    procedure UPPERcase1Click(Sender: TObject);
    procedure lowercase1Click(Sender: TObject);
    procedure UPPERcaseexceptg1Click(Sender: TObject);
    procedure PM_seqPopup(Sender: TObject);
    procedure Groupevery3bases1Click(Sender: TObject);
    procedure mi_RemoveOligoClick(Sender: TObject);
    procedure odClose(Sender: TObject);
    procedure odShow(Sender: TObject);
    procedure Tools(Sender: TObject);
    procedure menuHandler(Sender: TObject);
    procedure seqKeyPress(Sender: TObject; var Key: Char);
    procedure ed_oligo_salt_ccKeyPress(Sender: TObject; var Key: Char);
    procedure Ungroup1Click(Sender: TObject);
    procedure Ungruop1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure tb_newClick(Sender: TObject);
    procedure SequencefFont1Click(Sender: TObject);
    procedure tvChange(Sender: TObject; Node: TTreeNode);
    procedure tb_retrieveClick(Sender: TObject);
    procedure Copy4Click(Sender: TObject);
    procedure Copyallcharacters1Click(Sender: TObject);
    procedure Copy5Click(Sender: TObject);
    procedure Font3Click(Sender: TObject);
    procedure mi_ExportOligoClick(Sender: TObject);
    procedure mo_ExportMultiSequencesClick(Sender: TObject);
    procedure mi_SaveProjectClick(Sender: TObject);
    procedure mo_TmAlgoClick(Sender: TObject);
    procedure Quicksearchforsequence1Click(Sender: TObject);
    procedure mi_tv_removeClick(Sender: TObject);
    procedure mi_RemoveAllSequenceClick(Sender: TObject);
    procedure Quicksearcholigoinsequences1Click(Sender: TObject);
    procedure lvAlignClick(Sender: TObject);
    procedure lvAlignDblClick(Sender: TObject);
    procedure mi_search_SequenceHeaderClick(Sender: TObject);
    procedure mi_OpenProjectClick(Sender: TObject);
    procedure mo_ExportSequenceClick(Sender: TObject);
    procedure mi_PrintOligoClick(Sender: TObject);
    procedure Printsequence1Click(Sender: TObject);
    procedure mo_ViewAllResultsClick(Sender: TObject);
    procedure mi_EditSequenceClick(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure tvChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure Rxgcgseq2SelectionChange(Sender: TObject);
    procedure RxgcgseqEnter(Sender: TObject);
    procedure mmHeaderEnter(Sender: TObject);
    procedure ed_seq_nameEnter(Sender: TObject);
    procedure mi_cutClick(Sender: TObject);
    procedure rxgcgseqSelectionChange(Sender: TObject);
    procedure RxRichEdit1Enter(Sender: TObject);
    procedure mi_tv_MovedownClick(Sender: TObject);
    procedure mi_tv_MoveupClick(Sender: TObject);
    procedure Selectsubsequence1Click(Sender: TObject);
    procedure mi_PrintoligolistClick(Sender: TObject);
    procedure mi_NewProjectClick(Sender: TObject);
    procedure ed_seq_longnameChange(Sender: TObject);
    procedure ed_seq_descripChange(Sender: TObject);
    procedure ed_seq_typeChange(Sender: TObject);
    procedure ed_seq_creatorChange(Sender: TObject);
    procedure ed_seq_creationdateChange(Sender: TObject);
    procedure Workspace2Click(Sender: TObject);
    procedure tb_upClick(Sender: TObject);
    procedure tb_downClick(Sender: TObject);
    procedure PCRproduct1Click(Sender: TObject);
    procedure lvAnnotationsDblClick(Sender: TObject);
    procedure ed_oligo_nameChange(Sender: TObject);
    procedure ed_seq_nameChange(Sender: TObject);
    procedure mi_AddSelectedSeqFeaturesClick(Sender: TObject);
    procedure ed_seq_checksumKeyPress(Sender: TObject; var Key: Char);
    procedure cbColorChange(Sender: TObject);
    procedure cbColorEnter(Sender: TObject);
    procedure lvSeqColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvSeqCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure lv_oligoColumnClick(Sender: TObject; Column: TListColumn);
    procedure lv_oligoCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure tvDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tvDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Printsequenceslist1Click(Sender: TObject);
    procedure mi_PrintSequenceslist2Click(Sender: TObject);
    procedure Printoligolist2Click(Sender: TObject);
    procedure mi_ImportMAClick(Sender: TObject);
    procedure sbhChange(Sender: TObject);
    procedure sbvChange(Sender: TObject);
    procedure lv_oligoDblClick(Sender: TObject);
    procedure lvSeqDblClick(Sender: TObject);
    procedure mi_PrintMAClick(Sender: TObject);
    procedure lvAlignColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvAlignCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure mi_EditSequenceAttributesClick(Sender: TObject);
    procedure Clearresults1Click(Sender: TObject);
    procedure Checkallresults1Click(Sender: TObject);
    procedure mi_CloseProjectClick(Sender: TObject);
    procedure mi_ExportoligolistClick(Sender: TObject);
    procedure mi_exportSequencelist2Click(Sender: TObject);
    procedure ExportFeaturesClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure split_maMoved(Sender: TObject);
    procedure Quicksearcholigoinmultialignment2Click(Sender: TObject);
    procedure Alignoligoinmultialignment1Click(Sender: TObject);
    procedure lvMAColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvMACompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure tvEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure tvEdited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure mi_cleanMAClick(Sender: TObject);
    procedure Removesequence1Click(Sender: TObject);
    procedure rxgcgseqMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure reNameMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ed_seq_nameKeyPress(Sender: TObject; var Key: Char);
    procedure Panel2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure panel_oligolistMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure mi_Clearhighlightedregions1Click(Sender: TObject);
    procedure mi_CheckAllOligoClick(Sender: TObject);
    procedure mi_InverseOligoCheckingClick(Sender: TObject);
    procedure mi_RemoveFeaturesFromAllSequencesClick(Sender: TObject);
    procedure mi_RemoveFeaturesFromSelectedSequenceClick(Sender: TObject);
    procedure ed_ma_nameChange(Sender: TObject);
    procedure Editsequenceattributes1Click(Sender: TObject);
    procedure tvMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mo_ViewAllAlignmentsClick(Sender: TObject);
    procedure mo_webClick(Sender: TObject);
    procedure lv_oligoClick(Sender: TObject);
    procedure recent_project_Handler(Sender: TObject);
    procedure sbClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure mi_ProjectinformationClick(Sender: TObject);
    procedure mi_InsertSeqClick(Sender: TObject);
    procedure mi_DeleteSeqClick(Sender: TObject);
    procedure tvDblClick(Sender: TObject);
    procedure mi_cropSeqClick(Sender: TObject);
    procedure ed_oligo_nameKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ed_seq_nameKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ed_ma_nameKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Crop1Click(Sender: TObject);
    procedure mi_RemoveMAClick(Sender: TObject);
    procedure mi_ConsensusClick(Sender: TObject);
    procedure edHomolKeyPress(Sender: TObject; var Key: Char);
    procedure edHomolExit(Sender: TObject);
    procedure Removesequencesfrommultialignment1Click(Sender: TObject);
    procedure ConvertselectedsequencetpUPPERcase1Click(Sender: TObject);
    procedure IdHTTP1Work(ASender: TObject; AWorkMode: TWorkMode;
      AWorkCount: Integer);
    procedure lbTmAlgoDblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Exportconsensussequence1Click(Sender: TObject);

  private
//     procedure AOnMessageHandler(var Msg: TMsg; var Handled: Boolean);
     procedure WMDROPFILES(var Message: TWMDROPFILES);
      message WM_DROPFILES;

    { Private declarations }
  public
      flag_seq_ed_valid,flagWorkspaceChanged,flag_show_oligoNotes:boolean;
      bibTm:shortstring;
      seqformat:shortstring;
      seqListe:string;
      procedure check_version(flag:boolean);
      procedure DisplayHint(Sender: TObject);
      procedure format_gcg(var instr:string;init:integer);
      procedure quicksort(deb,fin:word; ind:byte);
      procedure show_oligo_list;
      procedure affiche_liste_seq;
      procedure liste_ma;
      function foreground_color(c:tcolor):tcolor;
      function num_obj(c:integer):integer;
      function numoligo:integer;
      function numseq:integer;
      function numMA:integer;
      function check_oligo_name(var name:shortstring):boolean;
      function check_seq_name(var name:shortstring):boolean;
      procedure setTmAlgo(s:shortstring);
    { Public declarations }
  end;

type str4=string[4];
     T_o=record
         seq,name:shortstring;
         salt,conc:double;
         found_seq,found_ma,notes:string;
         view:Tcolor;
         end;
      T_al=record
           name:shortstring;
           namel,seql,found:tstringlist;
           consensus:string;
           p_homol:extended;
           end;
      pTo=^T_o;

      pAl=^T_al;

const version=version_number+' '+version_type+' '+version_date;

      annhyb_site='http://www.bioinformatics.org/annhyb/';
      maxObject=1024;

      C_oligo=1;
      C_sequence=2;
      C_al=3;

      max_degen:int64=16384;
      code:array[1..25] of str4=('A','CGT','C','AGT','','','G','ACT','',
      '','TG','','CA','ACGT','','','','AG','CG','T','U','ACG','AT','','CT');
      space80='                                                                                ';


var flag,flagCancelSave:boolean;

    dynform:TfrmResults;

    frmMain: TfrmMain;
    save_cursor:Tcursor;
    nb_oligo,nb_seq,nb_align,p2:integer;
    oligoF:record
           visu:boolean;
           nomseq,AlignedOligo,AlignedTarget:shortstring;
           sense:char;
           init,fin:integer;
           score:double;
           coul:Tcolor;
           end;

    o:array[0..maxObject] of pTo;
    sq:array[0..maxObject] of psq;
    al:array[0..maxObject] of pAl;

    year,month,day,hour,min,sec,msec,w,w1,w2,len2,len3:word;

    mw2,mec2,gc2,melt2,mw3,gc3,melt3,ssc2,fa2:real;

    nb_noname:byte;

    profile_dir,program_dir,sl,s,s1,s2:string;

    nomfichier:tfilename;
    fichier:textfile;
    erreur,ListSeqColumnToSort,ListOligoColumnToSort,ListMAColumnToSort,lvAlignColumnToSort,NumX,NumY:integer;
    seq2:tstrings;
    inifile:TIniFile;

    selectedenz,strl,totenzlist,cutenzlist,malign,recent_projects:TStringList;

    flag_degen, flagiso, flagselectedenz, flag_enz_loaded, flagfirsttime,
    flagtoute ,flagUpdateRE, flag_tabchange, flagstop, flagplay, flaganti,
    flagselect, flag_nom_deja_utilise,ListOligoSortInc,
    ListSeqSortInc,lvAlignSortInc,ListMASortInc,flagClose,flag_force_maj_oligo:boolean;

    poseq2, zz, mempos,_init,n_ma_seq,_end,ls: cardinal;

    flag_mem_menu,mem_nf_all,mem_nf_oligo,
    mem_nf_seq,mem_nf_probe,regdelay, revs,memSeqName,workspaceName,
    memstrOligo,memstrSeq,memstrAl:shortstring;
    pt:Tpoint;


procedure add_feature(deb,fin,coul:integer;nom,comment:string);
procedure affiche_features;
function date_time:shortstring;
function postoxy(ss:integer):tpoint;
procedure maj_recherche_oligo(s_old,s_new:shortstring);
procedure affiche_header;
function consensus(ma:T_al;p_hom:extended):string;

var l,nb_degen:integer;
    dblgc,dblmw,dblmec:double;

implementation

uses u_options, u_progress, u_retrieve, u_translationparameters, u_RestrEnzSelect, u_stringsearch, u_reversecomplement,
  u_multialigncleaner, u_confirmfile, u_features, u_sequenceattributes, u_findorf, u_edit_sequence, u_new,
  U_re, u_seqselect, U_sequence_melting, uprintsequence, u_search, Unit1,
  u_oligonotes, u_projectinformation, u_update, u_exportSequences, u_ma_edit,
  u_exportOligo;

{$R *.DFM}

procedure fwsc(s:shortstring);
begin
frmMain.flagworkspacechanged:=true;
//showmessage('chang '+s);
end;

procedure fwsnc(s:shortstring);
begin
frmMain.flagworkspacechanged:=false;
//showmessage('non chang '+s);
end;

procedure RX_BUG(frm:TfrmResults);
var i:integer;
begin
with frm do
    begin
    for i:=RxResults.Lines.count-1 downto 0 do
        if RxResults.Lines[i]='' then
           RxResults.Lines.Delete(i);
    for i:=RxResults.Lines.count-1 downto 0 do
        if RxResults.Lines[i]='****' then
           RxResults.Lines[i]:=''
    end;
end;

function TfrmMain.foreground_color(c:tcolor):tcolor;
begin
if (c=clMaroon) or (c=clGreen) or (c=clOlive) or (c=clNavy)
   or (c=clPurple) or (c=clTeal) or (c=clRed) or (c=clBlue) then
   foreground_color:=clWhite
else
   foreground_color:=clBlack;
end; //foreground_color


function TfrmMain.num_obj(c:integer):integer;
var i,compt:integer;
begin
compt:=0;
with frmMain do
    for i:=0 to tv.Items.Count-1 do
        if tv.Items[i].imageindex=c then
            inc(compt);
result:=compt;
end;  //num_obj

procedure close_project;
var treenode: TTreeNode;
begin
with frmMain do
    begin
    workspaceName:='';
    tv.items.Clear;
    nb_seq:=0;
    nb_oligo:=0;
    lvSeq.items.Clear;
    lv_oligo.Items.clear;
    caption:='AnnHyb '+version;
    application.Title:='AnnHyb '+version;
    with Tv.Items do
        begin
        treenode:=Add(nil,'Oligo'); // Add a root node
        treenode.imageindex:=0;
        treenode:=Add(treenode,'Sequence');
        treenode.imageindex:=0;
        treenode:=Add(treenode,'Multiple alignment');
        treenode.imageindex:=0;
        end;
    nb_oligo:=0;
    nb_seq:=0;
    nb_align:=0;
    memstrOligo:='';
    memstrSeq:='';
    pc.ActivePage:=taboligolist;
    statusbar1.panels[0].text:='Oligo list';
    end; //with
end; //close project

procedure decrypt(key:string);
var w:cardinal;
    sl:string;
begin
sl:='';
for w:=3 to seq2.count-1 do
    sl:=sl+seq2[w];

 for w:=1 to length(sl) do
     sl[w]:=chr(ord(sl[w]) xor ord(key[(w mod length(key))+1]));

seq2.clear;
seq2.text:=sl;
sl:='';
end; //decrypt

procedure add_recent_projects(s:string);
begin
if recent_projects.IndexOf(s)=-1 then
   recent_projects.insert(0,s);
if recent_projects.count>10 then
    recent_projects.Delete(10);
end; //add_recent_projects

procedure open_oligo(nf:shortstring); //s <- nom fichier  ouvrir
var i,t:integer;
    TNode:TTreeNode;
    sl:tstringlist;
    ss:shortstring;

begin
with frmMain do
    begin
    sl:=tstringlist.Create;
    sl.LoadFromFile(nf);
    //AnnHyb's multi oligo format (*.ola)
    if (sl[0]='AnnHyb - List of oligonucleotides') then
       begin
       mem_nf_all:=nf;
       for t:=1 to (sl.Count-1) div 4 do
           begin
           ss:=sl[4*t-3];
           if check_oligo_name(ss) then
              begin
              continue;
              end;
           inc(nb_oligo);
           new(o[nb_oligo]);
           for i:=0 to tv.items.count-1 do
                if tv.items[i].text='Oligo' then
                   break;
           if pos('|notes:',ss)<>0 then
               begin
               o[nb_oligo]^.notes:=copy(ss,pos('|notes:',ss)+7,maxint);
               ss:=copy(ss,1,pos('|notes:',ss)-1);
               ss:=stringreplace(ss,'|',#13#10,[rfReplaceAll]);
               end;
           o[nb_oligo]^.name:=ss;
           check_oligo_name(o[nb_oligo]^.name);
           o[nb_oligo]^.seq:=sl[4*t-3+1];
           o[nb_oligo]^.salt:=strtofloat2(sl[4*t-3+2]);
           o[nb_oligo]^.conc:=strtofloat2(sl[4*t-3+3]);
           o[nb_oligo]^.view:=0;
           tnode:=tv.Items.AddchildObject(tv.Items[i],o[nb_oligo]^.name,o[nb_oligo]);
           tnode.makevisible;
           tnode.imageindex:=1;
           tnode.Selected:=true;
           end; //for t
       ed_oligo_salt_cc.Text:=floattostr2(o[nb_oligo]^.salt/1e-3);
       ed_oligo_cc.text:=floattostr2(o[nb_oligo]^.conc/1e-9);
       sl.free;
       exit;
       end;

    //multiple oligo ancien format
    if (sl[0]='AnnHyb - All oligonucleotides - Olivier Friard') then
       begin
       mem_nf_all:=nf;
       for t:=1 to (sl.Count-1) div 3 do
           begin
           inc(nb_oligo);
           new(o[nb_oligo]);
           for i:=0 to tv.items.count-1 do
                if tv.items[i].text='Oligo' then
                   break;
           o[nb_oligo]^.name:=sl[3*t-2];
           check_oligo_name(o[nb_oligo]^.name);
           o[nb_oligo]^.seq:=sl[3*t-2+1];
           o[nb_oligo]^.salt:=strtofloat2(copy(sl[3*t-2+2],1,pos('|',sl[3*t-2+2])-1))*1e-3;
           o[nb_oligo]^.conc:=strtofloat2(copy(sl[3*t-2+2],pos('|',sl[3*t-2+2])+1,255))*1e-9;
           o[nb_oligo]^.view:=0;
           tnode:=tv.Items.AddchildObject(tv.Items[i],o[nb_oligo]^.name,o[nb_oligo]);
           tnode.makevisible;
           tnode.imageindex:=1;
           tnode.Selected:=true;
           end; //for t
       ed_oligo_salt_cc.Text:=floattostr2(o[nb_oligo]^.salt/1e-3);
       ed_oligo_cc.text:=floattostr2(o[nb_oligo]^.conc/1e-9);
       sl.free;
       exit;
       end;

    //single oligo nouveau format
    if (sl[0]='AnnHyb - Oligonucleotide') or (sl[0]='AnnHyb - Olivier Friard 1997') then
        begin
        ss:=sl[1];
        if check_oligo_name(ss) then
           begin
           sl.free;
           exit;
           end;
        mem_nf_oligo:=nf;
        inc(nb_oligo);
        new(o[nb_oligo]);
        for i:=0 to tv.items.count-1 do
            if tv.items[i].text='Oligo' then
               break;
        o[nb_oligo]^.name:=ss;
        o[nb_oligo]^.seq:=sl[2];
        if sl[0]='AnnHyb - Oligonucleotide' then
           begin
           if sl.count>3 then
              begin
              o[nb_oligo]^.salt:=strtofloat2(sl[3]);
              o[nb_oligo]^.conc:=strtofloat2(sl[4]);
              end
           else
              begin
              showmessage('Salt and oligonucleotide concentrations not found!');
              o[nb_oligo]^.salt:=strtofloat2(frmPreferences.defaut_sel.text)*1e-3;
              o[nb_oligo]^.conc:=strtofloat2(frmPreferences.defaut_amorces.text)*1e-9;
              end;
           end
        else
           begin
           if sl.count>3 then
              begin
              o[nb_oligo]^.salt:=strtofloat2(copy(sl[3],1,pos('|',sl[3])-1));
              o[nb_oligo]^.conc:=strtofloat2(copy(sl[3],pos('|',sl[3])+1,255));
              end
           else
              begin //oligo format antrieur  version 3.5
              //assume concentrations par defaut
              o[nb_oligo]^.salt:=strtofloat2(frmPreferences.defaut_sel.text)*1e-3;
              o[nb_oligo]^.conc:=strtofloat2(frmPreferences.defaut_amorces.text)*1e-9;
              end;
           end;

        o[nb_oligo]^.view:=0;
        tnode:=tv.Items.AddchildObject(tv.Items[i],o[nb_oligo]^.name,o[nb_oligo]);
        tnode.makevisible;
        tnode.imageindex:=1;
        tnode.Selected:=true;
        ed_oligo_salt_cc.Text:=floattostr2(o[nb_oligo]^.salt/1e-3);
        ed_oligo_cc.text:=floattostr2(o[nb_oligo]^.conc/1e-9);
        sl.free;
        exit;
        end;
    sl.free;
    messagedlg('This file is not an AnnHyb oligonucleotide file!',mtwarning,[mbok],0);
    end; //with frmMain
end;   //open oligo

procedure open_sequence(s:shortstring);
var i,j:integer;
    TNode:TTreeNode;
    sequ:t_sq;
    flagdeja:boolean;
    key:string;

label nouvelle_seq,fin;
begin
with frmMain do
   begin
   if not fileexists(s) then
      begin
      showmessage('File not found!');
      exit;
      end;
   seq2:=tstringlist.create;
   seq2.LoadfromFile(s);
   seq2.Text:=adjustlinebreaks(seq2.Text);
   if seq2.count=0 then
      begin
      showmessage('File is empty or not readable!');
      exit;
      end;
   // encrypted sequence
   if seq2[0]='AnnHyb encrypted sequence:' then
      begin
      key:='';
      if not inputquery('Decryption key','This sequence is encrypted, you must enter the key',key) then
         exit;
      decrypt(key);
      seq2.Text:='>Encrypted_sequence'+crlf+seq2.Text;
      end;
   //annhyb project
   if (seq2.IndexOf('<annhyb>')<>-1) and (seq2.IndexOf('</annhyb>')<>-1) then
      begin
      load_xml(s);
      seq2.free;
      workspacename:=ExpandFileName(s);
      add_recent_projects(workspacename);
      goto fin;
      end; //xml
   //old annhyb project based on RSF
   if seq2.IndexOf('AnnHyb environment')<>-1 then
       begin
       load_rsf(seq2);
       seq2.free;
       workspacename:=s;
       goto fin;
       end; //RSF

 //  nettoyage_nouvelle_seq;
   nouvelle_seq:

   analyse_seq(seq2,sequ,seqformat);

   if seqformat='' then
      exit;

   for i:=0 to tv.items.count-1 do
       if tv.items[i].text='Sequence' then
          break;

   if check_seq_name(sequ.name) then
       exit;

   inc(nb_seq);
   new(sq[nb_seq]);
   sq[nb_seq]^:=sequ;
   tnode:=tv.Items.AddchildObject(tv.Items[i],sq[nb_seq]^.name,sq[nb_seq]);
   if tnode.text='' then
       begin
       j:=1;
       while true do
           begin
           flagdeja:=false;
           for i:=0 to tv.Items.Count-1 do
               if (tv.Items[i].imageindex=c_sequence) and (tv.Items[i].text='Sequence'+inttostr(j)) then
                  flagdeja:=true;
           if not flagdeja then
              begin
              tnode.text:='Sequence'+inttostr(j);
              sq[nb_seq]^.name:=tnode.Text;
              break; //j
              end;
           inc(j);
           end;
       end;
    tnode.makevisible;
    tnode.imageindex:=c_sequence;
    tnode.Selected:=true;
    mem_nf_seq:=s;
    sq[nb_seq]^.seqrtf:=sq[nb_seq]^.seq;
    format_gcg(sq[nb_seq]^.seqrtf,1);
    rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
    affiche_header;
    affiche_features;

    if pos('MULTI',seqformat)<>0 then
       goto nouvelle_seq;
    seq2.free;
    end; //with

fin:
frmMain.tv.select(frmMain.tv.items[0]);
frmMain.caption:=extractfilename(workspacename)+' - AnnHyb '+version;
application.Title:=extractfilename(workspacename)+' - AnnHyb '+version;;
end; //open_sequence

procedure open_multialign_file(nf:string);
var init,l,tt:integer;
    s,seq_:string;
    TNode:TTreeNode;
    seq2,sqname:tstringlist;
    memcursor:Tcursor;

procedure load_clustalw;
var t,tt:integer;
begin
memcursor:=screen.Cursor;
screen.Cursor:=crHourGlass;
inc(init);
while seq2[init]='' do
    inc(init);
malign:=tstringlist.Create;
sqname:=tstringlist.Create;
for t:=init to seq2.count-1 do
    begin
    s:=copy(seq2[t],1,pos(' ',seq2[t])-1); //extr seq code
    if s='' then
        break;
    seq_:=trim(copy(seq2[t],length(s)+1,255)); //extr seq
    for tt:=t+1 to seq2.count-1 do
         if copy(seq2[tt],1,pos(' ',seq2[tt])-1)=s then
            seq_:=seq_+trim(copy(seq2[tt],length(s)+1,255));
    //remove spaces from seq
    seq_:=stringreplace(seq_,' ','',[rfReplaceAll, rfIgnoreCase]);

    //remove numbers from seq
    for tt:=48 to 57 do //ascii code for numbers
         seq_:=stringreplace(seq_,chr(tt),'',[rfReplaceAll, rfIgnoreCase]);
    sqname.add(s);
    malign.add(seq_);
    end;

end;//load_clustalw

begin
with frmMain do
   begin
   if not fileexists(nf) then
       begin
       showmessage('File not found!');
       exit;
       end;
   seq2:=tstringlist.create;
   seq2.LoadfromFile(nf);
   seq2.Text:=adjustlinebreaks(seq2.Text);
   if seq2.count=0 then
      begin
      showmessage('File is empty or not readable!');
      exit;
      end;
   init:=0;
   while (pos('CLUSTAL',seq2[init])<>1) and (init<seq2.count-1) do
         inc(init);
   if init<seq2.Count-1 then
      load_clustalw;

   inc(nb_align);
   new(al[nb_align]);
   al[nb_align]^.name:=extractfilename(nf);
   al[nb_align]^.seql:=tstringlist.create;
   al[nb_align]^.seql.text:=malign.text;
   al[nb_align]^.namel:=tstringlist.create;
   al[nb_align]^.namel.text:=sqname.text;
   al[nb_align]^.found:=tstringlist.create;
   al[nb_align]^.consensus:=consensus(al[nb_align]^,80);
   for tt:=0 to al[nb_align]^.namel.Count-1 do
       al[nb_align]^.found.add('');
   //position
   for l:=0 to tv.items.count-1 do
       if tv.items[l].text='Multiple alignment' then
          break;

   tnode:=tv.Items.AddchildObject(tv.Items[l],al[nb_align]^.name,al[nb_align]);
   tnode.makevisible;
   tnode.imageindex:=c_al;
   tnode.selected:=true;
   fwsc('ouvre multialing');
 //  malign.Free;
 //  sqname.free;
   seq2.free;
   screen.Cursor:=memcursor;
   end;//with
end;  //open_multialign

procedure TfrmMain.recent_project_handler(Sender: TObject);
begin
with Sender as TMenuItem do
//     if stringreplace(caption,'&','',[rfReplaceAll])<>workspacename then
    if stringreplace(caption,'&','',[rfReplaceAll])<>workspaceName then
         begin
         if workspaceName='' then
             begin
             open_sequence(stringreplace(caption,'&','',[rfReplaceAll]));
             workspaceName:=stringreplace(caption,'&','',[rfReplaceAll]);
//             ouvre_sequence(caption);
//             workspaceName:=caption;
             end
         else
             ShellExecute(0,nil,pchar(application.ExeName),pchar('"'+stringreplace(caption,'&','',[rfReplaceAll])+'"'),Nil,SW_NORMAL);
//             ShellExecute(0,nil,pchar(application.ExeName),pchar('"'+caption+'"'),Nil,SW_NORMAL);
         end
     else    //return to save project
         begin
         if MessageDlg('Return to saved project? All modifications to project will be lost!',mtConfirmation,[mbYes,mbNo],0)=mrYes then
             begin
             close_project;
             open_sequence(stringreplace(caption,'&','',[rfReplaceAll]));
             workspaceName:=stringreplace(caption,'&','',[rfReplaceAll]);
             end;
         end;
end; //recent_project_handler

procedure message(s1,s2:string);
begin
frmMessages.caption:=s1;
frmMessages.lb_message.caption:=s2;
frmMessages.showmodal;
end;

procedure TfrmMain.check_version(flag:boolean);
var v,v2:real;
    s:shortstring;
begin
if flag then
    begin
    frmUpdate.label1.caption:='Checking for new version of AnnHyb...';
    frmUpdate.btDownload.Enabled:=false;
    frmUpdate.show;
    application.processmessages;
    end;
//set proxy parameters
if frmPreferences.rb_proxy_server.Checked then
    begin
    idHTTP1.proxyparams.ProxyServer:=frmPreferences.proxy_server.text;
    idHTTP1.proxyparams.ProxyPort:=StrToIntDef(frmPreferences.proxy_port.text, 80);
    end;
//retrieve ver.dat file
try
    s:=frmMain.idHTTP1.get(annhyb_site+'ver.dat');
except
    frmUpdate.label1.caption:='Check your internet connection!';
end; //try

s:=trim(s);
val(version_number,v,erreur); //version prog
val(s,v2,erreur);    //available version
if v2>v then
    begin
    frmUpdate.label1.caption:='A new version ('+s+') of AnnHyb is available!';
    frmUpdate.btDownload.Enabled:=true;
    frmUpdate.show;
    end
else
    frmUpdate.label1.caption:='Your version of AnnHyb ('+version_number+') is the most recent';
end; //check_version

procedure menu_recent_projects;
const recent_projects_menu_position=4;
var t:byte;
    recent_SubItem:TMenuItem;
begin
frmMain.mainmenu1.Items[0].items[recent_projects_menu_position].free;      //recent projects
recent_SubItem:=TMenuItem.Create(application);
recent_SubItem.caption:='Recent projects';
frmMain.mainmenu1.Items[0].insert(recent_projects_menu_position,recent_SubItem);

for t:=0 to 9 do
    if recent_projects[t]<>'' then
        begin
        recent_SubItem:=TMenuItem.Create(application);
        recent_SubItem.Caption:=recent_projects[t];
        recent_SubItem.OnClick:=frmMain.recent_project_handler;
        frmMain.mainmenu1.Items[0].items[recent_projects_menu_position].Add(recent_SubItem);
        end;
end; //menu_recent_projects

procedure TfrmMain.WMDROPFILES(var Message: TWMDROPFILES);
var numfiles:longint;
    i:longint;
    buffer:array[0..255] of char;
begin
//How many files are being dropped
numfiles:=DragQueryFile(Message.Drop,4294967295,nil,0);
//Accept the dropped files
for i:=0 to numfiles-1 do
    begin
    DragQueryFile(Message.Drop,i,@buffer,sizeof(buffer));
    if (pos('.OLI',ansiuppercase(buffer))<>0) or (pos('.OLA',ansiuppercase(buffer))<>0) then
        open_oligo(string(buffer))
    else if (pos('.ALN',ansiuppercase(buffer))<>0) then
        open_multialign_file(string(buffer))
    else
        open_sequence(string(buffer));
    end;
end;

function rev_col(c:integer):integer;
var r:integer;
    t:byte;
begin
r:=0;
for t:=0 to 15 do
    if color_rsf[t]=c then
       begin
       r:=t;
       break;
       end;
rev_col:=r;
end;

function date_time:shortstring;
var year,month,day,hour,min,sec,msec:word;
    s:shortstring;
begin
decodedate(now,year,month,day);
decodetime(now,hour,min,sec,msec);
s:=month_[month]+' ';
if day<10 then
   s:=s+'0';
s:=s+inttostr(day)+', '+inttostr(year)+' ';
if hour<10 then
   s:=s+'0';
s:=s+inttostr(hour)+':';
if min<10 then
   s:=s+'0';
if frmPreferences.cb_includedate.Checked then
   date_time:='('+s+inttostr(min)+')'
else
   date_time:='';
end;

procedure TfrmMain.setTmAlgo(s:shortstring);
begin
if s=TmBreslauer1986 then
   begin
   mo_breslauer1986.Checked:=true;
   frmPreferences.rb_breslauer1986.Checked:=true;
   end;

if s=TmAllawi1997 then
   begin
   mo_allawi1997.Checked:=true;
   frmPreferences.rb_allawi1997.Checked:=true;
   end;
bibTm:=s;
lbTmAlgo.Caption:=s;
melt.Hint:='oligo melting temperature (C) see '+s;
lv_oligo.Columns[9].Caption:='Tm (C) '+s;
if pc.activepage=tb_oligo then
   frmMain.seqchange(self);
if pc.activepage=tabOligolist then
   frmMain.show_oligo_list;
end; //setTmAlgo


procedure TfrmMain.menuHandler(Sender: TObject);
var ss:string;
begin
with Sender as TMenuItem do
     begin
     ss:=caption;
     //retire les &
     while pos('&',ss)<>0 do
           system.delete(ss,pos('&',ss),1);
     if  (ansiuppercase(extractfileext(ss))='.OLI')
          or (ansiuppercase(extractfileext(ss))='.OLA') then
          begin
          flag_mem_menu:=ss;
          Oligonucleotide1Click(Sender);
          end
      else
          begin
          flag_mem_menu:=ss;
          mi_OpenSequenceClick(Sender);
          end;
      end;
end;


procedure affiche_features_list;
var sl:tstringlist;
    i:integer;
    itm:TListitem;

begin
with frmMain do
   begin
   lvAnnotations.items.BeginUpdate;
   lvAnnotations.Clear;
   sl:=tstringlist.Create;
   sl.Text:=pSq(frmMain.tv.selected.data)^.features;
   for i:=0 to sl.Count-1 do
        begin
        itm:=lvAnnotations.Items.Add;
        itm.ImageIndex:=rev_col(featuresExtr(sl[i]).color);
        itm.Caption:=featuresExtr(sl[i]).name;
        itm.SubItems.Add(inttostr(featuresExtr(sl[i]).f_init));
        itm.SubItems.Add(inttostr(featuresExtr(sl[i]).f_end));
        if pos('///',sl[i])<>0 then
           itm.SubItems.add(copy(sl[i],pos('///',sl[i])+3,65535))
        else
           itm.SubItems.add('');
        end;
   sl.free;
   lvAnnotations.items.EndUpdate;
   end;
end;

procedure affiche_header;  //show header and annotations list
begin
with frmMain do
   begin
   ed_seq_name.text:=pSq(tv.Selected.Data)^.name;
   ed_seq_longname.text:=pSq(tv.Selected.Data)^.longname;
   edLength.Text:=inttostr(length(pSq(tv.Selected.Data)^.seq));
   ed_seq_type.text:=pSq(tv.Selected.Data)^._type;
   ed_seq_descrip.text:=pSq(tv.Selected.Data)^.descrip;
   ed_seq_creator.Text:=pSq(tv.Selected.Data)^.creator;
   ed_seq_creationdate.Text:=pSq(tv.Selected.Data)^.creationdate;
   ed_seq_checksum.text:=gcg_checksum(pSq(tv.Selected.Data)^.seq);
   mmheader.lines.beginupdate;
   mmheader.clear;
   mmheader.lines.add(pSq(tv.Selected.Data)^.hrsf);
   mmheader.lines.endupdate;
   affiche_features_list;
   end;
end;

procedure nettoyage_nouvelle_seq;
begin
with frmFeatures do
    begin
    feature_name.clear;
    edFbegin.clear;
    edFend.clear;
    f_comment.clear;
    end;
with frmSequenceAttributes do
    begin
    s_name.clear;
    s_description.clear;
    s_type.text:='';
    s_creator.clear;
    s_comments.clear;
    end;
end;

procedure TfrmMain.DisplayHint(Sender: TObject);
begin
StatusBar1.panels[1].text:=GetLongHint(Application.Hint);
end;

procedure TfrmMain.format_gcg(var instr:string;init:integer);
var i:integer;
    s,s2:shortstring;
    outstr:string;

begin
statusbar1.panels[1].text:='Formating sequence, please wait...';
flagselect:=false;
flagstop:=false;
outstr:='';
with frmMain do
   begin
   i:=1; //init;
   while i<=length(instr) do
      begin
      s:=copy(instr,i,50);
      s:=copy(s,1,10)+' '+copy(s,11,10)+' '+copy(s,21,10)+' '+copy(s,31,10)+' '+copy(s,41,10);
      s2:=inttostr(init+i-1);
      while length(s2)<8 do
         s2:=' '+s2;
      outstr:=outstr+s2+'  '+s+CRLF;
      inc(i,50);
      end;
   end;
flagselect:=true;
instr:=outstr;
outstr:='';
statusbar1.panels[1].text:='';
end;

procedure quicksearchprimers;
var poseq,postrouve,countseq,noligo,nseq,nbOligoTrouve,j,t:integer;
    tt,compt:byte;
    soligo:shortstring;
    seqg:string;
    save_cursor:tcursor;
label suite;

begin   //quicksearchprimers
save_cursor:=screen.Cursor;
screen.Cursor := crHourGlass;
flagstop:=false;
nbOligoTrouve:=0;
with frmMain do
   begin
   //compte nbre oligo et seq
   noligo:=0;
   nseq:=0;
   for t:=0 to tv.Items.Count-1 do
       begin
       if tv.Items[t].imageindex=c_oligo then
           if pto(tv.items[t].data)^.view<>0 then
              inc(noligo);
       if tv.Items[t].imageindex=c_sequence then //seq
          inc(nseq);
       end;
   //pas d'oligo  chercher
   if noligo=0 then
      begin
      showmessage('No oligonucleotide to search!');
      goto suite;
      end;
   flagselect:=false;
   //quicksearch

   frmProgress.caption:='Searching oligo...';
   frmProgress.progressbar1.Position:=0;
   frmProgress.Show;

   for t:=0 to tv.Items.count-1 do
       if tv.Items[t].imageindex=c_oligo then
          if pto(tv.items[t].data)^.view<>0 then
             begin
             frmprogress.label1.Caption:=pto(tv.items[t].data)^.name;
             pto(tv.items[t].data)^.found_seq:='';
             for tt:=1 to 2 do      //sense et antisense
                 begin
                 //nettoyage oligo
                 if tt=1 then
                    soligo:=format_iupac(pto(tv.items[t].data)^.seq,false)
                 else
                    soligo:=revcompseq(pto(tv.items[t].data)^.seq);
                 if (soligo='') or (length(soligo)<5) then //oligo trop court
                    continue;
                 countseq:=0;
                 for j:=0 to tv.Items.count-1 do
                     if (tv.Items[j].imageindex=c_sequence)
                        and (pos('**'+ansiuppercase(pSq(tv.items[j].data)^.name)+'**',seqListe)<>0) then //seq
                        begin
                        inc(countseq);
                        frmProgress.progressbar1.Position:=round(countseq/nseq)*100;

                        seqg:=ansiuppercase(pSq(tv.items[j].data)^.seq);
                        //recherche rapide avec POS
                        poseq:=1;
                        compt:=length(soligo);
                        repeat
                            if pos(soligo,copy(seqg,poseq,maxint-1))<>0 then
                               begin
                               inc(nbOligoTrouve);
                               postrouve:=poseq+pos(soligo,copy(seqg,poseq,2147483648-1))-1;
                               //remplit champ FOUND de l'oligo
                               pto(tv.items[t].data)^.found_seq:=pto(tv.items[t].data)^.found_seq
                                                             +'0'
                                                             +pSq(tv.items[j].data)^.name+'|'  //nom seq
                                                             +copy('+-',tt,1)+'|'
                                                             +inttostr(postrouve)+'|'  //position seq2 sur seq1
                                                             +inttostr(postrouve+length(soligo)-1)+'|'   //fin seq2 sur seq1
                                                             +'100|' //score
                                                             +inttostr(pto(tv.items[t].data)^.view)+'|'    //couleur
                                                             +soligo+'|'  //aligned oligo
                                                             +copy(seqg,postrouve,length(soligo))  //aligned target
                                                             +'|'+LF;                                  //seq2
                               poseq:=postrouve+1;
                               end;
                        until pos(soligo,copy(seqg,poseq,maxint-1))=0;
                        end;
                 end; //for tt
             end;
   frmProgress.hide;
   end; //with frmMain

suite:
flagselect:=true;
screen.Cursor:=save_cursor;
end;  //quicksearchprimer

(*
procedure TfrmMain.AOnMessageHandler(var Msg:TMsg;var Handled:Boolean);
begin
case Msg.Message of WM_KEYFIRST..WM_KEYLAST,WM_MOUSEFIRST,WM_MOUSELAST:begin
                                                                       Handled:=True;
                                                                       end;
                    end;
end;
*)

procedure align_oligo;
var countseq,noligo,nbOligoTrouve,j,t,cc,align_length,nseq:integer;
    tt:byte;
    soligo,sepchar:shortstring;
    seqg:string;
    fasta_sl:tstringlist;

label suite;

begin   //align_oligo

sepchar:='|';

//Application.OnMessage:=frmMain.AOnMessageHandler;
save_cursor:=screen.Cursor;
screen.Cursor:=crHourGlass;
flagstop:=false;
nbOligoTrouve:=0;
with frmMain do
   begin
   //count seq
   nseq:=0;
   for t:=0 to tv.Items.Count-1 do
       if (tv.Items[t].imageindex=c_sequence) and (pos('**'+ansiuppercase(pSq(tv.items[t].data)^.name)+'**',seqListe)<>0) then //seq
           inc(nseq);
   flagselect:=false;

   //smith & Waterman algorithm
   frmProgress.caption:='Searching oligo...';
   frmProgress.progressbar1.Position:=0;
   frmProgress.Show;
   for t:=0 to tv.Items.count-1 do
       if tv.Items[t].imageindex=c_oligo then
          if pto(tv.items[t].data)^.view<>0 then
             begin
             frmprogress.label1.Caption:=pto(tv.items[t].data)^.name;
             //init oligo
             pto(tv.items[t].data)^.found_seq:='';
             for tt:=1 to 2 do      //sense et antisense
                 begin
                 //clear oligo
                 if tt=1 then
                    soligo:=format_iupac(pto(tv.items[t].data)^.seq,false)
                 else
                    soligo:=revcompseq(pto(tv.items[t].data)^.seq);
                 if length(soligo)<4 then //oligo trop court
                    begin
                    if tt=1 then
                       showmessage(pto(tv.items[t].data)^.name+' is too short! Minimal length: 4 nt');
                    continue;
                    end;
                 countseq:=0;
                 for j:=0 to tv.Items.count-1 do
                     if (tv.Items[j].imageindex=c_sequence)
                        and (pos('**'+ansiuppercase(pSq(tv.items[j].data)^.name)+'**',seqListe)<>0) then //seq
                        begin
                        pSq(tv.items[j].data)^.flag_f_ok:=false;
                        inc(countseq);
                       frmProgress.progressbar1.Position:=round(countseq/nseq)*100;
                       application.ProcessMessages;
                        seqg:=ansiuppercase(pSq(tv.items[j].data)^.seq);
                        fasta_sl:=tstringlist.create;
                        fasta_sl.Clear;
                        loc_al(seqg,soligo,fasta_sl);
                        if strtoint(fasta_sl[0])<>0 then
                           begin
                           //add position to oligo FOUND field
                           repeat
                               //alignment length
                               align_length:=length(soligo);
                               //gap in oligo
                               if pos('-',fasta_sl[2])>0 then   //2-> aligned oligo
                                   align_length:=length(fasta_sl[2]);
                               //gap in target
                               cc:=countchar('-',fasta_sl[3]);
                               if cc<>0 then
                                   align_length:=length(fasta_sl[3])-cc;

                               pto(tv.items[t].data)^.found_seq:=pto(tv.items[t].data)^.found_seq
                                                             +'0'     //not checked
                                                             +pSq(tv.items[j].data)^.name+sepchar
                                                             +copy('+-',tt,1)+sepchar
                                                             +fasta_sl[0]+sepchar      //init align
                                                             +inttostr(strtoint(fasta_sl[0])+align_length-1)+sepchar  //end align
                                                             +fasta_sl[1]+sepchar
                                                             +inttostr(pto(tv.items[t].data)^.view)+sepchar     //couleur
                                                             +fasta_sl[2]+sepchar      //oligo
                                                             +fasta_sl[3]+sepchar+LF;  //target
                               fasta_sl.Delete(0); //0  pos
                               fasta_sl.Delete(0); //1  score
                               fasta_sl.Delete(0); //2  seq courte
                               fasta_sl.Delete(0); //3  seq longue
                           until fasta_sl.count=0;
                           end;
                        fasta_sl.Free;
                        end;
                 end; //for tt
             end;
   frmProgress.hide;
   end; //with frmMain

suite:
flagselect:=true;
screen.Cursor:=save_cursor;
end; //align_primer

procedure TfrmMain.PlaySound(WavFileName:String);
var s:array[0..255] of char;
begin
if fileexists(wavfilename) then
   begin
   StrPCopy(s,WavFileName);
   sndPlaySound(s,0); //see mmsystem.hlp for other values
   end;
end;

procedure TfrmMain.mi_ExitClick(Sender: TObject);
begin
close;
end;

procedure calcul_param(seq:string;var l,nb_degen:integer;var mw,mec,gc:double);
var t,len2:integer;
    s:string;
    mw2,mec2,gc2:double;
begin
mw2:=0;
mec2:=0;
len2:=0;
gc2:=0;
nb_degen:=0;
s:=format_iupac(seq,false);
with frmPreferences do
for t:=1 to length(s) do
    begin
    case s[t] of 'A':begin mw2:=mw2+313.21; mec2:=mec2+strtoint(edA.text); end;
                 'C':begin mw2:=mw2+289.19; mec2:=mec2+strtoint(edc.text); gc2:=gc2+1; end;
                 'G':begin mw2:=mw2+329.21; mec2:=mec2+strtoint(edG.text); gc2:=gc2+1; end;
                 'T':begin mw2:=mw2+304.2;  mec2:=mec2+strtoint(edT.text); end;
		 'M':begin mw2:=mw2+301.2;  mec2:=mec2+(strtoint(edA.text)+strtoint(edC.text)) div 2; gc2:=gc2+0.5; inc(nb_degen); end;
                 'R':begin mw2:=mw2+321.21; mec2:=mec2+(strtoint(edA.text)+strtoint(edG.text)) div 2; gc2:=gc2+0.5; inc(nb_degen); end;
                 'S':begin mw2:=mw2+309.2; mec2:=mec2+(strtoint(edG.text)+strtoint(edC.text)) div 2; gc2:=gc2+1; inc(nb_degen); end;
                 'V':begin mw2:=mw2+310.54; mec2:=mec2+(strtoint(edA.text)+strtoint(edC.text)+strtoint(edG.text)) div 3; gc2:=gc2+0.67; inc(nb_degen); end;
                 'W':begin mw2:=mw2+308.7; mec2:=mec2+(strtoint(edA.text)+strtoint(edT.text)) div 2; inc(nb_degen); end;
                 'Y':begin mw2:=mw2+296.7; mec2:=mec2+(strtoint(edC.text)+strtoint(edT.text)) div 2; gc2:=gc2+0.5; inc(nb_degen); end;
                 'H':begin mw2:=mw2+302.2; mec2:=mec2+(strtoint(edA.text)+strtoint(edC.text)+strtoint(edT.text)) div 3; gc2:=gc2+0.33; inc(nb_degen); end;
                 'K':begin mw2:=mw2+316.7; mec2:=mec2+(strtoint(edG.text)+strtoint(edT.text)) div 2; gc2:=gc2+0.5;  inc(nb_degen); end;
                 'D':begin mw2:=mw2+315.5; mec2:=mec2+(strtoint(edA.text)+strtoint(edG.text)+strtoint(edT.text)) div 3; gc2:=gc2+0.33; inc(nb_degen); end;
                 'B':begin mw2:=mw2+307.53; mec2:=mec2+(strtoint(edC.text)+strtoint(edG.text)+strtoint(edT.text)) div 3; gc2:=gc2+0.67; inc(nb_degen); end;
                 'N':begin mw2:=mw2+308.95; mec2:=mec2+(strtoint(edC.text)+strtoint(edG.text)+strtoint(edT.text)+strtoint(edA.text)) div 4; gc2:=gc2+0.5; inc(nb_degen); end;
		  end;
    if pos(s[t],iupac)<>0 then
       inc(len2);
    end;
if frmPreferences.rbmec.checked then
    begin
    mec2:=0;
    for t:=1 to length(s)-1 do
        begin
        if s[t]+s[t+1]='AA' then mec2:=mec2+13.7*2;
        if s[t]+s[t+1]='AC' then mec2:=mec2+10.6*2;
        if s[t]+s[t+1]='AG' then mec2:=mec2+12.5*2;
        if s[t]+s[t+1]='AT' then mec2:=mec2+11.4*2;

        if s[t]+s[t+1]='CA' then mec2:=mec2+10.6*2;
        if s[t]+s[t+1]='CC' then mec2:=mec2+7.3*2;
        if s[t]+s[t+1]='CG' then mec2:=mec2+9.0*2;
        if s[t]+s[t+1]='CT' then mec2:=mec2+7.6*2;

        if s[t]+s[t+1]='GA' then mec2:=mec2+12.6*2;
        if s[t]+s[t+1]='GC' then mec2:=mec2+8.8*2;
        if s[t]+s[t+1]='GG' then mec2:=mec2+10.8*2;
        if s[t]+s[t+1]='GT' then mec2:=mec2+10.0*2;

        if s[t]+s[t+1]='TA' then mec2:=mec2+11.7*2;
        if s[t]+s[t+1]='TC' then mec2:=mec2+8.1*2;
        if s[t]+s[t+1]='TG' then mec2:=mec2+9.5*2;
        if s[t]+s[t+1]='TT' then mec2:=mec2+8.4*2;
        end;

    for t:=2 to length(s)-1 do
        begin
        if s[t]='A' then mec2:=mec2-15.4;
        if s[t]='C' then mec2:=mec2-7.4;
        if s[t]='G' then mec2:=mec2-11.5;
        if s[t]='T' then mec2:=mec2-8.7;
        end;
    mec:=mec2*1000;
    end; //rbmec
l:=len2;
mw:=round(mw2);

mec:=mec2;
if frmPreferences.rb09.checked then
   mec:=mec*0.9;

if l<>0 then
   gc:=(gc2/len2)*100
else
   gc:=0;
end; //param

procedure TfrmMain.seqChange(Sender: TObject);
var s_iupac:string;
begin
//verify if seq oligo has changed
s_iupac:=format_iupac(seq.text,false);
if (tv.selected=nil) or (tv.selected.imageindex<>c_oligo) then
   exit;
if s_iupac<>format_iupac(pto(tv.selected.data)^.seq,false) then
   begin
   if pto(tv.selected.data)^.found_seq<>'' then
      if MessageDlg('Modifying the oligo sequence will delete search results!'+lf+'Proceed anyway?',mtWarning,[mbYes,mbNo],0)=mrYes then
         begin
         lvAlign.Clear;
         pto(tv.selected.data)^.found_seq:='';
         end
      else
         seq.Text:=pto(tv.selected.data)^.seq;
   fwsc('seq changed');
   end;

if s_iupac=''  then //empty oligo
    begin
    rev.text:='';
    seq_iupac.text:='';
    len.text:='0';
    gc.text:='0';
    mw.text:='0';
    mec.text:='0';
    melt.text:='';
    gcgchecksum.text:='';
    pto(tv.selected.data)^.seq:=seq.text;
    exit;
    end;

//update oligo name in treeview
pto(tv.selected.data)^.seq:=seq.text;

//pto(tv.selected.data)^.change:=true;
//iub
seq_iupac.text:=format_iupac(seq.text,true);
//rev
if (activecontrol<>rev) or (flag_force_maj_oligo=true) then
   rev.text:=revcompseq(seq.text);
//param
calcul_param(seq.text,l,nb_degen,dblmw,dblmec,dblgc);
len.text:=inttostr(l);
mw.text:=floattostr2(dblmw);
mec.text:=floattostr2(dblmec);
gc.text:=floattostr2(dblgc);

gcgchecksum.text:=gcg_checksum(s_iupac);
//melting
melt.text:=melting(seq.text,compseq(seq.Text),pTo(tv.selected.data)^.salt,pto(tv.selected.data)^.conc,bibTm);
end;

procedure TfrmMain.About1Click(Sender: TObject);
begin
frmaboutbox.mm_license.Lines[0]:=lb_copyright.caption;
frmaboutbox.showmodal;
end; //about

procedure TfrmMain.ed_oligo_salt_ccChange(Sender: TObject);
var s_salt:double;
begin
if activecontrol=ed_oligo_salt_cc then
   fwsc('sel chang');
try
   s_salt:=strtofloat2(ed_oligo_salt_cc.text);
except
   begin
   melt.text:='Bad salt concentration';
   exit;
   end;
end;

if tv.selected<>nil then
   begin

   pto(tv.selected.data)^.salt:=s_salt*1e-3;
   melt.text:=melting(seq.text,compseq(seq.Text),pTo(tv.selected.data)^.salt,pto(tv.selected.data)^.conc,bibTm);
   end;
end;

procedure TfrmMain.ed_oligo_ccChange(Sender: TObject);
var s_primer:double;
begin
try
   s_primer:=strtofloat2(ed_oligo_cc.text);
except
   begin
   melt.text:='Bad primer concentration';
   exit;
   end;
end;

if tv.selected<>nil then
    begin
    pto(tv.selected.data)^.conc:=s_primer*1e-9;
    if activecontrol=ed_oligo_cc then
        fwsc('amorces changes');
    melt.text:=melting(seq.text,compseq(seq.text),pTo(tv.selected.data)^.salt,pto(tv.selected.data)^.conc,bibTm);
    end;

//calcul(seq.text,strtofloat2(sel.text),strtofloat2(amorces.text));
end;
(*
procedure can_paste(b:boolean);
begin
frmMain.mi_paste.enabled:=b;
frmMain.tb_paste.enabled:=b;
end;
*)
procedure TfrmMain.mi_copyClick(Sender: TObject);
var s,s1:string;
begin
//can_paste(false);
if tv.Focused then
    if tv.selected<>nil then
        begin
        if tv.Selected.imageindex=c_oligo then   //copy Oligo (name, seq, notes, salt, conc...)
            begin
            s:='OLIGO'+crlf;
            s:=s+pto(tv.selected.data)^.name+crlf;
            s:=s+pto(tv.selected.data)^.seq+crlf;
            s1:=stringreplace(pto(tv.selected.data)^.notes,crlf,'',[rfReplaceAll,rfIgnoreCase]);
            s:=s+s1+crlf;
            s:=s+floattostr(pto(tv.selected.data)^.salt)+crlf;
            s:=s+floattostr(pto(tv.selected.data)^.conc)+crlf;
            clipboard.astext:=s;
//            can_paste(true);
//            mi_tv_paste.Enabled:=true;
            exit;
            end;
        if tv.Selected.imageindex=c_sequence then   //copy seq (name, seq...)
            begin
            showmessage('function not yet implemented!');
            exit;
            end;
        if tv.Selected.imageindex=c_al then   //copy multi-alignment (name, seq...)
            begin
            showmessage('function not yet implemented!');
            exit;
            end;

        end;  //tv.selected<>nil
if ActiveControl is TEdit then
    begin
    clipboard.astext:=TEdit(ActiveControl).seltext;
//    can_paste(true);
    end;
if ActiveControl is TMemo then
    begin
    clipboard.astext:=TMemo(ActiveControl).seltext;
//    can_paste(true);
    end;
if ActiveControl is TRXRichEdit then
    begin
    if (activecontrol<>rxgcgseq) or (MessageDlg('Copy only nucleotides?',mtConfirmation,[mbYes,mbNo],0)=mrNo) then
        clipboard.astext:=TRXRichEdit(ActiveControl).seltext
    else
        clipboard.astext:=clearseq(TRXRichEdit(ActiveControl).seltext);
//    can_paste(true);
    end;
(*
for i:=ComponentCount-1 downto 0 do
    begin
    if Components[I] is TEdit then
       if (components[i] as TEdit).Focused then
          begin
          clipboard.astext:=(components[i] as TEdit).seltext;
          if clipboard.HasFormat(CF_TEXT) then
              can_paste(true);
          end;
    if Components[I] is TMemo then
       if (components[i] as TMemo).Focused then
          begin
          clipboard.astext:=(components[i] as TMemo).seltext;
          can_paste(true);
          end;
    if Components[I] is TRXRichEdit then
       if (components[i] as TRXRichEdit).Focused then
          begin
          clipboard.astext:=clearseq((components[i] as TRXRichEdit).seltext);
          can_paste(true);
          end;
    end;
*)
end;

procedure TfrmMain.mi_pasteClick(Sender: TObject);
var i:integer;
    flagpasted:boolean;
    sl:tstringlist;
begin
if clipboard.HasFormat(cf_text) then
    begin
    if copy(clipboard.astext,1,5)='OLIGO' then
       begin
//       if MessageDlg('Insert the oligo into the oligo list?',mtConfirmation,[mbYes,mbNo], 0)=mrYes then
//          begin
          new_oligoclick(self);
          sl:=tstringlist.Create;
          sl.text:=clipboard.astext;
          pto(tv.selected.data)^.name:='Copy of '+sl[1];
          tv.selected.Text:='Copy of '+sl[1];
          pto(tv.selected.data)^.seq:=sl[2];
          pto(tv.selected.data)^.notes:=stringreplace(sl[3],'',crlf,[rfReplaceAll,rfIgnoreCase]);
          pto(tv.selected.data)^.salt:=strtofloat(sl[4]);
          pto(tv.selected.data)^.conc:=strtofloat(sl[5]);
          tvChange(self,tv.selected);
          sl.Free;
          flagpasted:=false;
//          end;
       exit;
       end;
    flagpasted:=false;
    for i:=ComponentCount-1 downto 0 do
        begin
        if Components[I] is TEdit then
           if (components[i] as TEdit).Focused then
              begin
              (components[i] as TEdit).pastefromclipboard;
              flagpasted:=true;
              end;
(*       if Components[I] is TMemo then
           if (components[i] as TMemo).Focused then
              begin
              (components[i] as TMemo).pastefromclipboard;
              flagpasted:=true;
              end;
*)
        end;
    if not flagpasted then
       showmessage('You can not paste text into this control!');
    end;
end;

function seqselect(c:byte;title:shortstring):string; //give sequence list
var i:integer;
    itm:TlistItem;
    flagseq:boolean;
    s:string;
begin
flagseq:=false;
s:='';
with frmSeqSelect do
    begin
    lvSeqSelect.items.Clear;
    edKWselect.Clear;
    for i:=0 to frmMain.tv.Items.Count-1 do
       if frmMain.tv.Items[i].imageindex=c then
          begin
          flagseq:=true;
          itm:=lvSeqSelect.Items.Add;
          itm.ImageIndex:=0;
          case c of c_sequence:begin
                                  itm.checked:=(frmMain.seqliste<>'') and (pos('**'+ansiuppercase(pSq(frmMain.tv.Items[i].Data)^.name)+'**',frmMain.seqListe)<>0);
                                  itm.Caption:=pSq(frmMain.tv.Items[i].Data)^.name;
                                  itm.SubItems.Add(inttostr(length(pSq(frmMain.tv.Items[i].Data)^.seq)));
                                  itm.SubItems.Add(pSq(frmMain.tv.Items[i].Data)^.longname);
                                  itm.SubItems.Add(pSq(frmMain.tv.Items[i].Data)^.descrip);
                                  caption:='Select sequences';
                                  bt_select.caption:='Select all seq.';
                                  end;
                          c_oligo:begin  //oligo
                                  itm.Checked:=(frmMain.seqliste<>'') and (pos('**'+ansiuppercase(pTo(frmMain.tv.Items[i].Data)^.name)+'**',frmMain.seqListe)<>0);
                                  itm.Caption:=pto(frmMain.tv.Items[i].Data)^.name;
                                  itm.SubItems.Add(inttostr(length(format_iupac(pto(frmMain.tv.Items[i].Data)^.seq,false))));
                                  caption:='Select oligonucleotides';
                                  bt_select.caption:='Select all oligo';
                                  end;
                             c_al:begin //MA
                                  itm.Checked:=false;
                                  itm.Caption:=pAl(frmMain.tv.Items[i].Data)^.name;
//                                itm.SubItems.Add(inttostr(length(pto(frmMain.tv.Items[i].Data)^.seq)));
                                  caption:='Select multiple alignments';
                                  bt_select.caption:='Select all alignments';
                                  end;
                            end;//case
          end;
    if flagseq then
       begin
       caption:=title;
       showmodal;
       if modalresult=mrCancel then
          begin
          result:='cancel';
          exit;
          end;
       for i:=0 to lvSeqSelect.items.count-1 do
           if lvSeqSelect.items[i].checked then
              s:=s+'**'+lvSeqSelect.items[i].caption+'**';
       result:=ansiuppercase(s);
       end
    else
       result:='no sequence';
    end;
end; //seqSelect


function TfrmMain.numseq:integer;
var i,compt:integer;
begin
compt:=0;
with frmMain do
     for i:=0 to tv.items.Count-1 do
         if tv.items[i].imageindex=c_sequence then
            inc(compt);
result:=compt;
end;

function TfrmMain.numoligo:integer;
var i,compt:integer;
begin
compt:=0;
with frmMain do
     for i:=0 to tv.items.Count-1 do
         if tv.items[i].imageindex=c_oligo then
            inc(compt);
result:=compt;
end;

function TfrmMain.numMA:integer;
var i,compt:integer;
begin
compt:=0;
with frmMain do
     for i:=0 to tv.items.Count-1 do
         if tv.items[i].imageindex=c_al then
            inc(compt);
result:=compt;
end;

function select_oligo_seq(c:byte;title:shortstring):boolean;
var i:integer;
begin
if ((c=c_oligo) and (frmMain.numOligo=0))
   or ((c=c_sequence) and (frmMain.numSeq=0))
   or ((c=c_al) and (frmMain.numMA=0)) then
   begin
   showmessage('Nothing to select!');
   result:=false;
   exit;
   end;

if ((c=c_oligo) and (frmMain.numOligo=1))
   or ((c=c_sequence) and (frmMain.numSeq=1))
   or ((c=c_al) and (frmMain.numMA=1)) then
    begin
    for i:=0 to frmMain.tv.items.Count-1 do
        if frmMain.tv.items[i].imageindex=c then
           frmMain.seqListe:='**'+ansiuppercase(frmMain.tv.items[i].text)+'**'
    end
else
    frmMain.seqListe:=seqselect(c,title);

if (frmMain.seqliste='cancel') or (frmMain.seqliste='') then
   result:=false
else
   result:=true;
end; //select_oligo_seq

procedure TfrmMain.informationsClick(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\manual.html'),Nil,Nil,SW_NORMAL);
end;

procedure TfrmMain.Exportoligonucleotidedata1Click(Sender: TObject);
var flagajoute:boolean;
    i:integer;

procedure write_single_oligo(node:ttreenode;frm:TfrmResults);
begin
calcul_param(pto(node.data)^.seq,l,nb_degen,dblmw,dblmec,dblgc);
frm.rxresults.lines.add('****');
frm.rxresults.lines.add('Name:     '+pto(node.data)^.name);
frm.rxresults.lines.add('Sequence: '+format_iupac(ansiuppercase(pto(node.data)^.seq),true));
frm.rxresults.lines.add('****');
frm.rxresults.lines.add('Reverted/complemented: '+format_iupac(revcompseq(pto(node.data)^.seq),true));
frm.rxresults.lines.add(format('Length: %d b',[l]));
frm.rxresults.lines.add('Number of degeneracy: '+inttostr(nb_degen));
frm.rxresults.lines.add(format('Molecular weight: %g',[dblmw]));
frm.rxresults.lines.add(format('Molar extinction coefficient: %g  l/mol',[dblmec]));
frm.rxresults.lines.add(format('GC percent: %g',[roundto(dblgc,-2)]));
frm.rxresults.lines.add('GCG checksum: '+gcg_checksum(ansiuppercase(pto(node.data)^.seq)));
frm.rxresults.lines.add(format('Tm (%g mM salt; %g nM oligonucleotide): ',[pto(node.data)^.salt*1000,pto(node.data)^.conc*1e9])
               +melting(format_iupac(pto(node.data)^.seq,false),compseq(format_iupac(pto(node.data)^.seq,false)),
               pto(node.data)^.salt,pto(node.data)^.conc,bibTm)+' C   '
               +bibTm);
frm.rxresults.lines.add('****');
frm.rxresults.lines.add('****');
end; //write single oligo

begin //export oligo data
if not select_oligo_seq(c_oligo,'Select oligo') then
   exit;

dynform:=TfrmResults.create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='AnnHyb - Oligonucleotide analysis';
    rxresults.lines.add('AnnHyb - Oligonucleotide analysis   '+date_time);
    rxresults.lines.add('****');
    for i:=0 to tv.items.Count-1 do
        if (tv.Items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
            write_single_oligo(tv.items[i],dynform);

    RX_BUG(dynform);

    show;
    end;
end;

function TfrmMain.check_oligo_name(var name:shortstring):boolean;
var i,r:integer;
    flag_nom_deja_utilise2:boolean;
begin
repeat
   flag_nom_deja_utilise2:=false;
   for i:=0 to frmMain.tv.Items.Count-1 do
       if (frmMain.tv.Items[i].imageindex=c_oligo) and (ansiuppercase(name)=ansiuppercase(frmMain.tv.Items[i].text)) then
          begin
          flag_nom_deja_utilise2:=true;
          break;
          end;
   if flag_nom_deja_utilise2 then
       begin
       r:=MessageDlg(name+': name already in use'+LF+'Please change the oligo name or click Cancel',mtWarning,[mbOK,mbCancel],0);
       if r=mrOK then
          name:=inputBox('Change oligo name','New name',name);
       end;
until (not flag_nom_deja_utilise2) or (r=mrCancel);
result:=flag_nom_deja_utilise2;
end; //check oligo name

function sauvertf:string;     //sauve code RTF ds string
var ms:tmemorystream;
    s:string;
begin
frmMain.rxgcgseq.PlainText:=false;
ms:=tmemorystream.create;
frmMain.rxgcgseq.Lines.savetostream(ms);
setlength(s,ms.size);
ms.Position:=0;
ms.ReadBuffer(pointer(s)^,ms.size);
ms.Free;
result:=s;
end;

function TfrmMain.check_seq_name(var name:shortstring):boolean;
var i,r:integer;
    flag_nom_deja_utilise2:boolean;
begin
repeat
   flag_nom_deja_utilise2:=false;
   for i:=0 to frmMain.tv.Items.Count-1 do
       if (frmMain.tv.Items[i].imageindex=c_sequence) and (ansiuppercase(name)=ansiuppercase(frmMain.tv.Items[i].text)) then
          begin
          flag_nom_deja_utilise2:=true;
          break;
          end;
   if flag_nom_deja_utilise2 then
       begin
       r:=MessageDlg(name+': name already in use'+#13#10+'Please change the sequence name or click Abort',mtWarning,[mbOK,mbAbort],0);
       if r=mrOK then
          name:=inputBox('Change sequence name','New name',name);
       end;
until (not flag_nom_deja_utilise2) or (r=mrAbort);
result:=flag_nom_deja_utilise2;
end; //check_seq_name

function folder_path(VariableIdentifiantLeButDuGet:integer):string;
var
  IdList:PITEMIDLIST;
  Dossier:array[0..MAX_PATH] of Char;
begin
  if SHGetSpecialFolderLocation(0, VariableIdentifiantLeButDuGet,IdList)=NOERROR then
  begin
    SHGetPathFromIDList(IdList, Dossier);// pour rcuprer le dossier  partir de IdList
    result:=String(Dossier);
  end
  else   result:='';
end;

procedure TfrmMain.create(Sender: TObject);
var treenode: TTreeNode;
begin
DragAcceptFiles(frmMain.Handle, True);
caption:='AnnHyb '+version;

//treeview population
with Tv.Items do
    begin
    treenode:=Add(nil,'Oligo'); // Add a root node
    treenode.imageindex:=0;
    treenode:=Add(treenode,'Sequence');
    treenode.imageindex:=0;
    treenode:=Add(treenode,'Multiple alignment');
    treenode.imageindex:=0;
    end;
nb_oligo:=0;
nb_seq:=0;
nb_align:=0;

flag:=false;

flag_mem_menu:='';
memstrOligo:='';
memstrSeq:='';
ListOligoColumnToSort:=-1;
ListSeqColumnToSort:=-1;
flag_tabchange:=false;
fwsnc('create');
workspacename:='';
ListOligoSortInc:=true;
ListSeqSortInc:=true;
lvAlignSortInc:=true;
ListMASortInc:=true;
flag_show_oligoNotes:=false;
flagClose:=false;
Application.OnHint:=DisplayHint;
decimalseparator:='.';
flagUpdateRE:=true; //active mise  jour gcgseq
profile_dir:=folder_path(CSIDL_PROFILE)+'\';
program_dir:=ExtractFilePath(Application.ExeName);

flag_enz_loaded:=false;
nb_noname:=0;
recent_projects:=tstringlist.create;
end; //application.create

procedure TfrmMain.Options1Click(Sender: TObject);
begin
frmPreferences.showmodal;
end;

procedure save_ini;
var t:byte;
begin
with frmPreferences do
    try
        begin
        IniFile:=Tinifile.create(profile_dir+'annhyb.ini');
        //general
        inifile.writebool('general','AskBeforeClosingResults',cb_AskBeforeClosingResults.Checked);
        inifile.writeinteger('general','OutputTextFormat',rgTextFormat.itemindex);

        inifile.writestring('version','version',version_number);
    (*
        inifile.writebool('speech','readseq',cb_readseq.checked);
        inifile.writestring('speech','DelayBetweenBases',edit1.text);
        inifile.writestring('speech','GroupEveryBases',edit2.text);
        inifile.writestring('speech','DelayBetweenGroup',edit3.text);
    *)
        //tm
        inifile.writestring('melting','SaltConc',defaut_sel.text);
        inifile.writestring('melting','PrimerConc',defaut_amorces.text);
        inifile.writestring('melting','SaltConcSeq',defaut_sel_seq.text);
        inifile.writestring('melting','PrimerConcSeq',defaut_amorces_seq.text);
        inifile.writestring('melting','SaltConcLongSeq',long_seq_salt_tm.text);
        inifile.writestring('melting','BiblioTmAlgo',frmMain.bibTm);

        //mec
        inifile.writebool('mec','rb',rb.checked);
        inifile.writebool('mec','rb09',rb09.checked);
        inifile.writebool('mec','rbmec',rbmec.checked);
        inifile.writestring('mec','A',edA.text);
        inifile.writestring('mec','C',edC.text);
        inifile.writestring('mec','G',edG.text);
        inifile.writestring('mec','T',edT.text);

        //check update
        inifile.writebool('Update','check',cb_check_update.checked);

        s:='';
(*        if lvServerAddress.items.Count>0 then
           for t:=0 to lvServerAddress.items.Count-1 do
               s:=s+lvServerAddress.items[t].caption+'|';
*)
        if cbServerURL.Items.count>0 then
             for t:=0 to cbServerURL.Items.count-1 do
                 s:=s+cbServerURL.items[t]+'|';


        inifile.writestring('retrieve','Server Address List',s);
//        inifile.writestring('retrieve','Server Address',edDefaultServer.text);
        inifile.writestring('retrieve','Server Address',cbServerURL.text);

        inifile.writestring('retrieve','Proxy server',proxy_server.text);
        inifile.writestring('retrieve','Proxy port',proxy_port.text);

        if frmMain.calctm1.checked then
           inifile.writestring('melting','CalcSelTm','true')
        else
           inifile.writestring('melting','CalcSelTm','false');

        //print
        inifile.writebool('printing','includedate',cb_includedate.checked);
        //quicksearch / align oligo
        //automatic color
        inifile.writeInteger('search_oligo','OligoColor1',sh_oligo1.brush.color);
        inifile.writeInteger('search_oligo','OligoColor2',sh_oligo2.brush.color);
        inifile.writeInteger('search_oligo','OligoColor3',sh_oligo3.brush.color);
        inifile.writeInteger('search_oligo','OligoColor4',sh_oligo4.brush.color);
        inifile.writeInteger('search_oligo','OligoColor5',sh_oligo5.brush.color);
        inifile.writeInteger('search_oligo','OligoColor6',sh_oligo6.brush.color);
        inifile.writeInteger('search_oligo','OligoColor7',sh_oligo7.brush.color);
        inifile.writeInteger('search_oligo','OligoColor8',sh_oligo8.brush.color);
        inifile.writeInteger('search_oligo','OligoColor9',sh_oligo9.brush.color);
        inifile.writeInteger('search_oligo','OligoColor10',sh_oligo10.brush.color);
        inifile.writeInteger('search_oligo','OligoColor11',sh_oligo11.brush.color);
        inifile.writeInteger('search_oligo','OligoColor12',sh_oligo12.brush.color);
        //overlapping features color
        inifile.writeInteger('features','overlapping_features_color',overlapping_color.brush.color);
         //mismatch color
        inifile.writeInteger('features','mismatch_color',mismatch_color.brush.color);
        //Automatic check best found oligo
        inifile.writebool('search_oligo','AutomaticCheckBestOligo',cbAutomaticCheckBestOligo.checked);
        inifile.writestring('search_oligo','OligoThreshold',edOligoThreshold_seq.Text);
        inifile.writestring('search_oligo','OligoThreshold_ma',edOligoThreshold_ma.Text);        

        //recent projects
        for t:=0 to 9 do
            if t<recent_projects.Count then
               inifile.WriteString('recent projects','project'+inttostr(t),recent_projects[t]);
        //font
        inifile.writestring('font','header_font_name',frmMain.mmHeader.font.Name);
        inifile.writeinteger('font','header_font_size',frmMain.mmHeader.font.size);

        inifile.writestring('font','features_font_name',frmMain.lvAnnotations.font.Name);
        inifile.writeinteger('font','features_font_size',frmMain.lvAnnotations.font.size);

        inifile.writestring('font','sequence_font_name',frmMain.rxgcgseq.font.Name);
        inifile.writeinteger('font','sequence_font_size',frmMain.rxgcgseq.font.size);

        inifile.writestring('font','tree_font_name',frmMain.tv.font.Name);
        inifile.writeinteger('font','tree_font_size',frmMain.tv.font.size);

        //pos. & dim.
        //    inifile.Writeinteger('position','state',ord(self.windowstate));
        inifile.writeinteger('position','left',frmMain.left);
        inifile.writeinteger('position','top',frmMain.top);
        inifile.writeinteger('position','width',frmMain.width);
        inifile.writeinteger('position','height',frmMain.height);
        inifile.Writeinteger('position','treeview_width',frmMain.recipient_tv.Width);
        inifile.free;
        end; //try
    except
        showmessage('Problem saving user preferences!');
    end;
end;

procedure TfrmMain.close_(Sender: TObject; var Action: TCloseAction);
var w:word;
begin
if flagWorkspaceChanged then
   begin
   w:=MessageDlg('The project was modified!'+LF+'Do you want to save it?',mtWarning,[mbYes,mbNo,mbCancel],0);
   if w=mrCancel then
      begin
      action:=canone;
      exit;
      end;
   if w=mrYes then
      begin
      flagCancelSave:=false;
      frmMain.mi_SaveProjectClick(mi_saveProject);
      if flagCancelSave then
          begin
          action:=canone;
          exit;
          end;
      end;
   end;
if flag_enz_loaded then
   begin
   totenzlist.free;
   cutenzList.free;
   selectedenz.free;
   end;

save_ini;
recent_projects.free;
flagClose:=true;
end;

procedure TfrmMain.pcChange(Sender: TObject);
var i:integer;
begin
//show empty list of elements if no element are present
if (numoligo=0) and (pc.activepage=tb_oligo) then
   begin
   showmessage('You must first create a new oligo!'+crlf+'Menu Oligo/New Oligo');
   pc.activepage:=tabOligoList;
   statusbar1.Panels[0].text:='Oligo list';
   exit;
   end;
if (numseq=0) and (pc.activepage=seqtab) then
   begin
   showmessage('You must first create or load a new sequence!'+crlf+'Menu Sequence/New Sequence');
   pc.activepage:=tabSeqList;
   statusbar1.Panels[0].text:='Sequence list';
   exit;
   end;
if (numMA=0) and (pc.activepage=tabMA) then
   begin
   showmessage('You must first load a new multiple alignment!'+crlf+'Menu Multiple alignment/Load multiple alignment');
   pc.activepage:=tabMAList;
   statusbar1.Panels[0].text:='Multiple alignment list';
   exit;
   end;

for i:=0 to tv.Items.Count-1 do
    begin
    //show list of elements if the list tab is selected
    if ((pc.activepage=tabSeqList) and (tv.Items[i].imageindex=0) and (tv.Items[i].text='Sequence'))
       or ((pc.activepage=tabOligoList) and (tv.Items[i].imageindex=0) and (tv.Items[i].text='Oligo'))
       or ((pc.activepage=tabMAList) and (tv.Items[i].imageindex=0) and (tv.Items[i].text='Multiple alignment')) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;
    if (pc.activepage=tb_oligo) and (memstrOligo='') and (tv.Items[i].imageindex=c_oligo) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;
    if (pc.activepage=seqtab) and (memstrSeq='') and (tv.Items[i].imageindex=c_sequence) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;

    if (pc.activepage=tabMA) and (memstrAl='') and (tv.Items[i].imageindex=c_al) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;

    if (tv.Items[i].text=memstrOligo) and (tv.Items[i].imageindex=c_oligo) and (pc.activepage=tb_oligo) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;
    if (tv.Items[i].text=memstrSeq) and (tv.Items[i].imageindex=c_sequence) and (pc.activepage=seqtab) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;
    if (tv.Items[i].text=memstrAl) and (tv.Items[i].imageindex=c_al) and (pc.activepage=tabMA) then
       begin
       tv.Items[i].Selected:=true;
       break;
       end;
    end;
end;

procedure TfrmMain.mi_TestoligofordimersClick(Sender: TObject);
begin
if (tv.Selected=nil) or (tv.Selected.imageindex<>c_oligo) then
   begin
   showmessage('Please select an oligo!');
   exit;
   end;

if seq.text<>'' then
   frmDimerLoop.showmodal
else
   showmessage('No oligonucleotides!');
end;

procedure TfrmMain.Retrievefromserver3Click(Sender: TObject);
var flagok:boolean;
    i,j,zz:integer;
    TNode:TTreeNode;
    sequ:t_sq;
    seq,server,pos1,pos2:shortstring;

label label_1;
begin
with frmRetrieve do
    begin
    cbServerURL_retrieve.items:=frmPreferences.cbServerURL.items;
    cbServerURL_retrieve.itemindex:=frmPreferences.cbServerURL.itemindex;
    mListSeq.clear;
    showmodal;
if modalresult=mrAbort then
   exit;
if mListSeq.text='' then
   begin
   showmessage('No accession number or sequence ID!');
   exit;
   end;

if pos('*',cbServerURL_retrieve.text)=0 then
   begin
   showmessage('Invalid server address!'+LF+'You must indicate the AC/GI position in the URL by *');
   exit;
   end;

if save_after_retrieve.checked then    //sauve seq
   begin
   if rb_allseqonefile.checked then
      begin
      savedialog1.filter:='';
      savedialog1.defaultext:='';
      savedialog1.title:='Save retrieved sequence';
      savedialog1.filename:='';
      if savedialog1.execute then
         begin
         if fileexists(savedialog1.filename) then
                 begin
                 frmConfirmFile.lbMessage.caption:='The file '+savedialog1.filename+' already exists!';
                 frmConfirmFile.showmodal;
                 if frmConfirmFile.modalresult=mrYes then
                    begin
                    assignfile(fichier,savedialog1.filename);
                    rewrite(fichier);
                    end;
                 if frmConfirmFile.modalresult=mrNo then
                    begin
                    assignfile(fichier,savedialog1.filename);
                    append(fichier);
                    end;
                 if frmConfirmFile.modalresult=mrCancel then
                    goto label_1;
                 end //fileexists
         else
                 begin
                 assignfile(fichier,savedialog1.filename);
                 rewrite(fichier);
                 end;
         end
      else
         begin
         save_after_retrieve.checked:=false;
         savedialog1.filename:='';
         end;
      end;
   end;     //save seq

for i:=0 to mListSeq.lines.count-1 do
    begin
    seq:=trim(copy(mListSeq.lines[i],1,pos(' ',mListSeq.lines[i]+' ')-1));  //first word
    //range information
    pos1:='';
    pos2:='';
    if (pos(':',seq)<>0) and (pos('-',seq)<>0) then
       begin
       pos2:=copy(seq,pos('-',seq)+1,255);
       delete(seq,pos('-',seq),255);
       pos1:=copy(seq,pos(':',seq)+1,255);
       delete(seq,pos(':',seq),255);
       if strtoint(pos2)<strtoint(pos1) then
           begin
           showmessage('Stop position ('+pos2+') is lower than start position ('+pos1+')');
           pos1:='';
           pos2:='';
           end;
       end;

    if seq='' then
       continue;
    server:=cbServerURL_retrieve.text;

    save_cursor:=screen.cursor;
    screen.cursor:=crHourGlass;
    frmMain.statusbar1.panels[1].text:='Retrieving '+seq+' from server... Please wait';
    application.processmessages;
    flagok:=true;
    server:=AnsiReplaceStr(server,'*',seq);
    //range
    if (pos('http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch',server)<>0) and (pos1<>'') and (pos2<>'') then
         server:=server+'&seq_start='+pos1+'&seq_stop='+pos2;

    seq2:=tstringlist.create;
    if frmPreferences.rb_proxy_server.Checked then
        begin
        idHTTP1.proxyparams.ProxyServer:=frmPreferences.proxy_server.text;
        idHTTP1.proxyparams.ProxyPort:=StrToIntDef(frmPreferences.proxy_port.text, 80);
        end;
    try
        seq2.text:=AdjustLineBreaks(idHTTP1.get(server));
    except
//       on EIdSocketError do
           begin
           statusbar1.panels[1].text:='';
           screen.Cursor:=save_cursor;
           showmessage('Check your internet connection!');
           seq2.free;
           exit;
           end
    end; //try

    statusbar1.panels[1].text:='';
    screen.Cursor:=save_cursor;

    if (pos('ERROR',seq2[0])<>0) or (seq2.IndexOf('Can''t find your query.<br>')<>-1) or (seq2.count=1) or
        (pos('Nothing has been found',seq2.text)<>0)//NCBI error
       or (pos('No entries found.',seq2[0])<>0) //EBI error
       or (pos('accession no. error',seq2.text)<>0)  //DDBJ error
    then
       begin
       if mListSeq.lines.count=1 then
          showmessage('The sequence ID that you specified were not found or were unreadable.');
       seq2.free;
       continue;
       end;
    //remove HTML header
     while (pos('LOCUS       ',seq2[0])=0) and (pos('ID ',seq2[0])=0) do
         seq2.delete(0);
    repeat
        analyse_seq(seq2,sequ,seqformat);
       //check if sequence name contains | character
       {
        while pos('|', sequ.name)<>0 do
            sequ.name := stringreplace( sequ.name, '|', ' ', [rfReplaceAll]);
        }
        if check_seq_name(sequ.name) then
           continue;
        inc(nb_seq);
        new(sq[nb_seq]);
        for j:=0 to tv.items.count-1 do
            if tv.items[j].text='Sequence' then
               break;

        sq[nb_seq]^:=sequ;

        
        check_seq_name(sq[nb_seq]^.name);
        sq[nb_seq]^.seqrtf:=sq[nb_seq]^.seq;
        format_gcg(sq[nb_seq]^.seqrtf,1);
        sq[nb_seq]^.memposheader:=0;
        fwsc(' retrieved from server');

        tnode:=tv.Items.AddchildObject(tv.Items[j],sq[nb_seq]^.name,sq[nb_seq]);
        tnode.makevisible;
        tnode.imageindex:=2;
        tnode.Selected:=true;

        if seqformat='' then
           begin
           showmessage('Unknown format!');
           seq2.free;
           exit;
           end;

        if save_after_retrieve.checked then    //sauve seq
           begin
           if (rb_oneSeqOneFile.checked) then
               begin
               assignfile(fichier,de.Text+'\'+seq+'.txt');
               rewrite(fichier);
               for zz:=0 to seq2.count-1 do
                   writeln(fichier,seq2[zz]);
               closefile(fichier);
               end;
           if (rb_allSeqOneFile.checked) then
               begin
               for zz:=0 to seq2.count-1 do
                   writeln(fichier,seq2[zz]);
               end;
           end;
    until pos('MULTI',seqformat)=0;

    label_1:
    nettoyage_nouvelle_seq;
    fwsc(' retrieved from server');
    seq2.free;
    end; //for

    if (save_after_retrieve.checked) and (rb_allSeqOneFile.checked) then
        closefile(fichier);
    end; //with frmRetrieve
end; //retrieve from server

procedure PlaySound(WavFileName:String);
var s: Array[0..79] of char;
begin
StrPCopy(s,WavFileName);    //Convert filename to a null-terminated string
sndPlaySound(s,0); //Play the sound asynchronously (see mmsystem.hlp for other values)
end;

procedure TfrmMain.Oligonucleotide1Click(Sender: TObject);
var i:byte;
begin
if numoligo>=maxObject then
   begin
   showmessage('The maximum number of oligo is '+inttostr(maxobject));
   exit;
   end;
if flag_mem_menu<>'' then   //menu history
   begin
   nomfichier:=flag_mem_menu;
   open_oligo(nomfichier);
   end
else
   begin
   od.options:=[ofAllowMultiSelect];
   od.title:='Open oligonucleotide';
   od.filename:='';
   od.filter:='AnnHyb''s Oligo format (*.oli, *.ola)|*.oli;*.ola|Single oligo AnnHyb format (*.oli)|*.oli|Multi oligo AnnHyb format (*.ola)|*.ola';
   if od.execute then
      with od.Files do     //ouvertures multiples
           for i:=0 to Count-1  do
               begin
               nomfichier:=Strings[I];
               if nomfichier<>'' then
                  begin
                  open_oligo(nomfichier);
                  flagWorkspaceChanged:=true;
                  end;
               end; //for
   end;
pc.activepage:=tb_oligo;
flag_mem_menu:='';
end;

//ajoute feature  hrsf "selected"
procedure add_feature(deb,fin,coul:integer;nom,comment:string);
var ss:string;
begin
with frmMain do
   begin
   ss:='feature  '+inttostr(deb)+'  '+inttostr(fin)+'  '+inttostr(coul)+' square solid '+nom;
   if comment<>'' then
      ss:=ss+' ///'+comment;
   pSq(tv.selected.Data)^.features:=pSq(tv.selected.Data)^.features+ss+LF;
//   affiche_header;
   end;//with
end;

procedure extract_oligo(s:shortstring);
var sepchar:shortstring;
begin
sepchar:='|';

if (s[1]='1') or (s[1]='3') then
   oligoF.visu:=true
else
   oligoF.visu:=false;
delete(s,1,1); //efface visu

oligoF.nomseq:=copy(s,1,pos(sepchar,s)-1); //extract. nom seq
delete(s,1,pos(sepchar,s));
//sense
oligoF.sense:=s[1];
delete(s,1,pos(sepchar,s));
//init
oligoF.init:=strtoint(copy(s,1,pos(sepchar,s)-1));
//oligoF.init:=posseqtopos(oligoF.init);
delete(s,1,pos(sepchar,s));
//fin
oligoF.fin:=strtoint(copy(s,1,pos(sepchar,s)-1));
//oligoF.fin:=posseqtopos(oligoF.fin);
delete(s,1,pos(sepchar,s));
//score
if copy(s,1,pos(sepchar,s)-1)<>'' then
   oligoF.score:=roundto(strtofloat2(copy(s,1,pos(sepchar,s)-1)),-2)
else
   oligoF.score:=0;
delete(s,1,pos(sepchar,s));
//coul
oligoF.coul:=strtoint(copy(s,1,pos(sepchar,s)-1));
delete(s,1,pos(sepchar,s));
//aligned oligo
oligoF.AlignedOligo:=copy(s,1,pos(sepchar,s)-1);
delete(s,1,pos(sepchar,s));
//aligned target
oligoF.AlignedTarget:=copy(s,1,pos(sepchar,s)-1);
end;  //extract oligo

procedure affiche_features; //paint annotations of selected sequence
var ii,compt:integer;
    i:byte;
    c:char;
    str_primer,str_target:shortstring;
begin
with frmMain do
    begin
    rxgcgseq.lines.BeginUpdate;
    flagselect:=false;
    //delete previous annotations
    flagUpdateRE:=false;
    frmMain.rxgcgseq.selstart:=0;
    frmMain.rxgcgseq.selectall;
    frmMain.rxgcgseq.selAttributes.color:=clBlack;
    frmMain.rxgcgseq.selAttributes.backcolor:=clWindow;

    frmMain.rxgcgseq.selstart:=0;
    frmMain.rxgcgseq.sellength:=0;

    if frmMain.lvAnnotations.items.count>0 then
       for i:=0 to frmMain.lvAnnotations.items.Count-1 do
           begin
           compt:=0;
           //read if annotation is an aligned primer
           if pos('target:',frmMain.lvAnnotations.items[i].SubItems.strings[2])<>0 then
               begin
               str_primer:=copy(frmMain.lvAnnotations.items[i].SubItems.strings[2],pos('seq: ',frmMain.lvAnnotations.items[i].SubItems.strings[2])+5,255);
               str_primer:=split(str_primer,' ',0);
               str_target:=copy(frmMain.lvAnnotations.items[i].SubItems.strings[2],pos('target: ',frmMain.lvAnnotations.items[i].SubItems.strings[2])+8,255);
               end
           else
               begin
               str_primer:='';
               str_target:='';
               end;
           //selection init
           rxgcgseq.selstart:=posseqtopos(strtoint(lvAnnotations.items[i].subitems.strings[0]));
           //selection end
           rxgcgseq.sellength:=posseqtopos(strtoint(lvAnnotations.items[i].subitems.strings[1]))-rxgcgseq.selstart+1;
           _init:=rxgcgseq.selstart;
           _end:=length(rxgcgseq.seltext);
           for ii:=_init to _init+_end-1 do
               begin
               rxgcgseq.selstart:=ii;
               rxgcgseq.sellength:=1;
               //skip if selection is empty
               if rxgcgseq.seltext='' then
                   continue;
               c:=rxgcgseq.seltext[1];
               if upcase(c) in validbase then
                   begin
                   inc(compt);
                   if rxgcgseq.selAttributes.backcolor<>clWindow then
                       rxgcgseq.selAttributes.backcolor:=frmPreferences.overlapping_color.brush.color
                   else
                       rxgcgseq.selAttributes.backcolor:=color_rsf[lvAnnotations.items[i].imageindex];
                   //if background color too dark use white as foreground color
                   frmMain.rxgcgseq.selAttributes.color:=foreground_color(color_rsf[lvAnnotations.items[i].imageindex]);
                   //if annotation is a primer
                   if str_primer<>'' then
                       if str_primer[compt]<>str_target[compt] then
                           frmMain.rxgcgseq.selAttributes.backcolor:=frmPreferences.mismatch_color.brush.color;
 //                  if c<>str_primer[compt] then
//                       frmMain.rxgcgseq.selAttributes.backcolor:=clGreen;
//                        rxgcgseq.Text[rxgcgseq.selstart]:=lowercase(c);
//                       rxgcgseq.seltext[1]:=lowercase(c);

                   end;
               end;
           end; //for

    rxgcgseq.selstart:=0;
    rxgcgseq.sellength:=0;
    rxgcgseq.lines.EndUpdate;
    flagselect:=true;
    flagUpdateRE:=true;
    pSq(tv.Selected.Data)^.seqrtf:=sauvertf; //save only if modified
    pSq(tv.Selected.Data)^.flag_f_ok:=true;
    end;
end;    //paint annotations

procedure chargertf(s:string);
var ms:tmemorystream;
begin
ms:=tmemorystream.create;
ms.WriteBuffer(pointer(s)^,length(s));
ms.Position:=0;
frmMain.rxgcgseq.Lines.beginupdate;
frmMain.rxgcgseq.Lines.LoadFromStream(ms);
frmMain.rxgcgseq.Lines.endupdate;
ms.Free;
end;

procedure TfrmMain.mi_OpenSequenceClick(Sender: TObject);
label ouvre_fichier;
begin
if numseq>=maxObject then
   begin
   showmessage('The maximum number of sequence is '+inttostr(maxobject));
   exit;
   end;
if flag_mem_menu<>'' then
   begin
   nomfichier:=flag_mem_menu;
   if not fileexists(nomfichier) then
      begin
      showmessage('File not found!');
      exit;
      end;
   goto ouvre_fichier;
   end;
od.title:='Open sequence';
od.FileName:='';
od.Filter:='Sequence (*.rsf *.em* *.gb *.fas* *.seq *.gcg)|*.rsf;*.em*;*.gb;*.fas*;*.seq;*.gcg|All files (*.*)|*.*';
od.Filterindex:=1;
pc.activepage:=seqtab;
if od.Execute then
   begin
   nomfichier:=od.FileName;
   ouvre_fichier:
   open_sequence(nomfichier);
   flagWorkspaceChanged:=true;
   end;
flag_mem_menu:='';
end;

procedure seqvisible(flagvisible:boolean);
begin
with frmMain do
    begin
    mmheader.visible:=flagvisible;
    rxgcgseq.visible:=flagvisible;
    ed_seq_name.visible:=flagvisible;
    ed_seq_longname.visible:=flagvisible;
    ed_seq_type.visible:=flagvisible;
    ed_seq_descrip.visible:=flagvisible;
    ed_seq_creator.visible:=flagvisible;
    ed_seq_creationdate.visible:=flagvisible;
    ed_seq_checksum.visible:=flagvisible;
    lvAnnotations.Visible:=flagvisible;
    end;
end;
(*
procedure oligovisible(flagvisible:boolean);
begin
with frmMain do
    begin
    lvAlign.Visible:=flagvisible;
    lbSearchresults.visible:=flagvisible;
    lbname.visible:=flagvisible;
    ed_oligo_name.visible:=flagvisible;
    cbColor.Visible:=flagvisible;
    lbSeq1.visible:=flagvisible;
    lbSeq2.visible:=flagvisible;
    Seq.visible:=flagvisible;
    lbIUB.visible:=flagvisible;
    seq_IUPAC.visible:=flagvisible;
    rev.visible:=flagvisible;
    lbRevComp1.visible:=flagvisible;
    lbRevComp3.visible:=flagvisible;
    lbRevComp4.visible:=flagvisible;
    lbLength1.visible:=flagvisible;
    lbLength2.visible:=flagvisible;
    len.visible:=flagvisible;
    lbMW.visible:=flagvisible;
    mw.visible:=flagvisible;
    lbGC.visible:=flagvisible;
    gc.visible:=flagvisible;
    lbGCGChecksum.visible:=flagvisible;
    GCGChecksum.visible:=flagvisible;
    lbMEC.visible:=flagvisible;
    MEC.visible:=flagvisible;
    unite_mec.visible:=flagvisible;
    lbSalt1.visible:=flagvisible;
    lbSalt2.visible:=flagvisible;
    ed_oligo_salt_cc.visible:=flagvisible;
    lbPrimers1.visible:=flagvisible;
    lbPrimers2.visible:=flagvisible;
    ed_oligo_cc.visible:=flagvisible;
    lbTM1.visible:=flagvisible;
    lbTM2.visible:=flagvisible;
    melt.visible:=flagvisible;
    end;
end;
*)

procedure TfrmMain.new_oligoClick(Sender: TObject);
var i,j,k:integer;
    b:byte;
    TNode:TTreeNode;
    flagoligo,flag_nom_deja_utilise:boolean;
begin
if numoligo>=maxObject then
   begin
   showmessage('The maximum number of oligo is '+inttostr(maxObject));
   exit;
   end;
inc(nb_oligo);
new(o[nb_oligo]);
for i:=0 to tv.items.count-1 do
    if tv.items[i].text='Oligo' then
       break;
o[nb_oligo]^.seq:='';
//parse clipboard for sequence
if (Clipboard.HasFormat(CF_TEXT)) and (length(Clipboard.AsText)<=50) then
   begin
   flagoligo:=true;
   for b:=1 to length(Clipboard.AsText) do
       if not (upcase(Clipboard.AsText[b]) in validbase+[' ']) then
          begin
          flagoligo:=false;
          break;
          end;
   if flagoligo then
      if MessageDlg('Create new oligo with the clipboard sequence?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
         o[nb_oligo]^.seq:=Clipboard.AsText;
   end;

k:=1;
repeat
   o[nb_oligo]^.name:='Oligo'+inttostr(k);
   flag_nom_deja_utilise:=false;
   for j:=0 to frmMain.tv.Items.Count-1 do
       if (frmMain.tv.Items[j].imageindex=c_oligo) and (ansiuppercase(o[nb_oligo]^.name)=ansiuppercase(frmMain.tv.Items[j].text)) then
           begin
           flag_nom_deja_utilise:=true;
           inc(k);
           break;
           end;
until not flag_nom_deja_utilise;

o[nb_oligo]^.salt:=strtofloat2(frmPreferences.defaut_sel.text)*1e-3;
o[nb_oligo]^.conc:=strtofloat2(frmPreferences.defaut_amorces.text)*1e-9;
fwsc('new oligo');
o[nb_oligo]^.found_seq:='';
o[nb_oligo]^.found_ma:='';
o[nb_oligo]^.view:=0;
tnode:=tv.Items.AddchildObject(tv.Items[i],o[nb_oligo]^.name,o[nb_oligo]);
tnode.makevisible;
tnode.imageindex:=c_oligo;

tnode.Selected:=true;
activecontrol:=ed_oligo_name;
end; //new_oligoClick

procedure TfrmMain.mi_newSequenceClick(Sender: TObject);
var i,j,k:integer;
    TNode:TTreeNode;
    ss:shortstring;
    sl:tstringlist;
    flag_nom_deja_utilise:boolean;
begin
if numseq>maxObject then
   begin
   showmessage('The maximum number of sequences is '+inttostr(maxObject));
   exit;
   end;
edit_seq.seqed2.clear;
edit_seq.ShowModal;
if not frmMain.flag_seq_ed_valid then
    exit;
if edit_seq.seqed2.text='' then
   begin
   showmessage('The sequence is empty!');
   exit;
   end;
if not frmMain.flag_seq_ed_valid then
   exit;
with frmSequenceAttributes do
    begin
    s_creation_date.date:=now;
    s_checksum.text:=gcg_checksum(edit_seq.seqed2.text);
    s_name.text:='';
    s_longname.text:='';
    s_description.text:='';
    s_creator.text:='';
    s_comments.clear;
    ShowModal;
    if s_name.text<>'' then
       ss:=s_name.text
    else
       begin
       k:=1;
       repeat
          ss:='Sequence'+inttostr(k);
          flag_nom_deja_utilise:=false;
          for j:=0 to frmMain.tv.Items.Count-1 do
              if (frmMain.tv.Items[j].imageindex=c_sequence) and (ansiuppercase(ss)=ansiuppercase(frmMain.tv.Items[j].text)) then
                  begin
                  flag_nom_deja_utilise:=true;
                  inc(k);
                  break;
                  end;
       until not flag_nom_deja_utilise;
       end;
    inc(nb_seq);
    new(sq[nb_seq]);
    for i:=0 to tv.items.count-1 do
        if tv.items[i].text='Sequence' then
           break;

    sq[nb_seq]^.creationdate:=datetostr(s_creation_date.date);
    sq[nb_seq]^.name:=ss;
    sq[nb_seq]^.longname:=s_longname.text;
    sq[nb_seq]^.descrip:=s_description.text;
    sq[nb_seq]^.creator:=s_creator.text;
    sq[nb_seq]^._type:=s_type.text;

    //comments
    sl:=tstringlist.Create;
    sq[nb_seq]^.hrsf:='';
    sl.Text:=s_comments.Text;
    if sl.count>0 then
       for j:=0 to sl.Count-1 do
           sq[nb_seq]^.hrsf:=sq[nb_seq]^.hrsf+sl[j]+CRLF;
    sl.Free;
    end; //with
sq[nb_seq]^.seq:=clearseq(edit_seq.seqed2.text);
sq[nb_seq]^.seqrtf:=sq[nb_seq]^.seq;
format_gcg(sq[nb_seq]^.seqrtf,1);
sq[nb_seq]^.flag_f_ok:=true;
sq[nb_seq]^.memposheader:=0;
tnode:=tv.Items.AddchildObject(tv.Items[i],sq[nb_seq]^.name,sq[nb_seq]);
tnode.makevisible;
tnode.imageindex:=2;
//tnode.edittext;
tnode.Selected:=true;

rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
affiche_header;
tnode.Selected:=true;
activecontrol:=ed_seq_name;
fwsc('new sequence');
end;

procedure revert_complement(seqname:shortstring;sl:string;p1,p2:integer);
var i:integer;
begin
with frmMain do
    begin
    frmReverseComplement.showmodal;
    if frmReverseComplement.modalresult=mrcancel then
       exit;
    s:='';
    dynform:=TfrmResults.Create(application);
    dynform.rxresults.clear;
    with frmReverseComplement do
       begin
       if rb_r.checked then
          dynform.rxresults.lines.add('Reverse of: '+seqname+'   '+date_time);
       if rb_c.checked then
          dynform.rxresults.lines.add('Complement of: '+seqname+'   '+date_time);
       if rb_rc.checked then
          dynform.rxresults.lines.add('Reverse-Complement of: '+seqname+'   '+date_time);

       dynform.rxresults.lines.add('');

       dynform.rxresults.lines.add(format('Selection: %d > %d',[p1,p2]));
       dynform.rxresults.lines.add(format('Length: %d',[length(sl)]));

        if rb_rc.checked then
           for i:=length(sl) downto 1 do
               begin
               if not (sl[i] in ['0'..'9',#10,#13,' ']) then
                  s:=s+rev_(sl[i]);
               if length(s)>=50 then
                  begin
                  dynform.rxresults.lines.add(s);
                  s:='';
                  end;
               end;
        if rb_r.checked then
           for i:=length(sl) downto 1 do
               begin
               if not (sl[i] in ['0'..'9',#10,#13,' ']) then
                  s:=s+sl[i];
               if length(s)>=50 then
                  begin
                  dynform.rxresults.lines.add(s);
                  s:='';
                  end;
               end;

        if rb_c.checked then
           for i:=1 to length(sl) do
               begin
               if not (sl[i] in ['0'..'9',#10,#13,' ']) then
                  s:=s+rev_(sl[i]);
               if length(s)>=50 then
                  begin
                  dynform.rxresults.lines.add(s);
                  s:='';
                  end;
               end;

          //seq finale ou seq courte
          if s<>'' then
             dynform.rxresults.lines.add(s);
          end; //with reverse_complement
    dynform.caption:='Reverse-Complement sequence';
    dynform.show;
    end;//with form1
end;

{$i make_re_base.inc}

procedure tfrmMain.quicksort(deb,fin:word; ind:byte);
var i,j:word;
    x:cardinal;
    swapstr:shortstring;
begin
with frmMain do
   begin
   i:=deb;
   j:=fin;
   x:=strtoint(copy(frmRE.rresults.items[(deb+fin) div 2],ind,255));
   repeat
       while strtoint(copy(frmRE.rresults.items[i],ind,255))<x do inc(i);
       while x<strtoint(copy(frmRE.rresults.items[j],ind,255)) do dec(j);
       if i<=j then
          begin
          swapstr:=frmRE.rresults.items[i];
          frmRE.rresults.items[i]:=frmRE.rresults.items[j];
          frmRE.rresults.items[j]:=swapstr;
          inc(i);
          dec(j);
          end;
    until i>j;
    end; //with
if deb<j then quicksort(deb,j,ind);
if i<fin then quicksort(i,fin,ind);
end; //quicksort

function Restriction(seqname:shortstring;sl:string;p1,p2:integer):string;
var t,i,ii,j,k,p,comptfreq:integer;
    t1:byte;
    flagnoncut,flagrev:boolean;
    ne,iso,pos1:string[30];
    s1,s2:string[50];
    po:string[10];
    ss2,ss,sfn:shortstring;
    out:array[1..30] of shortstring;
    sl2,r:string;

Type str4=string[4];

label init;

begin
if not fileexists(program_dir+'enz.dat') then
   begin
   showmessage('Error: RE database file not found!');
   exit;
   end;

if not flag_enz_loaded then
   make_re_base(program_dir+'enz.dat');

with frmRE do
     begin
     cutenzlist.clear;
     selectedenz.clear;
     fraglist.clear;
     noc.clear;
     topo.caption:='';

     frmRestrEnzSelect.showmodal;
     if frmRestrEnzSelect.modalresult=mrcancel then
        exit;
     if selectedenz.count=0 then
        begin
        showmessage('No RE selected');
        exit;
        end;

//digestion
save_cursor:=screen.cursor;
screen.Cursor:=crHourGlass;
flagstop:=false;
frmProgress.caption:='Restriction analysis of '+seqname+' in progress...';
frmProgress.label1.caption:='Please wait...';
frmProgress.btnCancel.visible:=true;
frmProgress.show;
k:=0;
flagrev:=false;
assignfile(fichier,profile_dir+'annhyb_results.map');
rewrite(fichier);

while k<selectedenz.count do
    begin
    application.processmessages;
    if flagstop then
       begin
       frmProgress.hide;
       screen.Cursor:=save_cursor;
       exit;
       end;
    application.ProcessMessages;
    frmProgress.progressbar1.position:=round(k/selectedenz.count*100);
    ne:=trim(copy(selectedenz[k],1,20));  //nom enzyme
    iso:=selectedenz[k][21];              //iso ?
    s1:=trim(copy(selectedenz[k],22,25));  // site
    pos1:=trim(copy(selectedenz[k],52,3));  //pos coupure ds site
    init:
    flag_degen:=false;
    for i:=1 to length(s1) do
        if s1[i] in ['Y','R','W','S','K','M','B','D','H','V','N'] then
           begin
           flag_degen:=true;
           break;
           end;
    if not flag_degen then
       begin
       sl2:=sl;
       repeat
         p:=pos(s1,sl2);
         if p<>0 then
            begin
            po:=inttostr(p+strtoint(pos1));
            while length(po)<6 do
                      po:=' '+po;
            cutenzlist.add(ne+'|'+po);

            writeln(fichier,trim(ne)+' '+trim(po));
            sl2[p]:='*'
            end;
       until p=0;
       end
    else   //seq enz degenre
       begin
          //vrif si seq + longue que site re
          if length(sl)>=length(s1) then
          for i:=1 to length(sl)-length(s1)+1  do
              begin
              compt:=0;
              for j:=1 to length(s1) do
                  if (sl[i-1+j]=s1[j]) or (pos(sl[i-1+j],code[ord(s1[j])-64])<>0) then
                     inc(compt)
                  else
                      break;
              if compt>=length(s1) then
                 begin
                 po:=inttostr(i+strtoint(pos1));
                 while length(po)<6 do
                    po:=' '+po;
                 cutenzlist.add(ne+'|'+po);

(*========*)     writeln(fichier,trim(ne)+' '+trim(po));

                 end;
              end;
          end;
    //test si seq. est palindrome
    if not flagrev then
       begin
       s2:='';
       for i:=length(s1) downto 1 do
           s2:=s2+rev_(s1[i]);
       if s2<>s1 then
          begin
          flagrev:=true;
          s1:=s2;
          goto init;
          end;
       end;
    flagrev:=false;
    inc(k);
    end;

dynform:=TFrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    rxresults.lines.add('Restriction map of: '+seqname+'   '+date_time);
    rxresults.lines.add('');

    rxresults.lines.add(format('Selection: %d > %d',[p1,p2]));
    rxresults.lines.add('Length: '+inttostr(length(sl)));

    rxresults.lines.add('');
    rxresults.lines.add('With '+inttostr(selectedenz.count)+' enzymes');

    rxresults.lines.add('');
    rxresults.lines.add(date_time);
    rxresults.lines.add('');
    rxresults.lines.add('');

    t:=1;
    i:=0;
    repeat
       inc(i);
       if i=61 then
          i:=1;
       if i=1 then
          begin
          for j:=1 to 30 do
              out[j]:=space80;
          // seq sense
          ss2:='';
          for j:=0 to 59 do
              if t+j<=length(sl) then
                 ss2:=ss2+sl[t+j];
          str((t div 60)*60+1,sfn);
          while length(sfn)<8 do
             sfn:=' '+sfn;
          rxresults.lines.add('          '+ss2);
          //separateur
          ss:='';
          for t1:=1 to length(ss2) do
              if t1 mod 10=0 then
                 ss:=ss+'+'
              else
                 ss:=ss+'-';
          ss:=sfn+'  '+ss;
          //pos fin sparateur
          str((t div 60)*60+1+59,sfn);
          ss:=ss+' '+sfn;
          rxresults.lines.add(ss);
          //seq anti
          ss:='';
          for t1:=1 to length(ss2) do
              ss:=ss+rev_(ss2[t1]);
          rxresults.lines.add('          '+ss);
          end;
       str(t,ss2);
       reset(fichier);
       repeat
         readln(fichier,s1);
         if copy(s1,pos(' ',s1)+1,255)=ss2 then
            begin
            j:=0;
            repeat
              inc(j);
              if j=31 then
                 begin
                 showmessage('Too much restriction sites!');
                 exit;
                 end;
            until (out[j][i]=' ') and ((out[j][i-1]=' ') or (i=1));
            for k:=1 to length(copy(s1,1,pos(' ',s1)-1)) do  //reprise de cutpos pour conomie
                out[j][i+k-1]:=s1[k];
            end;
       until eof(fichier);
       inc(t);
       if i=60 then
          begin
          for j:=1 to 30 do
              if out[j]<>space80 then
                 begin
                 rxresults.lines.add('          '+out[j]);
                 end;
          rxresults.lines.add('');
          end;
    until t=length(sl);

    //rsidu
    if i<60 then
          begin
          for j:=1 to 20 do
              if out[j]<>space80 then
                 begin
                 rxresults.lines.add('          '+out[j]);
                 end;
            rxresults.lines.add('');
          end;

    rxresults.lines.add('');
    rxresults.lines.add('');
    rxresults.lines.add('');

    rxresults.lines.add('Enzyme         Site                             Freq   Positions');
    rxresults.lines.add('----------------------------------------------------------------');

    //tableau
    if cutenzlist.count>0 then
       begin
        for k:=0 to selectedenz.count-1 do
            begin
            ss2:='';
            s1:=trim(copy(selectedenz[k],1,20));
            //nb sites et positions
            comptfreq:=0;
            for i:=0 to cutenzlist.count-1 do
                begin
                if s1=copy(cutenzlist[i],1,pos('|',cutenzlist[i])-1) then
                   begin
                   inc(comptfreq);
                   if ss2='' then
                      begin
                      ss2:=s1;
                      while length(ss2)<15 do
                         ss2:=ss2+' ';
                      //site de coupure
                      ss2:=ss2+trim(copy(selectedenz[k],22,25));
                      while length(ss2)<49 do
                         ss2:=ss2+' ';
                      //position de coupure
                      ss2:=ss2+trim(copy(cutenzlist[i],pos('|',cutenzlist[i])+1,255));
                      end
                   else
                      begin
                      if length(ss2)>80 then
                         begin
                         insert('      ',ss2,49);
                         rxresults.lines.add(ss2);
                         ss2:='';
                         while length(ss2)<49 do
                             ss2:=ss2+' ';
                         end;
                      if ss2<>'                                                 ' then
                         ss2:=ss2+', ';
                      ss2:=ss2+trim(copy(cutenzlist[i],pos('|',cutenzlist[i])+1,255));
                      end;
                   end;
                end;
            if ss2<>'' then
               begin
               s1:=inttostr(comptfreq);
               while length(s1)<6 do
                   s1:=s1+' ';
               insert(s1,ss2,49);
               rxresults.lines.add(ss2);
               end;
            end;

       end;

    rxresults.lines.add('');
    rxresults.lines.add('');
    rxresults.lines.add('');


    rxresults.lines.add('Enzymes that do not cut:');
    rxresults.lines.add('------------------------');
    rxresults.lines.add('');

    ss2:='';
    for i:=0 to selectedenz.count-1 do
        begin
        flagnoncut:=true;
        s1:=trim(copy(selectedenz[i],1,20));
        if cutenzlist.count>0 then
        for j:=0 to cutenzlist.count-1 do
            if s1=copy(cutenzlist[j],1,pos('|',cutenzlist[j])-1) then
               begin
               flagnoncut:=false;
               break;
               end;
        if flagnoncut then
           begin
           while (length(ss2) mod 10)<>0 do
              ss2:=ss2+' ';
           ss2:=ss2+trim(copy(selectedenz[i],1,20));
           if length(ss2)>=50 then
              begin
              rxresults.lines.add(ss2);
              ss2:='';
              end;
           end;
        end;

    //rsidu
    if ss2<>'' then
       rxresults.lines.add(ss2);

    screen.Cursor:=save_cursor;
    frmProgress.hide;
    closefile(fichier);
    deletefile(pchar(profile_dir+'annhyb_results.map'));
    if cutenzlist.count=0 then
       begin
       showmessage('No cutting enzyme found');
       exit;
       end;

    //re.enabled:=true;
    _init:=1;
    ls:=length(sl);
    _end:=ls;

    rresults.sorted:=false;
    cutenzlist.sorted:=true;
    //tri enz. par nom
    rb_name.checked:=false;
    rb_name.checked:=true;
    if frmRestrEnzSelect.rb_lin.checked then
       topo.caption:='Linear'
    else
       topo.caption:='Circular';

    caption:='Restriction analysis';
    show;
    end;//with dynform

frmRE.Showmodal;
end;//with form1
end; //restriction

{$i base_composition.inc}

function show_homology(s1,s2:string):string;
var i:integer;
    s:string;
begin
s:='';
for i:=1 to length(s1) do
    if s1[i]=s2[i] then
       s:=s+'|'
    else
       s:=s+' ';
show_homology:=s;
end;

procedure search_sequence;
var t,j:integer;
    querystr,seqg,revs:string;
    fasta_sl:tstringlist;
begin
with frmMain do
      begin
      dynform:=tfrmResults.Create(application);
      frmstringsearch.query.clear;
      frmstringsearch.caption:='Align sub-sequence';
      repeat
         frmstringsearch.showmodal;
         if frmstringsearch.modalresult=mrcancel then
            exit;
         querystr:=uppercase(clearseq(frmstringsearch.query.text));
         if length(querystr)<4 then
            showmessage('Sequence too short!');
      until length(querystr)>=4;
      if querystr='' then
         exit;
      //select sequences
      if not select_oligo_seq(c_sequence,'Select sequences') then
           exit;

      //flagfound:=false;
      dynform.rxresults.clear;
      dynform.caption:='Results of sub-sequence alignment';
      dynform.rxresults.lines.add('Results of sub-sequence alignment '+date_time);
      dynform.rxresults.lines.add('');

      dynform.rxresults.lines.add('Sequence found at:');
      dynform.rxresults.lines.add('------------------');
      dynform.rxresults.lines.add('');

      for j:=0 to tv.Items.count-1 do
          if tv.Items[j].imageindex=c_sequence then
             if (pos('**'+ansiuppercase(pSq(tv.items[j].data)^.name)+'**',seqListe)<>0) then
                 begin
                 seqg:=uppercase(pSq(tv.items[j].data)^.seq);
                 application.processmessages;
                 fasta_sl:=tstringlist.create;
                 loc_al(seqg,querystr,fasta_sl);

                 if strtoint(fasta_sl[0])<>0 then
                    repeat
                       dynform.rxresults.lines.add(pSq(tv.items[j].data)^.name);
                       dynform.rxresults.lines.add('position: '+fasta_sl[0]+' - '+inttostr(strtoint(fasta_sl[0])+length(querystr)-1));
                       dynform.rxresults.lines.add(format('score: %3.2f',[strtofloat(fasta_sl[1])]));
                       dynform.rxresults.lines.add(fasta_sl[2]);
                       dynform.rxresults.lines.add(show_homology(fasta_sl[2],fasta_sl[3]));
                       dynform.rxresults.lines.add(fasta_sl[3]);
                       dynform.rxresults.lines.add('');

                       fasta_sl.Delete(0);  //0
                       fasta_sl.Delete(0);
                       fasta_sl.Delete(0);
                       fasta_sl.Delete(0);
                    until fasta_sl.count=0;

                 //antisense
                 if frmstringsearch.cbBothSenses.checked then
                    begin
                    fasta_sl.Clear;
                    //reverse complement seq
                    revs:='';
                    for t:=1 to length(querystr) do
                        revs:=rev_(querystr[t])+revs;

                    loc_al(seqg,revs,fasta_sl);

                    if strtoint(fasta_sl[0])<>0 then
                       repeat
                          dynform.rxresults.lines.add(pSq(tv.items[j].data)^.name+'  /rev');
                          dynform.rxresults.lines.add('position: '+fasta_sl[0]+' - '+inttostr(strtoint(fasta_sl[0])+length(querystr)-1));
                          dynform.rxresults.lines.add(format('score: %3.2f',[strtofloat(fasta_sl[1])]));
                          dynform.rxresults.lines.add(fasta_sl[2]);
                          dynform.rxresults.lines.add(show_homology(fasta_sl[2],fasta_sl[3]));
                          dynform.rxresults.lines.add(fasta_sl[3]);
                          dynform.rxresults.lines.add('');
                          fasta_sl.Delete(0);
                          fasta_sl.Delete(0);
                          fasta_sl.Delete(0);
                          fasta_sl.Delete(0);
                       until fasta_sl.count=0;
                    end; //antisense
                 fasta_sl.Free;
                 end;
      dynform.Show;
      end; //with
end; //sear sequence

procedure Find_ORF(seqname:shortstring;sl:string;p1,p2:integer);
var poseq,_inc,l_sl:integer;
label fin_orf;
begin
with frmMain do
begin
flagstop:=false;
repeat
    frmFindOrf.showmodal;
    if frmfindorf.modalresult=mrcancel then
       exit;
    if frmfindorf.mol.text='' then
       showmessage('Please select an ORF minimal length in aa')
    else
        begin
        val(frmfindorf.mol.text,_inc,erreur);
        if erreur<>0 then
           showmessage('Please insert a numerical value');
        end;
until frmfindorf.mol.text<>'';

dynform:=tfrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='ORF';
    rxresults.lines.add('Search ORF for: +'+seqname+'   '+date_time);
    rxresults.lines.add('');
    rxresults.lines.add(format('Selection: %d > %d',[p1,p2]));
    rxresults.lines.add('Length: '+inttostr(length(sl)));
    rxresults.lines.add('');
    rxresults.lines.add('ORF found (sense):');
    rxresults.lines.add('------------------');
    rxresults.lines.add('');
    if not flagtoute then
       _inc:=p1-1
    else
       _inc:=0;
    poseq:=1;

    frmProgress.caption:='Find ORF in sequence...';
    frmProgress.label1.caption:='Please wait...';
    frmProgress.btnCancel.visible:=true;
    application.processmessages;
    frmProgress.progressbar1.position:=0;
    frmProgress.show;

    l_sl:=length(sl);
    while poseq<=l_sl-2 do
        begin
        application.processmessages;
        if flagstop then
           goto fin_orf;
        compt:=0;
        if (sl[poseq]='A') and (sl[poseq+1]='T') and (sl[poseq+2]='G')
         (*  or (poseq=1) or (poseq=2) or (poseq=3) *) then
            begin
            poseq2:=poseq+3;
            while poseq2<l_sl-2 do
                begin
                application.processmessages;
                if flagstop then
                    goto fin_orf;
                if ((sl[poseq2]='T') and (sl[poseq2+1]='A') and (sl[poseq2+2]='G')) or
                   ((sl[poseq2]='T') and (sl[poseq2+1]='G') and (sl[poseq2+2]='A')) or
                   ((sl[poseq2]='T') and (sl[poseq2+1]='A') and (sl[poseq2+2]='A')) then
                    begin
                    if (_inc+poseq2+2-(_inc+poseq)+1)>=strtoint(frmfindorf.mol.text) then
                        begin
                        rxresults.lines.add('Frame: '+inttostr(((_inc+poseq-1) mod 3)+1)+'   '+inttostr(_inc+poseq)+' .. '+inttostr(_inc+poseq2+2)+'   Length: '+inttostr(_inc+poseq2+2-(_inc+poseq)+1)+ '  ('+inttostr(((_inc+poseq2+2-(_inc+poseq)+1) div 3)-1)+' aa)');
                        break;
                        end
                    else
                        break; //annulle recherche fin ORF car trop court
                    end;
                inc(poseq2,3);
                end;
            end;
        inc(poseq);
        frmProgress.progressbar1.position:=round(poseq/l_sl*50);
        end;

    //recherche antisens
    if frmfindorf.f6.checked then
        begin
     //reversion seq
        s:='';
        for poseq:=l_sl downto 1 do
            s:=s+rev_(sl[poseq]);
        sl:=s;
        s:='';

        rxresults.lines.add('');
        rxresults.lines.add('');
        rxresults.lines.add('ORF found (antisense):');
        rxresults.lines.add('----------------------');
        rxresults.lines.add('');

        poseq:=1;
        while poseq<=l_sl-2 do
            begin
            application.processmessages;
            if flagstop then
                goto fin_orf;
            compt:=0;
            if (sl[poseq]='A') and (sl[poseq+1]='T') and (sl[poseq+2]='G')
            (*   or (poseq=1) or (poseq=2) or (poseq=3) *) then
                begin
                poseq2:=poseq+3;
                while poseq2<l_sl-2 do
                    begin
                    application.processmessages;
                    if flagstop then
                        goto fin_orf;
                    if ((sl[poseq2]='T') and (sl[poseq2+1]='A') and (sl[poseq2+2]='G')) or
                       ((sl[poseq2]='T') and (sl[poseq2+1]='G') and (sl[poseq2+2]='A')) or
                       ((sl[poseq2]='T') and (sl[poseq2+1]='A') and (sl[poseq2+2]='A')) then
                        begin
                        if (_inc+poseq2+2-(_inc+poseq)+1)>=strtoint(frmfindorf.mol.text) then
                            begin
                            rxresults.lines.add('Frame: -'+inttostr(((length(sl)-poseq+1-1) mod 3)+1)+'   '+inttostr(length(sl)-poseq+1)+' .. '+inttostr(length(sl)-poseq2-1)+'   Length: '+inttostr(length(sl)-poseq+1-(length(sl)-poseq2-1)+1)+ '  ('+inttostr(((length(sl)-poseq+1-(length(sl)-poseq2-1)+1) div 3)-1)+' aa)');
                            break;
                            end
                        else
                            break; //annulle recherche fin ORF car trop court
                        end;
                    inc(poseq2,3);
                    end;
                end;
            inc(poseq);
            frmProgress.progressbar1.position:=round(50+poseq/l_sl*50);
            end;
        end; //6f.checked
       fin_orf:
       frmProgress.hide;

       sl:='';

       if not flagstop then
           Show;
       end;
    end;//with
end;

//{$i codon_usage.inc}

procedure split(s,s2:string;var sl:tstringlist);
begin
sl.Text:=stringreplace(s,s2,#13,[rfReplaceAll]);
end;

procedure load_init;
var i:integer;
    itm:tlistitem;
    last_check:double;
    sl:tstringlist;
begin
with frmPreferences do
     begin
     IniFile:=Tinifile.create(profile_dir+'annhyb.ini');
     revs:=inifile.readstring('version','version','');
     //general
     cb_AskBeforeClosingResults.Checked:=inifile.readbool('general','AskBeforeClosingResults',true);
     cb_includedate.checked:=inifile.readbool('printing','includedate',true);
     rgTextFormat.itemindex:=inifile.readinteger('general','OutputTextFormat',0);

     //seq reader
(*     cb_readseq.checked:=inifile.readbool('speech','readseq',false);
     edit1.text:=inifile.readstring('speech','DelayBetweenBases','');
     edit2.text:=inifile.readstring('speech','GroupEveryBases','');
     edit3.text:=inifile.readstring('speech','DelayBetweenGroup','');
*)
     //tm
     defaut_sel.text:=inifile.readstring('melting','SaltConc','50');
     frmMain.ed_oligo_salt_cc.text:=defaut_sel.text;
     defaut_amorces.text:=inifile.readstring('melting','PrimerConc','250');
     frmMain.ed_oligo_cc.text:=defaut_amorces.text;
     defaut_sel_seq.text:=inifile.readstring('melting','SaltConcSeq','50');
     defaut_amorces_seq.text:=inifile.readstring('melting','PrimerConcSeq','250');
     long_seq_salt_tm.text:=inifile.readstring('melting','SaltConcLongSeq','50');

     frmMain.bibTm:=inifile.readstring('melting','BiblioTmAlgo','Allawi, 1997');
     frmMain.setTmAlgo(frmMain.bibTm);

     //MEC
     rb.checked:=inifile.readbool('mec','rb',false);
     rb09.checked:=inifile.readbool('mec','rb09',true);
     rbmec.checked:=inifile.readbool('mec','rbmec',false);
     edA.text:=inifile.readstring('mec','A','15400');
     edC.text:=inifile.readstring('mec','C','7300');
     edG.text:=inifile.readstring('mec','G','11700');
     edT.text:=inifile.readstring('mec','T','8800');

     //Internet
     s:=inifile.readstring('retrieve','Server Address List','');
     sl:=tstringlist.create;
     split(s,'|',sl);
     if s<>'|' then
        for i:=0 to sl.Count-1 do
            if  cbServerURL.Items.indexof(sl[i])=-1 then
                 cbServerURL.Items.Add(sl[i]);
     sl.Free;

//     frmretrieve.server_adress.text:=inifile.readstring('retrieve','Server Address','');
//     edDefaultServer.text:=frmretrieve.server_adress.text;
     cbServerURL.itemindex:=cbServerURL.Items.indexof(inifile.readstring('retrieve','Server Address',''));
     //proxy
     proxy_server.text:=inifile.readstring('retrieve','Proxy server','');
     proxy_port.text:=inifile.readstring('retrieve','Proxy port','');
     if (proxy_server.text<>'') and (proxy_port.text<>'') then
        rb_proxy_server.checked:=true;

     if inifile.readstring('melting','CalcSelTm','true')='true' then
        frmMain.calctm1.checked:=true
     else
        frmMain.calctm1.checked:=false;

     //quicksearch / align oligo
     //automatic color
     sh_oligo1.brush.color:=inifile.readinteger('search_oligo','OligoColor1',clRed);
     sh_oligo2.brush.color:=inifile.readinteger('search_oligo','OligoColor2',clLime);
     sh_oligo3.brush.color:=inifile.readinteger('search_oligo','OligoColor3',clYellow);
     sh_oligo4.brush.color:=inifile.readinteger('search_oligo','OligoColor4',clBlue);
     sh_oligo5.brush.color:=inifile.readinteger('search_oligo','OligoColor5',clFuchsia);
     sh_oligo6.brush.color:=inifile.readinteger('search_oligo','OligoColor6',clAqua);
     sh_oligo7.brush.color:=inifile.readinteger('search_oligo','OligoColor7',clMaroon);
     sh_oligo8.brush.color:=inifile.readinteger('search_oligo','OligoColor8',clGreen);
     sh_oligo9.brush.color:=inifile.readinteger('search_oligo','OligoColor9',clNavy);
     sh_oligo10.brush.color:=inifile.readinteger('search_oligo','OligoColor10',clPurple);
     sh_oligo11.brush.color:=inifile.readinteger('search_oligo','OligoColor11',clTeal);
     sh_oligo12.brush.color:=inifile.readinteger('search_oligo','OligoColor12',clGray);
     //overlapping features color
     overlapping_color.brush.color:=inifile.readinteger('features','overlapping_features_color',$004080FF);
     //mismatch color
     mismatch_color.brush.color:=inifile.readinteger('features','mismatch_color',$00C080FF);
     //Automatic check best found oligo
     cbAutomaticCheckBestOligo.checked:=inifile.readbool('search_oligo','AutomaticCheckBestOligo',true);
     edOligoThreshold_seq.enabled:=cbAutomaticCheckBestOligo.checked;
     lbOligoThreshold.enabled:=cbAutomaticCheckBestOligo.checked;
     edOligoThreshold_seq.Text:=inifile.readstring('search_oligo','OligoThreshold','90');
     edOligoThreshold_ma.Text:=inifile.readstring('search_oligo','OligoThreshold_ma','90');

     //check update
     cb_check_update.checked:=inifile.readbool('Update','check',true);
     last_check:=inifile.readfloat('Update','lastcheck',0);
     if (cb_check_update.checked) and (daysbetween(now,last_check)>=15) then
         begin
         frmMain.check_version(false);
         inifile.WriteFloat('Update','lastcheck',now);
         end;

     //pos. & dim.

     //inifile.Writeinteger('position','state',ord(self.windowstate));
     frmMain.left:=inifile.readinteger('position','left',0);
     //  frmMain.top:=strtoint(inifile.readstring('position','top','0'));
     //  frmMain.width:=strtoint(inifile.readstring('position','width','680'));
     //  frmMain.height:=strtoint(inifile.readstring('position','height','400'));
     end;

with frmmain do
    begin
    recipient_tv.Width:=inifile.readInteger('position','treeview_width',120);

    //font
    mmHeader.Font.Name:=inifile.readstring('font','header_font_name','Courier new');
    mmHeader.Font.size:=inifile.readinteger('font','header_font_size',9);
    frmPreferences.ed_seq_header_font.font.name:=mmHeader.Font.Name;
    frmPreferences.ed_seq_header_font.font.size:=mmHeader.Font.size;

    lvAnnotations.Font.Name:=inifile.readstring('font','features_font_name','Arial');
    lvAnnotations.Font.size:=inifile.readinteger('font','features_font_size',7);
    frmPreferences.ed_seq_features_font.font.name:=lvAnnotations.Font.Name;
    frmPreferences.ed_seq_features_font.font.size:=lvAnnotations.Font.size;

    rxgcgseq.Font.Name:=inifile.readstring('font','sequence_font_name','Courier new');
    rxgcgseq.Font.size:=inifile.readinteger('font','sequence_font_size',10);
    frmPreferences.ed_seq_font.font.name:=rxgcgseq.Font.Name;
    frmPreferences.ed_seq_font.font.size:=rxgcgseq.Font.size;
    rxgcgseq.SelectAll;
    rxgcgseq.SelAttributes.name:=rxgcgseq.font.name;
    rxgcgseq.SelAttributes.size:=rxgcgseq.font.size;
    rxgcgseq.SelStart:=0;

    tv.Font.Name:=inifile.readstring('font','tree_font_name','Arial');
    tv.Font.size:=inifile.readinteger('font','tree_font_size',10);

    //recent projects
    for i:=0 to 9 do
        recent_projects.Add(inifile.readstring('recent projects','project'+inttostr(i),''));
    menu_recent_projects;
    end;
inifile.free;
end; //load init

procedure TfrmMain.FormShow(Sender: TObject);
begin

frmMain.caption:='AnnHyb '+version;
application.Title:='AnnHyb '+version;
pc.ActivePage:=tabOligoList;
pn_ma_info.Height:=26;

if fileexists(profile_dir+'annhyb.ini') then
    load_init
else //first run
    begin
    Showmessage('You run AnnHyb for the first time!'+crlf+
                'See File / Preferences to set program parameters.'+crlf+crlf+
                'Please note that AnnHyb will try to access to internet to check for AnnHyb updates.'+crlf+
                'You can disable this feature in the Preferences window.');
    load_init;
    end;            

//clipboard verification
//can_paste(clipboard.HasFormat(CF_TEXT));

//ouverture fichier en ligne de commande
if paramcount<>0 then
   begin
   if (pos('.OLI',ansiuppercase(paramstr(1)))<>0) or (pos('.OLA',ansiuppercase(paramstr(1)))<>0) then
      open_oligo(paramstr(1))
   else if (pos('.ALN',ansiuppercase(paramstr(1)))<>0) then
      open_multialign_file(paramstr(1))
   else
      open_sequence(paramstr(1));
   end; //paramcount
end; //frmMain.show

procedure TfrmMain.revChange(Sender: TObject);
var revs,ss:shortstring;
    t:byte;
begin
if activecontrol=rev then
   begin
   ss:=format_iupac(rev.text,false);
   revs:='';
   for t:=1 to length(ss) do
       revs:=rev_(ss[t])+revs;
   seq.text:=revs;
   end;
end;

procedure TfrmMain.Memo2Change(Sender: TObject);
begin
seqtab.tabvisible:=true;
end;

procedure affiche_align_results(s:string);
var ns:shortstring;
    itm:tlistitem;
begin
with frmMain do
   begin
//   lvAlign.clear;
   while s<>'' do
      begin
      itm:=lvAlign.Items.Add;
      extract_oligo(copy(s,1,pos(LF,s)-1));
      itm.Checked:=oligoF.visu;
      itm.Caption:=oligoF.nomseq;
      itm.SubItems.Add(oligoF.sense);  //sense
      itm.SubItems.Add(inttostr(oligoF.init));  //init
      itm.SubItems.Add(inttostr(oligoF.fin));  //fin
      str(oligoF.score:4:2,ns);
      itm.SubItems.Add(ns);  //score
      itm.SubItems.Add(oligoF.AlignedOligo); //seq oligo aligne
      delete(s,1,pos('|',s));
      itm.SubItems.Add(oligoF.AlignedTarget); //seq target aligne
      itm.SubItems.Add(inttostr(oligoF.coul)); //coul
      delete(s,1,pos(LF,s));
      end; //while s<>''
   end; //with
end;

procedure add_checked_oligo_to_features;
var i,j,k,l:integer;
    sl,sl2:tstringlist;
    flag_already_featured:boolean;
begin
with frmMain do
for i:=0 to tv.items.Count-1 do
    if (tv.items[i].imageindex=c_oligo) and (pTo(tv.Items[i].Data)^.view<>0) then
       begin
       sl:=tstringlist.Create;
       sl.Text:=pTo(tv.Items[i].Data)^.found_seq;
       for k:=0 to sl.count-1 do
           begin
           extract_oligo(sl[k]);
           if oligoF.visu then //ajoute oligo comme feature
              for j:=0 to tv.items.Count-1 do
                  if tv.items[j].imageindex=c_sequence then
                     if oligoF.nomseq=pSq(frmMain.tv.items[j].data)^.name then
                         begin
                         sl2:=tstringlist.create;
                         sl2.text:=pSq(frmMain.tv.items[j].data)^.features;
                         flag_already_featured:=false;
                         if sl2.count>0 then
                            for l:=sl2.count-1 downto 0 do
                                if (pos(inttostr(oligoF.init)+' ',sl2[l])<>0)
                                   and (pos(inttostr(oligoF.fin)+' ',sl2[l])<>0)
                                   and (pos(inttostr(oligoF.coul)+' ',sl2[l])<>0)
                                   and (pos('sense: '+oligoF.sense+' ',sl2[l])<>0)
                                   and (pos('seq: '+oligoF.alignedOligo+' ',sl2[l])<>0)
                                   and (pos('target: '+oligoF.alignedTarget,sl2[l])<>0)
                                   and (pos(pTo(tv.Items[i].Data)^.name,sl2[l])<>0) then
                                       flag_already_featured:=true;
                         sl2.free;
                         if not flag_already_featured then

//                     if pos('feature  '+inttostr(oligoF.init)+'  '+inttostr(oligoF.fin)+'  '+inttostr(oligoF.coul)+' square solid '+pTo(tv.Items[i].Data)^.name,pSq(frmMain.tv.items[j].data)^.features)=0 then
                             pSq(frmMain.tv.items[j].data)^.features:=pSq(frmMain.tv.items[j].data)^.features
                                                                    +'feature  '+inttostr(oligoF.init)+'  '
                                                                    +inttostr(oligoF.fin)+'  '
                                                                    +inttostr(oligoF.coul)+' square solid '
                                                                    +pTo(tv.Items[i].Data)^.name
                                                                    +' ///found oligo score: '+floattostr2(oligoF.score)
                                                                    +' sense: '+oligoF.sense
                                                                    +' seq: '+oligoF.AlignedOligo
                                                                    +' target: '+oligoF.AlignedTarget+LF;
                         end;
           if not oligoF.visu then  //retire oligo des features
              for j:=0 to tv.items.Count-1 do
                  if tv.items[j].imageindex=c_sequence then
                     if oligoF.nomseq=pSq(frmMain.tv.items[j].data)^.name then
                        begin
                        sl2:=tstringlist.create;
                        sl2.text:=pSq(frmMain.tv.items[j].data)^.features;
                        if sl2.count>0 then
                           for l:=sl2.count-1 downto 0 do
                         (*      showmessage(sl2[l]+#13#10
                                           +inttostr(oligoF.init)+' '+#13#10
                                           +inttostr(oligoF.fin)+' '+#13#10
                                           +inttostr(oligoF.coul)+' '+#13#10
                                           +'sense: '+oligoF.sense+' '+#13#10
                                           +'seq: '+oligoF.alignedOligo+' '+#13#10
                                           +'target: ###'+oligoF.alignedTarget+'### '+#13#10
                                           +pTo(tv.Items[i].Data)^.name+#13#10);*)
                               if (pos(inttostr(oligoF.init)+' ',sl2[l])<>0) and
                                  (pos(inttostr(oligoF.fin)+' ',sl2[l])<>0) and
                                  (pos(inttostr(oligoF.coul)+' ',sl2[l])<>0) and
                                  (pos('sense: '+oligoF.sense+' ',sl2[l])<>0) and
                                  (pos('seq: '+oligoF.alignedOligo+' ',sl2[l])<>0) and
                                  (pos('target: '+oligoF.alignedTarget,sl2[l])<>0) and
                                  (pos(pTo(tv.Items[i].Data)^.name,sl2[l])<>0) then
                                  sl2.delete(l);
                        pSq(frmMain.tv.items[j].data)^.features:=sl2.text;
                        sl2.free;
                        end;
           end; //while s<>''
       sl.Free;
       end;
end; //add_found_oligo_to_features;

procedure check_best_aligned_oligo;
var i,j:integer;
    sl:tstringlist;
begin
with frmMain do
for i:=0 to tv.items.Count-1 do
   if (tv.items[i].imageindex=c_oligo) and (pTo(tv.Items[i].Data)^.view<>0) then
      begin
      sl:=tstringlist.create;
      sl.text:=pTo(tv.Items[i].Data)^.found_seq;
      for j:=0 to sl.count-1 do
            begin
            extract_oligo(sl[j]);
            s:=sl[j];
            if oligoF.score>=strtofloat2(frmPreferences.edOligoThreshold_seq.text) then
               s[1]:='3'  //check oligo
            else
               s[1]:='2';    //uncheck oligo
            sl[j]:=s;
            end; //while s<>''
      pTo(tv.Items[i].Data)^.found_seq:=sl.text;
      end;
add_checked_oligo_to_features;
end; //check best aligned oligo

function color_oligo(i:integer):Tcolor;
begin
case (i mod 12) of   1:color_oligo:=frmPreferences.sh_oligo1.brush.color;
                     2:color_oligo:=frmPreferences.sh_oligo2.brush.color;
                     3:color_oligo:=frmPreferences.sh_oligo3.brush.color;
                     4:color_oligo:=frmPreferences.sh_oligo4.brush.color;
                     5:color_oligo:=frmPreferences.sh_oligo5.brush.color;
                     6:color_oligo:=frmPreferences.sh_oligo6.brush.color;
                     7:color_oligo:=frmPreferences.sh_oligo7.brush.color;
                     8:color_oligo:=frmPreferences.sh_oligo8.brush.color;
                     9:color_oligo:=frmPreferences.sh_oligo9.brush.color;
                     10:color_oligo:=frmPreferences.sh_oligo10.brush.color;
                     11:color_oligo:=frmPreferences.sh_oligo11.brush.color;
                     0:color_oligo:=frmPreferences.sh_oligo12.brush.color;
                     end;

end;

procedure TfrmMain.mi_alignPrimersClick(Sender: TObject);
var i,noligo:integer;
begin
noligo:=0;
for i:=0 to tv.Items.Count-1 do
    if tv.Items[i].imageindex=c_oligo then
        if pto(tv.items[i].data)^.view<>0 then
            begin
            inc(noligo);
            break;
            end;
//choose oligo to align
if noligo=0 then
    if not select_oligo_seq(c_oligo,'Select oligonucleotides to align') then
         exit
    else
        begin
        //check oligo to align
        for i:=0 to tv.Items.Count-1 do
            if (tv.Items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(pTo(tv.items[i].data)^.name)+'**',seqListe)<>0) then
                begin
                inc(noligo);
                pTo(tv.items[i].data)^.view:=color_oligo(noligo);
                end;
        show_oligo_list;        
        end;

if not select_oligo_seq(c_sequence,'Select sequences in which align oligo') then
   exit;

align_oligo;

//check best found oligo
if frmPreferences.cbAutomaticCheckBestOligo.Checked then
   check_best_aligned_oligo;

tvChange(self,tv.selected);
end; //align primers

procedure Crypt_decrypt_seq(seqname:shortstring;sl:string);
var w:cardinal;
    key:string;
begin
with frmMain do
    begin
    dynform:=TfrmResults(application);
    dynform.rxresults.clear;
    dynform.caption:='Encrypted sequence';
    dynform.rxresults.lines.add('AnnHyb encrypted sequence:');
    dynform.rxresults.lines.add('--------------------------');
    dynform.rxresults.lines.add('');

    key:='';
    if not InputQuery('Encryption key', 'Key', key) then
       exit;

    flagstop:=false;
    frmProgress.caption:='Encrypting sequence...';
    frmProgress.label1.caption:='Please wait...';
    frmProgress.btncancel.visible:=true;
    application.processmessages;
    frmProgress.progressbar1.position:=0;
    frmProgress.show;

    for w:=1 to length(sl) do
        begin
        sl[w]:=chr(ord(sl[w]) xor ord(key[(w mod length(key))+1]));
        application.processmessages;
        if flagstop then
           begin
           frmProgress.hide;
           exit;
           end;
        frmProgress.progressbar1.position:=round(w/length(sl)*100);
        end;
    dynform.rxresults.lines.add(sl);

    frmProgress.hide;
    sl:='';
    dynform.Show;
    end; //with
end;   //crypt decrypt


procedure TfrmMain.Checkfornewversion1Click(Sender: TObject);
begin
frmMain.check_version(true);
end;

function postoxy(ss:integer):tpoint;
var x,y:integer;
begin
x:=(ss mod 65)+1;
y:=sendmessage(frmMain.rxgcgseq.Handle,em_linefromchar,ss,0)+1;
result.x:=x;
result.y:=y;
end;

procedure TfrmMain.Rxgcgseq2SelectionChange(Sender: TObject);
var x,y,pos_,pos2:integer;
    sl,ss,sreg,region:shortstring;
begin
if rxgcgseq.text='' then
   exit;
if not flagUpdateRE then
   exit;
region:='';
y:=postoxy(rxgcgseq.selstart).y;
x:=postoxy(rxgcgseq.selstart).x;
pos_:=xytopos(x,y);
pos2:=xytopos(postoxy(rxgcgseq.selstart+rxgcgseq.sellength).x,postoxy(rxgcgseq.selstart+rxgcgseq.sellength).y);
if region<>'' then
   sreg:='Region: %s'
else
   sreg:='';

if pos2-pos_=0 then //no selection
   statusbar1.panels[0].text:=format('Seq. length: %d   Position: %d  '+sreg,[length(pSq(tv.Selected.data)^.seq),pos_,region])
else
   statusbar1.panels[0].text:=format('Seq. length: %d   Selection: %d - %d   (%d bp)  '+sreg,[length(pSq(tv.Selected.data)^.seq),pos_,pos2-1,pos2-pos_,region]);
//calcul Tm
if (calctm1.checked) and (pos2-pos_>=8) and (pos2-pos_<=50) then
   begin
   sl:=copy(pSq(tv.Selected.data)^.seq,pos_,pos2-pos_);
   ss:=statusbar1.panels[0].text+'  Tm= '+melting(sl,compseq(sl),strtofloat2(frmPreferences.defaut_sel_seq.text)*1e-3,strtofloat2(frmPreferences.defaut_amorces_seq.text)*1e-9,bibtm);
   statusbar1.panels[0].text:=ss;
   end;
end;


procedure TfrmMain.mi_SelectallClick(Sender: TObject);
var i:integer;
begin
for i:=ComponentCount-1 downto 0 do
    begin
    if Components[I] is TEdit then
       if (components[i] as TEdit).Focused then
          (components[i] as TEdit).selectall;
    if Components[I] is TMemo then
       if (components[i] as TMemo).Focused then
          (components[i] as TMemo).selectall;
    if Components[I] is TRXRichEdit then
       if (components[i] as TRXRichEdit).Focused then
          (components[i] as TRXRichEdit).selectall;
    end;
end;

procedure TfrmMain.Goto1Click(Sender: TObject);
var newpos:integer;
begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_sequence) then
   begin
   showmessage('Select a sequence first!');
   exit;
   end;
s:='';
InputQuery('Go to position', 'Position',s);
val(s,newpos,erreur);
if (erreur<>0) or (newpos>length(pSq(tv.Selected.data)^.seq)) or (newpos<1) then
   begin
   showmessage('Nucleotide position not valid!');
   exit;
   end;
rxgcgseq.SetFocus;
rxgcgseq.selstart:=posseqtopos(newpos);
end;

procedure TfrmMain.m1Click(Sender: TObject);
begin
if  (ansiuppercase(extractfileext((sender as tmenuitem).caption))='.OLI')
    or (ansiuppercase(extractfileext((sender as tmenuitem).caption))='.OLA') then
    begin
    flag_mem_menu:=(sender as tmenuitem).caption;
    Oligonucleotide1Click(Sender);
    end
else
    begin
    flag_mem_menu:=(sender as tmenuitem).caption;
    mi_OpenSequenceClick(Sender);
    end;
end;

procedure TfrmMain.calcTm1Click(Sender: TObject);
begin
calctm1.checked:=not calctm1.checked;
end;

//sequence/features
procedure TfrmMain.EditFeaturesClick(Sender: TObject);
var i:integer;
    memfeatures:string;

begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_sequence) then
   begin
   showmessage('Select a sequence first!');
   exit;
   end;

with frmFeatures do
   begin
   edFbegin.Clear;
   edFend.clear;
   feature_name.clear;
   f_comment.clear;
   lvFeatures.Items:=lvAnnotations.Items;
   clbFeatures.ItemIndex:=16;

   edFbegin.enabled:=false;
   edFend.enabled:=false;
   feature_name.enabled:=false;
   f_comment.enabled:=false;
   clbFeatures.enabled:=false;
   lbName.Enabled:=false;
   lbBegin.Enabled:=false;
   lbEnd.Enabled:=false;
   lbComment.Enabled:=false;

   //mmoire seq.
   memfeatures:=pSq(tv.Selected.Data)^.features;
   showmodal;
   if modalresult=mrCancel then    //cancel features modification
      begin
      pSq(tv.Selected.Data)^.features:=memfeatures;
      affiche_features_list;
      affiche_features;
      exit;
      end;

   pSq(tv.Selected.Data)^.features:='';
   if lvAnnotations.items.count>0 then
      for i:=0 to lvAnnotations.items.count-1 do
          add_feature(strtoint(lvAnnotations.items[i].subitems.strings[0]),
                      strtoint(lvAnnotations.items[i].subitems.strings[1]),
                      color_rsf[lvAnnotations.items[i].imageindex],
                      lvAnnotations.items[i].caption,
                      lvAnnotations.items[i].subitems.strings[2]);

   pSq(tv.Selected.Data)^.seqrtf:=sauvertf;
   pSq(tv.Selected.Data)^.flag_f_ok:=true;
   end;//with frmFeatures
end;

procedure TfrmMain.prefClick(Sender: TObject);
begin
with frmPreferences do
    begin
    showmodal;
    frmRetrieve.cbserverURL_retrieve.items:=frmPreferences.cbServerURL.items;
    frmRetrieve.cbserverURL_retrieve.itemindex:=frmPreferences.cbServerURL.itemindex;
    end;
end;

procedure TfrmMain.Viewsequenceattributes1Click(Sender: TObject);
begin
if rxgcgseq.text='' then
   begin
   showmessage('No sequence!');
   exit;
   end;
frmSequenceAttributes.showmodal;
end;

procedure TfrmMain.UPPERcase1Click(Sender: TObject);
begin
if TEdit(ActiveControl).seltext<>'' then
    TEdit(ActiveControl).seltext:=ansiuppercase(TEdit(ActiveControl).seltext)
else
    (activecontrol as tedit).Text:=ansiuppercase((activecontrol as tedit).Text);
end;  //UPPERcase

procedure TfrmMain.lowercase1Click(Sender: TObject);
begin
if TEdit(ActiveControl).seltext<>'' then
    TEdit(ActiveControl).seltext:=ansilowercase(TEdit(ActiveControl).seltext)
else
    (activecontrol as tedit).Text:=ansilowercase((activecontrol as tedit).Text);
end;

procedure TfrmMain.UPPERcaseexceptg1Click(Sender: TObject);
var t:byte;
    ss,ss2:shortstring;
begin
ss2:='';
if TEdit(ActiveControl).seltext<>'' then
    ss:=ansiuppercase(TEdit(ActiveControl).seltext)
else
    ss:=ansiuppercase((activecontrol as tedit).text);
for t:=1 to length(ss) do
    if ss[t]='G' then
        ss2:=ss2+'g'
    else
        ss2:=ss2+ss[t];
if TEdit(ActiveControl).seltext<>'' then
    TEdit(ActiveControl).seltext:=ss2
else
    (activecontrol as tedit).text:=ss2;
end; //G/g

procedure TfrmMain.PM_seqPopup(Sender: TObject);
begin
copy2.enabled:=seq.seltext<>'';
cut2.enabled:=seq.seltext<>'';
//Paste2.Enabled:=Clipboard.HasFormat(CF_TEXT);
end;

procedure TfrmMain.Groupevery3bases1Click(Sender: TObject);
var s:shortstring;
begin
s:=(activecontrol as tedit).text;
while pos(' ',s)<>0 do
   delete(s,pos(' ',s),1);
(activecontrol as tedit).text:=group(s);
end;


procedure TfrmMain.mi_RemoveOligoClick(Sender: TObject);
var i:integer;
label lab1;
begin
if not select_oligo_seq(c_oligo,'Select oligo to remove') then
   exit;

lab1:
for i:=0 to tv.Items.Count-1 do
   if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
       begin
       tv.Items[i].Delete;
       goto lab1;
       end;
nb_oligo:=frmMain.numoligo;
cbColor.ItemIndex:=0;
show_oligo_list;
tv.Select(tv.Items[0]);
fwsc('removed oligo');
end;

procedure TfrmMain.odClose(Sender: TObject);
var s:shortstring;
begin
getdir(0,s);
IniFile:=Tinifile.create(extractFilePath(application.exename)+'annhyb.ini');
inifile.writestring('directory','memdir',s);
inifile.free;
end;

procedure TfrmMain.odShow(Sender: TObject);
var s:shortstring;
begin
IniFile:=Tinifile.create(extractFilePath(application.exename)+'annhyb.ini');
s:=inifile.readstring('directory','memdir','.');
chdir(s);
inifile.free;
end;

procedure seq_melting(seqname:shortstring;sl:string);
var i:integer;
begin
sequence_melting.edLength.Text:=inttostr(length(sl));
sequence_melting.edGC.Text:=floattostr(roundto(gcp(sl)*100,-2));
sequence_melting.showmodal;
end; //SEQ_MELTING

procedure sequence_translation(seqname:shortstring;sl:string;p1,p2:integer);
var frame:shortstring;
    aa:byte;
begin
frame:='';
with frmTranslationParameters do
    begin
    showmodal;
    if modalresult=mrcancel then
       exit;
    if f1.Checked then frame:=frame+'1';
    if f2.Checked then frame:=frame+'2';
    if f3.Checked then frame:=frame+'3';
    if f4.Checked then frame:=frame+'4';
    if f5.Checked then frame:=frame+'5';
    if f6.Checked then frame:=frame+'6';
    if frame='' then
        begin
        showmessage('Choose at least one frame!');
        exit;
        end;
    if _1char.Checked then aa:=1 else aa:=3;
    end; //with

//dynamic form for results
dynform:=TFrmResults.create(application);
dynform.caption:='Translation of: '+seqname+'   '+date_time;
with dynform do
    begin
    rxresults.text:='Translation of: '+seqname+'   '+date_time+crlf+crlf;
    rxresults.text:=rxresults.text+format('Selection: %d > %d',[p1,p2])+crlf+'Length: '+inttostr(length(sl))+crlf+crlf;
    rxresults.text:=rxresults.text+trans(seqname,sl,frame,aa,frmTranslationParameters.cb_include_nt.checked);
    Show;
    end; //with
end; //translation

procedure sequence_codon_usage(seqname:shortstring;sl:string;p1,p2:integer);
begin
dynform:=TfrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='Codon usage';
    rxresults.text:='Codon usage of: '+seqname+'   '+date_time+crlf+crlf;
    rxresults.text:=rxresults.text+'Codon Preference: '+crlf;
    rxresults.text:=rxresults.text+format('Selection: %d > %d',[p1,p2])+crlf+'Length: '+inttostr(length(sl))+crlf+crlf;

    rxresults.text:=rxresults.text+codon_usage(seqname,sl);
    Show;
    end;
end; //sequence_codon_usage

procedure TfrmMain.Tools(Sender: TObject);
var seqname:shortstring;
    p1,p2:integer;
begin
if (Sender as TMenuItem).tag<>4 then   //search seq
    begin
    if (tv.selected=nil) or ((tv.selected.imageindex<>c_sequence) and (tv.selected.imageindex<>c_oligo)) then
        begin
        showmessage('Select a valid sequence!');
        exit;
        end;
    flagtoute:=true;
    if tv.selected.imageindex=c_sequence then
        begin
        seqname:=pSq(tv.Selected.data)^.name;
        sl:=ansiuppercase(pSq(tv.Selected.data)^.seq);
        p1:=1;
        p2:=length(sl);
        if rxgcgseq.seltext<>'' then
            if MessageDlg('Do you want to analyze only the selected sequence?',mtConfirmation,[mbYes, mbNo],0)=mrYes then
                begin
                p1:=xytopos(postoxy(rxgcgseq.selstart).x,postoxy(rxgcgseq.selstart).y);
                p2:=xytopos(postoxy(rxgcgseq.selstart+rxgcgseq.sellength).x,postoxy(rxgcgseq.selstart+rxgcgseq.sellength).y)-1;
                sl:=ansiuppercase(copy(pSq(tv.Selected.data)^.seq,p1,p2-p1+1));
                flagtoute:=false;
                end;
        end;

    if tv.selected.imageindex=c_oligo then
        begin
        seqname:=pTo(tv.selected.Data)^.name;
        sl:=ansiuppercase(pTo(tv.selected.Data)^.seq);
        p1:=1;
        p2:=length(sl);
        if seq.seltext<>'' then
            if MessageDlg('Do you want to analyze only the selected sequence?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
                begin
                sl:=ansiuppercase(stringreplace(seq.seltext,' ','',[rfReplaceAll,rfIgnoreCase]));
                p1:=pos(sl,ansiuppercase(stringreplace(seq.text,' ','',[rfReplaceAll,rfIgnoreCase])));
                p2:=p1+length(sl)-1;
                flagtoute:=false;
                end;
        end;
    end;

case (Sender as TMenuItem).tag of 1:restriction(seqname,sl,p1,p2);
                                  2:sequence_translation(seqname,sl,p1,p2);
                                  3:revert_complement(seqname,sl,p1,p2);
                                  4:search_sequence;
                                  6:find_orf(seqname,sl,p1,p2);
                                  7:base_composition(seqname,sl,p1,p2);
                                  8:sequence_codon_usage(seqname,sl,p1,p2);
                                  9:crypt_decrypt_seq(seqname,sl);
                                  10:if length(sl)>=50 then
                                         seq_melting(seqname,sl)
                                     else
                                         showmessage('The sequence must be longer than 50 nt to apply this algorithm!');
                                  end;
sl:='';
end;

procedure TfrmMain.seqKeyPress(Sender: TObject; var Key: Char);
begin
if (not (key in [' ','/','I','i',#8,'(',')'])) and (not (upcase(key) in validbase)) then
    key:=#0
else if upcase(key) in validbase+['I'] then
    begin
    if frmPreferences.cb_readseq.Checked then
       frmMain.PlaySound(program_dir+key+'.wav');
    end;
end;

procedure TfrmMain.ed_oligo_salt_ccKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TfrmMain.Ungroup1Click(Sender: TObject);
var s:shortstring;
begin
s:=(activecontrol as tedit).text;
while pos(' ',s)<>0 do
   delete(s,pos(' ',s),1);
(activecontrol as tedit).text:=s;
end;

procedure TfrmMain.Ungruop1Click(Sender: TObject);
begin
s:=rev.text;
while pos(' ',s)<>0 do
   delete(s,pos(' ',s),1);
rev.text:=s;
end;

procedure TfrmMain.ToolButton2Click(Sender: TObject);
begin
od.title:='Open';
od.filename:='';
od.filter:='All files (*.*)|*.*|'
                    +'Oligo (*.ol?)|*.oli;*.ola|Single oligo (*.oli)|*.oli|'
                    +'Oligo list (*.ola)|*.ola|'
                    +'Sequence (*.rsf *.em* *.gb *.fas* *.seq *.gcg)|*.rsf;*.em*;*.gb;*.fas*;*.seq;*.gcg|';
if od.Execute then
   begin
   nomfichier:=od.filename;
   if (ansiuppercase(extractfileext(nomfichier))='.OLI') or
      (ansiuppercase(extractfileext(nomfichier))='.OLA') then
      open_oligo(nomfichier)
   else
      open_sequence(nomfichier);
   end;

end;

procedure TfrmMain.tb_newClick(Sender: TObject);
begin
frmNew.showmodal;
if frmNew.modalresult=mrCancel then
   exit;
if frmNew.rb_oligo.checked then
   new_oligoClick(sender);
if frmNew.rb_sequence.checked then
   mi_NewSequenceClick(sender);
if frmNew.rb_project.checked then
   mi_NewProjectClick(sender);
end;


procedure TfrmMain.SequencefFont1Click(Sender: TObject);
begin
fd.font:=rxgcgseq.Font;
if fd.Execute then
   rxgcgseq.font:=fd.font;
end;

function RE_GetLastVisibleLine(RichEdit: TRXRichEdit): Integer;
const
  EM_EXLINEFROMCHAR = WM_USER + 54;
var
  r: TRect;
  i: Integer;
begin
  RichEdit.Perform(EM_GETRECT, 0, Longint(@r));
  r.Left := r.Left + 1;
  r.Top  := r.Bottom - 2;
  i := RichEdit.Perform(EM_CHARFROMPOS, 0, Integer(@r.topleft));
  Result := RichEdit.Perform(EM_EXLINEFROMCHAR, 0, i);
end;

procedure TfrmMain.affiche_liste_seq;
var i:integer;
    itm:TlistItem;
begin
lvSeq.items.Clear;
for i:=0 to tv.Items.Count-1 do
   if tv.Items[i].imageindex=c_sequence then
      begin
      itm:=lvSeq.Items.Add;
      itm.ImageIndex:=0;
      itm.Caption:=pSq(tv.Items[i].Data)^.name;
      itm.SubItems.Add(inttostr(length(pSq(tv.Items[i].Data)^.seq)));
      itm.SubItems.Add(pSq(tv.Items[i].Data)^.longname);
      itm.SubItems.Add(gcg_checksum(pSq(tv.Items[i].Data)^.seq));
      itm.SubItems.Add(pSq(tv.Items[i].Data)^.descrip);
      end;
if ListSeqColumnToSort<>-1 then
   frmMain.lvSeqColumnClick(lvSeq,lvSeq.columns[ListSeqColumnToSort]);
end;

procedure TfrmMain.show_oligo_list;
var i:integer;
    itm:TlistItem;
begin
with frmMain do
    begin
    lv_oligo.items.Clear;
    for i:=0 to tv.Items.Count-1 do
       if tv.Items[i].imageindex=c_oligo then
          begin
          itm:=lv_oligo.Items.Add;
          itm.ImageIndex:=0;
          if pTo(tv.Items[i].Data)^.view<>0 then
             begin
             itm.Checked:=true;
             itm.ImageIndex:=rev_col(pTo(tv.Items[i].Data)^.view);
             end;
          calcul_param(pTo(tv.Items[i].Data)^.seq,l,nb_degen,dblmw,dblmec,dblgc);
          itm.Caption:=pTo(tv.Items[i].Data)^.name;
          itm.SubItems.Add(pTo(tv.Items[i].Data)^.seq);
          itm.SubItems.Add(floattostr2(l));
          itm.SubItems.Add(gcg_checksum(pTo(tv.Items[i].Data)^.seq));
          itm.SubItems.Add(floattostr2(dblmw));
          itm.SubItems.Add(floattostr2(roundto(dblgc,-1)));
          itm.SubItems.Add(floattostr2(dblmec));
          itm.SubItems.Add(floattostr2(pTo(tv.Items[i].Data)^.salt/1e-3));
          itm.SubItems.Add(floattostr2(pTo(tv.Items[i].Data)^.conc/1e-9));
          if pTo(tv.Items[i].Data)^.seq<>'' then
             itm.SubItems.Add(melting(pTo(tv.Items[i].Data)^.seq,compseq(pTo(tv.Items[i].Data)^.seq),pto(tv.Items[i].data)^.salt,pto(tv.Items[i].data)^.conc,bibtm))
          else
             itm.SubItems.Add('ND')
          end;
    if ListOligoColumnToSort<>-1 then
       frmMain.lv_oligoColumnClick(lv_oligo,lv_oligo.columns[ListOligoColumnToSort]);
    end;
end;

procedure TfrmMain.liste_ma;
var i:integer;
    itm:TlistItem;
begin
with frmMain do
    begin
    lvMA.items.Clear;
    for i:=0 to tv.Items.Count-1 do
       if tv.Items[i].imageindex=c_al then
          begin
          itm:=lvMA.Items.Add;
          itm.ImageIndex:=0;
          itm.Caption:=pAl(tv.Items[i].Data)^.name;
          itm.SubItems.Add(inttostr(length(pAl(tv.Items[i].Data)^.seql[0])));
          itm.SubItems.Add(inttostr(pAl(tv.Items[i].Data)^.seql.count));
          end;
    end;
end; //liste_ma

procedure affiche_al;
var wh,wv,t,tt,maxl,ligne,comptgap,compt:integer;
    x,d,f:integer;
    s:string;
    scorethreshold:double;
begin
(*
form1.show;
form1.Memo1.Clear;
*)
try
   scorethreshold:=strtofloat(frmPreferences.edOligoThreshold_ma.text);
except
   exit;
end;  //try

with frmMain do
    begin
    ed_ma_name.text:=pAl(tv.Selected.Data)^.name;
    maxl:=length(pAl(tv.Selected.Data)^.seql[0]);   //longueur multi-align
    sbh.Min:=1;
    if maxl-round(re.Width/re.Font.size)+1<=0 then //alignment of short sequences
        sbh.max:=1
    else
        sbh.Max:=maxl-round(re.Width/re.Font.size)+1;
    sbh.LargeChange:=round(re.Width/re.Font.size);
    sbv.Min:=1;

//    t:=pAl(tv.Selected.Data)^.seql.count-round(reName.Height/15)+1;
    t:=pAl(tv.Selected.Data)^.seql.count-round(re.Height/(-re.Font.height+4))+1+1;
    if t<0 then
       t:=1;
    sbv.max:=t;
    sbv.LargeChange:=round(re.Height/(-re.Font.height+4))-1;
    wh:=round(re.Width/re.Font.size);
    wv:=round(re.Height/(-re.Font.height+4))-1;
(*
    memo1.Lines.clear;
//    memo1.Lines.add('reName.TextHeight(): '+memo1.canvas.TextHeight('A'));
    memo1.Lines.add('pAl(tv.Selected.Data)^.seql.count: '+inttostr(pAl(tv.Selected.Data)^.seql.count));
    memo1.Lines.add('round(reName.Height/15): '+inttostr(round(reName.Height/15)));

//    memo1.Lines.add('maxl: '+inttostr(maxl));
    memo1.Lines.add('sbv.min: '+inttostr(sbv.min));
    memo1.Lines.add('sbv.max: '+inttostr(sbv.max));
    memo1.Lines.add('wh: '+inttostr(wh));
    memo1.Lines.add('wv: '+inttostr(wv));

    memo1.Lines.add('sbv.position: '+inttostr(sbv.position));
*)
    //affiche noms squences
    reName.Clear;
    for t:=sbv.position to sbv.position+wv-1 do
        if t-1<pAl(tv.Selected.Data)^.namel.count then
           rename.Lines.add(pAl(tv.Selected.Data)^.namel[t-1]);

    //consensus
//    al[nb_align]^.consensus:=consensus(al[nb_align]^,80);
    if mi_consensus.checked then
        edConsensus.Text:=' '+copy(pAl(tv.Selected.Data)^.consensus,sbh.Position,wh);

    //affiche squences
    re.clear;
    ligne:=0;
    x:=sbh.position;

    for t:=sbv.position to sbv.position+wv-1 do
        if t-1<pAl(tv.Selected.Data)^.namel.count then
           begin
           re.lines.add(copy(pAl(tv.Selected.Data)^.seql[t-1],sbh.Position,wh));

           //highlight aligned oligo
           if pAl(tv.Selected.Data)^.found[t-1]<>'' then
              begin
              s:=pAl(tv.Selected.Data)^.found[t-1];
              while s<>'' do
                 begin
                 s1:=copy(s,1,pos('',s)-1);
                 delete(s,1,pos('',s));
                 extract_oligo(s1);
                 //vrif score>cut-off visualisation
                 if oligoF.score<scorethreshold then
                    continue;
                 //compte gap avant init
                 comptgap:=0;
                 compt:=0;
                 tt:=1;
                 while compt<oligoF.init do
                     begin
                     if pAl(tv.Selected.Data)^.seql[t-1][tt]='-' then
                        inc(comptgap)
                     else
                        inc(compt);
                     inc(tt);
                     end;
                 inc(oligoF.init,comptgap);
                 inc(oligoF.fin,comptgap);
                 //compte gap ds oligo
                 comptgap:=0;
                 compt:=0;
                 tt:=oligoF.init;
                 while compt<=oligoF.fin-oligoF.init+1 do
                     begin
                     if pAl(tv.Selected.Data)^.seql[t-1][tt]='-' then
                        inc(comptgap)
                     else
                        inc(compt);
                     inc(tt);
                     end;
                 inc(oligoF.fin,comptgap);
(*
                 form1.memo1.lines.add('oligo init: '+inttostr(oligoF.init));
                 form1.memo1.lines.add('oligo fin: '+inttostr(oligoF.fin));

                 form1.memo1.lines.add('sbh: '+inttostr(sbh.position));
                 form1.memo1.lines.add('wh: '+inttostr(wh));
*)
                 if (oligoF.init-sbh.position>=0) and (oligoF.init-sbh.position<wh) then
                     begin
                     d:=oligoF.init-sbh.Position;
                     if oligoF.fin<=sbh.Position+wh-1 then
                         f:=oligoF.fin-oligoF.init+1
                     else
                         f:=wh-(oligoF.init-sbh.Position);

                     re.SelStart:=ligne*(wh+1)+d;
                     re.sellength:=f;
                     re.selAttributes.color:=foreground_color(oligoF.coul);
                     re.selAttributes.backcolor:=oligoF.coul;

                     end;

                 if (oligoF.init-sbh.position<0) then
                     begin
                     d:=0;
                     f:=(oligoF.fin-oligoF.init)+1+(oligoF.init-sbh.Position);
                     if f<0 then
                         f:=0;

                     re.SelStart:=ligne*(wh+1)+d;
                     re.sellength:=f;
                     re.selAttributes.color:=foreground_color(oligoF.coul);
                     re.selAttributes.backcolor:=oligoF.coul;
                     end;
(*
                 form1.memo1.lines.add('SelStart: '+inttostr(ligne*(wh+1)+d));
                 form1.memo1.lines.add('SelLength: '+inttostr(f));
*)
                end;
              end; //highlight oligo
           inc(ligne);
           end;

    sbh.Top:=pn_ma_info.Height+re.Height-14;
    sbh.Left:=re.Left+2;
    sbh.Width:=re.Width-18;

    sbv.top:=re.Top+1;
    sbv.left:=rename.Width+split_ma.Width+re.width-16-1;
    sbv.Height:=re.Height-18;

(*    statusbar1.panels[0].text:=inttostr(sbv.Position)+'  '+
                               inttostr(sbv.Position+wv-1)+'  '+
                               inttostr(sbh.Position)+'/'+inttostr(sbh.max)+'  '+
                               inttostr(sbh.Position+wh-1);
*)                               
    ed_ma_position.text:=inttostr(sbh.Position)+' - '+inttostr(sbh.Position+wh-1);
    end;
end; //affiche_al

procedure TfrmMain.tvChange(Sender: TObject; Node: TTreeNode);
var i:integer;
begin
if tv.selected.text='Multiple alignment' then   //multiple alignment list
   begin
   pc.ActivePage:=tabMAList;
   statusbar1.panels[0].text:='Multiple alignment list ('+inttostr(numMA)+' multiple alignments)';
   liste_ma;
   end;

if node.imageindex=c_al then
    begin
    memstrAl:=node.text;
    affiche_al;
    pc.ActivePage:=tabMA;
    end;

if tv.selected.text='Oligo' then   //oligo's list
   begin
   pc.ActivePage:=taboligolist;
   statusbar1.panels[0].text:='Oligo list ('+inttostr(numoligo)+' oligonucleotides)';
   show_oligo_list;
   end;

if node.imageindex=c_oligo then    //single oligo
   begin
   flag_force_maj_oligo:=true;
   memstrOligo:=node.text;
   statusbar1.panels[0].text:='';
   ed_oligo_name.text:=pTo(tv.Selected.Data)^.name;
   seq.text:=pTo(tv.Selected.Data)^.seq;
   frmOligoNotes.mm_oligonotes.Text:=pTo(tv.Selected.Data)^.notes;
   ed_oligo_salt_cc.text:=floattostr2(pTo(tv.Selected.Data)^.salt*1000);
   ed_oligo_cc.text:=floattostr2(pTo(tv.Selected.Data)^.conc*1e9);
   cbColor.ItemIndex:=rev_col(pTo(tv.Selected.Data)^.view);
   lvAlign.Items.clear;
   affiche_align_results(pTo(tv.Selected.Data)^.found_seq);
   affiche_align_results(pTo(tv.Selected.Data)^.found_ma);
   pc.ActivePage:=tb_oligo;
   flag_force_maj_oligo:=false;
   end;

if tv.selected.text='Sequence' then   //list of sequences
   begin
   pc.ActivePage:=tabSeqlist;
   statusbar1.panels[0].text:='Sequences list ('+inttostr(numseq)+' sequences)';
   affiche_liste_seq;
   end;

if node.imageindex=c_sequence then
    begin
    memstrSeq:=node.text;    //memorize old seq
    save_cursor:=screen.cursor;
    Screen.Cursor:=crHourGlass;
    affiche_header;
    chargertf(pSq(tv.Selected.Data)^.seqrtf);
    affiche_features;

    pc.ActivePage:=seqtab;
    //show header with memorized position
    with mmheader do
        begin
        SelLength:=0;
        SelStart:=Perform(EM_LINEINDEX,pSq(tv.Selected.Data)^.memposheader,0); //zero-based index
        Perform(EM_SCROLLCARET,0,0);
        end;
    //show sequence with memorized position
    with rxgcgseq do
        begin
        SelLength:=0;
        //    activecontrol:=rxgcgseq;
        //    rxgcgseq.SetFocus;

       //     SelStart:=Perform(EM_LINEINDEX,pSq(tv.Selected.Data)^.memposseq,0); //zero-based index

       //        Perform(EM_SCROLLCARET,0,0);

        //activecontrol:=rxgcgseq;  rxgcgseq.
        //rxgcgseq.SetFocus;
        //rxgcgseq.selstart:=posseqtopos(pSq(tv.Selected.Data)^.memposseq*50+1);
        //        Perform(EM_SCROLLCARET,0,0);


//        rxgcgseq.selstart:=pSq(tv.Selected.Data)^.memposseq;
        end;
    Screen.Cursor:=save_cursor;
    tv.setfocus;
    end;
end; //tv change

procedure TfrmMain.tb_retrieveClick(Sender: TObject);
begin
Retrievefromserver3Click(application);
end;

procedure TfrmMain.Copy4Click(Sender: TObject);
begin
clipboard.astext:=clearseq(rxgcgseq.seltext);
end;

procedure TfrmMain.Copyallcharacters1Click(Sender: TObject);
begin
clipboard.astext:=rxgcgseq.seltext;
end;

procedure TfrmMain.Copy5Click(Sender: TObject);
begin
clipboard.astext:=mmHeader.seltext;
end;

procedure TfrmMain.Font3Click(Sender: TObject);
begin
fd.font:=tv.Font;
if fd.Execute then
   begin
   tv.font:=fd.font;
   IniFile:=Tinifile.create(extractFilePath(application.exename)+'annhyb.ini');
   inifile.free;
   end;
end;


procedure TfrmMain.mi_ExportOligoClick(Sender: TObject);
var i,j,comp:integer;
    nf,s:shortstring;
    dir:string;
begin
if not select_oligo_seq(c_oligo,'Select oligo to export') then
   exit;

compt:=0;
for i:=0 to tv.Items.Count-1 do
    if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
       inc(compt);
if compt=1 then
    begin
    savedialog1.title:='Export oligonucleotides';
    savedialog1.filter:='FASTA format|*.fasta;*.seq;*.fst|Oligonucleotides AnnHyb''s format|*.ola';
    savedialog1.filterindex:=1;
    savedialog1.filename:='';
    savedialog1.defaultext:='';

    if savedialog1.execute then
       begin
       nf:=savedialog1.filename;
       if (savedialog1.FilterIndex=3) and (ansiuppercase(extractfileext(nf))<>'OLA') then
          if MessageDlg('Add .OLA extention to the file?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
             nf:=ChangeFileExt(nf,'.ola');

       assignfile(fichier,nf);
       if fileexists(nf) then
          begin
          frmConfirmFile.lbMessage.caption:='The file '+nf+' already exists!';
          frmConfirmFile.showmodal;
          if frmConfirmFile.modalresult=mrNo then
             append(fichier);
          if frmConfirmFile.modalresult=mrCancel then
             exit;
          if frmConfirmFile.modalresult=mrYes then
             rewrite(fichier);
          end
       else
          rewrite(fichier);
       if savedialog1.FilterIndex=1 then //FASTA format
           begin
           for i:=0 to tv.Items.Count-1 do
               if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
                  begin
                  writeln(fichier,'>'+pto(tv.items[i].data)^.name);
                  writeln(fichier,format_iupac(pto(tv.items[i].data)^.seq,false));
                  end
           end;
       if savedialog1.FilterIndex=3 then //OLA format for backward compatibility
           begin
           writeln(fichier,'AnnHyb - List of oligonucleotides');
           for i:=0 to tv.Items.Count-1 do
               if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
                  begin
                  write(fichier,pto(tv.items[i].data)^.name);
                  if pto(tv.items[i].data)^.notes<>'' then
                      writeln(fichier,'|notes:'+stringreplace(pto(tv.items[i].data)^.notes,#13#10,'|',[rfReplaceAll]))
                  else
                      writeln(fichier);
                  writeln(fichier,pto(tv.items[i].data)^.seq);
                  writeln(fichier,floattostr2(pto(tv.items[i].data)^.salt));
                  writeln(fichier,floattostr2(pto(tv.items[i].data)^.conc));
                  end;
           end;
       closefile(fichier);
       end;
   end
else
    begin //compt<>1
    frmExportOligo.showmodal;
    if frmExportOligo.ModalResult=mrOK then
        begin
        if frmExportOligo.rb_AllOligoOneFile.Checked then
            begin
            savedialog1.Title:='Save all selected oligonucleotides in one file';
            savedialog1.filename:='';
            savedialog1.Filter:='';
            savedialog1.defaultext:='';
            if savedialog1.execute then
                s:=savedialog1.filename;
            end
        else
            begin
            if SelectDirectory('Save all selected oligonucleotides in','',dir) then
                begin
                if dir[length(s)]<>'\' then
                   dir:=dir+'\';
                end
            else
                exit;
            end;
        if frmExportOligo.rb_AllOligoOneFile.Checked then
            begin
            assignfile(fichier,s);
            //file exists?
            if fileexists(s) then
                begin
                frmConfirmFile.lbMessage.caption:='The file '+s+' already exists!';
                frmConfirmFile.btAppend.visible:=true;
                frmConfirmFile.showmodal;
                if frmConfirmFile.modalresult=mrNo then
                    append(fichier);
                if frmConfirmFile.modalresult=mrCancel then
                    exit;
                if frmConfirmFile.modalresult=mrYes then
                    rewrite(fichier);
                end
            else
                rewrite(fichier);    
            if frmExportOligo.rg_OligoFormat.itemindex=1 then //OLA format for backward compatibility
                writeln(fichier,'AnnHyb - List of oligonucleotides');
            end;
       for j:=0 to tv.Items.Count-1 do
            if (tv.items[j].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
               begin
               //open file
               if frmExportOligo.rb_OneOligoOneFile.Checked then
                   begin
                   s:=dir+validfilename(tv.Items[j].text);;
                   case frmExportOligo.rg_OligoFormat.itemindex of 0:s:=s+'.fasta';
                                                                   1:s:=s+'.ola';
                                                                   end;
                   assignfile(fichier,s);
                   rewrite(fichier);
                   if frmExportOligo.rg_OligoFormat.itemindex=1 then //OLA format for backward compatibility
                      writeln(fichier,'AnnHyb - List of oligonucleotides');

                   s:='';
                   end;
               //write oligo
               if frmExportOligo.rg_OligoFormat.itemindex=0 then //FASTA format
                  begin
                  writeln(fichier,'>'+pto(tv.items[j].data)^.name);
                  writeln(fichier,format_iupac(pto(tv.items[j].data)^.seq,false));
                  end;
               if frmExportOligo.rg_OligoFormat.itemindex=1 then //OLA format for backward compatibility
                  begin
                  write(fichier,pto(tv.items[j].data)^.name);
                  if pto(tv.items[j].data)^.notes<>'' then
                      writeln(fichier,'|notes:'+stringreplace(pto(tv.items[j].data)^.notes,#13#10,'|',[rfReplaceAll]))
                  else
                      writeln(fichier);
                  writeln(fichier,pto(tv.items[j].data)^.seq);
                  writeln(fichier,floattostr2(pto(tv.items[j].data)^.salt));
                  writeln(fichier,floattostr2(pto(tv.items[j].data)^.conc));
                  end;
               //close file
               if frmExportOligo.rb_OneOligoOneFile.Checked then
                   closefile(fichier);
               end;
       if frmExportOligo.rb_AllOligoOneFile.Checked then
           closefile(fichier);

       end; //modalresult=mrOK

    end;


end; //export Oligo

procedure TfrmMain.mo_ExportMultiSequencesClick(Sender: TObject);
//var flagPremiereSeq:boolean;
//    j,i:integer;

begin
(*
if not select_oligo_seq(c_sequence) then
   exit;

savedialog1.title:='Export multi sequences';
savedialog1.filename:='';
savedialog1.defaultext:='';
*)
//SaveDialog1.Filter:='Rich Sequence Format (RSF)|*.RSF|FASTA|*.*|GCG (*.gcg)|*.gcg|GenBank (*.*)|*.*|EMBL (*.*)|*.*|Rich Text Format (RTF)|*.RTF|HTML (*.html)|*.html|Rich Sequence Format (RSF)|*.RSF';
//SaveDialog1.Filter:='FASTA (all sequences in one file)|*.fasta|FASTA (one sequence one file)|*.fasta|Rich Sequence Format (RSF)|*.RSF';
(*
if not savedialog1.execute then
    exit;  //cancel
nomfichier:=savedialog1.filename;

if SaveDialog1.Filterindex=2 then   //fasta single seq
    begin
    if nomfichier<>'' then
       if MessageDlg('Sequences will be saved in various files.'+crlf+'The file name will be the sequence name with ".fasta" extension',mtConfirmation,[mbYes,mbNo],0)=mrNo then
           exit;
    for j:=0 to tv.Items.Count-1 do
        if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
           begin
           nomfichier:=pSq(tv.items[j].Data)^.name+'.fasta';
           assignfile(fichier,nomfichier);
           if fileexists(nomfichier) then
               if MessageDlg(nomfichier+' already exists! Overwrite it?',mtWarning,[mbYes,mbNo],0)=mrNo then
                  continue;
           rewrite(fichier);
           writeln(fichier,'>'+pSq(tv.items[j].Data)^.name);
           for i:=1 to length(pSq(tv.items[j].Data)^.seq) div 50 do
               writeln(fichier,copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           i:=(length(pSq(tv.items[j].Data)^.seq) div 50)+1;
           if copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50)<>'' then
              writeln(fichier,copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           closefile(fichier);
           end;
    exit;
    end;

if nomfichier<>'' then
   begin
   assignfile(fichier,nomfichier);
   if fileexists(nomfichier) then
      begin
      //concatnation avec ancien fichier possible
      frmConfirmFile.btAppend.visible:=true;
      frmConfirmFile.lbMessage.caption:='The file '+nomfichier+' already exists!';
      frmConfirmFile.showmodal;
      frmConfirmFile.btAppend.visible:=true;
      if frmConfirmFile.modalresult=mrNo then
         append(fichier);
      if frmConfirmFile.modalresult=mrCancel then
         exit;
      if frmConfirmFile.modalresult=mrYes then
         rewrite(fichier);
      end
   else
      rewrite(fichier);
   end;
//fichier
if SaveDialog1.Filterindex=1 then   //fasta multi seq
    begin
    for j:=0 to tv.Items.Count-1 do
        if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
           begin
           writeln(fichier,'>'+pSq(tv.items[j].Data)^.name);
           for i:=1 to length(pSq(tv.items[j].Data)^.seq) div 50 do
               writeln(fichier,copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           i:=(length(pSq(tv.items[j].Data)^.seq) div 50)+1;
           if copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50)<>'' then
              writeln(fichier,copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           end;
    end;


if SaveDialog1.Filterindex=3 then //RSF
    begin
    flagPremiereSeq:=true;
    for j:=0 to tv.Items.Count-1 do
        if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
           begin
           if flagPremiereSeq then
              begin
              writeln(fichier,'!!RICH_SEQUENCE 1.0');
              writeln(fichier,'..');
              writeln(fichier,'{');
              flagPremiereSeq:=false;
              end
           else
              writeln(fichier,'{');
           writeln(fichier,'name   '+pSq(tv.items[j].Data)^.name);
           writeln(fichier,'type    '+pSq(tv.items[j].Data)^._type);
           writeln(fichier,'descrip     '+pSq(tv.items[j].Data)^.descrip);
           writeln(fichier,pSq(tv.items[j].Data)^.hrsf);
           writeln(fichier,'sequence');
           for i:=1 to length(pSq(tv.items[j].Data)^.seq) div 50 do
               writeln(fichier,'      '+copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           i:=(length(pSq(tv.items[j].Data)^.seq) div 50)+1;
           if copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50)<>'' then
              writeln(fichier,'      '+copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
           writeln(fichier,'}');
           end;
    end;
flush(fichier);
closefile(fichier);
*)
end; //save multi sequences

procedure TfrmMain.mi_SaveProjectClick(Sender: TObject);  //save environment
var oligo_hrsf:string;
    flagPremiereSeq:boolean;
    j,i:integer;
    w:word;
label label1;
begin
if numOligo+numSeq+numMA=0 then
   begin
   showmessage('This project do not contain any sequence!'+LF+'It is not possible to save it.');
   exit;
   end;

SaveDialog1.Filterindex:=1; //XML
if ((sender=mi_SaveProject) or (sender=tb_saveproject)) and (workspacename<>'') then
    savedialog1.filename:=workspacename
else   //save as
    begin
    label1:
    savedialog1.Title:='Save project as...';
    savedialog1.filename:='';
    SaveDialog1.Filter:='Annhyb project|*.annhyb|Rich Sequence Format (RSF)|*.RSF';
    SaveDialog1.Filterindex:=1; //.annhyb
    if not savedialog1.execute then
        begin

        flagCancelSave:=true;
        exit;  //cancel save

        end;
    end;

save_cursor:=screen.Cursor;
screen.Cursor:=crHourGlass;
if savedialog1.filename<>'' then
   begin
   if SaveDialog1.Filterindex=1 then //XML
      savedialog1.filename:=changefileext(savedialog1.filename,'.annhyb');
   if SaveDialog1.Filterindex=2 then //RSF
      savedialog1.filename:=changefileext(savedialog1.filename,'.rsf');

   assignfile(fichier,savedialog1.filename);
   if (fileexists(savedialog1.filename)) and (savedialog1.filename<>workspacename) then
      begin
      frmConfirmFile.btAppend.visible:=false;
      frmConfirmFile.lbMessage.caption:='The file '+savedialog1.filename+' already exists!';
      frmConfirmFile.showmodal;
      frmConfirmFile.btAppend.visible:=true;
      if frmConfirmFile.modalresult=mrCancel then
         exit;
      if frmConfirmFile.modalresult=mrYes then
         rewrite(fichier);
      end
   else
      rewrite(fichier);
   end;

workspacename:=savedialog1.filename;
application.Title:=extractfilename(workspacename)+' - AnnHyb '+version;
frmMain.caption:=extractfilename(workspacename)+' - AnnHyb '+version;

if SaveDialog1.Filterindex=1 then //XML
   begin
   closefile(fichier);
   save_xml(workspacename);
   add_recent_projects(workspacename);
   menu_recent_projects;
   end;

if SaveDialog1.Filterindex=2 then   //RSF
    begin
    w:=MessageDlg('The RSF format do not allow to save multi-alignment!'+crlf+'Do you want to use the "annhyb (XML) format."',mtWarning,[mbNo,mbYes,mbCancel],0);
    if w=mrCancel then
       exit;
    if w=mrYes then
       begin
       SaveDialog1.filename:='';
       SaveDialog1.Filterindex:=1;
       goto label1;
       end;
    flagPremiereSeq:=true;
    for j:=0 to tv.Items.Count-1 do
        if (tv.Items[j].imageindex=c_oligo) or (tv.Items[j].imageindex=c_sequence) then
           begin
           if flagPremiereSeq then
              begin
              writeln(fichier,'!!RICH_SEQUENCE 1.0');
              writeln(fichier,'GCG Rich Sequence File (RSF).');
              writeln(fichier,'AnnHyb environment');
              writeln(fichier,'..');
              writeln(fichier,'{');
              flagPremiereSeq:=false;
              end
           else
              writeln(fichier,'{');

           if (tv.Items[j].imageindex=c_sequence) then
              begin
              writeln(fichier,'name   '+pSq(tv.items[j].Data)^.name);
              if pSq(tv.items[j].Data)^.longname<>'' then
                 writeln(fichier,'longname  '+pSq(tv.items[j].Data)^.longname);
              writeln(fichier,'type     '+pSq(tv.items[j].Data)^._type);
              if pSq(tv.items[j].Data)^.descrip<>'' then
                 writeln(fichier,'descrip     '+pSq(tv.items[j].Data)^.descrip);
              if pSq(tv.items[j].Data)^.creator<>'' then
                 writeln(fichier,'creator    '+pSq(tv.items[j].Data)^.creator);
              if pSq(tv.items[j].Data)^.creationdate<>'' then
                 writeln(fichier,'creation-date  '+pSq(tv.items[j].Data)^.creationdate);
              writeln(fichier,'checksum    '+gcg_checksum(pSq(tv.items[j].data)^.seq));
              if pSq(tv.items[j].Data)^.hrsf<>'' then
                 begin
                 writeln(fichier,'comments');
                 writeln(fichier,pSq(tv.items[j].Data)^.hrsf);
                 end;
              if pSq(tv.items[j].Data)^.features<>'' then
                 writeln(fichier,pSq(tv.items[j].Data)^.features);  //features
              end
           else if (tv.Items[j].imageindex=c_oligo) then
              begin //oligo
              oligo_hrsf:='name  '+pTo(tv.items[j].Data)^.name+CRLF;
              oligo_hrsf:=oligo_hrsf+'type    DNA'+CRLF;
              oligo_hrsf:=oligo_hrsf+'checksum    '+gcg_checksum(pTo(tv.items[j].Data)^.seq)+CRLF;
              oligo_hrsf:=oligo_hrsf+'strand  1'+CRLF;
              oligo_hrsf:=oligo_hrsf+'comments'+CRLF;
              oligo_hrsf:=oligo_hrsf+'   Oligonucleotide'+CRLF;
              oligo_hrsf:=oligo_hrsf+'   Salt:'+floattostr2(pTo(tv.items[j].Data)^.salt)+CRLF;
              oligo_hrsf:=oligo_hrsf+'   Conc:'+floattostr2(pTo(tv.items[j].Data)^.conc)+CRLF;
              writeln(fichier,oligo_hrsf);
              end;

           writeln(fichier,'sequence');
           if (tv.Items[j].imageindex=c_sequence) then
              begin
              for i:=1 to length(pSq(tv.items[j].Data)^.seq) div 50 do
                  writeln(fichier,'      '+copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
              i:=(length(pSq(tv.items[j].Data)^.seq) div 50)+1;
              if copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50)<>'' then
                  writeln(fichier,'      '+copy(pSq(tv.items[j].Data)^.seq,1+(i-1)*50,50));
              end
           else if (tv.Items[j].imageindex=c_oligo) then
                  writeln(fichier,'      '+format_iupac(pTo(tv.items[j].Data)^.seq,false));
           writeln(fichier,'}');
           end;
    flush(fichier);
    closefile(fichier);
   end;
screen.Cursor:=save_cursor;
fwsnc('save all');
end;

procedure TfrmMain.mo_TmAlgoClick(Sender: TObject);
begin
if sender=mo_breslauer1986 then
   setTmAlgo(TmBreslauer1986);
if sender=mo_allawi1997 then
   setTmAlgo(TmAllawi1997);
end;

procedure TfrmMain.Quicksearchforsequence1Click(Sender: TObject);
//recherche avec fonction POS une squence
var t,j,poseq,postrouve:integer;
    querystr,seqg,revs:string;
begin
with frmMain do
    begin
    frmstringsearch.query.clear;
    frmstringsearch.caption:='Search for sub-sequence';
    repeat
        frmstringsearch.showmodal;
        if frmstringsearch.modalresult=mrcancel then
            exit;
        querystr:=uppercase(clearseq(frmstringsearch.query.text));
        if length(querystr)<6 then
            showmessage('Sequence too short!');
    until length(querystr)>=6;
    if querystr='' then
        exit;
    if not select_oligo_seq(c_sequence,'Select sequences') then
        exit;

    dynform:=TfrmResults.create(application);
    with dynform do
        begin
        //flagfound:=false;
        rxresults.clear;
        caption:='Results of sequence search';
        rxresults.lines.add('Results of sequence search '+date_time);
        rxresults.lines.add('');
        rxresults.lines.add('Sub-sequence: '+querystr);
        rxresults.lines.add('');

        for j:=0 to tv.Items.count-1 do
           if tv.Items[j].imageindex=c_sequence then
               if (pos('**'+ansiuppercase(pSq(tv.items[j].data)^.name)+'**',seqListe)<>0) then
                   begin
                   seqg:=uppercase(pSq(tv.items[j].data)^.seq);

                   //reverse complement seq
                   revs:='';
                   for t:=1 to length(querystr) do
                       revs:=rev_(querystr[t])+revs;
                   //pre search to check if sub-seq found in sense or in antisense strand
                   if (pos(querystr,seqg)<>0) or (pos(revs,seqg)<>0) then
                       begin
                       rxresults.lines.add('Sequence found at:');
                       rxresults.lines.add('------------------');
                       rxresults.lines.add('');
                       end
                   else
                       begin
                       rxresults.lines.add(pSq(tv.items[j].data)^.name+': not found');
                       rxresults.lines.add('');
                       continue;
                       end;

                   poseq:=1;
                   compt:=length(querystr);
                   repeat
                       application.processmessages;
                       if pos(querystr,copy(seqg,poseq,maxint))<>0 then
                           begin
                           postrouve:=poseq+pos(querystr,copy(seqg,poseq,maxint))-1;
                           rxresults.lines.add(pSq(tv.items[j].data)^.name);
                           rxresults.lines.add('position: '+inttostr(postrouve)+' - '+inttostr(postrouve+length(querystr)-1));
                           rxresults.lines.add('');
                           poseq:=postrouve+1;
                           end;
                   until pos(querystr,copy(seqg,poseq,maxint))=0;

                   //antisense  search
                   if frmstringsearch.cbBothSenses.checked then
                       begin
                       poseq:=1;
                       compt:=length(querystr);
                       repeat
                           application.processmessages;
                           if pos(revs,copy(seqg,poseq,maxint))<>0 then
                               begin
                               postrouve:=poseq+pos(revs,copy(seqg,poseq,maxint))-1;
                               rxresults.lines.add(pSq(tv.items[j].data)^.name+' /rev');
                               rxresults.lines.add('position: '+inttostr(postrouve)+' - '+inttostr(postrouve+length(revs)-1));
                               rxresults.lines.add('');
                               poseq:=postrouve+1;
                               end;
                       until pos(revs,copy(seqg,poseq,maxint))=0;
                       end; //antisense
                   end;
            Show;
        end; //with dynform
    end; //with frmMain

end; //quicksearch

procedure clear_oligo_search(ss:shortstring);
var i,j:integer;
    s:string;
    sl:tstringlist;
begin
with frmMain do
for i:=0 to tv.items.Count-1 do
    begin
    if (tv.items[i].imageindex=c_oligo) and (pto(tv.items[i].data)^.found_seq<>'') then //oligo
       begin
       if pos(ss+'|',pto(tv.items[i].data)^.found_seq)<>0 then
          begin
          s:=pto(tv.items[i].data)^.found_seq;
          sl:=tstringlist.create;
          while s<>'' do
             begin
             if pos(ss+'|',copy(s,1,pos(LF,s)))=0 then
                begin
                sl.add(copy(s,1,pos(LF,s)));
                end;
             delete(s,1,pos(LF,s));
             end;
          s:='';
          for j:=0 to sl.Count-1 do
              s:=s+sl[j];
          pto(tv.items[i].data)^.found_seq:=s;
          sl.free;
          end;
       end;
    end;
end;

procedure maj_recherche_oligo(s_old,s_new:shortstring);
var i:integer;
    s:string;
begin
with frmMain do
for i:=0 to tv.items.Count-1 do
    begin
    if (tv.items[i].imageindex=1) and (pto(tv.items[i].data)^.found_seq<>'') then //oligo
       begin
       s:=pto(tv.items[i].data)^.found_seq;
       while pos(s_old+'|',s)<>0 do
           begin
           insert(s_new,s,pos(s_old+'|',s));
           delete(s,pos(s_old+'|',s),length(s_old));
           end;
       pto(tv.items[i].data)^.found_seq:=s;
       end;
    end;
s:='';
end;


procedure TfrmMain.mi_tv_removeClick(Sender: TObject);
begin
if (tv.selected=nil) then
    exit;
if tv.selected.imageindex=0 then
   begin
   showmessage('This node can not be deleted!');
   exit;
   end;
//efface recherches d'oligo
if tv.selected.imageindex=c_sequence then
   clear_oligo_search(pSq(tv.selected.data)^.name);
fwsc('close');
tv.selected.Delete;
end;

procedure TfrmMain.mi_RemoveAllSequenceClick(Sender: TObject);
var i:integer;
label lab1;
begin
if not select_oligo_seq(c_sequence,'Select sequences to remove') then
   exit;
lab1:
for i:=0 to tv.Items.Count-1 do
   if (tv.items[i].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
       begin
       clear_oligo_search(pSq(tv.Items[i].data)^.name);
       tv.Items[i].Delete;
       goto lab1;
       end;
nb_seq:=frmMain.numseq;
lvSeq.items.Clear;
affiche_liste_seq;

for i:=0 to tv.items.count-1 do
    if tv.items[i].text='Sequence' then
       break;
tv.Select(tv.Items[i]);

fwsc('removed seq');
end;  //remove sequences(s)

procedure TfrmMain.Quicksearcholigoinsequences1Click(Sender: TObject);
begin
if not select_oligo_seq(c_sequence,'Select sequences in which quick search oligo') then
   exit;

quicksearchprimers;
//check best found oligo
if frmPreferences.cbAutomaticCheckBestOligo.Checked then
   check_best_aligned_oligo;
//add checked found oligo in features
add_checked_oligo_to_features;

if tv.selected.imageindex=c_oligo then //oligo
   affiche_align_results(pto(tv.selected.data)^.found_seq);
end;


procedure TfrmMain.lvAlignClick(Sender: TObject);
var s1:string;
    i:integer;
    sl:tstringlist;
begin
if tv.selected=nil then
   exit;
sl:=tstringlist.create;
s1:=pTo(tv.selected.Data)^.found_seq;
while s1<>'' do
   begin
   sl.add(copy(s1,1,pos(LF,s1)-1));
   delete(s1,1,pos(LF,s1));
   end;

for i:=0 to lvAlign.items.Count-1 do
    begin
    s1:=sl[i];
    if lvAlign.Items[i].Checked then
       s1[1]:='3'
    else
       s1[1]:='2';
    sl[i]:=s1;
    end;

s1:='';
for i:=0 to sl.Count-1 do
    s1:=s1+sl[i]+LF;

pTo(tv.selected.Data)^.found_seq:=s1;
sl.Free;

add_checked_oligo_to_features;
end;

function fs(s:shortstring;l:byte):shortstring;
begin
while length(s)<l do
      s:=s+' ';
fs:=s;
end;

procedure view_alignment(itm:tlistitem;frm:TfrmResults);
var s1,s2,s3,revs,s1_n,s2_n,s4,s5,s6,ns:shortstring;
    pos_init,pos_fin,i,j,len_target:integer;
begin
s1:=itm.SubItems.Strings[4]; //oligo
s2:=itm.SubItems.Strings[5]; //target
len_target:=0;
for i:=1 to length(s2) do
    if pos(s2[i],iupac)<>0 then
       inc(len_target);

if itm.SubItems.Strings[0]='-' then   //rev-comp
   begin
   revs:='';
   for i:=1 to length(s1) do
       if s1[i]<>'-' then
          revs:=rev_(s1[i])+revs
       else
          revs:='-'+revs;
   s1:=revs;
   revs:='';
   for i:=1 to length(s2) do
       if s2[i]<>'-' then
          revs:=rev_(s2[i])+revs
       else
          revs:='-'+revs;
   s2:=revs;
   end;
//homology visualization
s3:=show_homology(s1,s2);
s1_n:=frmMain.tv.selected.text+': ';

ns:=ansiuppercase(itm.caption);
s2_n:=itm.caption;
if itm.SubItems.Strings[0]='-' then
   s2_n:=s2_n+' (rev-comp)';
s2_n:=s2_n+': ';

s1_n:=fs(s1_n,max(length(s1_n),length(s2_n)));
s2_n:=fs(s2_n,max(length(s1_n),length(s2_n)));

frm.rxresults.lines.add('Local alignment of '+frmMain.tv.selected.text+' on '+itm.caption);
frm.rxresults.lines.add(' ');

pos_init:=strtoint(itm.SubItems.Strings[1]);
pos_fin:=strtoint(itm.SubItems.Strings[2]);

if itm.SubItems.Strings[0]='+' then
   frm.rxresults.lines.add('position: '
                                  +'1 - '+frmMain.len.Text+' : '
                                  +itm.SubItems.Strings[1]+' - '+itm.SubItems.Strings[2])
else
   frm.rxresults.lines.add('position: '
                                  +'1 - '+frmMain.len.Text+' : '
                                  +itm.SubItems.Strings[2]+' - '+itm.SubItems.Strings[1]);

//search target seq
for j:=1 to frmMain.tv.Items.Count-1 do
    begin
    if ansiuppercase(frmMain.tv.Items[j].text)=ns then
       begin
       if pos_init-10>0 then
           s4:=copy(pSq(frmMain.tv.Items[j].Data)^.seq,pos_init-10,10)
       else
           s4:=copy(pSq(frmMain.tv.Items[j].Data)^.seq,1,pos_init-1);

       s5:=copy(pSq(frmMain.tv.Items[j].Data)^.seq,pos_init+len_target,10);
       break;
       end
    end;

if itm.SubItems.Strings[0]='-' then
   begin
   s4:=revcompseq(s4);
   s5:=revcompseq(s5);
   s6:=s5;
   s5:=s4;
   s4:=s6;
   end;

frm.rxresults.lines.add('****');
frm.rxresults.lines.add(s1_n+dupestring(' ',length(s4))+s1);
frm.rxresults.lines.add(dupestring(' ',length(s1_n))+dupestring(' ',length(s4))+s3);  //pipe
frm.rxresults.lines.add(s2_n+s4+s2+s5);
end; //view alignment


procedure TfrmMain.lvAlignDblClick(Sender: TObject);
begin
if lvAlign.selected=nil then
   begin
   showmessage('Select an alignment from the "Alignment results" window!');
   exit;
   end;

dynform:=TfrmResults.create(application);
dynform.rxresults.clear;

view_alignment(lvAlign.Selected,dynform);

RX_BUG(dynform);

dynform.caption:='Alignment of '+tv.selected.text+' on '+lvAlign.selected.caption;
dynform.show;
end;

procedure explode(var sl:tstringlist;s:string;ss:shortstring);
//explode string into stringlist
begin
while pos(ss,s)<>0 do
   begin
   sl.add(copy(s,1,pos(ss,s)-1));
   delete(s,1,pos(ss,s)-1+length(ss));
   end;
end; //explode

procedure TfrmMain.mi_search_SequenceHeaderClick(Sender: TObject);
var i,j:integer;
    flagfound:boolean;
    sl:tstringlist;
begin
frmSearch.edSearch.text:='';
frmSearch.showmodal;
if frmSearch.modalresult=mrCancel then
   exit;
dynform:=tfrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='String search results';
    rxresults.lines.add('Search for: '+frmSearch.edSearch.text+'   '+date_time);
    rxresults.lines.add('');
    flagfound:=false;

    for i:=0 to tv.Items.Count-1 do
        if tv.Items[i].imageindex=c_sequence then
            if (pos(ansiuppercase(frmSearch.edSearch.text),ansiuppercase(pSq(tv.items[i].data)^.hrsf))<>0) then
               begin
               flagfound:=true;
               sl:=tstringlist.Create;
               explode(sl,pSq(tv.items[i].data)^.hrsf,CRLF);
               for j:=0 to sl.Count-1 do
                   if (pos(ansiuppercase(frmSearch.edSearch.text),ansiuppercase(sl[j]))<>0) then
                      begin
                      rxresults.lines.add(pSq(tv.items[i].data)^.name+': '+sl[j]);
                      break;
                      end;
               sl.free;
               end;
    if flagfound then
       show
    else
       showmessage('"'+frmSearch.edSearch.text+'" not found!');
    end;//with
end; //string search

//open a project
procedure TfrmMain.mi_OpenProjectClick(Sender: TObject);
begin
if sender=mi_AppendProject then
    begin
    od.title:='Append Project to current project';
    od.filter:='Annhyb project|*.annhyb|Rich Sequence File (*.RSF)|*.RSF|All files (*.*)|*.*';
    flagWorkspaceChanged:=true;
    if od.execute then
       open_sequence(od.filename);
    end
else
    begin
    od.title:='Open Project';
    od.options:=[];
    od.filename:='';
    od.filter:='Annhyb project|*.annhyb|Rich Sequence File (*.RSF)|*.RSF|All files (*.*)|*.*';
    od.filterindex:=0;
    if od.execute then
        begin
        if workspaceName='' then
            begin
            open_sequence(od.filename);
            workspaceName:=od.filename;
            end
        else
            ShellExecute(0,nil,pchar(application.ExeName),pchar('"'+od.filename+'"'),Nil,SW_NORMAL);
        end;
    end;
menu_recent_projects;
end; //open project

//export sequences
procedure TfrmMain.mo_ExportSequenceClick(Sender: TObject);
var s,dir:string;
    i,j,compt:integer;
begin
if not select_oligo_seq(c_sequence,'Select sequences to export') then
   exit;

compt:=0;
for j:=0 to tv.Items.Count-1 do
    if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
       inc(compt);

if compt=1 then
    begin
    savedialog1.title:='Export sequence';
    savedialog1.filename:='';
    savedialog1.defaultext:='';
    SaveDialog1.Filter:='Rich Sequence Format (RSF)|*.RSF|FASTA|*.*|GCG (*.gcg)|*.gcg|GenBank (*.*)|*.*|EMBL (*.*)|*.*|Rich Text Format (RTF)|*.RTF|HTML (*.html)|*.html';
    if savedialog1.execute then
        begin
        s:=savedialog1.filename;
        if extractfileext(s)='' then
            case frmmain.SaveDialog1.Filterindex of  1:s:=s+'.rsf';
                                                     2:s:=s+'.fasta';
                                                     3:s:=s+'.gcg';
                                                     4:s:=s+'.gb';
                                                     5:s:=s+'.embl';
                                                     6:s:=s+'.rtf';
                                                     7:s:=s+'.html';
                                                     end;
        for j:=0 to tv.Items.Count-1 do
            if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
                export_seq(s,pSq(tv.items[j].data)^,SaveDialog1.Filterindex-1,false);
        end;
   end
else
    begin //compt<>1
    frmExportSequences.showmodal;
    if frmExportSequences.ModalResult=mrOK then
       begin
       if frmExportSequences.rb_AllSeqOneFile.Checked then
           begin
           savedialog1.Title:='Save all selected sequences in one file';
           savedialog1.filename:='';
           savedialog1.Filter:='';
           savedialog1.defaultext:='';
           if savedialog1.execute then
               s:=savedialog1.filename;
           end
       else
           begin
           if SelectDirectory('Save all selected sequences in','',dir) then
               begin
               if dir[length(s)]<>'\' then
                  dir:=dir+'\';
               end
           else
               exit;
           end;
       //file exists?
       if frmExportSequences.rb_AllSeqOneFile.Checked and (fileexists(s)) then
           begin
           frmConfirmFile.lbMessage.caption:='The file '+s+' already exists!';
           frmConfirmFile.btAppend.visible:=true;
           frmConfirmFile.showmodal;
           if frmConfirmFile.modalresult=mrCancel then
               exit;
           if frmConfirmFile.modalresult=mrYes then
               sysutils.deletefile(s);
           end;
       for j:=0 to tv.Items.Count-1 do
            if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
               begin
               if frmExportSequences.rb_AllSeqOneFile.Checked then
                   export_seq(s,pSq(tv.items[j].data)^,frmExportSequences.rg_SequenceFormat.itemindex,true)
               else
                   begin
                   s:=dir+ValidFileName(tv.Items[j].text);
                   case frmExportSequences.rg_SequenceFormat.itemindex of 0:s:=s+'.rsf';
                                                                      1:s:=s+'.fasta';
                                                                      2:s:=s+'.gcg';
                                                                      3:s:=s+'.gb';
                                                                      4:s:=s+'.embl';
                                                                      5:s:=s+'.rtf';
                                                                      6:s:=s+'.html';
                                                                      end;

                   export_seq(s,pSq(tv.items[j].data)^,frmExportSequences.rg_SequenceFormat.itemindex,false);
                   s:='';
                   end;
               end;
       end; //modalresult=mrOK
    end;
end;   //export seq

procedure TfrmMain.mi_PrintOligoClick(Sender: TObject);
var ft:textfile;
    t2:byte;
    i:integer;

procedure print_single_oligo(oligo:T_o);
begin
calcul_param(oligo.seq,l,nb_degen,dblmw,dblmec,dblgc);
writeln(ft);
writeln(ft,'Name:     '+oligo.name);
writeln(ft,'Sequence: '+format_iupac(ansiuppercase(oligo.seq),true));
writeln(ft);
writeln(ft,'Reverted/complemented: '+format_iupac(revcompseq(oligo.seq),true));
writeln(ft,format('Length: %d b',[l]));
writeln(ft,'Number of degeneracy: '+inttostr(nb_degen));
writeln(ft,format('Molecular weight: %g',[dblmw]));
writeln(ft,format('Molar extinction coefficient: %g  l/mol',[dblmec]));
writeln(ft,format('GC percent: %g',[roundto(dblgc,-2)]));
writeln(ft,'GCG checksum: '+gcg_checksum(ansiuppercase(oligo.seq)));
writeln(ft,format('Tm (%g mM salt; %g nM oligonucleotide): ',[oligo.salt*1000,oligo.conc*1e9])
               +melting(format_iupac(oligo.seq,false),compseq(format_iupac(oligo.seq,false)),oligo.salt,oligo.conc,bibtm)+' C   '
               +bibTm);
writeln(ft);
writeln(ft);
end; //print single oligo           

begin
if not select_oligo_seq(c_oligo,'Select oligo to print') then
   exit;

if printdialog1.execute then
   for t2:=1 to printdialog1.Copies do
       begin
       AssignPrn(ft);
       Rewrite(ft);
       printer.canvas.font.name:='Courier New';
       printer.canvas.font.size:=9;
       printer.canvas.font.style:=[fsBold];
       write(ft,'AnnHyb - Oligonucleotide analysis   ');
       writeln(ft,date_time);
       writeln(ft,'  ');
       for i:=0 to tv.items.count-1 do
            if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
                print_single_oligo(pTo(tv.items[i].data)^);
       flush(ft);
       system.closefile(ft);
       end;
end; //print oligo

procedure print_sequence;
var t:byte;
    ft:textfile;
    sl:tstringlist;
    i,j:integer;
    memNode:ttreenode;
begin
with frmMain do
    begin
    memNode:=tv.selected;
    PrintDialog1.Options:=[];
    if printdialog1.execute then
        begin
        for t:=1 to printdialog1.Copies do
            for j:=0 to tv.items.count-1 do
                if (tv.items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[j].text)+'**',seqListe)<>0) then
                    begin
                    tv.select(tv.items[j]);
                    AssignPrn(ft);
                    Rewrite(ft);
                    if frmPrintSequence.cbHeader.checked then
                        begin
                        printer.canvas.font.name:='Courier New';
                        printer.canvas.font.size:=9;
                        printer.canvas.font.style:=[];
                        writeln(ft,'Sequence name: '+pSq(tv.items[j].data)^.name);
                        writeln(ft,'Sequence long name: '+pSq(tv.items[j].data)^.longname);
                        writeln(ft,'type: '+pSq(tv.items[j].data)^._type);
                        writeln(ft,'Description: '+pSq(tv.items[j].data)^.descrip);
                        writeln(ft,'Creator: '+pSq(tv.items[j].data)^.creator);
                        writeln(ft,'Creation date: '+pSq(tv.items[j].data)^.creationdate);
                        writeln(ft);
                        writeln(ft,mmHeader.text);
                        writeln(ft);
                        writeln(ft);
                        end;
                    if frmPrintSequence.cbFeatures.Checked then
                        begin
                        printer.canvas.font.name:='Courier New';
                        printer.canvas.font.size:=9;
                        printer.canvas.font.style:=[];
                        sl:=tstringlist.Create;
                        sl:=featuresToSl(pSq(tv.items[j].data)^.features);
                        for i:=0 to sl.Count-1 do
                            begin
                            write(ft,featuresExtr(sl[i]).name+'     '+inttostr(featuresExtr(sl[i]).f_init)+'..'+inttostr(featuresExtr(sl[i]).f_end));
                            if pos('///',sl[i])<>0 then
                                writeln(ft,'   '+copy(sl[i],pos('///',sl[i])+3,maxword))
                            else
                                writeln(ft);
                            end;
                        sl.free;
                        end;
                    if frmPrintSequence.cbSequence.checked and frmPrintSequence.cbSelectedSequence.Checked and (rxgcgseq.seltext<>'') then
                        begin
                        printer.canvas.font.name:='Courier New';
                        printer.canvas.font.size:=9;
                        printer.canvas.font.style:=[];
                        s:=copy(pSq(tv.items[j].data)^.seq,xytopos(postoxy(rxgcgseq.selstart).x,postoxy(rxgcgseq.selstart).y),
                                                         xytopos(postoxy(rxgcgseq.selstart+rxgcgseq.sellength).x,postoxy(rxgcgseq.selstart++rxgcgseq.sellength).y)-xytopos(postoxy(rxgcgseq.selstart).x,postoxy(rxgcgseq.selstart).y));

                        if frmPrintSequence.rbResetnumeration.checked then
                            frmMain.format_gcg(s,1)
                        else
                            frmMain.format_gcg(s,xytopos(postoxy(rxgcgseq.selstart).x,postoxy(rxgcgseq.selstart).y));
                        writeln(ft,s);
                        end;
                    System.CloseFile(ft);
                    if frmPrintSequence.cbSequence.checked and not frmPrintSequence.cbSelectedSequence.Checked then
                       rxgcgseq.print(pSq(tv.Selected.Data)^.name);
                    end;//j
        end; //execute
    tv.select(memNode);
    end; //with frmMain
end; //print seq

procedure TfrmMain.Printsequence1Click(Sender: TObject);
begin
if not select_oligo_seq(c_sequence,'Select sequences to print') then
   exit;

frmPrintSequence.showmodal;
if frmPrintSequence.modalresult=mrOK then
    begin
    if not frmPrintSequence.cbHeader.checked and not frmPrintSequence.cbFeatures.checked and not frmPrintSequence.cbSequence.checked then
        showmessage('Nothing to print!')
    else
        print_sequence;
    end;
end; //print seq

procedure TfrmMain.mo_ViewAllResultsClick(Sender: TObject);
var i:integer;
begin
if lvAlign.Items.count=0 then
   exit;

dynform:=TfrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    rxresults.lines.add('Align results for '+tv.selected.text);
    rxresults.lines.add(' ');

    for i:=0 to lvAlign.Items.count-1 do
        rxresults.lines.add(lvAlign.items[i].Caption+#9+
               'Sense: '+lvAlign.items[i].subitems.strings[0]+#9+  //sense
               'Position: '+lvAlign.items[i].subitems.strings[1]+' - '+  //init
               lvAlign.items[i].subitems.strings[2]+#9+    //end
               lvAlign.items[i].subitems.strings[3]+#9+ //score
               lvAlign.items[i].subitems.strings[4]+#9+ //seq
               lvAlign.items[i].subitems.strings[5]); //target

    //BUG RX
    for i:=RxResults.Lines.count-1 downto 0 do
        if RxResults.Lines[i]='' then
           RxResults.Lines.Delete(i);

    caption:='Align results for '+tv.selected.text;
    show;
    end;//with dynform
end;

procedure TfrmMain.mi_EditSequenceClick(Sender: TObject);
var s,s2:string;
    t:integer;
begin
if (tv.selected=nil) or (tv.selected.imageindex<>c_sequence) then    //no seq
   begin
   showmessage('Select a sequence!');
   exit;
   end;
if MessageDlg('All sequence''s annotations and oligo search will be erased!'+crlf+'Are you sure to edit this sequence?',mtWarning,[mbYes,mbCancel],0)=mrCancel then
   exit;
pSq(tv.Selected.Data)^.features:='';
clear_oligo_search(pSq(tv.Selected.Data)^.name);

s2:=pSq(tv.Selected.Data)^.seq;
s:='';
for t:=1 to length(s2) do
     begin
     s:=s+s2[t];
     if t mod 50=0 then
        s:=s+CRLF
     else
        if t mod 10=0 then
           s:=s+' ';
     end;
edit_seq.seqed2.text:=s;
s:='';
s2:='';
flag_seq_ed_valid:=true;
edit_seq.ShowModal;
if not flag_seq_ed_valid then
   exit;
//pSq(tv.Selected.Data)^.change:=true;
fwsc('edit seq');
clear_oligo_search(pSq(tv.Selected.Data)^.name);
pSq(tv.Selected.Data)^.seq:=clearseq(edit_seq.seqed2.text);
pSq(tv.Selected.Data)^.seqrtf:=pSq(tv.Selected.Data)^.seq;
format_gcg(pSq(tv.Selected.Data)^.seqrtf,1);
rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
affiche_header;
affiche_features;
//pSq(tv.Selected.Data)^.seqrtf:=sauvertf;
//pSq(tv.Selected.Data)^.flag_f_ok:=true;
end;

procedure TfrmMain.Contents1Click(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\manual.html'),Nil,Nil,SW_NORMAL);
end;

procedure TfrmMain.tvChanging(Sender: TObject; Node: TTreeNode;  var AllowChange: Boolean);
begin
if flag_nom_deja_utilise then   //change of name non authorized
   begin
   if tv.selected.imageindex=c_oligo then
      begin
      showmessage(ed_oligo_name.text+' already exists!'+LF+'Please change this name');
      ed_oligo_name.text:=memstrOligo;
      tv.Selected.text:=memstrOligo;
      end;
   if tv.selected.imageindex=c_sequence then
      begin
      showmessage(ed_seq_name.text+' already exists!'+LF+'Please change this name');
      ed_seq_name.Text:=memstrSeq;
      tv.Selected.text:=memstrSeq;
      end;
   if tv.selected.imageindex=c_al then
      begin
      showmessage(ed_ma_name.text+' already exists!'+LF+'Please change this name');
      ed_ma_name.Text:=memstrAl;
      tv.Selected.text:=memstrAl;
      end;
   AllowChange:=false;
   end
else
   begin  //change of name OK
   if (tv.selected<>nil ) and (tv.selected.imageindex=c_oligo) then
      begin
      tv.Selected.text:=ed_oligo_name.Text;
      pTo(tv.Selected.Data)^.name:=ed_oligo_name.Text;
//      fwsc(' tv changing oligo name chang');
      end;
   if (tv.selected<>nil ) and (tv.selected.imageindex=c_sequence) then
      begin
      tv.Selected.text:=ed_seq_name.Text;
      pSq(tv.Selected.Data)^.name:=ed_seq_name.Text;
      end;
   if (tv.selected<>nil ) and (tv.selected.imageindex=c_al) then
      begin
      tv.Selected.text:=ed_ma_name.Text;
      pAl(tv.Selected.Data)^.name:=ed_ma_name.Text;
      end;
   end;

if (tv.selected<>nil) and (tv.Selected.imageindex=c_sequence) then
    begin
    pSq(tv.Selected.Data)^.memposheader:=mmheader.Perform(EM_GETFIRSTVISIBLELINE,0,0);
//    pSq(tv.Selected.Data)^.memposseq:=rxgcgseq.Perform(EM_GETFIRSTVISIBLELINE,0,0);

    pSq(tv.Selected.Data)^.memposseq:=rxgcgseq.selstart;
    end;
end;

procedure TfrmMain.RxgcgseqEnter(Sender: TObject);
begin
//can_paste(false);
mi_cut.Enabled:=false;
end;

procedure TfrmMain.mmHeaderEnter(Sender: TObject);
begin
//can_paste(clipboard.HasFormat(CF_TEXT));
mi_cut.Enabled:=false;
end;

procedure TfrmMain.ed_seq_nameEnter(Sender: TObject);
begin
mi_cut.Enabled:=true;
//can_paste(clipboard.HasFormat(CF_TEXT));
memseqname:=ed_seq_name.text;
end;

procedure TfrmMain.mi_cutClick(Sender: TObject);
begin
//can_paste(false);
if tv.Focused then
    if tv.selected<>nil then
        begin
        if tv.Selected.imageindex=c_oligo then   //cut Oligo (name, seq, notes, salt, conc...)
            begin
            s:='OLIGO'+crlf;
            s:=s+pto(tv.selected.data)^.name+crlf;
            s:=s+pto(tv.selected.data)^.seq+crlf;
            s1:=stringreplace(pto(tv.selected.data)^.notes,crlf,'',[rfReplaceAll,rfIgnoreCase]);
            s:=s+s1+crlf;
            s:=s+floattostr(pto(tv.selected.data)^.salt)+crlf;
            s:=s+floattostr(pto(tv.selected.data)^.conc)+crlf;
            clipboard.astext:=s;
//            can_paste(true);
            mi_tv_paste.Enabled:=true;
            mi_tv_removeClick(self);
            exit;
            end;
        if tv.Selected.imageindex=c_sequence then   //cut seq (name, seq...)
            begin
            showmessage('function not yet implemented...');
            exit;
            end;
        if tv.Selected.imageindex=c_al then   //cut multi-alignment (name, seq...)
            begin
            showmessage('function not yet implemented...');
            exit;
            end;
        end;  //tv.selected<>nil
        
if ActiveControl is TEdit then
    begin
    TEdit(ActiveControl).cuttoclipboard;
//    can_paste(true);
    end;
if ActiveControl is TMemo then
    begin
    TMemo(ActiveControl).cuttoclipboard;
//    can_paste(true);
    end;
if ActiveControl is TRXRichEdit then
    begin
    showmessage('function not yet implemented...');
(*    if (activecontrol<>rxgcgseq) or (MessageDlg('Copy only nucleotides?',mtConfirmation,[mbYes,mbNo],0)=mrNo) then
        clipboard.astext:=TRXRichEdit(ActiveControl).seltext
    else
        clipboard.astext:=clearseq(TRXRichEdit(ActiveControl).seltext);
    can_paste(true);
*)
    end;
end; //cut

procedure TfrmMain.rxgcgseqSelectionChange(Sender: TObject);
var x,y,pos_,pos2:integer;
    sl,ss,sreg,region:shortstring;

begin
if Rxgcgseq.text='' then
   exit;
if not flagUpdateRE then
   exit;
region:='';
y:=postoxy(Rxgcgseq.selstart).y;
x:=postoxy(Rxgcgseq.selstart).x;
pos_:=xytopos(x,y);    //position init
pos2:=xytopos(postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).x,postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).y); //position finale

//calcul feature EMBL o GB
(*
if pos('   ID   ',pSq(tv.Selected.data)^.hrsf)<>0 then
   begin
   for x:=0 to mmHeader.Lines.Count-1 do
       begin
       if copy(mmHeader.Lines[x],1,11)='   FT   CDS' then
          begin
          ss:=copy(mmHeader.Lines[x],25,255);
          if pos('..',ss)<>0 then     //format EMBL
             ss:=copy(ss,1,pos('..',ss)-1);
          if pos('. .',ss)<>0 then            //format EMBL/GCG
             ss:=copy(ss,1,pos('. .',ss)-1);

          try
            i:=strtoint(ss);
          except
            break;
          end;
          if pos('..',mmHeader.Lines[x])<>0 then //format EMBL
             ss:=copy(mmHeader.Lines[x],pos('..',mmHeader.Lines[x])+2,255);
          if pos('. .',mmHeader.Lines[x])<>0 then //format EMBL/GCG
             ss:=copy(mmHeader.Lines[x],pos('. .',mmHeader.Lines[x])+3,255);
          try
            j:=strtoint(ss);
          except
            break;
          end;
          if (pos_>=i) and (pos_<=j) then
             if pos('/gene=',mmHeader.Lines[x+1])<>0 then
                region:=copy(mmHeader.Lines[x+1],31,255);
          end;
       end;
   end;
*)

if region<>'' then
   sreg:='Region: %s'
else
   sreg:='';

if pos_>length(pSq(tv.Selected.data)^.seq)+1 then
   pos_:=length(pSq(tv.Selected.data)^.seq)+1;

if pos2-1>length(pSq(tv.Selected.data)^.seq) then
   pos2:=length(pSq(tv.Selected.data)^.seq)+1;

if pos2-pos_=0 then //no selection
   statusbar1.panels[0].text:=format('Seq. length: %d   Position: %d  '+sreg,[length(pSq(tv.Selected.data)^.seq),pos_,region])
else
   statusbar1.panels[0].text:=format('Seq. length: %d   Selection: %d - %d   (%d bp)  '+sreg,[length(pSq(tv.Selected.data)^.seq),pos_,pos2-1,pos2-pos_,region]);
//calcul Tm
if (calctm1.checked) and (pos2-pos_>=8) and (pos2-pos_<=50) then
    begin
    sl:=copy(pSq(tv.Selected.data)^.seq,pos_,pos2-pos_);
//    statusbar1.panels[1].text:=inttostr(ndegen(sl));
    if ndegen(sl)<=max_degen then
        begin
{ TODO : correct value for target }        ss:=statusbar1.panels[0].text+'  Tm= '+melting(sl,compseq(sl),strtofloat2(frmPreferences.defaut_sel_seq.text)*1e-3,strtofloat2(frmPreferences.defaut_amorces_seq.text)*1e-9,bibtm)+'C  ('+bibtm+')';
        statusbar1.panels[0].text:=ss;
        end;
    end
else if (pos2-pos_>50) then  //seq longer than 50 nt
    begin
//    showmessage('salt: '+frmPreferences.long_seq_salt_tm.text);
//showmessage(floattostr(gcp(copy(ansiuppercase(pSq(tv.Selected.data)^.seq),pos_,pos2-pos_))*100));
    ss:=statusbar1.panels[0].text+'  Tm= '+long_seq_melting(strtofloat2(frmPreferences.long_seq_salt_tm.text)/1000,gcp(copy(ansiuppercase(pSq(tv.Selected.data)^.seq),pos_,pos2-pos_))*100,0,pos2-pos_)+'C  (Howley, 1979)';
    statusbar1.panels[0].text:=ss;
    end;

end;

procedure TfrmMain.RxRichEdit1Enter(Sender: TObject);
begin
//can_paste(false);
mi_cut.Enabled:=false;
end;

procedure TfrmMain.mi_tv_MovedownClick(Sender: TObject);
begin

if (tv.Selected.absoluteindex+1<tv.items.count) and (tv.selected.imageindex=tv.Items[tv.Selected.absoluteindex+1].ImageIndex) then
   begin
   if (tv.Selected.absoluteindex+2>=tv.items.count) or (tv.selected.imageindex<>tv.Items[tv.Selected.absoluteindex+2].ImageIndex) then
      tv.Selected.MoveTo(tv.items[tv.selected.absoluteindex+1], naadd)
   else
      tv.Selected.MoveTo(tv.items[tv.selected.absoluteindex+2], nainsert);
   end
else
   showmessage('Can not move the selected oligo!');

end;

procedure TfrmMain.mi_tv_MoveupClick(Sender: TObject);
begin
if (tv.Selected.absoluteindex-1>=0) and (tv.selected.imageindex=tv.Items[tv.Selected.absoluteindex-1].ImageIndex) then
   tv.Selected.MoveTo(tv.Items[tv.Selected.absoluteindex-1], nainsert)
else
   showmessage('Can not move the selected oligo!');
end;

procedure TfrmMain.Selectsubsequence1Click(Sender: TObject);
var pos1,pos2:integer;
    s1,s2:shortstring;
begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_sequence) then
   begin
   showmessage('Select a sequence first!');
   exit;
   end;
s:='';
InputQuery('Select subsequence', 'start position - end position',s);
if (pos('-',s)=0) and (pos('..',s)=0) then
   begin
   showmessage('Nucleotide positions not valid!'+LF+'try for example: 123-789 or 123..789');
   exit;
   end;

if pos('..',s)<>0 then //remplace .. par -
   begin
   s[pos('..',s)]:='-';
   delete(s,pos('.',s),1);
   end;

s1:=trim(copy(s,1,pos('-',s)-1));  //init
s2:=trim(copy(s,pos('-',s)+1,255));
if (s1='') or (s2='') then
   begin
   showmessage('Nucleotide positions are not valid!'+LF+'example: 123-789');
   exit;
   end;

val(s1,pos1,erreur);
if erreur<>0 then
   begin
   showmessage('Nucleotide position is not valid!');
   exit;
   end;
val(s2,pos2,erreur);
if erreur<>0 then
   begin
   showmessage('Nucleotide position is not valid!');
   exit;
   end;

if (pos1>=pos2) or (pos1>length(pSq(tv.Selected.data)^.seq)) or (pos2>length(pSq(tv.Selected.data)^.seq)) then
   begin
   showmessage('Nucleotide positions are not valid! Starting position must be minor than ending position');
   exit;
   end;

rxgcgseq.SetFocus;
rxgcgseq.selstart:=posseqtopos(pos1);
rxgcgseq.sellength:=posseqtopos(pos2)-posseqtopos(pos1)+1;
end;



procedure TfrmMain.mi_PrintoligolistClick(Sender: TObject);
var i,t:integer;
    nl:byte;
    ft:textfile;

procedure formatedprint(s:shortstring;l:byte);
begin
while length(s)<l do
      s:=s+' ';
write(ft,s);
end;

begin
if num_obj(c_oligo)=0 then
    begin
    showmessage('No oligo to print!');
    exit;
    end;
seqListe:=seqselect(c_oligo,'Select oligo');
if (seqliste<>'cancel') and printdialog1.execute then
   for t:=1 to printdialog1.Copies do
       begin
       AssignPrn(ft);
       Rewrite(ft);
       printer.canvas.font.name:='Courier New';
       printer.canvas.font.size:=9;
       printer.canvas.font.style:=[fsBold];
//       printer.orientation:=polandscape;
       writeln(ft);
       write(ft,'AnnHyb - Oligonucleotide analysis   ');
       writeln(ft,date_time);
       writeln(ft);
       //dtermination long max. nom oligo
       nl:=0;
       for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
              nl:=max(nl,length(pTo(tv.Items[i].Data)^.name));
       //impression lgende
       formatedprint('Name',nl+2);
       formatedprint('Sequence',43);
       formatedprint('nb',4);
       formatedprint('Check',5);
       formatedprint('MW',7);
       formatedprint('GC%',6);
       formatedprint('MEC',8);
       formatedprint('salt',5);
       formatedprint('olg',5);
       write(ft,'Tm ');
       writeln(ft,BibTm);
       formatedprint('',nl+2+43+4+9+7+6);
       formatedprint('l/mol',8); //mec
       formatedprint('cc',5);   //salt cc
       formatedprint('cc',5);  //oligo cc
       writeln(ft,'C');

       writeln(ft);

       for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then //oligo
              begin
              formatedprint(pTo(tv.Items[i].Data)^.name,nl+2);
              if length(format_iupac(pTo(tv.Items[i].Data)^.seq,true))>43 then
                 formatedprint(copy(format_iupac(pTo(tv.Items[i].Data)^.seq,true),1,40)+'...',40)
              else
                 formatedprint(format_iupac(pTo(tv.Items[i].Data)^.seq,true),43);

              calcul_param(pTo(tv.Items[i].Data)^.seq,l,nb_degen,dblmw,dblmec,dblgc);

              formatedprint(inttostr(l),4);
              formatedprint(gcg_checksum(pTo(tv.Items[i].Data)^.seq),5);
              formatedprint(floattostr2(dblmw),7);
              formatedprint(floattostr2(roundto(dblgc,-1)),6);
              formatedprint(floattostr2(dblmec),8);

              formatedprint(floattostr2(pTo(tv.Items[i].Data)^.salt/1e-3),5);
              formatedprint(floattostr2(pTo(tv.Items[i].Data)^.conc/1e-9),5);
              if pTo(tv.Items[i].Data)^.seq<>'' then
                 writeln(ft,melting(pTo(tv.Items[i].Data)^.seq,compseq(pTo(tv.Items[i].Data)^.seq),pto(tv.Items[i].data)^.salt,pto(tv.Items[i].data)^.conc,bibtm))
              else
                 writeln(ft,'ND');
              end;
       flush(ft);
       system.closefile(ft);
       end;
end;

procedure TfrmMain.mi_NewProjectClick(Sender: TObject);
begin
ShellExecute(0,nil,pchar(application.ExeName),Nil,Nil,SW_NORMAL);
end;

procedure TfrmMain.ed_seq_longnameChange(Sender: TObject);
begin
pSq(tv.selected.data)^.longname:=ed_seq_longname.text;
if activecontrol=ed_seq_longname then
   fwsc('ed seq longname');
end;

procedure TfrmMain.ed_seq_descripChange(Sender: TObject);
begin
pSq(tv.selected.data)^.descrip:=ed_seq_descrip.text;
if activecontrol=ed_seq_descrip then
   fwsc('ed seq description');
end;

procedure TfrmMain.ed_seq_typeChange(Sender: TObject);
begin
pSq(tv.selected.data)^._type:=ed_seq_type.text;
if activecontrol=ed_seq_type then
   fwsc('ed seq type');
end;

procedure TfrmMain.ed_seq_creatorChange(Sender: TObject);
begin
pSq(tv.selected.data)^.creator:=ed_seq_creator.text;
if activecontrol=ed_seq_creator then
   fwsc('ed seq creator');
end;

procedure TfrmMain.ed_seq_creationdateChange(Sender: TObject);
begin
pSq(tv.selected.data)^.creationdate:=ed_seq_creationdate.text;
if activecontrol=ed_seq_creationdate then
   fwsc('ed seq date');
end;

procedure TfrmMain.Workspace2Click(Sender: TObject);
begin
ShellExecute( 0, Nil, PChar( application.ExeName ), Nil, Nil, SW_NORMAL );
end;

procedure TfrmMain.tb_upClick(Sender: TObject);
begin
if activecontrol=tv then
   if (tv.Selected.absoluteindex-1>=0) then
        tv.Items[tv.Selected.absoluteindex-1].Selected:=true;
end;

procedure TfrmMain.tb_downClick(Sender: TObject);
begin
if activecontrol=tv then
   if (tv.Selected.absoluteindex+1<tv.items.count) then
      tv.Items[tv.Selected.absoluteindex+1].Selected:=true;
end;

procedure TfrmMain.PCRproduct1Click(Sender: TObject);
var i,j,minpos,maxpos,nb_degen:integer;
    mw,mec,gc:double;
    sense:shortstring;
    s:string;
    sl:tstringlist;
begin
if lvAnnotations.items.count=0 then
   begin
   showmessage('There are no oligo in sequence annotations!');
   exit;
   end;
if lvAnnotations.selcount<>2 then
   begin
   showmessage('Select two oligo from sequence annotations!');
   exit;
   end;
minpos:=maxint;
maxpos:=0;
for i:=0 to lvAnnotations.items.count-1 do
    begin
    if lvAnnotations.items[i].selected then
       begin
       if strtoint(lvAnnotations.items[i].subitems.strings[0])<minpos then
          minpos:=strtoint(lvAnnotations.items[i].subitems.strings[0]);
       if strtoint(lvAnnotations.items[i].subitems.strings[1])>maxpos then
          maxpos:=strtoint(lvAnnotations.items[i].subitems.strings[1]);
       end;
    end;
dynform:=TfrmResults.create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='PCR product';
    rxresults.lines.add('PCR product from '+pSq(tv.Selected.data)^.name+'   '+date_time);
    rxresults.lines.add('');
    sense:='';
    for i:=0 to lvAnnotations.items.count-1 do
        if lvAnnotations.items[i].selected then
           begin
           if lvAnnotations.items[i].subitems.strings[2]<>'' then
              begin
              sl:=tstringlist.create;
              split(lvAnnotations.items[i].subitems.strings[2],' ',sl);
              rxresults.lines.add(lvAnnotations.items[i].caption);
              rxresults.lines.add(sl[0]+' '+sl[1]+' '+sl[2]+' '+sl[3]);
              rxresults.lines.add(sl[4]+' '+sl[5]);
              sense:=sense+sl[5];
              rxresults.lines.add('position: '+lvAnnotations.items[i].subitems.strings[0]+' - '+lvAnnotations.items[i].subitems.strings[1]);
              rxresults.lines.add('');
              rxresults.lines.add('query:  '+sl[7]);
              s:='';
              for j:=1 to length(sl[7]) do
                  if sl[7][j]=sl[9][j] then
                     s:=s+'|'
                  else
                     s:=s+' ';
              rxresults.lines.add('        '+s);
              rxresults.lines.add('target: '+sl[9]);
              rxresults.lines.add('');
              sl.free;
              end
           else
              begin
              rxresults.lines.add(lvAnnotations.items[i].caption);
              rxresults.lines.add('position: '+lvAnnotations.items[i].subitems.strings[0]+' - '+lvAnnotations.items[i].subitems.strings[1]);
              end;
           rxresults.lines.add('');
           end;
    rxresults.lines.add('PCR product:');
    if (pos('+',sense)=0) or (pos('-',sense)=0) then
        begin
        rxresults.lines.add('');
        rxresults.lines.add('Attention');
        rxresults.lines.add('The two primer sequences are on the same frame ('+sense[1]+')');
        rxresults.lines.add('');
        end;
    rxresults.lines.add('  Length: '+inttostr(maxpos-minpos+1)+' bp');
    s:=copy(pSq(tv.selected.data)^.seq,minpos,maxpos-minpos+1);
    calcul_param(s,l,nb_degen,mw,mec,gc);
    rxresults.lines.add('  GC%: '+floattostr2(roundto(gc,-2)));                                                                                                
    RxResults.Lines.add('  Tm ('+frmPreferences.long_seq_salt_tm.Text+' mM Na+): '+long_seq_melting(strtofloat(frmPreferences.long_seq_salt_tm.Text)/1000,gc,0,l)+' C');
    show;
    end; //with
end;

procedure TfrmMain.lvAnnotationsDblClick(Sender: TObject);
begin
if lvAnnotations.selected=nil then
   exit;
with rxgcgseq do
     begin
     selLength:=0;

(*     selStart:=Perform(EM_LINEINDEX,postoxy(i).y,0);
       Perform(EM_SCROLLCARET,0,0);
*)
    rxgcgseq.SetFocus;
    rxgcgseq.selstart:=posseqtopos(strtoint(lvAnnotations.selected.subitems.strings[0]));
    end;
end;

procedure TfrmMain.ed_oligo_nameChange(Sender: TObject);
var i:integer;
begin
if activecontrol=ed_oligo_name then
   fwsc('name changed');
flag_nom_deja_utilise:=false;
for i:=0 to tv.Items.Count-1 do
    if (tv.Items[i]<>tv.selected) and (tv.Items[i].imageindex=c_oligo)
        and (ansiuppercase(ed_oligo_name.text)=ansiuppercase(tv.Items[i].text)) then
       begin
       flag_nom_deja_utilise:=true;
       exit;
       end;
end;

procedure TfrmMain.ed_seq_nameChange(Sender: TObject);
var i:integer;
begin
if activecontrol=ed_seq_name then
   fwsc('seq name changed');

flag_nom_deja_utilise:=false;
for i:=0 to tv.Items.Count-1 do
    if (tv.Items[i]<>tv.selected) and (tv.Items[i].imageindex=c_sequence) and (ansiuppercase(ed_seq_name.text)=ansiuppercase(tv.Items[i].text)) then
       begin
       flag_nom_deja_utilise:=true;
       exit;
       end;
end;

procedure TfrmMain.mi_AddSelectedSeqFeaturesClick(Sender: TObject);
var pos1,pos2,i:integer;
    itm:Tlistitem;
begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_sequence) then
   begin
   showmessage('Select a sequence!');
   exit;
   end;

pos1:=xytopos(postoxy(Rxgcgseq.selstart).x,postoxy(Rxgcgseq.selstart).y);
pos2:=xytopos(postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).x,postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).y)-1;
if pos1>pos2 then
   begin
   showmessage('Select a sequence!');
   exit;
   end;

with frmFeatures do
   begin
   edFbegin.text:=inttostr(pos1);
   edFend.text:=inttostr(pos2);
   feature_name.clear;
   f_comment.clear;
   clbFeatures.itemindex:=16;  //none
   lvFeatures.Items:=lvAnnotations.Items;

   itm:=lvFeatures.Items.Add;
   itm.ImageIndex:=-1;
   itm.Caption:='';
   itm.SubItems.Add(edFbegin.text);
   itm.SubItems.Add(edFend.text);
   itm.SubItems.add('');
   lvFeatures.Selected:=itm;

   showmodal;
   pSq(tv.Selected.Data)^.features:='';
   if lvAnnotations.items.count>0 then
      for i:=0 to lvAnnotations.items.count-1 do
          add_feature(strtoint(lvAnnotations.items[i].subitems.strings[0]),
                      strtoint(lvAnnotations.items[i].subitems.strings[1]),
                      color_rsf[lvAnnotations.items[i].imageindex],
                      lvAnnotations.items[i].caption,
                      lvAnnotations.items[i].subitems.strings[2]);


   pSq(tv.Selected.Data)^.seqrtf:=sauvertf;
   pSq(tv.Selected.Data)^.flag_f_ok:=true;
   end;

end;

procedure TfrmMain.ed_seq_checksumKeyPress(Sender: TObject; var Key: Char);
begin
showmessage('This is a calculated value that can not be modified by user');
end;

procedure TfrmMain.cbColorChange(Sender: TObject);
begin
if numoligo=0 then
   exit;
if (tv.selected<>nil) and (tv.selected.imageindex=c_oligo) then
   begin
//   showmessage(inttostr(cbColor.itemindex));
   if (cbColor.itemindex=16) then //efface oligo trouvs si choix "none"
       begin
       pto(tv.selected.data)^.found_seq:='';
       lvAlign.clear;
       pto(tv.selected.data)^.view:=0;
       end
   else
       pto(tv.selected.data)^.view:=color_rsf[cbColor.itemindex];
   end;
end;

procedure TfrmMain.cbColorEnter(Sender: TObject);
begin
//can_paste(false);
mi_cut.Enabled:=false;
end;

procedure TfrmMain.lvSeqColumnClick(Sender: TObject; Column: TListColumn);
begin
ListSeqColumnToSort:=Column.Index;
(Sender as TCustomListView).AlphaSort;
ListSeqSortInc:=not ListSeqSortInc;
end;

procedure TfrmMain.lvSeqCompare(Sender:TObject;Item1,Item2:TListItem;Data:Integer;var Compare: Integer);
begin
case ListSeqColumnToSort of 0:Compare:=CompareText(Item1.Caption,Item2.Caption);
                            1,3:if strtoint(Item1.SubItems[ListSeqColumnToSort-1])>strtoint(Item2.SubItems[ListSeqColumnToSort-1]) then
                                   compare:=1
                                else if strtoint(Item1.SubItems[ListSeqColumnToSort-1])<strtoint(Item2.SubItems[ListSeqColumnToSort-1]) then
                                   compare:=-1
                                else
                                   compare:=0;
                            2,4:Compare:=CompareText(Item1.SubItems[ListSeqColumnToSort-1],Item2.SubItems[ListSeqColumnToSort-1]);
                            end; //case
if not ListSeqSortInc then
   compare:=-compare;
end;

procedure TfrmMain.lv_oligoColumnClick(Sender: TObject; Column: TListColumn);
begin
ListOligoColumnToSort:=Column.Index;
(Sender as TCustomListView).AlphaSort;
Listoligosortinc:=not Listoligosortinc;
end;

procedure TfrmMain.lv_oligoCompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
var a,b:double;
begin
case ListOligoColumnToSort of 0:Compare:=CompareText(Item1.Caption,Item2.Caption);
                              1:Compare:=CompareText(Item1.SubItems[ListOligoColumnToSort-1],Item2.SubItems[ListOligoColumnToSort-1]);
                              2..9:begin
                                   if pos(' - ',Item1.SubItems[ListOligoColumnToSort-1])<>0 then
                                      a:=strtofloat2(copy(Item1.SubItems[ListOligoColumnToSort-1],1,pos(' - ',Item1.SubItems[ListOligoColumnToSort-1])-1))
                                   else
                                      a:=strtofloat2(Item1.SubItems[ListOligoColumnToSort-1]);
                                   if pos(' - ',Item2.SubItems[ListOligoColumnToSort-1])<>0 then
                                      b:=strtofloat2(copy(Item2.SubItems[ListOligoColumnToSort-1],1,pos(' - ',Item2.SubItems[ListOligoColumnToSort-1])-1))
                                   else
                                      b:=strtofloat2(Item2.SubItems[ListOligoColumnToSort-1]);
                                   if a>b then
                                      compare:=1
                                   else if a<b then
                                      compare:=-1
                                   else
                                      compare:=0;
                                   end;
                              end;//case
if not ListOligoSortInc then
   compare:=-compare;
end;

procedure TfrmMain.tvDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
Accept:=Source is TTreeview;
end;

procedure TfrmMain.tvDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
if (tv.GetNodeAt(x,y)<>nil) and (tv.selected.imageindex<>0) and (tv.selected.imageindex=tv.GetNodeAt(x,y).imageindex) then
   begin
   tv.Selected.MoveTo(tv.GetNodeAt(x,y),nainsert)
   end;
   //showmessage(inttostr(tv.GetNodeAt(x,y).imageindex));
end;

procedure TfrmMain.Printsequenceslist1Click(Sender: TObject);
var i,t:integer;
    nl:byte;
    ft:textfile;

procedure formatedprint(s:shortstring;l:byte);
begin
while length(s)<l do
      s:=s+' ';
write(ft,s);
end;

begin
if num_obj(c_sequence)=0 then
    begin
    showmessage('No sequence to print!');
    exit;
    end;

seqListe:=seqselect(c_sequence,'Select sequences');
if (seqliste<>'cancel') and printdialog1.execute then
   for t:=1 to printdialog1.Copies do
       begin
       AssignPrn(ft);
       Rewrite(ft);
       printer.canvas.font.name:='Courier New';
       printer.canvas.font.size:=9;
       printer.canvas.font.style:=[fsBold];
//       printer.orientation:=polandscape;
       writeln(ft);
       write(ft,'AnnHyb - Sequences list   ');
       writeln(ft,date_time);
       writeln(ft);

       nl:=0;
       for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
              nl:=max(nl,length(pSq(tv.Items[i].Data)^.name));

       printer.canvas.font.style:=[fsBold];
       formatedprint('Name',nl+2);
       formatedprint('Length',10);
       formatedprint('Long name',25);
       formatedprint('Check',5);
       writeln(ft,'Description');

       for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
              begin
              printer.canvas.font.style:=[fsBold];
              formatedprint(pSq(tv.Items[i].Data)^.name,nl+2);
              printer.canvas.font.style:=[];
              formatedprint(inttostr(length(pSq(tv.Items[i].Data)^.seq)),10);
              formatedprint(pSq(tv.Items[i].Data)^.longname,25);
              formatedprint(gcg_checksum(pSq(tv.Items[i].Data)^.seq),5);
              writeln(ft,pSq(tv.Items[i].Data)^.descrip);
              end;
       flush(ft);
       system.closefile(ft);
       end;
end;

procedure TfrmMain.mi_PrintSequenceslist2Click(Sender: TObject);
begin
Printsequenceslist1Click(self);
end;

procedure TfrmMain.Printoligolist2Click(Sender: TObject);
begin
mi_PrintoligolistClick(self);
end;

procedure TfrmMain.mi_ImportMAClick(Sender: TObject);
var i:integer;
begin
od.options:=[ofAllowMultiSelect];
od.title:='Open Multiple Alignment';
od.filename:='';
od.filter:='CLUSTAL Multiple alignment (*.aln)|*.aln|All files (*.*)|*.*';
if od.execute then
    with od.Files do     //ouvertures multiples
        for i:=0 to Count-1  do
            begin
            nomfichier:=Strings[I];
            if nomfichier<>'' then
                open_multialign_file(nomfichier);
            end; //for
end;

procedure TfrmMain.sbhChange(Sender: TObject);
begin
affiche_al;
application.ProcessMessages;
end;

procedure TfrmMain.sbvChange(Sender: TObject);
begin
affiche_al;
application.ProcessMessages;
end;

procedure TfrmMain.lv_oligoDblClick(Sender: TObject);
var i:integer;
begin
if lv_oligo.selected=nil then
   exit;
for i:=0 to tv.items.count-1 do
    if (tv.items[i].text=lv_oligo.Selected.caption) and (tv.items[i].imageindex=c_oligo) then
       begin;
       tv.items[i].selected:=true;
       break;
       end;
end;

procedure TfrmMain.lvSeqDblClick(Sender: TObject);
var i:integer;
begin
if lvSeq.selected=nil then
   exit;
for i:=0 to tv.items.count-1 do
    if (tv.items[i].text=lvSeq.Selected.caption) and (tv.items[i].imageindex=c_sequence) then
       begin;
       tv.items[i].selected:=true;
       break;
       end;
end;

procedure TfrmMain.mi_PrintMAClick(Sender: TObject);
var flagfirst:boolean;
var t1,t,compt:integer;
    s,ss,def,ac,src,id:shortstring;
    sl:tstringlist;
const l=125;
begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_al) then
    begin
    showmessage('Select a multiple alignment!');
    exit;
    end;

if printdialog1.execute then
   begin
   sl:=tstringlist.create;
   //fiche lecture
   if MessageDlg('Print sequence references?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
      with printer do
         begin
         flagfirst:=true;
         compt:=1;
         printer.canvas.font.name:='Courier New';
         printer.canvas.font.size:=9;
         printer.canvas.font.style:=[];
         printer.orientation:=polandscape;
         begindoc;
         canvas.penpos:=point(5,10);
         for t:=0 to pAl(tv.Selected.Data)^.seql.count-1 do
             begin
             // recup info
             id:=trim(pAl(tv.Selected.Data)^.namel[t]);
             s:=AnsiReplaceStr(frmPreferences.cbServerURL.Items[frmPreferences.cbServerURL.itemindex],'*',id);
             try
                sl.text:=AdjustLineBreaks(idHTTP1.get(s));
                def:='';
                for t1:=0 to sl.count-1 do
                    begin
                    if pos('DEFINITION  ',sl[t1])=1 then  //GB
                       begin
                       def:=copy(sl[t1],13,255)+' ';  //first line
                       if sl[t1+1][1]=' ' then    //second line
                          def:=def+copy(sl[t1+1],13,255);
                       end;
                    if pos('DE   ',sl[t1])=1 then //EMBL
                       begin
                       def:=copy(sl[t1],10,255)+' ';
                       if pos('DE   ',sl[t1+1])=1 then
                          def:=def+copy(sl[t1+1],10,255);
                       end;

                    if pos('ACCESSION   ',sl[t1])=1 then
                       ac:=copy(sl[t1],13,255);
                    if pos('AC   ',sl[t1])=1 then
                       begin
                       ac:=copy(sl[t1],10,255);
                       while pos(';',ac)<>0 do
                           delete(ac,pos(';',ac),1);
                       end;
                    if pos('SOURCE      ',sl[t1])=1 then
                       src:=copy(sl[t1],13,255);
                    if pos('OS   ',sl[t1])=1 then
                       src:=copy(sl[t1],10,255);
                    end;
             except
                ac:=id;
             end; //try
             while length(ac)<10 do
                   ac:=ac+' ';
             while length(def)<70 do
                   def:=def+' ';
             ss:=ac+def+'  '+src;
             canvas.textout(5,canvas.penpos.y+canvas.textheight(ss),ss);
             if canvas.penpos.y>=pageheight then
                begin
                newpage;
                canvas.PenPos:=point(5,10);
                end;
             end;
         enddoc;  //textout penpos
         end; //with printer

   //squences
   with printer do
        begin
        flagfirst:=true;
        compt:=1;
        printer.canvas.font.name:='Courier New';
        printer.canvas.font.size:=9;
        printer.canvas.font.style:=[];
        printer.orientation:=polandscape;
        begindoc;
        canvas.penpos:=point(10,10);
        repeat
            for t:=0 to pAl(tv.Selected.Data)^.seql.count-1 do
                begin
                if flagfirst then
                   begin
                   s:=pAl(tv.Selected.Data)^.namel[t];
                   while length(s)<16 do
                         s:=s+' ';
                   canvas.textout(10,canvas.penpos.y+canvas.textheight(s),s);
                   canvas.textout(canvas.penpos.x,canvas.penpos.y,copy(pAl(tv.Selected.Data)^.seql[t],compt,l));
                   end
                else
                   begin
                   canvas.textout(10,canvas.penpos.y+canvas.textheight(copy(pAl(tv.Selected.Data)^.seql[t],compt,l+16)),copy(re.lines[t],compt,l+16));
                   end;
                if canvas.penpos.y>=pageheight then
                   begin
                   newpage;
                   canvas.PenPos:=point(10,10);
                   end;
                end;
            if flagfirst then
               compt:=compt+l
            else
               compt:=compt+l+16;
            flagfirst:=false;
            newpage;
            canvas.PenPos:=point(10,10);
        until compt>length(pAl(tv.Selected.Data)^.seql[0]);
        enddoc;  //textout penpos
        end; //with printer
   sl.free;
   end;//execute

end;

procedure TfrmMain.lvAlignColumnClick(Sender: TObject; Column: TListColumn);
var i:integer;
    s:string;
begin

lvAlignColumnToSort:=Column.Index;
(Sender as TCustomListView).AlphaSort;
lvAlignSortInc:=not lvAlignSortInc;

s:='';
for i:=0 to lvAlign.Items.Count-1 do
    begin
    if lvAlign.Items[i].Checked then
       s:=s+'3'
    else
       s:=s+'2';
    s:=s+lvAlign.Items[i].Caption+'|'; //seq name
    s:=s+lvAlign.Items[i].subitems.strings[0]+'|';   //sense
    s:=s+lvAlign.Items[i].subitems.strings[1]+'|';   //init
    s:=s+lvAlign.Items[i].subitems.strings[2]+'|';   //end
    s:=s+lvAlign.Items[i].subitems.strings[3]+'|';   //score
    s:=s+lvAlign.Items[i].subitems.strings[6]+'|';   //color
    s:=s+lvAlign.Items[i].subitems.strings[4]+'|';   //aligned seq
    s:=s+lvAlign.Items[i].subitems.strings[5]+'|'+LF;   //target seq
    end;

pTo(tv.Selected.Data)^.found_seq:=s;
end;

procedure TfrmMain.lvAlignCompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
begin
case lvAlignColumnToSort of 0:Compare:=CompareText(Item1.Caption,Item2.Caption);
                            1,5,6:Compare:=CompareText(Item1.SubItems[lvAlignColumnToSort-1],Item2.SubItems[lvAlignColumnToSort-1]);
                            2,3:if strtoint(Item1.SubItems[lvAlignColumnToSort-1])>strtoint(Item2.SubItems[lvAlignColumnToSort-1]) then
                                     compare:=1
                                  else if strtoint(Item1.SubItems[lvAlignColumnToSort-1])<strtoint(Item2.SubItems[lvAlignColumnToSort-1]) then
                                     compare:=-1
                                  else
                                     compare:=0;
                            4:if strtofloat2(Item1.SubItems[lvAlignColumnToSort-1])>strtofloat2(Item2.SubItems[lvAlignColumnToSort-1]) then
                                     compare:=1
                                  else if strtofloat2(Item1.SubItems[lvAlignColumnToSort-1])<strtofloat2(Item2.SubItems[lvAlignColumnToSort-1]) then
                                     compare:=-1
                                  else
                                     compare:=0;
                                  end; //case
if not lvAlignSortInc then
   compare:=-compare;
end;

procedure TfrmMain.mi_EditSequenceAttributesClick(Sender: TObject);
var i:integer;
    sl:tstringlist;
begin
if (tv.selected=nil) or (tv.selected.imageindex<>c_sequence) then
    begin
    showmessage('Select a valid sequence!');
    exit;
    end;

with frmSequenceAttributes do
    begin
    s_name.text:=pSq(tv.Selected.Data)^.name;
    try
       s_creation_date.date:=strtodate(pSq(tv.Selected.Data)^.creationdate);
    except
       on EConvertError do s_creation_date.date:=now;

    end;

    s_longname.text:=pSq(tv.Selected.Data)^.longname;
    s_description.text:=pSq(tv.Selected.Data)^.descrip;
    s_checksum.text:=gcg_checksum(pSq(tv.Selected.Data)^.seq);
    s_creator.text:=pSq(tv.Selected.Data)^.creator;

    sl:=tstringlist.Create;
    sl.text:=pSq(tv.Selected.Data)^.hrsf;
     s_comments.text:=sl.text;

    s_type.text:=pSq(tv.Selected.Data)^._type;

    ShowModal;

    if modalresult=mrOK then
          begin
          pSq(tv.Selected.Data)^.name:=s_name.Text;
          pSq(tv.Selected.Data)^.creationdate:=datetostr(s_creation_date.date);
          pSq(tv.Selected.Data)^.longname:=s_longname.text;
          pSq(tv.Selected.Data)^.descrip:=s_description.text;
          pSq(tv.Selected.Data)^.creator:=s_creator.text;
          pSq(tv.Selected.Data)^._type:=s_type.text;

          //comments
          pSq(tv.Selected.Data)^.hrsf:='';
          sl.Text:=s_comments.Text;
          if sl.count>0 then
           for i:=0 to sl.Count-1 do
               pSq(tv.Selected.Data)^.hrsf:=pSq(tv.Selected.Data)^.hrsf+sl[i]+CRLF;

          affiche_header;
          fwsc('ed seq attibutes');
          end;
    sl.free;      
    end; //with

end;

procedure TfrmMain.Clearresults1Click(Sender: TObject);
begin
lvAlign.Clear;
pto(tv.selected.data)^.found_seq:='';
end;

procedure TfrmMain.Checkallresults1Click(Sender: TObject);
var i:integer;
begin
for i:=0 to lvAlign.items.Count-1 do
    if sender=Checkallresults1 then
       lvAlign.Items[i].Checked:=true
    else
       lvAlign.Items[i].Checked:=false;
end;

procedure TfrmMain.mi_CloseProjectClick(Sender: TObject);
var w:word;
begin
if flagWorkspaceChanged then
   begin
   w:=MessageDlg('The project was modified!'+LF+'Do you want to save it?',mtWarning,[mbYes,mbNo,mbCancel],0);
   if w=mrCancel then
      exit;
   if w=mrYes then
      frmMain.mi_SaveProjectClick(mi_saveProject);
   end;
fwsnc('close ws');
close_project;
end;

procedure TfrmMain.mi_ExportoligolistClick(Sender: TObject);
var i:integer;
    nl:byte;
    ss1,ss2:shortstring;
begin
if not select_oligo_seq(c_oligo,'Select oligo to include in the list') then
   exit;

dynform:=tfrmResults.Create(application);
with dynform do
    begin
    rxresults.clear;
    caption:='AnnHyb - Oligonucleotide list';
    rxresults.lines.add('AnnHyb - Oligonucleotide list   '+date_time);
    rxresults.lines.add('****');

    nl:=0;
    for i:=0 to tv.items.count-1 do
        if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
            nl:=max(nl,length(pTo(tv.Items[i].Data)^.name));

    ss1:=bibTm;

    rxresults.lines.add(fs('Name',nl+2)+
              fs('Sequence',43)+
              fs('nb',4)+
              fs('Check',5)+
              fs('MW',7)+
              fs('GC%',6)+
              fs('MEC',8)+
              fs('salt',5)+
              fs('olg',5)+
              'Tm '+ss1+
              fs('',nl+2+43+4+5+7+6)+
              fs('l/mol',8)+
              fs('cc',5)+
              fs('cc',5)+'C');

    for i:=0 to tv.items.count-1 do
        if (tv.items[i].imageindex=c_oligo) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then //oligo
            begin
            if length(format_iupac(pTo(tv.Items[i].Data)^.seq,true))>43 then
               ss1:=fs(copy(format_iupac(pTo(tv.Items[i].Data)^.seq,true),1,40)+'...',40)
            else
               ss1:=fs(format_iupac(pTo(tv.Items[i].Data)^.seq,true),43);
            calcul_param(pTo(tv.Items[i].Data)^.seq,l,nb_degen,dblmw,dblmec,dblgc);

            if pTo(tv.Items[i].Data)^.seq<>'' then
                ss2:=melting(pTo(tv.Items[i].Data)^.seq,compseq(pTo(tv.Items[i].Data)^.seq),pto(tv.Items[i].data)^.salt,pto(tv.Items[i].data)^.conc,bibtm)
            else
                ss2:='ND';

            rxresults.lines.add(fs(pTo(tv.Items[i].Data)^.name,nl+2)+
                         ss1+
                         fs(inttostr(l),4)+
                         fs(gcg_checksum(pTo(tv.Items[i].Data)^.seq),5)+
                         fs(floattostr2(dblmw),7)+
                         fs(floattostr2(roundto(dblgc,-1)),6)+
                         fs(floattostr2(dblmec),8)+
                         fs(floattostr2(pTo(tv.Items[i].Data)^.salt/1e-3),5)+
                         fs(floattostr2(pTo(tv.Items[i].Data)^.conc/1e-9),5)+
                         ss2);
            end;
    RX_BUG(dynform);
    show;
    end;//with dynform
end; //export oligo list

procedure TfrmMain.mi_exportSequencelist2Click(Sender: TObject);
var i:integer;
    nl:byte;
    sl:tstringlist;
begin
if numseq=0 then
    begin
    showmessage('No sequences!');
    exit;
    end;
seqListe:=seqselect(c_sequence,'Select sequences to include in the list');
if seqliste<>'cancel' then
   begin
   sl:=tstringlist.create;
   sl.add('AnnHyb - Sequences list   '+date_time);
   sl.add('');

   nl:=0;
   for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
              nl:=max(nl,length(pSq(tv.Items[i].Data)^.name));
   sl.add(fs('Name',nl+2)+
          fs('Length',10)+
          fs('Long name',25)+
          fs('Check',5)+
          'Description');

       for i:=0 to tv.items.count-1 do
           if (tv.items[i].imageindex=c_sequence) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
              begin
              sl.add(fs(pSq(tv.Items[i].Data)^.name,nl+2)+
                     fs(inttostr(length(pSq(tv.Items[i].Data)^.seq)),10)+
                     fs(pSq(tv.Items[i].Data)^.longname,25)+
                     fs(gcg_checksum(pSq(tv.Items[i].Data)^.seq),5)+
                     pSq(tv.Items[i].Data)^.descrip);
              end;
   savedialog1.filename:='';
   savedialog1.DefaultExt:='';
   savedialog1.Filter:='*.*|*.*';
   if savedialog1.Execute then
      sl.savetofile(savedialog1.filename);
   sl.free;
   end;

end;     //save sequences list

procedure TfrmMain.Exportconsensussequence1Click(Sender: TObject);
begin
dynform:=tfrmResults.Create(application);
dynform.caption:='Multiple alignment consensus sequence';
dynform.rxresults.clear;

dynform.rxresults.lines.add('Consensus with '+edHomol.Text+'% homology');
dynform.rxresults.lines.add(pAl(tv.Selected.Data)^.consensus);
dynform.show;
end;

procedure TfrmMain.ExportFeaturesClick(Sender: TObject);
var i,j:integer;
    sl,sl2:tstringlist;
    s:string;
begin
if not select_oligo_seq(c_sequence,'Select sequences') then
   exit;
sl:=tstringlist.Create;
sl2:=tstringlist.Create;
sl2.Add('AnnHyb - Sequence''s annotations'+'  '+date_time);
sl2.add(''); sl2.add('');
for j:=0 to tv.Items.count-1 do
    if (tv.Items[j].imageindex=c_sequence) and (pos('**'+ansiuppercase(pSq(tv.items[j].data)^.name)+'**',seqListe)<>0) then
        begin
//        showmessage(pSq(tv.items[j].data)^.features);
        sl2.add(''); sl2.add('');
        sl2.add('Sequence''s name: '+pSq(tv.items[j].data)^.name);
        sl2.add(fs('Name',30)+fs('start',10)+fs('End',10)+'Comment');
        sl2.add(dupestring('-',30+10+10+30));
        sl.Text:=pSq(tv.items[j].data)^.features;
        if sl.count>0 then
            for i:=0 to sl.Count-1 do
                begin
                s:='';
                s:=fs(featuresExtr(sl[i]).name,30)+
                fs(inttostr(featuresExtr(sl[i]).f_init),10)+
                fs(inttostr(featuresExtr(sl[i]).f_end),10);
                if pos('///',sl[i])<>0 then
                   s:=s+copy(sl[i],pos('///',sl[i])+3,maxint);
                sl2.add(s);
                end
        else
             sl2.add('No annotations');
        end;

savedialog1.title:='Save sequence annotations';
savedialog1.filename:='';
savedialog1.DefaultExt:='';
savedialog1.Filter:='*.*|*.*';
if savedialog1.Execute then
    sl2.savetofile(savedialog1.filename);

sl.Free;
sl2.free;
exit;
end;

procedure TfrmMain.FormResize(Sender: TObject);
begin
if (not flagClose) and (pc.activepage=tabMA) then
   begin
   sbh.Left:=re.Left+2;
   affiche_al;
   end;
end;

procedure TfrmMain.split_maMoved(Sender: TObject);
begin
edConsensus.Left:=re.Left;
affiche_al;
edConsensus.Width:=re.Width-15;
end;

procedure quicksearchOligoInMA(nma:integer);
var poseq,postrouve,countMA,nbOligoTrouve,j,t,k:integer;
    tt,compt:byte;
    soligo,nameseq:shortstring;
    seqg:string;
    save_cursor:tcursor;
label suite;

begin   //quicksearchprimers
save_cursor:=screen.Cursor;
screen.Cursor:=crHourGlass;
flagstop:=false;
nbOligoTrouve:=0;

with frmMain do
   begin
   //compte nbre oligo et MA

   flagselect:=false;
   //quicksearch

    //clear previous results
    for t:=0 to tv.Items.count-1 do
       if (tv.Items[t].imageindex=c_al) and (pos('**'+ansiuppercase(pAl(tv.items[t].data)^.name+'**'),seqListe)<>0) then
          for k:=0 to pAl(tv.items[t].Data)^.namel.count-1 do
              pAl(tv.items[t].data)^.found[k]:='';

   frmProgress.caption:='Searching oligo...';
   frmProgress.progressbar1.Position:=0;
   frmProgress.Show;

   for t:=0 to tv.Items.count-1 do
       if tv.Items[t].imageindex=c_oligo then
          if pto(tv.items[t].data)^.view<>0 then
             begin
             frmprogress.label1.Caption:=pto(tv.items[t].data)^.name;
//             pto(tv.items[t].data)^.found:='';
             for tt:=1 to 2 do      //sense et antisense
                 begin
                 //clean oligo
                 if tt=1 then
                    soligo:=format_iupac(pto(tv.items[t].data)^.seq,false)
                 else
                    soligo:=revcompseq(pto(tv.items[t].data)^.seq);
                 if (soligo='') or (length(soligo)<5) then //oligo trop court
                    continue;
                 countMA:=0;
                 for j:=0 to tv.Items.count-1 do
                     if (tv.Items[j].imageindex=c_al)
                        and (pos('**'+ansiuppercase(pAl(tv.items[j].data)^.name+'**'),seqListe)<>0) then //MA
                        begin
                        inc(countMA);
                        frmProgress.progressbar1.Position:=round(countMA/nMA)*100;

                        for k:=0 to pAl(tv.items[j].Data)^.seql.count-1 do  //each seq in multiple align
                            begin
                            seqg:=pAl(tv.items[j].data)^.seql[k];
                            nameseq:=pAl(tv.items[j].data)^.namel[k];
                            //recherche rapide avec POS
                            poseq:=1;
                            compt:=length(soligo);
                            repeat
                               if pos(soligo,copy(seqg,poseq,maxint-1))<>0 then
                                   begin
                                   inc(nbOligoTrouve);
                                   postrouve:=poseq+pos(soligo,copy(seqg,poseq,maxint))-1;

                                   pAl(tv.items[j].data)^.found[k]:=pAl(tv.items[j].data)^.found[k]+'0'
                                                                    +nameseq+'|'
                                                                    +copy('+-',tt,1)+'|'
                                                                    +inttostr(postrouve)+'|'
                                                                    +inttostr(postrouve+length(soligo)-1)+'|'
                                                                    +'100'+'|'
                                                                    +inttostr(pto(tv.items[t].data)^.view)+'|' //color
                                                                    +soligo+'|'

                                                                    //+soligo+'|';
                                                                    +copy(seqg,postrouve,length(soligo))+'|';

                           (*        frmResults.rxresults.lines.add('Multi-alignment: '+pAl(tv.items[j].data)^.name
                                                                  +#9+'  Sequence name: '+nameseq
                                                                  +#9+'  Sense: '+copy('+-',tt,1)
                                                                  +#9+'  Position: '+inttostr(postrouve)+' - '+inttostr(postrouve+length(soligo)-1));
*)
                                   //remplit champ FOUND_ma de l'oligo
                                   pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma+
                                                                  stringreplace(pAl(tv.items[j].data)^.found[k],'',LF,[]);
(*
                                   pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma
                                                                 +'0'+pAl(tv.items[j].data)^.name+'|';  //nom seq
                                   if tt=2 then
                                       pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma+'-'+'|'  //seq rev
                                   else
                                       pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma+'+'+'|'; //seq sense
                                   pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma
                                                                 +inttostr(postrouve)+'|'  //position seq2 sur seq1
                                                                 +inttostr(postrouve+length(soligo)-1)+'|'   //fin seq2 sur seq1
                                                                 +'100|' //score
                                                                 +inttostr(pto(tv.items[t].data)^.view)+'|'    //color
                                                                 +soligo+'|'  //aligned oligo
                                                                 +copy(seqg,postrouve,length(soligo))  //aligned target
                                                                 +'|'+LF;                                  //seq2
*)
//                                   frmResults.rxresults.text:=pAl(frmMain.tv.items[j].data)^.found.text;
                                   poseq:=postrouve+1;
                                   end;
                            until pos(soligo,copy(seqg,poseq,maxint-1))=0;
 //                           showmessage(pAl(tv.items[j].data)^.found[k]);
                            end; //kk
                        end;
                    end; //for tt
                end;
   frmProgress.hide;
   end; //with frmMain

suite:
flagselect:=true;
screen.Cursor:=save_cursor;
//frmResults.showmodal;
end; //quicksearchOligoInMA

procedure TfrmMain.Quicksearcholigoinmultialignment2Click(Sender: TObject);
var noligo,nMA,t:integer;
begin
noligo:=0;
nMA:=0;
for t:=0 to tv.Items.Count-1 do
    begin
    if tv.Items[t].imageindex=c_oligo then
       if pto(tv.items[t].data)^.view<>0 then
          inc(noligo);
    if tv.Items[t].imageindex=c_al then //MA
       inc(nMA);
    end;
//no oligo to align
if noligo=0 then
    begin
    showmessage('No oligonucleotide to search!');
    exit;
    end;
if not select_oligo_seq(c_al,'Select multiple alignment in which quick search oligo') then
   exit;
quicksearchOligoInMA(nMA);

if tv.selected.imageindex=c_oligo then //oligo
   affiche_align_results(pto(tv.selected.data)^.found_ma);

end;

procedure align_Oligo_in_MA(nMA:integer);
var countMA:integer;
    tt:byte;
    soligo,nameseq:shortstring;
    s_sense,s_antisense:string;
    nbOligoTrouve,j,t,k:integer;
    seqg:string;
    fasta_sl:tstringlist;
    score1,score2:double;

label suite;

begin   //align_primers_in_MA
save_cursor:=screen.Cursor;
screen.Cursor:=crHourGlass;
flagstop:=false;
nbOligoTrouve:=0;

with frmMain do
    begin
    flagselect:=false;

    //clear previous results
    for t:=0 to tv.Items.count-1 do
       if (tv.Items[t].imageindex=c_al) and (pos('**'+ansiuppercase(pAl(tv.items[t].data)^.name+'**'),seqListe)<>0) then
          for k:=0 to pAl(tv.items[t].Data)^.namel.count-1 do
              pAl(tv.items[t].data)^.found[k]:='';


    for t:=0 to tv.Items.count-1 do
       if tv.Items[t].imageindex=c_oligo then
          if pto(tv.items[t].data)^.view<>0 then //oligo to align
             if length(format_iupac(pto(tv.items[t].data)^.seq,false))<4 then //oligo too short
                begin
                showmessage(pto(tv.items[t].data)^.name+' is too short! Minimal length: 4 nt');
                continue;
                end
             else
                begin  //oligo to align OK
//                frmprogress.label1.Caption:=pto(tv.items[t].data)^.name;
                countMA:=0;
                for j:=0 to tv.Items.count-1 do
                     if (tv.Items[j].imageindex=c_al) and (pos('**'+ansiuppercase(pAl(tv.items[j].data)^.name+'**'),seqListe)<>0) then //seq
                        begin
                        inc(countMA);
 //                       frmProgress.progressbar1.Position:=round(countMA/nMA)*100;
                        for k:=0 to pAl(tv.items[j].Data)^.namel.count-1 do
                            begin
                            for tt:=1 to 2 do      //sense et antisense
                                 begin
                                 //clean oligo
                                 if tt=1 then
                                     soligo:=format_iupac(pto(tv.items[t].data)^.seq,false)
                                 else
                                     soligo:=revcompseq(pto(tv.items[t].data)^.seq);
                                 if tt=1 then //sense
                                     s3:='';

                                 if tt=1 then
                                    begin
                                    s_sense:='';
                                    s_antisense:='';
                                    end;


                                 nameseq:=pAl(tv.items[j].data)^.namel[k];
                                 seqg:=pAl(tv.items[j].data)^.seql[k];

                                 while pos('-',seqg)<>0 do
                                     delete(seqg,pos('-',seqg),1);

                                 fasta_sl:=tstringlist.create;
                                 fasta_sl.Clear;
                                 loc_al(seqg,soligo,fasta_sl);
                                 if strtoint(fasta_sl[0])<>0 then
                                     begin
                                     //ajoute pos a champ FOUND de l'oligo
                                     repeat
                                         if tt=1 then //sense
                                             s_sense:=s_sense+'0'
                                                                        +nameseq+'|+|'
                                                                        +fasta_sl[0]+'|'
                                                                        +inttostr(strtoint(fasta_sl[0])+length(soligo)-1)+'|'
                                                                        +floattostr2(roundto(strtofloat2(fasta_sl[1]),-1))+'|'
                                                                        +inttostr(pto(tv.items[t].data)^.view)+'|' //color
                                                                        +fasta_sl[2]+'|'
                                                                        +fasta_sl[3]+'|';

                                         if tt=2 then
                                             s_antisense:=s_antisense+'0'
                                                                        +nameseq+'|-|'
                                                                        +fasta_sl[0]+'|'
                                                                        +inttostr(strtoint(fasta_sl[0])+length(soligo)-1)+'|'
                                                                        +floattostr2(roundto(strtofloat2(fasta_sl[1]),-1))+'|'
                                                                        +inttostr(pto(tv.items[t].data)^.view)+'|' //color
                                                                        +fasta_sl[2]+'|'
                                                                        +fasta_sl[3]+'|';

(*                                       s3:=s3+'0'
                                                                        +nameseq+'|'
                                                                        +copy('+-',tt,1)+'|'
                                                                        +fasta_sl[0]+'|'
                                                                        +inttostr(strtoint(fasta_sl[0])+length(soligo)-1)+'|'
                                                                        +floattostr2(roundto(strtofloat2(fasta_sl[1]),-1))+'|'
                                                                        +inttostr(pto(tv.items[t].data)^.view)+'|' //color
                                                                        +fasta_sl[2]+'|'
                                                                        +fasta_sl[3]+'|';
*)
                                         fasta_sl.Delete(0); //0  pos
                                         fasta_sl.Delete(0); //1  score
                                         fasta_sl.Delete(0); //2  seq courte
                                         fasta_sl.Delete(0); //3  seq longue
                                     until fasta_sl.count=0;
                                     end;
                                 fasta_sl.Free;
                                 end; //tt

                            extract_oligo(s_sense);
                            score1:=oligoF.score;
                            extract_oligo(s_antisense);
                            score2:=oligoF.score;
                            if score1>=score2 then
                                pAl(tv.items[j].data)^.found[k]:=pAl(tv.items[j].data)^.found[k]+s_sense
                            else
                                pAl(tv.items[j].data)^.found[k]:=pAl(tv.items[j].data)^.found[k]+s_antisense;

                            //fill FOUND_ma oligo field
                            pto(tv.items[t].data)^.found_ma:=pto(tv.items[t].data)^.found_ma
                                                                 +stringreplace(pAl(tv.items[j].data)^.found[k],'',LF,[]);
                            end; //k

                        end; //j
             end; //view<>0
   end; //with frmMain

suite:
flagselect:=true;
screen.Cursor:=save_cursor;
end; //align_primers_in_MA


procedure TfrmMain.Alignoligoinmultialignment1Click(Sender: TObject);
var noligo,nMA,t:integer;
begin
//compte nbre oligo et seq
noligo:=0;
nMA:=0;
for t:=0 to tv.Items.Count-1 do
     begin
     if tv.Items[t].imageindex=c_oligo then
         if pto(tv.items[t].data)^.view<>0 then
            inc(noligo);
     if tv.Items[t].imageindex=c_al then //MA
        inc(nMA);
     end;
//no oligo to align
if noligo=0 then
    begin
    showmessage('No oligonucleotide to align!');
    exit;
    end;
if not select_oligo_seq(c_al,'Select multiple alignment in which align oligo') then
   exit;

align_Oligo_in_MA(nMA);

if tv.selected.imageindex=c_oligo then //oligo
   affiche_align_results(pto(tv.selected.data)^.found_ma);
end; //align oligo in ma

procedure TfrmMain.lvMAColumnClick(Sender: TObject; Column: TListColumn);
begin
ListMAColumnToSort:=Column.Index;
(Sender as TCustomListView).AlphaSort;
ListMAsortinc:=not ListMAsortinc;
end;

procedure TfrmMain.lvMACompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
begin
case ListMAColumnToSort of 0:Compare:=CompareText(Item1.Caption,Item2.Caption);
                           1,2:if strtoint(Item1.SubItems[ListMAColumnToSort-1])>strtoint(Item2.SubItems[ListMAColumnToSort-1]) then
                                   compare:=1
                                else if strtoint(Item1.SubItems[ListMAColumnToSort-1])<strtoint(Item2.SubItems[ListMAColumnToSort-1]) then
                                   compare:=-1
                                else
                                   compare:=0;
                           end;//case
if not ListMASortInc then
   compare:=-compare;
end;

procedure TfrmMain.tvEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
allowedit:=false;
if node.imageindex=c_oligo then
   begin
   ed_oligo_name.selectall;
   ed_oligo_name.setfocus;
   end;
if node.imageindex=c_sequence then
   begin
   ed_seq_name.selectall;
   ed_seq_name.setfocus;
   end;
if node.imageindex=c_al then
   begin
   ed_ma_name.selectall;
   ed_ma_name.setfocus;
   end;

end;

procedure TfrmMain.tvEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
if node.imageindex=c_al then
   pAl(tv.selected.Data)^.name:=s;
end;

function consensus(ma:T_al;p_hom:extended):string;  //determination of MA consensus considerating homology %
const maxchar=21;
var i,j,ns,longseq:integer;
    max:extended;
    q,b:byte;
    deg,degmax:char;
    n:array[1..maxchar] of integer;
    cs:string;
    s:string;
begin
cs:='';
longseq:=length(ma.seql[0]);
//replace initial and final gaps by =
for i:=0 to ma.seql.Count-1 do
    begin
    s:=ma.seql[i]; //malign[i];
    for j:=1 to length(s) do
        begin
        if s[j]<>'-' then
            break;
        if s[j]='-' then
            s[j]:='=';
        end;
    for j:=length(s) downto 1 do
        begin
        if s[j]<>'-' then
            break;
        if s[j]='-' then
            s[j]:='=';
        end;
    ma.seql[i]:=s; //malign[i]:=s;
    end;
for j:=1 to longseq do
    begin
    for q:=1 to 4 do //nb dgnrations
        begin
        max:=0;
        for b:=1 to length(iupac) do
            begin
            deg:=iupac[b];
            if length(code[ord(deg)-64])<>q then
                continue;
            for i:=0 to maxchar do
                n[i]:=0;
            i:=0;
            ns:=0;
            repeat
                      if ma.seql[i][j]<>'=' then
                         inc(ns);
                      if (pos(ma.seql[i][j],code[ord(deg)-64])<>0) then
                         inc(n[b]);
                      inc(i);
            until i>=ma.seql.Count;
            if n[b]/ns*100>max then
                      begin
                      max:=n[b]/ns*100;
                      degmax:=deg;
                      end;
            end;
        if max>=p_hom then
            break;
        end;
    //gap
    for i:=0 to maxchar do
        n[i]:=0;
    i:=0;
    ns:=0;
    repeat
         if ma.seql[i][j]<>'=' then
             inc(ns);
         if ma.seql[i][j]='-' then
             inc(n[b]);
         inc(i);
    until i>=ma.seql.Count;
    if n[b]/ns*100>max then
        begin
        max:=n[b]/ns*100;
        degmax:='-';
        end;
    cs:=cs+degmax; //cration sq. consensus
    end;
consensus:=cs;
end;//consensus

procedure TfrmMain.mi_cleanMAClick(Sender: TObject);
var ma:T_al;
    p_hom:extended;
    i,j,long,k,kk,ncons,longseq:integer;
    flagaa:boolean;
    strhomol,rule,ntpos:string;
    cs,s:string;
    compt:array of integer;
    memcursor:tcursor;

label 1;
begin
if (tv.selected=nil) or (tv.selected.imageindex<>c_al) then
   begin
   showmessage('Select a multiple alignment!');
   exit;
   end;
with frmMultiAlignCleaner do
   begin
   frmMultiAlignCleaner.list_seq.clear;
   for i:=0 to pAl(tv.selected.Data)^.namel.Count-1 do
       frmMultiAlignCleaner.list_seq.items.add(ansiuppercase(pAl(tv.selected.Data)^.namel[i]));
   1:

   frmMultiAlignCleaner.ShowModal;
   if frmMultiAlignCleaner.modalresult=mrCancel then
      exit;

   if (rb_choose_seq.checked) and (list_seq.Items.IndexOf(ansiuppercase(list_seq.text))=-1) then
      begin
      showmessage('The reference sequence was not found in multiple alignment!');
      goto 1;
      end
   else
      list_seq.itemindex:=list_seq.Items.IndexOf(ansiuppercase(list_seq.text));

   if rb_m_consensus.checked then
       begin
       ncons:=0;
       p_hom:=0;
       try
         p_hom:=strtofloat2(homol_pc.text);
       except
       end;
       if (p_hom<=0) or (p_hom>100) then
          begin
          showmessage('The homology value for the consensus sequence must be between 0 and 100%');
          goto 1;
          end;
       end
   else
       ncons:=list_seq.itemindex+1;

   ma.namel:=tstringlist.create;
   ma.seql:=tstringlist.create;

   ma:=pAl(tv.selected.Data)^;

   long:=strtoint(ed_oll.Text);

   memcursor:=screen.cursor;
   screen.cursor:=crHourGlass;

   flagaa:=false; //nucl seq.
   dynform:=tfrmResults.Create(application);
   dynform.caption:='Multiple alignment cleaner';
   dynform.rxresults.clear;

   strhomol:=FloatToStrF(p_hom,ffgeneral,3,1);

   strhomol:=stringreplace(strhomol,',','.',[rfReplaceAll, rfIgnoreCase]);

   if ncons=0 then //no choosen sequence
       begin
       dynform.rxresults.lines.add('Consensus with '+strhomol+'% homology');
       dynform.rxresults.lines.add('****');
       end;

   longseq:=length(ma.seql[0]);

   cs:='';
   if ncons<>0 then
      cs:=ma.seql[ncons-1] //reference sequence
   else  //calcul consensus
      begin
      cs:=consensus(ma,p_hom);
      end;

   //results
   for i:=1 to long do   //complete ref seq with spaces
       cs:=cs+' ';

   //init counter
   if cbIncludePosition.Checked then
      begin
      setlength(compt,ma.seql.Count);
      for i:=0 to ma.seql.Count-1 do
          compt[i]:=0;
      end;

   for k:=1 to (longseq div long)+1-byte(longseq div long=longseq/long) do
        begin
        if ncons<>0 then
            s:=ma.namel[ncons-1] //ref seq name
        else
            s:='Consensus ';
        while length(s)<16 do  //complete until l=16
            s:=s+' ';

        //rule and nt position
        if cbIncludeRules.Checked then
           begin
           rule:=dupestring(' ',16);
           ntpos:=dupestring(' ',16);
           for j:=1+(k-1)*long to 1+(k-1)*long+long-1 do
               begin
               if j>longseq then
                  break;
               if j mod 10=0 then
                  begin
                  rule:=rule+'|';
                  while length(ntpos)<length(rule)-length(inttostr(j)) do
                      ntpos:=ntpos+' ';
                  ntpos:=ntpos+inttostr(j);
                  end
               else
                  rule:=rule+'-';
               end;
           dynform.rxresults.lines.add(ntpos);
           dynform.rxresults.lines.add(rule);

           end;
        //print ref seq or consensus seq
        if cbIncludePosition.Checked then
           begin
           for j:=1+(k-1)*long to 1+(k-1)*long+long-1 do
               if cs[j] in validbase then
                  inc(compt[0]);
           dynform.rxresults.lines.add(s+trim(copy(cs,1+(k-1)*long,long))+' '+inttostr(compt[0]));
           end
        else
           dynform.rxresults.lines.add(s+trim(copy(cs,1+(k-1)*long,long)));
        i:=0;
        repeat
           if i<>ncons-1 then  //saute seq
               begin
               s:=ma.namel[i];  //seq name
               while length(s)<16 do  //complete until l=16
                  s:=s+' ';
               for j:=1+(k-1)*long to 1+(k-1)*long+long-1 do
                   begin
                   if j>longseq then
                      break;
                   if (cs[j]='-') and (ma.seql[i][j]='-') then
                      s:=s+'-'
                   else if ma.seql[i][j]=cs[j] then
                      begin
                      s:=s+'.';
                      if cbIncludePosition.Checked then
                         compt[i]:=compt[i]+1;
                      end
                   else
                      begin
                      s:=s+ma.seql[i][j];
                      if cbIncludePosition.Checked then
                         if ma.seql[i][j]<>'-' then
                            compt[i]:=compt[i]+1;
                      end;
                   //ma.seql[i][j]:=s[length(s)];  /////////
                   end;
               while pos('=',s)<>0 do
                   s[pos('=',s)]:='-';
               if cbIncludePosition.Checked then
                  begin
                  dynform.rxresults.lines.add(s+' '+inttostr(compt[i]));
                  end
               else
                  dynform.rxresults.lines.add(s);
               end;
           inc(i);
        until i>=ma.seql.count;
        if cbIncludeRules.Checked then
           begin
           dynform.rxresults.lines.add(rule);
           dynform.rxresults.lines.add(ntpos);
           end;
        dynform.rxresults.lines.add('****');    //ligne vide
        dynform.rxresults.lines.add('****');    //ligne vide
        end; //k

   if cbIncludePosition.Checked then
       compt:=nil;
   end; //with

RX_BUG(dynform);

screen.cursor:=memcursor;
dynform.show;
//dynform.Free;
pAl(tv.selected.Data)^:=ma;
end;

procedure TfrmMain.Removesequence1Click(Sender: TObject);
begin
(*
if (not reName.focused) or (sendmessage(reName.Handle,em_linefromchar,reName.selstart,0)>=pAl(tv.selected.data)^.namel.count) then
   begin
   showmessage('Select a sequence in the name panel!');
   exit;
   end;

if MessageDlg('Are you sure you want to remove '+pAl(tv.selected.data)^.namel[sendmessage(reName.Handle,em_linefromchar,reName.selstart,0)]+' from the multi-alignment?',mtWarning,[mbYes,mbNo],0)=mrNo then
   exit;
pAl(tv.selected.data)^.namel.delete(sendmessage(reName.Handle,em_linefromchar,reName.selstart,0));
pAl(tv.selected.data)^.seql.delete(sendmessage(reName.Handle,em_linefromchar,reName.selstart,0));
affiche_al;
*)
end; //remove seq from MA

procedure TfrmMain.rxgcgseqMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
//popup menu activation due to a bug in RXRichEdit component
if button=mbRight then
   begin
   getcursorpos(pt);
   pmGCG.Popup(pt.x,pt.y);
   end;
end;

procedure TfrmMain.reNameMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
//popup menu activation due to a bug in RXRichEdit component
if button=mbRight then
   begin
   getcursorpos(pt);
   pm_reName.Popup(pt.x,pt.y);
   end;
end;

procedure TfrmMain.ed_seq_nameKeyPress(Sender: TObject; var Key: Char);
begin
if key='|' then
   begin
   showmessage('Character | (pipe) is not allowed!');
   key:=#0
   end;
end;

procedure TfrmMain.Panel2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
//panel3.BeginDrag(true,10);
end;

procedure TfrmMain.panel_oligolistMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
panel_oligolist.BeginDrag(true,10);
end;

procedure TfrmMain.mi_Clearhighlightedregions1Click(Sender: TObject);
var t:integer;
begin
if (tv.selected=nil) or (tv.Selected.imageindex<>c_al) then
    begin
    showmessage('Select a multiple alignment!');
    exit;
    end;
for t:=0 to pAl(tv.Selected.Data)^.namel.count-1 do
     pAl(tv.Selected.Data)^.found[t]:='';
affiche_al;
end;

procedure TfrmMain.mi_CheckAllOligoClick(Sender: TObject);
var t:integer;
begin
for t:=0 to lv_oligo.Items.Count-1 do
    begin
    lv_oligo.Items[t].Checked:=(sender=mi_CheckAllOligo);
    lv_oligoClick(self);
    end;
end;

procedure TfrmMain.mi_InverseOligoCheckingClick(Sender: TObject);
var t:integer;
begin
for t:=0 to lv_oligo.Items.Count-1 do
    begin
    lv_oligo.Items[t].Checked:=not lv_oligo.Items[t].Checked;
    lv_oligoClick(self);
    end;
end;

procedure TfrmMain.mi_RemoveFeaturesFromAllSequencesClick(Sender: TObject);
var t:integer;
begin
if MessageDlg('Remove all sequences annotations?',mtConfirmation,[mbYes,mbNo],0)=mrNo then
   exit;
for t:=0 to tv.Items.Count-1 do
    begin
    if tv.items[t].imageindex=c_sequence then
        pSq(tv.Items[t].Data)^.features:='';
    end;
if (tv.selected<>nil) and (tv.selected.imageindex=c_sequence) then
   begin
   affiche_features_list;
   affiche_features;
   end;
fwsc('all featureannotations deleted');
end;

procedure TfrmMain.mi_RemoveFeaturesFromSelectedSequenceClick(
  Sender: TObject);
begin
if (tv.selected<>nil) and (tv.Selected.imageindex=c_sequence) then
   begin
   if MessageDlg('Delete annotations from '+tv.Selected.text+' ?',mtConfirmation,[mbYes, mbNo],0)=mrNo then
      exit;
   pSq(tv.selected.Data)^.features:='';
   affiche_features_list;
   affiche_features;
   end
else
   showmessage('Select a sequence first!');
end;

procedure TfrmMain.ed_ma_nameChange(Sender: TObject);
var i:integer;
begin
if not ed_ma_name.Focused then
    exit;
flag_nom_deja_utilise:=false;
for i:=0 to tv.Items.Count-1 do
    if (tv.Items[i]<>tv.selected) and (tv.Items[i].imageindex=c_al)
     and (ansiuppercase(ed_ma_name.text)=ansiuppercase(tv.Items[i].text)) then
       begin
       flag_nom_deja_utilise:=true;
       exit;
       end;
end;

procedure TfrmMain.Editsequenceattributes1Click(Sender: TObject);
begin
frmMain.mi_EditSequenceAttributesClick(self);
end;

procedure TfrmMain.tvMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var node:TTreeNode;
begin
if button=mbRight then
   begin
   node:=tv.GetNodeAt(x,y);
   if node=nil then
      exit;
   tv.selected:=node;
   getcursorpos(pt);
   pm_tv.Popup(pt.x,pt.y);
   end;
end;


procedure TfrmMain.mo_ViewAllAlignmentsClick(Sender: TObject);
var i:integer;
begin
if lvAlign.items.count=0 then
   exit;
dynform:=tfrmResults.Create(application);
dynform.rxresults.clear;

for i:=0 to lvAlign.items.count-1 do
    begin
    view_alignment(lvAlign.items[i],dynform);

    dynform.rxresults.lines.add('****');
    dynform.rxresults.lines.add('****');
    end; //for i

RX_BUG(dynform);
dynform.caption:='Alignments';
dynform.show;
end;

procedure TfrmMain.mo_webClick(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(annhyb_site),Nil,Nil,SW_NORMAL);
end;

procedure TfrmMain.lv_oligoClick(Sender: TObject);
var i,compt:integer;
begin
compt:=0;
for i:=0 to lv_oligo.Items.Count-1 do
    begin
    if lv_oligo.Items[i].Checked then
       begin
       inc(compt);
       pTo(tv.Items[i+1].Data)^.view:=color_oligo(compt);
       lv_oligo.Items[i].imageindex:=rev_col(pTo(tv.Items[i+1].Data)^.view);
       end
    else //checked=false
       begin
       pTo(tv.Items[i+1].Data)^.view:=0;
       lv_oligo.Items[i].imageindex:=-1;
       end;
    end;
end;

procedure TfrmMain.sbClick(Sender: TObject);
var i:integer;
    s:string;
begin
if flag then
   begin
   sb.Down:=false;
   flag:=false;
   exit;
   end;
s:='';
for i:=ComponentCount-1 downto 0 do
    begin
    if Components[I] is TEdit then
       if (components[i] as TEdit).Focused then
          s:=(components[i] as TEdit).seltext;
    if Components[I] is TMemo then
       if (components[i] as TMemo).Focused then
          s:=(components[i] as TMemo).seltext;
    if Components[I] is TRXRichEdit then
       if (components[i] as TRXRichEdit).Focused then
          s:=clearseq((components[i] as TRXRichEdit).seltext);
    end;

if s='' then
   begin
   showmessage('Select a sequence to read!');
   sb.Down:=false;
   exit;
   end;


flag:=true;
sb.Down:=true;

s:=ansiuppercase(s);
for i:=1 to length(s) do
    if s[i] in validbase then
       begin
       if not flag then
          begin
          exit;
          end;

       playsound(program_dir+s[i]+'.wav');
       application.ProcessMessages;
       end;
flag:=false;
sb.Down:=false;
end;

procedure TfrmMain.SpeedButton1Click(Sender: TObject);
begin
if not flag_show_oligoNotes then
   frmOligoNotes.show
else
   frmOligoNotes.hide;
flag_show_oligoNotes:=not flag_show_oligoNotes;
end;

procedure TfrmMain.mi_ProjectinformationClick(Sender: TObject);
begin
frmProjectDescription.lbProjectFileName.caption:=workspacename;
frmProjectDescription.showmodal;
end;

procedure TfrmMain.mi_InsertSeqClick(Sender: TObject);
var pos1,i,mem_selstart:integer;
    flagoligo:boolean;
    s,s2:string;
begin
if MessageDlg('All sequence''s annotations and oligo search will be erased!'+crlf+'Are you sure to paste into this the sequence?',mtWarning,[mbYes,mbCancel],0)=mrCancel then
   exit;

mem_selstart:=rxgcgseq.selstart;
if clearseq(rxgcgseq.seltext)<>'' then //selected seq
    mi_DeleteSeqClick(application); //delete selected seq before pasting
if clipboard.HasFormat(cf_text) then
    begin
    flagoligo:=true;
    s:='';
    for i:=1 to length(Clipboard.AsText) do
        if upcase(Clipboard.AsText[i]) in validbase+[' '] then
            begin
            if upcase(Clipboard.AsText[i]) in validbase then
                s:=s+Clipboard.AsText[i];
            end
        else
            begin
            flagoligo:=false;
            break;
            end;
     if not flagoligo then
         begin
         showmessage('The clipboard do not contain only nucleotides!');
         exit;
         end;
    //delete seq features
    pSq(tv.Selected.Data)^.features:='';
    //delete all alignes oligo
    clear_oligo_search(pSq(tv.Selected.Data)^.name);

    pos1:=xytopos(postoxy(Rxgcgseq.selstart).x,postoxy(Rxgcgseq.selstart).y);

    s2:=pSq(tv.Selected.Data)^.seq;
    insert(s,s2,pos1);
    pSq(tv.Selected.Data)^.seq:=s2;
    s2:='';

    pSq(tv.Selected.Data)^.seqrtf:=pSq(tv.Selected.Data)^.seq;
    format_gcg(pSq(tv.Selected.Data)^.seqrtf,1);
    rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
    affiche_header;
    affiche_features;
    rxgcgseq.selstart:=mem_selstart;
    end;
end;

procedure TfrmMain.mi_DeleteSeqClick(Sender: TObject);
var pos1,pos2,mem_selstart:integer;
begin
if MessageDlg('All sequence''s annotations and oligo search will be erased!'+crlf+'Are you sure to delete the selected sequence?',mtWarning,[mbYes,mbCancel],0)=mrCancel then
   exit;
//delete seq features
pSq(tv.Selected.Data)^.features:='';
//delete all alignes oligo
clear_oligo_search(pSq(tv.Selected.Data)^.name);

mem_selstart:=rxgcgseq.selstart;
pos1:=xytopos(postoxy(Rxgcgseq.selstart).x,postoxy(Rxgcgseq.selstart).y);
pos2:=xytopos(postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).x,postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).y)-1;
if pos1>pos2 then
   begin
   showmessage('Select a sequence!');
   exit;
   end;
delete(pSq(tv.Selected.Data)^.seq,pos1,pos2-pos1+1);
pSq(tv.Selected.Data)^.seqrtf:=pSq(tv.Selected.Data)^.seq;
format_gcg(pSq(tv.Selected.Data)^.seqrtf,1);
rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
affiche_header;
affiche_features;
rxgcgseq.selstart:=mem_selstart;
end;

procedure TfrmMain.tvDblClick(Sender: TObject);
begin
if tv.Selected.imageindex=c_sequence then
   mi_EditSequenceClick(self);
end;

procedure TfrmMain.mi_cropSeqClick(Sender: TObject);
var pos1,pos2:integer;
begin
if MessageDlg('All sequence''s annotations and oligo search will be erased!'+crlf+'Are you sure to crop the sequence?',mtWarning,[mbYes,mbCancel],0)=mrCancel then
   exit;
//delete seq features
pSq(tv.Selected.Data)^.features:='';
//delete all alignes oligo
clear_oligo_search(pSq(tv.Selected.Data)^.name);

pos1:=xytopos(postoxy(Rxgcgseq.selstart).x,postoxy(Rxgcgseq.selstart).y);
pos2:=xytopos(postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).x,postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).y)-1;
if pos1>pos2 then
   begin
   showmessage('Select a sequence!');
   exit;
   end;

delete(pSq(tv.Selected.Data)^.seq,pos2+1,length(pSq(tv.Selected.Data)^.seq));
delete(pSq(tv.Selected.Data)^.seq,1,pos1-1);
pSq(tv.Selected.Data)^.seqrtf:=pSq(tv.Selected.Data)^.seq;
format_gcg(pSq(tv.Selected.Data)^.seqrtf,1);
rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
affiche_header;
affiche_features;
end;

procedure TfrmMain.ed_oligo_nameKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
tv.Selected.text:=ed_oligo_name.Text;
end;

procedure TfrmMain.ed_seq_nameKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
tv.Selected.text:=ed_seq_name.Text;
end;

procedure TfrmMain.ed_ma_nameKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
tv.Selected.text:=ed_ma_name.Text;
end;

procedure TfrmMain.Crop1Click(Sender: TObject);
begin
if TEdit(ActiveControl).seltext<>'' then
    (activecontrol as tedit).Text:=ansiuppercase(TEdit(ActiveControl).seltext);
end;

procedure TfrmMain.mi_RemoveMAClick(Sender: TObject);
var i:integer;
label lab1;
begin
if not select_oligo_seq(c_al,'Select multiple alignments to remove') then
   exit;
lab1:
for i:=0 to tv.Items.Count-1 do
   if (tv.items[i].imageindex=c_al) and (pos('**'+ansiuppercase(tv.Items[i].text)+'**',seqListe)<>0) then
       begin
       clear_oligo_search(pSq(tv.Items[i].data)^.name);
       tv.Items[i].Delete;
       goto lab1;
       end;
nb_align:=frmMain.numMA;
liste_ma;
for i:=0 to tv.items.count-1 do
    if tv.items[i].text='Multiple alignment' then
       break;

tv.Select(tv.Items[i]);
fwsc('removed MA');
end;  //remove MA(s)


procedure TfrmMain.mi_ConsensusClick(Sender: TObject);
begin
mi_consensus.checked:=not mi_consensus.checked;
if not mi_consensus.checked then
    begin
    edConsensus.Text:='';
    pn_ma_info.Height:=26;   //panel containing MA info
    end
else
    begin
    edConsensus.Text:=' '+copy(pAl(tv.Selected.Data)^.consensus,sbh.Position,round(re.Width/re.Font.size));
    pn_ma_info.Height:=57;   //panel containing MA info
    end;
lbHomol.Visible:=mi_consensus.checked;
edHomol.Visible:=mi_consensus.checked;
label4.Visible:=mi_consensus.checked;
affiche_al;
end;

procedure TfrmMain.edHomolKeyPress(Sender: TObject; var Key: Char);
begin
if key=#13 then
    begin
    pAl(tv.Selected.Data)^.consensus:=consensus(pAl(tv.Selected.Data)^,strtofloat(edHomol.text));
    affiche_al;
    end;

if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TfrmMain.edHomolExit(Sender: TObject);
begin
pAl(tv.Selected.Data)^.consensus:=consensus(pAl(tv.Selected.Data)^,strtofloat(edHomol.text));
affiche_al;
end;

procedure TfrmMain.Removesequencesfrommultialignment1Click(
  Sender: TObject);
var i:integer;
begin
with frmMAedit do
    begin
    clbMASeq.clear;
   for i:=0 to pAl(tv.selected.Data)^.namel.Count-1 do
       clbMASeq.items.add(ansiuppercase(pAl(tv.selected.Data)^.namel[i]));
    showmodal;
    if modalresult=mrCancel then
        exit;
    for i:=clbMASeq.Items.Count-1 downto 0 do
        if clbMASeq.checked[i] then
            begin
            pAl(tv.selected.data)^.namel.delete(i);
            pAl(tv.selected.data)^.seql.delete(i);
            end;
    affiche_al;
    end;
end;

procedure TfrmMain.ConvertselectedsequencetpUPPERcase1Click(Sender: TObject);
var pos1,pos2,mem_selstart,mem_sellength:integer;
    s:string;
begin
mem_selstart:=rxgcgseq.selstart;
mem_sellength:=rxgcgseq.sellength;

if rxgcgseq.sellength>0 then
    begin
    if MessageDlg('Convert only selected sequence?',mtConfirmation,[mbYes, mbNo],0)=mrNo then
       rxgcgseq.selectall;
    end
else
    rxgcgseq.selectall;

if (Sender as TMenuItem).tag=0 then    //upper
    s:=uppercase(clearseq(rxgcgseq.seltext))
else                                   //lower
    s:=lowercase(clearseq(rxgcgseq.seltext));
pos1:=xytopos(postoxy(Rxgcgseq.selstart).x,postoxy(Rxgcgseq.selstart).y);
pos2:=xytopos(postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).x,postoxy(Rxgcgseq.selstart+Rxgcgseq.sellength).y)-1;
pSq(tv.Selected.Data)^.seq:=copy(pSq(tv.Selected.Data)^.seq,1,pos1-1)
                            +s
                            +copy(pSq(tv.Selected.Data)^.seq,pos2+1,maxint);
pSq(tv.Selected.Data)^.seqrtf:=pSq(tv.Selected.Data)^.seq;
format_gcg(pSq(tv.Selected.Data)^.seqrtf,1);
rxgcgseq.Text:=pSq(tv.Selected.Data)^.seqrtf;
affiche_features;
rxgcgseq.selstart:=mem_selstart;
rxgcgseq.sellength:=mem_sellength;
end;

procedure TfrmMain.IdHTTP1Work(ASender: TObject; AWorkMode: TWorkMode;
  AWorkCount: Integer);
begin
application.ProcessMessages;
end;

procedure TfrmMain.lbTmAlgoDblClick(Sender: TObject);
begin
if lbTmAlgo.caption='Breslauer, 1986' then
    ShellExecute(0,Nil,PChar('http://www.pubmedcentral.gov/articlerender.fcgi?tool=pubmed&pubmedid=3459152'),Nil,Nil,SW_NORMAL);
if lbTmAlgo.caption='Allawi, 1997' then
    ShellExecute(0,Nil,PChar('http://www.pubmedcentral.gov/articlerender.fcgi?tool=pubmed&pubmedid=9465037'),Nil,Nil,SW_NORMAL);

end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
//showmessage(booltostr(ed_oligo_name.enabled));
end;

end.

