unit u_codon_usage;

interface
function codon_usage(seqname:shortstring;sl:string):string;

implementation
uses u_biotools, sysutils, dialogs;

function codon_usage(seqname:shortstring;sl:string):string;
var i, totcod: integer;
    compt: array[1..124] of cardinal;
    s,ss: shortstring;
    t: byte;
    r: string;

begin
sl := ansiuppercase(sl);

//init codon count
for i := 1 to 124 do
    compt[i]:=0;
totcod:=0;

for i:=1 to length(sl)-2 do
    begin
    if i mod 3 = 1 then  // only frame 1
        begin
        for t:=1 to 21 do
            if pos(sl[i] + sl[i+1] + sl[i+2], cg1[t])<>0 then
                begin
                inc(compt[ pos(sl[i], base) * 25 + pos(sl[i+1], base) *5 + pos(sl[i+2], base)]);
                //showmessage(inttostr( compt[ pos(sl[i], base) * 25 + pos(sl[i+1], base) + pos(sl[i+2], base)]));
                end;
        inc(totcod);
        end;
    end;

r:='Total codons: '+inttostr(totcod)+crlf+crlf;
for t:=1 to 21 do
    begin
    s := cg1[t];
    totcod:=0;
    r := r + crlf + cg2[t] + ' (' + cg3[t] + ')' + crlf + '-------' + crlf;
    s:=stringreplace(s,' ','',[rfReplaceAll]);
    while s<>'' do
       begin
       ss:=copy(s,1,3);
       delete(s,1,3);
       totcod := totcod + compt[pos(ss[1], base) * 25 + pos(ss[2], base) *5 + pos(ss[3], base)];
       r:=r + ss + '  ' + inttostr(compt[pos(ss[1], base) * 25 + pos(ss[2], base) * 5 + pos(ss[3], base)])+crlf;
       end;
    r:=r+'Total: '+inttostr(totcod)+crlf;
    end;
codon_usage:=r
end; //codon_usage
end.
