{unit3.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_dimerloop;

interface

uses shellapi,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst;

type
  TfrmDimerLoop = class(TForm)
    dimers: TMemo;
    Button1: TButton;
    label1: TLabel;
    Label2: TLabel;
    loops: TMemo;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Listoligo: TListBox;
    nom_oligo: TLabel;
    btSave: TButton;
    Button9: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ListoligoClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var frmDimerLoop: TfrmDimerLoop;
    a,b,c,s1,s3:string;
    posloop,i,j,compt,memcompt:cardinal;
    longa,longb:byte;

implementation

uses u_annhyb,u_biotools;

{$R *.DFM}


procedure dimer(s1,s2:string);
begin
frmDimerLoop.dimers.Clear;
while (s1[1]=' ') and (s2[1]=' ') do
      begin
      delete(s1,1,1);
      delete(s2,1,1);
      end;
s:='';
for j:=1 to length(s1) do
    if (s1[j]<>' ') and (rev_(s1[j])=upcase(s2[j])) then
       s:=s+'|'
    else
       s:=s+' ';

frmDimerLoop.dimers.lines.add(s1);
frmDimerLoop.dimers.lines.add(s);
frmDimerLoop.dimers.lines.add(s2);
end;


procedure maxdimer;
var i:cardinal;
begin
with frmDimerLoop do
   begin
memcompt:=0;
a:=trimleft(a);
for i:=1 to longa+longb do
    begin
    a:=' '+a;
    dimer(b,a);
    compt:=0;
    for j:=1 to length(dimers.lines[1]) do
        if dimers.lines[1][j]='|' then
           if dimers.lines[0][j] in ['C','G'] then
              compt:=compt+4
           else
              compt:=compt+2;
    if compt>memcompt then
       memcompt:=compt;
    end;
a:=trimleft(a);
for i:=1 to longa+longb do
    begin
    a:=' '+a;
    dimer(b,a);
    compt:=0;
    for j:=1 to length(dimers.lines[1]) do
        if dimers.lines[1][j]='|' then
           if dimers.lines[0][j] in ['C','G'] then
              compt:=compt+4
           else
              compt:=compt+2;
    if compt=memcompt then
       exit;
    end;
end; (*with*)
end;

procedure loop;
const esp:string='                                                                                                     ';
var j:integer;
begin
frmDimerLoop.loops.clear;
i:=posloop;
s1:=copy(c,1,i);
s2:='';
s3:='';
if i<length(c) then
   begin
   s:=copy(esp,1,i);
   s2:=s+c[i+1];
   if i<length(c)-1 then
      begin
      s3:=copy(c,i+2,100);
      s:='';
      for j:=length(s3) downto 1 do
          s:=s+s3[j];
      s3:=s;
      s3:=copy(esp,1,i-length(copy(c,i+2,100)))+s3;
      end;
   end;

if s1='' then
   s1:=esp;
if s2='' then
   s2:=esp;
if s3='' then
   s3:=esp;

for j:=1 to length(s2) do
    begin
    if (s1[j]<>' ') and (rev_(s1[j])=upcase(s3[j])) then
       s2[j]:='|';
    end;

while (s1[1]=' ') and (s2[1]=' ') and (s3[1]=' ') do
      begin
      delete(s1,1,1);
      delete(s2,1,1);
      delete(s3,1,1);
      end;
frmDimerLoop.loops.lines.add(s1);
frmDimerLoop.loops.lines.add(s2);
frmDimerLoop.loops.lines.add(s3);
end;


procedure maxloop;
var i,j:integer;
begin
with frmDimerLoop do
   begin
    memcompt:=0;

    posloop:=length(c);
    for i:=length(c) downto 1 do
      begin
      dec(posloop);
      loop;
      compt:=0;
      for j:=1 to length(frmDimerLoop.loops.lines[1]) do
          if frmDimerLoop.loops.lines[1][j]='|' then
             if frmDimerLoop.loops.lines[0][j] in ['C','G'] then
                compt:=compt+4
             else
                compt:=compt+2;
      if compt>memcompt then
         memcompt:=compt;
      end;

    posloop:=length(c);
    for i:=length(c) downto 1 do
      begin
      dec(posloop);
      loop;
      compt:=0;
      for j:=1 to length(frmDimerLoop.loops.lines[1]) do
          if frmDimerLoop.loops.lines[1][j]='|' then
             if frmDimerLoop.loops.lines[0][j] in ['C','G'] then
                compt:=compt+4
             else
                compt:=compt+2;
      if compt=memcompt then
         exit;
      end;
   end;
end;


procedure TfrmDimerLoop.FormActivate(Sender: TObject);
var i:integer;
begin
nom_oligo.caption:=frmMain.ed_oligo_name.text+':  '+format_iupac(frmMain.seq.text,false);
//chargement oligo
listoligo.Clear;
with frmMain do
for i:=0 to tv.items.Count-1 do
    if tv.Items[i].imageindex=c_oligo then
        begin
        if pTo(tv.items[i].Data)^.seq<>'' then
           listoligo.items.add(pto(tv.items[i].data)^.name+' : '+format_iupac(pTo(tv.items[i].Data)^.seq,false));
        end;

// init dimers
b:=format_iupac(pTo(frmMain.tv.selected.Data)^.seq,false);
while pos(' ',b)<>0 do
   delete(b,pos(' ',b),1);
c:=b;

//homodimer initial
a:='';
longb:=length(b);
for i:=1 to length(b) do
   a:=b[i]+a;
longa:=length(a);
for i:=1 to length(a) do
    b:=' '+b+' ';
maxdimer;

//init loop
j:=length(c)+1;
for i:=1 to j do
 c:=' '+c;
maxloop;
end;

procedure TfrmDimerLoop.Button3Click(Sender: TObject);
begin
a:=' '+a;
dimer(b,a);
end;

procedure TfrmDimerLoop.Button2Click(Sender: TObject);
begin
if a[1]=' ' then
   begin
   delete(a,1,1);
   dimer(b,a);
   end;

end;

procedure TfrmDimerLoop.Button6Click(Sender: TObject);
begin
maxdimer;
end;

procedure TfrmDimerLoop.Button4Click(Sender: TObject);
begin
if posloop<length(c) then
   inc(posloop);
loop;
end;

procedure TfrmDimerLoop.Button5Click(Sender: TObject);
begin

if posloop>1 then
   dec(posloop);
loop;
end;

procedure TfrmDimerLoop.ListoligoClick(Sender: TObject);
var i,j:integer;
begin
for i:=0 to listoligo.items.count-1 do
    begin
    if listoligo.selected[i] then
        begin
        b:=copy(listoligo.items[i],pos(' : ',listoligo.items[i])+3,50);
        a:='';
        for j:=1 to length(b) do
            a:=b[j]+a;
        longa:=length(a);

        b:=uppercase(pTo(frmMain.tv.selected.Data)^.seq);
        while pos(' ',b)<>0 do
           delete(b,pos(' ',b),1);
        longb:=length(b);
        for j:=1 to length(a) do
            b:=' '+b+' ';
        maxdimer;
        end;
    end;
end;

procedure TfrmDimerLoop.Button7Click(Sender: TObject);
begin
maxloop;
end;

procedure TfrmDimerLoop.btSaveClick(Sender: TObject);
var i:byte;
    ft:textfile;
begin
frmMain.SaveDialog1.filename:='';
frmMain.SaveDialog1.filter:='';
if frmMain.SaveDialog1.execute then
   begin
   assignfile(ft,frmMain.savedialog1.filename);
   rewrite(ft);
   writeln(ft,'AnnHyb - Oligonucleotides dimers and Haipin Loops');
   writeln(ft,'-------------------------------------------------');
   writeln(ft);
   writeln(ft,nom_oligo.caption);
   for i:=0 to listoligo.items.count-1 do
       if listoligo.selected[i] then
          writeln(ft,listoligo.items[i]);

   writeln(ft);
   writeln(ft,'Dimer:');
   for i:=0 to 2 do
       writeln(ft,dimers.lines[i]);
   writeln(ft);
   writeln(ft,'Hairpin loop:');
   for i:=0 to 2 do
       writeln(ft,loops.lines[i]);

   closefile(ft);
   end;
end;

procedure TfrmDimerLoop.Button9Click(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\dimer_hairpin.html'),Nil,Nil,SW_NORMAL);

end;

end.
