{u_edit_sequence.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_edit_sequence;

interface

uses shellapi,clipbrd,seq, ComCtrls, Menus, Controls, StdCtrls, Classes,
  Windows, Messages, SysUtils, Graphics,  Forms, Dialogs, RxRichEd, ToolWin;
   type
  Tedit_seq = class(TForm)
    MainMenu1: TMainMenu;
    Sequence1: TMenuItem;
    Close1: TMenuItem;
    SB_editseq: TStatusBar;
    Edit1: TMenuItem;
    Clearsequence1: TMenuItem;
    Insertsequencefromfile1: TMenuItem;
    fromfile1: TMenuItem;
    fromclipboard1: TMenuItem;
    Cancel1: TMenuItem;
    N1: TMenuItem;
    seqed2: TRxRichEdit;
    Help1: TMenuItem;
    N2: TMenuItem;
    Gotoposition1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    procedure Close1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Clearsequence1Click(Sender: TObject);
    procedure Insertsequencefromfile1Click(Sender: TObject);
    procedure fromclipboard1Click(Sender: TObject);
    procedure Cancel1Click(Sender: TObject);
    procedure seqed2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure seqed2KeyPress(Sender: TObject; var Key: Char);
    procedure seqed2SelectionChange(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure Gotoposition1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var edit_seq: Tedit_seq;
    seq2:string;

implementation

uses u_annhyb,u_biotools, u_options;

{$R *.DFM}

function posseqtopos(i:integer):integer;
var x,x1:integer;
begin
x:=((i-1) mod 50)+1;
x1:=x;
if x1>10 then
   inc(x);
if x1>20 then
   inc(x);
if x1>30 then
   inc(x);
if x1>40 then
   inc(x);
//inc(x,10);
posseqtopos:=(((i-1) div 50))*55+x-1;
end;

function xytopos(x,y:integer):integer;
var i:integer;
begin
//showmessage(inttostr(x));
i:=x;
//if i>10 then
//   begin
  // i:=i-10;
   if x>=12 then
      dec(i);
   if x>=23 then
      dec(i);
   if x>=34 then
      dec(i);
   if x>=45 then
      dec(i);
   if x>54 then
      begin
      inc(y);
      i:=1;
      end;
  // end
//else
//   i:=1;
result:=(y-1)*50+i;
end;


function postoxy(ss:integer):tpoint;
var x,y:integer;
begin
x:=(ss mod 55)+1;

y:=sendmessage(edit_seq.seqed2.Handle,em_linefromchar,ss,0)+1;
result.x:=x;
result.y:=y;
end;

procedure format_sequence;
var s:string;
    t:integer;
begin
s:='';
for t:=1 to length(seq2) do
    begin
    s:=s+seq2[t];
    if t mod 50=0 then
       s:=s+CRLF
    else
       if (t mod 10=0)  then
          s:=s+' ';
    end;
edit_seq.seqed2.text:=s;
end;

procedure Tedit_seq.Close1Click(Sender: TObject);
begin
frmMain.flag_seq_ed_valid:=true;
close;
end;

procedure Tedit_seq.FormActivate(Sender: TObject);
begin
seq2:=clearseq(seqed2.text);
seqed2.setfocus;
seqed2SelectionChange(nil);
end;

procedure Tedit_seq.Clearsequence1Click(Sender: TObject);
begin
if MessageDlg('Are you sure to delete the entire sequence?',mtWarning,[mbYes,mbNo],0)=mrYes then
    begin
    seq2:='';
    seqed2.clear;
    sb_editseq.panels[0].text:='';
    end;
end;

procedure Tedit_seq.Insertsequencefromfile1Click(Sender: TObject);
var x,y,mem,mem2:integer;
    sl:tstringlist;
    sequ:t_sq;
    seqformat:shortstring;
begin
frmMain.od.filter:='All files (*.*)|*.*';
if frmMain.od.execute then
   begin
   x:=postoxy(seqed2.SelStart).x;
   y:=postoxy(seqed2.SelStart).y;
   mem:=xytopos(x,y);

   sl:=tstringlist.create;
   sl.loadfromfile(frmMain.od.filename);

   analyse_seq(sl,sequ,seqformat);

   sb_editseq.panels[0].text:='Length: '+inttostr(length(sequ.seq));

   if seqed2.seltext<>'' then    //replace selected nt by s1
       begin
       mem2:=xytopos(postoxy(seqed2.SelStart+seqed2.sellength-1).x,postoxy(seqed2.SelStart+seqed2.sellength-1).y);
       delete(seq2,mem,mem2-mem+1);
       insert(sequ.seq,seq2,mem);
       inc(mem,length(sequ.seq));
       end
    else
       begin           //insert seq
       insert(sequ.seq,seq2,mem);
       inc(mem,length(sequ.seq));
       end;

   format_sequence;
   seqed2.selstart:=posseqtopos(mem);
   sl.free;
   end; //opendlg
end;

procedure Tedit_seq.fromclipboard1Click(Sender: TObject);
var  t,x,y,mem,mem2:integer;
     clp,s:string;
begin
if Clipboard.HasFormat(CF_TEXT) then
   clp:=Clipboard.AsText
else
   begin
   showmessage('Clipboard do not contain text!');
   exit;
   end;

s:='';
for t:=1 to length(clp) do
      if upcase(clp[t]) in validbase then
         s:=s+clp[t];
clp:=s;

x:=postoxy(seqed2.SelStart).x;
y:=postoxy(seqed2.SelStart).y;

mem:=xytopos(x,y);

if seqed2.seltext<>'' then    //replace selected nt by clipboard
   begin
   mem2:=xytopos(postoxy(seqed2.SelStart+seqed2.sellength-1).x,postoxy(seqed2.SelStart+seqed2.sellength-1).y);
   delete(seq2,mem,mem2-mem+1);
   insert(clp,seq2,mem);
   inc(mem,length(clp));
   end
else
   begin           //insert clipboard
   insert(clp,seq2,mem);
   inc(mem,length(clp));
   end;

format_sequence;
seqed2.selstart:=posseqtopos(mem);
(*
s1:=copy(seqed2.text,1,seqed2.selstart);   //avant insertion
s2:=copy(seqed2.text,seqed2.selstart+1,65536);

memselstart:=seqed2.selstart;

for t:=1 to length(clp) do
      if upcase(clp[t]) in validbase then
         s1:=s1+upcase(clp[t]);

s1:=s1+s2;
while pos(' ',s1)<>0 do
  delete(s1,pos(' ',s1),1);
while pos(#10,s1)<>0 do
  delete(s1,pos(#10,s1),1);
while pos(#13,s1)<>0 do
  delete(s1,pos(#13,s1),1);

//frmMain.length_s:=inttostr(length(s1));
sb_editseq.panels[0].text:='Length: '+inttostr(length(s1));
s:='';
for t:=1 to length(s1) do
begin
s:=s+s1[t];
if t mod 50=0 then
   s:=s+#13#10
else
if (t mod 10=0)  then
   s:=s+' ';
end;
seqed2.text:=s;
if s='' then
  exit;
if s[length(s)]=' ' then
  inc(memselstart);
if s[length(s)-1]+s[length(s)]=#13#10 then
  inc(memselstart,2);
seqed2.selstart:=memselstart+1;

*)
end;

procedure Tedit_seq.Cancel1Click(Sender: TObject);
begin
frmMain.flag_seq_ed_valid:=false;
close;
end;

procedure Tedit_seq.seqed2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var s:string;
    t,x,y,mem,mem2:integer;
begin
if key=46 then   //DEL key
   begin
   //sel init
   x:=postoxy(seqed2.SelStart).x;
   y:=postoxy(seqed2.SelStart).y;
   mem:=xytopos(x,y);

   //sel end
   if seqed2.sellength>0 then
      begin
      x:=postoxy(seqed2.SelStart+seqed2.SelLength).x;
      y:=postoxy(seqed2.SelStart+seqed2.SelLength).y;
      mem2:=xytopos(x,y);
      delete(seq2,mem,mem2-mem);
      end
   else
      begin //sellength=0
      delete(seq2,mem,1);
      end;
   s:='';
   for t:=1 to length(seq2) do
       begin
       s:=s+seq2[t];
       if t mod 50=0 then
          s:=s+CRLF
       else
          if (t mod 10=0)  then
             s:=s+' ';
       end;
   seqed2.text:=s;
   seqed2.selstart:=posseqtopos(mem);
   end; //del key
end;

procedure Tedit_seq.seqed2KeyPress(Sender: TObject; var Key: Char);
var c:char;
    x,y,mem,mem2:integer;
begin
c:=key;
if (c<>chr(vk_back)) and not (upcase(c) in validbase) then
   exit
else if (upcase(c) in validbase) and (frmPreferences.cb_readseq.checked) then
     frmMain.PlaySound(program_dir+c+'.wav');

x:=postoxy(seqed2.SelStart).x;
y:=postoxy(seqed2.SelStart).y;

mem:=xytopos(x,y);

//backspace
if c=chr(vk_back) then   //delete
   begin
   if seqed2.seltext<>'' then
       begin
       mem2:=xytopos(postoxy(seqed2.SelStart+seqed2.sellength-1).x,postoxy(seqed2.SelStart+seqed2.sellength-1).y);
       delete(seq2,mem,mem2-mem+1);
       end
   else
       if mem>1 then
          begin
          delete(seq2,mem-1,1);
          dec(mem);
          end;
   end
else
   begin
   if seqed2.seltext<>'' then    //replace selected nt by keyboard input
       begin
       mem2:=xytopos(postoxy(seqed2.SelStart+seqed2.sellength-1).x,postoxy(seqed2.SelStart+seqed2.sellength-1).y);
       delete(seq2,mem,mem2-mem+1);
       insert(c,seq2,mem);
       inc(mem);
       end
   else
       begin           //insert keyboard input
       insert(c,seq2,mem);
       inc(mem);
       end;
   end;

format_sequence;
seqed2.selstart:=posseqtopos(mem);
end; //editseq key pressed


procedure Tedit_seq.seqed2SelectionChange(Sender: TObject);
var x,y,pos_,pos2:integer;
begin
y:=postoxy(edit_seq.seqed2.selstart).y;
x:=postoxy(edit_seq.seqed2.selstart).x;
pos_:=xytopos(x,y);
pos2:=xytopos(postoxy(edit_seq.seqed2.selstart+edit_seq.seqed2.sellength).x,postoxy(edit_seq.seqed2.selstart+edit_seq.seqed2.sellength).y);
(*
if pos_>length(pSq(tv.Selected.data)^.seq)+1 then
   pos_:=length(pSq(tv.Selected.data)^.seq)+1;

if pos2-1>length(pSq(tv.Selected.data)^.seq) then
   pos2:=length(pSq(tv.Selected.data)^.seq)+1;
*)

if pos2-pos_=0 then //no selection
   sb_editseq.panels[1].text:=format('Position: %d  ',[pos_])
else
   sb_editseq.panels[1].text:=format('Selection: %d - %d   (%d bp)  ',[pos_,pos2-1,pos2-pos_]);
end;

procedure Tedit_seq.Help1Click(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\edit_sequence.html'),Nil,Nil,SW_NORMAL);
end;

procedure Tedit_seq.Gotoposition1Click(Sender: TObject);
var newpos,erreur:integer;
//    s:string;
begin

s:='';
InputQuery('Go to position', 'Position',s);
val(s,newpos,erreur);
if (erreur<>0) or (newpos>length(seq2)) or (newpos<1) then
   begin
   showmessage('Nucleotide position not valid!');
   exit;
   end;
seqed2.SetFocus;
seqed2.selstart:=posseqtopos(newpos);
end;

end.
