{u_export_seq.pas - AnnHyb
 	Copyright (C) 1997-2007 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_export_seq;

interface
uses dialogs,seq,forms,u_results;

procedure export_seq(nf:string;seq2save:T_sq;fmt:integer;flagAppend:boolean);

implementation
uses u_annhyb,sysutils,u_confirmfile,controls,u_biotools,classes,graphics,windows;

function TColorToHex(Color:TColor):string;
begin
Result:=IntToHex(GetRValue(Color),2)+IntToHex(GetGValue(Color),2)+IntToHex(GetBValue(Color),2);
end;

procedure export_seq(nf:string;seq2save:T_sq;fmt:integer;flagAppend:boolean);
var i,j,k,ii,_init,_end:integer;
     fichier:textfile;
     s:string;
     sl1,sl2,sl:tstringlist;
     flagfirst:boolean;
     ms:tmemorystream;
     memcolor:tcolor;
     c:char;

begin
if nf<>'' then
    begin
    assignfile(fichier,nf);
    if flagAppend then
        begin
        if fileexists(nf) then
           append(fichier)
        else
           rewrite(fichier);
        end
    else
    if fileexists(nf) then
        begin
        //no concatenation with older file
        frmConfirmFile.lbMessage.caption:='The file '+nf+' already exists!';
        frmConfirmFile.btAppend.visible:=false;
        frmConfirmFile.showmodal;
        frmConfirmFile.btAppend.visible:=true;
        if frmConfirmFile.modalresult=mrNo then
            append(fichier);
        if frmConfirmFile.modalresult=mrCancel then
            exit;
        if frmConfirmFile.modalresult=mrYes then
            rewrite(fichier);
        end
    else
        rewrite(fichier);
    end;
with frmMain do
    begin
    //RSF
    if fmt=0 then
       begin
       //RSF header
       writeln(fichier,'!!RICH_SEQUENCE 1.0');
       writeln(fichier,'GCG Rich Sequence File (RSF).');
       writeln(fichier,'Written by AnnHyb (http://bioinformatics.org/annhyb)');
       writeln(fichier,'..');
       writeln(fichier,'{');

       writeln(fichier,'name   '+seq2save.name);
       if seq2save.longname<>'' then
          writeln(fichier,'longname  '+seq2save.longname);
       writeln(fichier,'type    '+seq2save._type);
       if seq2save.descrip<>'' then
          writeln(fichier,'descrip     '+seq2save.descrip);
       if seq2save.creator<>'' then
          writeln(fichier,'creator    '+seq2save.creator);
       if seq2save.creationdate<>'' then
          writeln(fichier,'creation-date  '+seq2save.creationdate);
       writeln(fichier,'checksum    '+gcg_checksum(seq2save.seq));

       if seq2save.hrsf>'' then
          writeln(fichier,seq2save.hrsf);
       //features
       if seq2save.features<>'' then
          writeln(fichier,seq2save.features);

       writeln(fichier,'sequence');
       for i:=1 to length(seq2save.seq) div 50 do
           begin
           writeln(fichier,'      '+copy(seq2save.seq,1+(i-1)*50,50));
           end;
       i:=(length(seq2save.seq) div 50)+1;
       if copy(seq2save.seq,1+(i-1)*50,50)<>'' then
          writeln(fichier,'      '+copy(seq2save.seq,1+(i-1)*50,50));
       writeln(fichier,'}');
       end;
    //FASTA
    if fmt=1 then
       begin
       writeln(fichier,'>'+seq2save.name);
       for i:=1 to length(seq2save.seq) div 50 do
           writeln(fichier,copy(seq2save.seq,1+(i-1)*50,50));
       i:=(length(seq2save.seq) div 50)+1;
       if copy(seq2save.seq,1+(i-1)*50,50)<>'' then
          writeln(fichier,copy(seq2save.seq,1+(i-1)*50,50));
       end;
    //GCG
    if fmt=2 then
       begin
       s:='!!NA_SEQUENCE 1.0'+CRLF;
       s:=s+seq2save.name+'  Length: '+inttostr(length(seq2save.seq));
       DecodeDate(now,Year,Month,Day);
       DecodeTime(now,Hour,Min,Sec,MSec);
       s:=s+'  '+month_[month]+' '+inttostr(day)+', '+inttostr(year)+' ';   if hour<10 then
          s:=s+'0'+inttostr(hour)+':'
       else
          s:=s+inttostr(hour)+':';
       if min<10 then
          s:=s+'0'+inttostr(min)
       else
          s:=s+inttostr(min);
       s:=s+'  Type: N';
       s:=s+'  Check: '+gcg_checksum(seq2save.seq)+' ..'+CRLF;
       s:=s+CRLF;

       for i:=0 to rxgcgseq.Lines.count-1 do
           s:=s+rxgcgseq.lines[i]+CRLF+CRLF;
       writeln(fichier,s);
       end;
    //Genbank
    if fmt=3 then
      begin  //header genbank
      if (pos('LOCUS       ',seq2save.hrsf)<>0)
         and (pos('DEFINITION  ',seq2save.hrsf)<>0)
         and (pos('ACCESSION   ',seq2save.hrsf)<>0)
         and (pos('ORIGIN',seq2save.hrsf)<>0) then
         begin
         s:=seq2save.hrsf;
         while copy(s,1,15)<>'   LOCUS       ' do
            delete(s,1,pos(CRLF,s)+1);

         while copy(s,1,9)<>'   ORIGIN' do
            begin
            writeln(fichier,copy(s,4,pos(CRLF,s)-4));
            delete(s,1,pos(CRLF,s)+1);
            end;
         //copie ORIGIN
         writeln(fichier,copy(s,4,pos(CRLF,s)-4));
         end
      else
         begin //pas de header genbank dans comments RSF
         s:='LOCUS       '+seq2save.name;
         while length(s)+length(inttostr(length(seq2save.seq))+' bp')<32 do
             s:=s+' ';
         writeln(fichier,s+inttostr(length(seq2save.seq))+' bp');
         writeln(fichier,'DEFINITION  ');
         writeln(fichier,'ACCESSION   ');
         writeln(fichier,'ORIGIN      ');
         end;
      //seq
      i:=1;
      while i<=length(seq2save.seq) do
            begin
            s:=ansilowercase(copy(seq2save.seq,i,60));
            for j:=5 downto 1 do
                if length(s)>j*10 then
                   insert(' ',s,j*10+1);
            s2:=inttostr(i);
            while length(s2)<9 do
                  s2:=' '+s2;
            writeln(fichier,s2+' '+s);
            inc(i,60);
            end;
      writeln(fichier,'//');
      end;
    //EMBL
    if fmt=4 then
      begin
      if (pos('ID   ',seq2save.hrsf)<>0)
         and (pos('AC   ',seq2save.hrsf)<>0)
         and (pos('DE   ',seq2save.hrsf)<>0) then
         begin
         s:=seq2save.hrsf;
         while copy(s,1,8)<>'   ID   ' do
            delete(s,1,pos(CRLF,s)+1);

         while copy(s,1,8)<>'   SQ   ' do
            begin
            writeln(fichier,copy(s,4,pos(CRLF,s)-4));
            delete(s,1,pos(CRLF,s)+1);
            end;
         //copie SQ
         writeln(fichier,copy(s,4,pos(CRLF,s)-4));
         end
      else
         begin //pas de header genbank dans comments RSF
         writeln(fichier,'ID   '+seq2save.name);
         writeln(fichier,'AC   ');
         writeln(fichier,'DE   ');
         writeln(fichier,'SQ   Sequence '+inttostr(length(seq2save.seq))+' BP');
         end;
      //seq
      i:=1;
      while i<=length(seq2save.seq) do
            begin
            s:=ansilowercase(copy(seq2save.seq,i,60));
            if length(s)=60 then
               s2:=inttostr(i+59)
            else
               s2:=inttostr(i+length(s)-1);
            while length(s2)<10 do
                  s2:=' '+s2;
            for j:=5 downto 1 do
                if length(s)>j*10 then
                   insert(' ',s,j*10+1);
            while length(s)<65 do        //dernire ligne
                 s:=s+' ';
            writeln(fichier,'     '+s+s2);
            inc(i,60);
            end;
      writeln(fichier,'//');
      end;
    //RTF
    if fmt=5 then
      begin
      writeln(fichier,seq2save.seqrtf);
      end;
    //HTML
    if fmt=6 then
        begin
        writeln(fichier,s);
        //writeln(fichier,'<!doctype html public "-//W3C//DTD HTML 4.0 Transitional//EN">');
        writeln(fichier,'<html><head><title>'+seq2save.name+'</title>');
        writeln(fichier,'<meta name="Generator" content="AnnHyb">');
        writeln(fichier,'<meta name="Author" content="'+seq2save.creator+'">');
        writeln(fichier,'<meta name="Description" content="'+seq2save.descrip+'">');
        writeln(fichier,'<style>');
        writeln(fichier,'.normal {color:black; background:white;}');
        writeln(fichier,'</style>');
        writeln(fichier,'</head><body>');
        writeln(fichier,'<pre>');
        writeln(fichier,'Name: '+'<b>'+seq2save.name+'</b><br>');
        writeln(fichier,'Description: '+seq2save.descrip+'<br><br>');

        //paint sequence with annotations in dynform
        s:=seq2save.seqrtf;
        ms:=tmemorystream.create;
        ms.WriteBuffer(pointer(s)^,length(s));
        ms.Position:=0;
        dynform:=TfrmResults.Create(application);
        dynform.rxResults.clear;
        dynform.rxResults.Lines.LoadFromStream(ms);
        dynform.Repaint;
        ms.Free;
        dynform.rxResults.selstart:=0;
        dynform.rxResults.sellength:=0;

        _init:=dynform.rxResults.selstart;
        dynform.rxResults.selectall;
        _end:=length(dynform.rxResults.seltext);
        memcolor:=-16777211;
        for ii:=_init to _init+_end-1 do
               begin
               dynform.rxResults.selstart:=ii;
               dynform.rxResults.sellength:=1;
               c:=dynform.rxResults.seltext[1];
               if dynform.rxResults.selAttributes.backcolor=memcolor then
                   begin
                   write(fichier,c);
                   if c=#13 then
                      writeln(fichier,'<br>');
                   end
               else
                   begin
                   write(fichier,'</span>');
                   if dynform.rxResults.selAttributes.backcolor=-16777211 then
                        write(fichier,'<span class="normal">')
                   else
                        begin
                        write(fichier,'<span style="color:#'+TColorToHex(frmMain.foreground_color(dynform.rxResults.selAttributes.backcolor))+'; background:#'+TColorToHex(dynform.rxResults.selAttributes.backcolor)+';">');
                        end;

                   write(fichier,c);
                   if c=#13 then
                      writeln(fichier,'<br>');
                   end;
               memcolor:=dynform.rxResults.selAttributes.backcolor;
               end;

       writeln(fichier,'</pre></body></html>');
       end;
       sl.Free;
       flush(fichier);
       closefile(fichier);
       end;//with
end;



end.
