{u_features.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

//frmFeatures
unit u_features;

interface

uses shellapi,u_biotools,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ColorGrd, CheckLst, Mask, ExtCtrls, ComCtrls, ImgList;

type
  TfrmFeatures = class(TForm)
    Button1: TButton;
    feature_name: TEdit;
    B_remove: TButton;
    lbName: TLabel;
    Label2: TLabel;
    lbBegin: TLabel;
    edFBegin: TEdit;
    lbEnd: TLabel;
    edFEnd: TEdit;
    lbComment: TLabel;
    f_comment: TEdit;
    B_new: TButton;
    btHelp: TButton;
    lvFeatures: TListView;
    btCancel: TButton;
    btRemoveAll: TButton;
    clbFeatures: TComboBoxEx;
    bt_up: TButton;
    bt_down: TButton;
    btApply: TButton;
    procedure B_removeClick(Sender: TObject);
    procedure B_newClick(Sender: TObject);
    procedure clbFeatureslistClickCheck(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure lvFeaturesClick(Sender: TObject);
    procedure edFBeginChange(Sender: TObject);
    procedure edFEndChange(Sender: TObject);
    procedure feature_nameChange(Sender: TObject);
    procedure f_commentChange(Sender: TObject);
    procedure clbfeatureChange(Sender: TObject);
    procedure edFBeginKeyPress(Sender: TObject; var Key: Char);
    procedure FormActivate(Sender: TObject);
    procedure btRemoveAllClick(Sender: TObject);
    procedure clbFeaturesChange(Sender: TObject);
    procedure bt_upClick(Sender: TObject);
    procedure btApplyClick(Sender: TObject);
    procedure bt_downClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var frmFeatures: TfrmFeatures;
    t:cardinal;
    ss:shortstring;
    flagedit:integer;

implementation
uses u_annhyb;

{$R *.DFM}

procedure update_lv;
var memcursor:tcursor;
begin
memcursor:=screen.Cursor;
screen.Cursor:=crHourglass;
with frmFeatures do
    begin
    frmMain.lvAnnotations.Items:=lvFeatures.Items;
    if (edFbegin.text<>'') and (edFEnd.text<>'') and (strtoint(edFbegin.text)<=strtoint(edFend.text)) then
       affiche_features;
    end;
screen.Cursor:=memcursor;
end;

procedure TfrmFeatures.B_removeClick(Sender: TObject);   //remove
begin
if lvFeatures.Selected<>nil then
   begin
   lvFeatures.selected.Delete;
   frmMain.lvAnnotations.Items:=lvFeatures.Items;
   affiche_features;
   end
else
   showmessage('Select an annotation to delete!');
end;

procedure TfrmFeatures.B_newClick(Sender: TObject);
var itm:Tlistitem;
begin
itm:=lvFeatures.Items.Add;
itm.ImageIndex:=-1;
itm.Caption:='';
itm.SubItems.Add('');
itm.SubItems.Add('');
itm.SubItems.add('');
lvFeatures.Selected:=itm;

edFbegin.enabled:=true;
edFend.enabled:=true;
feature_name.enabled:=true;
f_comment.enabled:=true;
clbFeatures.enabled:=true;
lbName.Enabled:=true;
lbBegin.Enabled:=true;
lbEnd.Enabled:=true;
lbComment.Enabled:=true;


frmMain.lvAnnotations.Items:=lvFeatures.Items;

edFbegin.clear;
edFend.clear;
feature_name.clear;
clbfeatures.itemindex:=16;
f_comment.clear;
edFbegin.setfocus;
end;

procedure TfrmFeatures.clbFeatureslistClickCheck(Sender: TObject);
begin
affiche_features;
end;

procedure edit_feature;
begin
with frmFeatures do
    begin
    feature_name.text:=lvFeatures.Selected.Caption;
    edFBegin.Text:=lvFeatures.Selected.subitems.strings[0];
    edFEnd.Text:=lvFeatures.Selected.subitems.strings[1];
    f_comment.text:=lvFeatures.Selected.subitems.strings[2];
    clbfeatures.itemindex:=lvFeatures.Selected.imageindex;
    edFBegin.setfocus;
    end;
end;

procedure TfrmFeatures.Button1Click(Sender: TObject);
var i:integer;
    flagok:boolean;
begin
update_lv;
flagok:=true;
if lvFeatures.items.count>0 then
   for i:=0 to lvFeatures.items.count-1 do
       begin
       //feature_name.text:=lvFeatures.Selected.Caption;
       if (lvFeatures.items[i].subitems.strings[0]='')
          or (lvFeatures.items[i].subitems.strings[1]='') then
          flagok:=false
       else if strtoint(lvFeatures.items[i].subitems.strings[0])>strtoint(lvFeatures.items[i].subitems.strings[1]) then
          flagok:=false;
       if not flagok then
          break;
       end;
if not flagok then
   begin
   showmessage('The annotation "'+lvFeatures.items[i].Caption+'" is not correct!');
   lvFeatures.items[i].Selected:=true;
   edit_feature;
   end
else
   begin
   modalresult:=mrOK;
//   close;
   end;
end;

procedure TfrmFeatures.Button3Click(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\features.html'),Nil,Nil,SW_NORMAL);
end;

procedure TfrmFeatures.lvFeaturesClick(Sender: TObject);
begin
if lvFeatures.Selected<>nil then
   begin
   edFbegin.enabled:=true;
   edFend.enabled:=true;
   feature_name.enabled:=true;
   f_comment.enabled:=true;
   clbFeatures.enabled:=true;
   lbName.Enabled:=true;
   lbBegin.Enabled:=true;
   lbEnd.Enabled:=true;
   lbComment.Enabled:=true;
   edit_feature;
   end;
end;

procedure TfrmFeatures.edFBeginChange(Sender: TObject);
begin
if (activecontrol=edFbegin) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;
   lvFeatures.Selected.subitems.strings[0]:=edFBegin.Text;
 //  update_lv;
   end;
end;

procedure TfrmFeatures.edFEndChange(Sender: TObject);
begin
if (activecontrol=edFEnd) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;

   lvFeatures.Selected.subitems.strings[1]:=edFEnd.Text;
 //  update_lv;
   end;

end;

procedure TfrmFeatures.feature_nameChange(Sender: TObject);
begin
if (activecontrol=feature_name) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;

   lvFeatures.Selected.caption:=feature_name.Text;
   frmMain.lvAnnotations.Items:=lvFeatures.Items;
   end;

end;

procedure TfrmFeatures.f_commentChange(Sender: TObject);
begin
if (activecontrol=f_comment) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;

   lvFeatures.Selected.subitems.strings[2]:=f_comment.Text;
   frmMain.lvAnnotations.Items:=lvFeatures.Items;
   end;
end;

procedure TfrmFeatures.clbfeatureChange(Sender: TObject);
var b:byte;
begin
if (activecontrol=clbfeatures) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;

   for b:=0 to 15 do
      if color_rsf[b]=clbFeatures.itemindex then
         begin
         lvFeatures.Selected.imageindex:=b;
         break;
         end;

 //  lvFeatures.Selected.imageindex:=rev_col(clbFeature.selected);
//   update_lv;
   end;
end;

procedure TfrmFeatures.edFBeginKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in [#8,'0'..'9']) then
    key:=#0;
end;

procedure TfrmFeatures.FormActivate(Sender: TObject);
begin
lvFeatures.SetFocus;
end;

procedure TfrmFeatures.btRemoveAllClick(Sender: TObject);
var i:integer;
begin
if lvFeatures.Items.count>0 then
   for i:=0 to lvFeatures.items.count-1 do
       lvFeatures.items[0].Delete;
frmMain.lvAnnotations.Items:=lvFeatures.Items;
affiche_features;
end;

procedure TfrmFeatures.clbFeaturesChange(Sender: TObject);
begin
if (activecontrol=clbfeatures) then
   begin
   if lvFeatures.Selected=nil then
       begin
       showmessage('select an existing annotation or click "new" button');
       exit;
       end;

//   for b:=0 to 15 do
//      if color_rsf[b]=clbFeatures.itemindex then
//         begin
         lvFeatures.Selected.imageindex:=clbFeatures.itemindex;
//         break;
//         end;

 //  lvFeatures.Selected.imageindex:=rev_col(clbFeature.selected);
//   update_lv;
   end;
end;

procedure ExchangeItems(lv:TListView;const i,j:Integer);
var tempLI:TListItem;
begin
lv.Items.BeginUpdate;
try
    tempLI := TListItem.Create(lv.Items);
    tempLI.Assign(lv.Items.Item[i]);
    lv.Items.Item[i].Assign(lv.Items.Item[j]);
    lv.Items.Item[j].Assign(tempLI);
    tempLI.Free;
finally
    lv.Items.EndUpdate
end;
end;

procedure TfrmFeatures.bt_upClick(Sender: TObject);
begin
if (lvFeatures.Selected<>nil) then
    if lvFeatures.selected.index>0 then
        begin
        ExchangeItems(lvFeatures,lvFeatures.selected.index,lvFeatures.selected.index-1);
        lvFeatures.selected:=lvFeatures.items[lvFeatures.selected.index-1];
        end;
end;

procedure TfrmFeatures.btApplyClick(Sender: TObject);
begin
update_lv;
end;

procedure TfrmFeatures.bt_downClick(Sender: TObject);
begin
if (lvFeatures.Selected<>nil) then
    if lvFeatures.selected.index<lvFeatures.items.Count-1 then
        begin
        ExchangeItems(lvFeatures,lvFeatures.selected.index,lvFeatures.selected.index+1);
        lvFeatures.selected:=lvFeatures.items[lvFeatures.selected.index+1];
        end;

end;

end.
