{u_multialigncleaner.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_multialigncleaner;

interface

uses shellapi,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TfrmMultiAlignCleaner = class(TForm)
    list_seq: TComboBox;
    lb_homol: TLabel;
    homol_pc: TEdit;
    rb_choose_seq: TRadioButton;
    rb_m_consensus: TRadioButton;
    btHelp: TButton;
    lb_mal: TLabel;
    ed_oll: TLabeledEdit;
    lb_b: TLabel;
    cbIncludePosition: TCheckBox;
    btOK: TButton;
    btCancel2: TButton;
    cbIncludeRules: TCheckBox;
    procedure rb_choose_seqClick(Sender: TObject);
    procedure rb_m_consensusClick(Sender: TObject);
    procedure list_seqChange(Sender: TObject);
    procedure homol_pcChange(Sender: TObject);
    procedure btHelpClick(Sender: TObject);
    procedure homol_pcKeyPress(Sender: TObject; var Key: Char);
    procedure ed_ollKeyPress(Sender: TObject; var Key: Char);

  private
    { Private declarations }
  public
    { Public declarations }
  end;


const  maxchar=21;
       nc:array[1..maxchar] of char=('A','T','C','G','-','K','R','H','Q','S','Y','D',
                              'E','N','V','L','I','P','F','M','W');

  espaces80='                                                            ';


var frmMultiAlignCleaner: TfrmMultiAlignCleaner;

implementation

uses u_annhyb, u_results,u_biotools;

{$R *.DFM}

procedure TfrmMultiAlignCleaner.rb_choose_seqClick(Sender: TObject);
begin
lb_homol.enabled:=false;
homol_pc.enabled:=false;

list_seq.enabled:=true;
list_seq.setfocus;
end;

procedure TfrmMultiAlignCleaner.rb_m_consensusClick(Sender: TObject);
begin
list_seq.enabled:=false;

lb_homol.enabled:=true;
homol_pc.enabled:=true;
homol_pc.setfocus;
end;

procedure TfrmMultiAlignCleaner.list_seqChange(Sender: TObject);
begin
if list_seq.text<>'' then
   begin
   rb_choose_seq.checked:=true;
   rb_m_consensus.checked:=false;
   end;
end;

procedure TfrmMultiAlignCleaner.homol_pcChange(Sender: TObject);
begin
if homol_pc.text<>'' then
   begin
   rb_choose_seq.checked:=false;
   rb_m_consensus.checked:=true;
   end;
end;

procedure TfrmMultiAlignCleaner.btHelpClick(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\tools.html'),Nil,Nil,SW_NORMAL);
end;

procedure TfrmMultiAlignCleaner.homol_pcKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in ['.','0'..'9',#8]) then
   key:=#0;
end;

procedure TfrmMultiAlignCleaner.ed_ollKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in ['0'..'9',#8]) then
   key:=#0;
end;

end.
