unit u_oligonotes;

interface

uses clipbrd,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus;

type
  TfrmOligoNotes = class(TForm)
    mm_oligonotes: TMemo;
    btClose: TButton;
    pm_mmOligoNotes: TPopupMenu;
    mi_copy: TMenuItem;
    mi_cut: TMenuItem;
    mi_paste: TMenuItem;
    procedure mm_oligonotesChange(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure mi_copyClick(Sender: TObject);
    procedure mi_cutClick(Sender: TObject);
    procedure mi_pasteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOligoNotes: TfrmOligoNotes;

implementation
uses u_annhyb;

{$R *.dfm}

procedure TfrmOligoNotes.mm_oligonotesChange(Sender: TObject);
begin
pto(frmMain.tv.selected.data)^.notes:=mm_OligoNotes.text;
if activecontrol=mm_oligoNotes then
   frmMain.flagworkspacechanged:=true;
end;

procedure TfrmOligoNotes.btCloseClick(Sender: TObject);
begin
frmMain.flag_show_oligoNotes:=false;
hide;
end;

procedure TfrmOligoNotes.mi_copyClick(Sender: TObject);
begin
mm_OligoNotes.copyToClipboard;
end;

procedure TfrmOligoNotes.mi_cutClick(Sender: TObject);
begin
mm_OligoNotes.cuttoclipboard;
end;

procedure TfrmOligoNotes.mi_pasteClick(Sender: TObject);
begin
if clipboard.HasFormat(cf_text) then
   mm_OligoNotes.pastefromclipboard;
end;

end.
