{u_options.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_options;

interface

uses u_biotools,u_annhyb,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Grids, Outline, DirOutln, ValEdit;

type
  TfrmPreferences = class(TForm)
    Button1: TButton;
    pc_options: TPageControl;
    ts_tm: TTabSheet;
    ts_internet: TTabSheet;
    GroupBox4: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    rb_proxy_server: TCheckBox;
    proxy_server: TEdit;
    proxy_port: TEdit;
    ts_search_align: TTabSheet;
    GroupBox8: TGroupBox;
    lbOligoThreshold: TLabel;
    cbAutomaticCheckBestOligo: TCheckBox;
    edOligoThreshold_seq: TEdit;
    ts_mec: TTabSheet;
    GroupBox7: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    rb: TRadioButton;
    rb09: TRadioButton;
    rbMEC: TRadioButton;
    edA: TEdit;
    edC: TEdit;
    edG: TEdit;
    edT: TEdit;
    ts_print: TTabSheet;
    ts_seq_reader: TTabSheet;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    cb_readseq: TCheckBox;
    TabSheet7: TTabSheet;
    GroupBox5: TGroupBox;
    colbox: TColorBox;
    Label21: TLabel;
    btAddAddress: TButton;
    btDelAdress: TButton;
    gb_oligo_color_pref: TGroupBox;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    gb_TM_short_seq: TGroupBox;
    gb_tm_parameters: TGroupBox;
    rb_breslauer1986: TRadioButton;
    rb_allawi1997: TRadioButton;
    GroupBox2: TGroupBox;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    defaut_sel_seq: TEdit;
    defaut_amorces_seq: TEdit;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    defaut_sel: TEdit;
    defaut_amorces: TEdit;
    gb_TM_long_seq: TGroupBox;
    long_seq_salt_tm: TEdit;
    lb_salt_conc: TLabel;
    Label34: TLabel;
    ts_Update: TTabSheet;
    cb_check_update: TCheckBox;
    GroupBox9: TGroupBox;
    cb_includedate: TCheckBox;
    GroupBox10: TGroupBox;
    cb_AskBeforeClosingResults: TCheckBox;
    ts_font: TTabSheet;
    FontDialog1: TFontDialog;
    bt_seq_header_font: TButton;
    ed_seq_header_font: TEdit;
    ed_seq_features_font: TEdit;
    bt_seq_features_font: TButton;
    ed_seq_font: TEdit;
    Button3: TButton;
    ed_treeview_font: TEdit;
    bt_tv_font: TButton;
    gb_overlapping_color: TGroupBox;
    cd: TColorDialog;
    overlapping_color: TShape;
    gb_alignment_mismatch_color: TGroupBox;
    mismatch_color: TShape;
    edOligoThreshold_ma: TEdit;
    Label35: TLabel;
    Label36: TLabel;
    rgTextFormat: TRadioGroup;
    btCheckNewVersionNow: TButton;
    cbServerURL: TComboBox;
    btEdit: TButton;
    sh_oligo1: TShape;
    sh_oligo2: TShape;
    sh_oligo4: TShape;
    sh_oligo3: TShape;
    sh_oligo5: TShape;
    sh_oligo6: TShape;
    sh_oligo7: TShape;
    sh_oligo8: TShape;
    sh_oligo9: TShape;
    sh_oligo10: TShape;
    sh_oligo11: TShape;
    sh_oligo12: TShape;
    Label37: TLabel;
    btReset: TButton;
    ValueListEditor1: TValueListEditor;
    procedure rb_proxy_serverClick(Sender: TObject);
    procedure rb_TmAlgoClick(Sender: TObject);
    procedure rbClick(Sender: TObject);
    procedure edAKeyPress(Sender: TObject; var Key: Char);
    procedure edAChange(Sender: TObject);
    procedure cbAutomaticCheckBestOligoClick(Sender: TObject);
    procedure edOligoThresholdKeyPress(Sender: TObject; var Key: Char);
    procedure btAddAddressClick(Sender: TObject);
    procedure btDelAdressClick(Sender: TObject);
    procedure numeric_input(Sender: TObject; var Key: Char);
    procedure bt_seq_header_fontClick(Sender: TObject);
    procedure bt_seq_features_fontClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure bt_tv_fontClick(Sender: TObject);
    procedure overlapping_colorMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure rgTextFormatClick(Sender: TObject);
    procedure btCheckNewVersionNowClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure sh_oligo1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btResetClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPreferences: TfrmPreferences;

implementation


{$R *.DFM}

procedure TfrmPreferences.rb_proxy_serverClick(Sender: TObject);
begin
if rb_proxy_server.checked then
   begin
   label12.enabled:=true;
   label13.enabled:=true;
   proxy_server.enabled:=true;
   proxy_port.enabled:=true;
   end
else
   begin
   label12.enabled:=false;
   label13.enabled:=false;
   proxy_server.enabled:=false;
   proxy_port.enabled:=false;
   proxy_server.text:='';
   proxy_port.text:='';
   end;
end;

procedure TfrmPreferences.rb_TmAlgoClick(Sender: TObject);
begin
if rb_breslauer1986.Checked then
   frmMain.setTmAlgo(TmBreslauer1986);
if rb_allawi1997.Checked then
   frmMain.setTmAlgo(TmAllawi1997);
end;

procedure TfrmPreferences.rbClick(Sender: TObject);
begin
if (activecontrol<>rb) and (activecontrol<>rb09) and (activecontrol<>rbMEC) then
   exit;

if (frmMain.tv.selected<>nil) then
    begin
    if frmMain.tv.selected.imageindex=c_oligo then
        frmMain.seqchange(self);
    if frmMain.tv.selected.Text='Oligo' then
        frmMain.show_oligo_list;
    end;
if rb.Checked or rb09.Checked then
   begin
   edA.Enabled:=true;
   edC.Enabled:=true;
   edG.Enabled:=true;
   edT.Enabled:=true;
   end
else
   begin
   edA.Enabled:=false;
   edC.Enabled:=false;
   edG.Enabled:=false;
   edT.Enabled:=false;
   end;
end;

procedure TfrmPreferences.edAKeyPress(Sender: TObject; var Key: Char);
begin
if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TfrmPreferences.edAChange(Sender: TObject);
begin
if frmMain.tv.selected=nil then
   exit;
if frmMain.tv.selected.imageindex=1 then
   frmMain.seqchange(self);
if frmMain.tv.selected.text='Oligo' then
   frmMain.show_oligo_list;
end;

procedure TfrmPreferences.cbAutomaticCheckBestOligoClick(Sender: TObject);
begin
edOligoThreshold_seq.enabled:=cbAutomaticCheckBestOligo.checked;
lbOligoThreshold.enabled:=cbAutomaticCheckBestOligo.checked;
end;

procedure TfrmPreferences.edOligoThresholdKeyPress(Sender: TObject;
  var Key: Char);
begin
if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TfrmPreferences.btAddAddressClick(Sender: TObject);
var ss:shortstring;
    itm:TListitem;
begin
ss:='http://';
repeat
   ss:=InputBox('Add server address','Server address',ss);
   if (ss<>'') and (ss<>'http://') and (pos('*',ss)=0) then
      showmessage('Insert * (asterisk) to indicate the Accession number position');
until (ss<>'') and (ss<>'http://') and (pos('*',ss)<>0);

cbServerURL.Items.add(ss);
end;

procedure TfrmPreferences.btDelAdressClick(Sender: TObject);
begin
cbServerURL.items.Delete(cbServerURL.itemindex);
if cbServerURL.items.count>0 then
   cbServerURL.itemindex:=0
else
   cbServerURL.itemindex:=-1;
end;

procedure TfrmPreferences.numeric_input(Sender: TObject; var Key: Char);
begin
if not (key in [#8,'0'..'9','.']) then
    key:=#0;
end;

procedure TfrmPreferences.bt_seq_header_fontClick(Sender: TObject);
begin
fontDialog1.font:=ed_seq_header_font.Font;
if fontDialog1.Execute then
   ed_seq_header_font.font:=fontDialog1.font;
frmMain.mmheader.font:=ed_seq_header_font.font;
end;

procedure TfrmPreferences.bt_seq_features_fontClick(Sender: TObject);
begin
fontDialog1.font:=ed_seq_features_font.Font;
if fontDialog1.Execute then
   ed_seq_features_font.font:=fontDialog1.font;
frmMain.lvAnnotations.font:=ed_seq_features_font.font;
end;

procedure TfrmPreferences.Button3Click(Sender: TObject);
var mem:integer;
begin
fontDialog1.font:=ed_seq_font.Font;
if fontDialog1.Execute then
   ed_seq_font.font:=fontDialog1.font;
with frmMain do
    begin
    mem:=rxgcgseq.SelStart;
    rxgcgseq.font:=ed_seq_font.font;
    rxgcgseq.SelectAll;
    rxgcgseq.SelAttributes.name:=ed_seq_font.font.name;
    rxgcgseq.SelAttributes.size:=ed_seq_font.font.size;
    rxgcgseq.SelStart:=mem;
    end;
end;

procedure TfrmPreferences.bt_tv_fontClick(Sender: TObject);
begin
fontDialog1.font:=ed_treeview_font.Font;
if fontDialog1.Execute then
   ed_treeview_font.font:=fontDialog1.font;
frmMain.tv.font:=ed_treeview_font.font;
end;

procedure TfrmPreferences.overlapping_colorMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
if cd.execute then
    (sender as tshape).brush.color:=cd.color;
end;

procedure TfrmPreferences.rgTextFormatClick(Sender: TObject);
begin
case rgTextformat.ItemIndex of 0:DefaultTextLineBreakStyle:=tlbsCRLF;
                               1:DefaultTextLineBreakStyle:=tlbsLF;
                               end;//case
end;

procedure TfrmPreferences.btCheckNewVersionNowClick(Sender: TObject);
begin
close;
frmMain.check_version(true);
end;

procedure TfrmPreferences.btEditClick(Sender: TObject);
var ss:shortstring;
begin
ss:=cbServerURL.items[cbServerURL.itemindex];
cbServerURL.items.Delete(cbServerURL.itemindex);
repeat
   ss:=InputBox('Add server address','Server address',ss);
   if (ss<>'') and (ss<>'http://') and (pos('*',ss)=0) then
      showmessage('Insert * (asterisk) to indicate the Accession number position');
until (ss<>'') and (ss<>'http://') and (pos('*',ss)<>0);
cbServerURL.Items.add(ss);
cbServerURL.itemindex:=cbServerURL.items.IndexOf(ss);
end;

procedure TfrmPreferences.sh_oligo1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
if cd.execute then
    (sender as tshape).brush.color:=cd.color;
end;

procedure TfrmPreferences.btResetClick(Sender: TObject);
begin
if MessageDlg('Are you sure to reset all preferences?',mtWarning,[mbYes,mbNo],0)=mrYes then
    begin
    deletefile(ExtractFilePath(Application.ExeName)+'annhyb.ini');
    showmessage('Restart AnnHyb to initialize');
    end;

end;

end.
