{u_re.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit U_re;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, CheckLst;

type
  TfrmRE = class(TForm)
    enz_list: TRadioGroup;
    rresults: TCheckListBox;
    Button6: TButton;
    RadioGroup1: TRadioGroup;
    rb_name: TRadioButton;
    rb_position: TRadioButton;
    rb_freq: TRadioButton;
    Label29: TLabel;
    re_site: TMemo;
    Label31: TLabel;
    noc: TEdit;
    topo: TLabel;
    Label30: TLabel;
    fraglist: TListBox;
    btnClose: TButton;
    procedure enz_listClick(Sender: TObject);
    procedure rresultsClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure rb_nameClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
   { Public declarations }
  end;

var frmRE: TfrmRE;

procedure presentation_re_results;

implementation

uses u_annhyb, u_RestrEnzSelect;

{$R *.dfm}

procedure fragments;
var compt,i,j,frag,k:cardinal;
    s,s1:string[30];
    bd:tstringlist;
    nbands:boolean;
label suite;
begin
with frmRE do
   begin
   bd:=Tstringlist.create;
   bd.sorted:=false;
   re_site.clear;
   re_site.lines.add('');
   fraglist.clear;
   fraglist.sorted:=false;
   compt:=0;
   nbands:=false;
   if rresults.items.count>0 then
      for i:=0 to rresults.items.count-1 do
       begin
       if rresults.checked[i] then
          begin
          nbands:=true;
          //nom enz
          s:=copy(rresults.items[i],1,pos(':',rresults.items[i])-1);
          //dja slectionn?
          k:=0;
          while k<bd.count do
              begin
              if pos('|'+s,bd[k])<>0 then
                 goto suite;
              inc(k);
              end;
          inc(compt);
          k:=0;
          while k<selectedenz.count do
             begin
             if trim(copy(selectedenz[k],1,20))=s then
                break;
             inc(k);
             end;
          //site de coupure
          s1:=trim(copy(selectedenz[k],22,25));
          re_site.lines[0]:=re_site.lines[0]+s+' ('+s1+');  ';
    (*      with image1.canvas.pen do
          case compt of 1:color:=clred;2:color:=clyellow;3:color:=claqua;4:color:=clFuchsia;
                        5:color:=clgreen;6:color:=clLime;7:color:=clPurple;8:color:=clteal;
                        9:color:=clOlive;10:color:=clmaroon;
                        end; *)

          for j:=0 to cutenzlist.count-1 do
              if copy(cutenzlist[j],1,pos('|',cutenzlist[j])-1)=s then
                 if (strtoint(copy(cutenzlist[j],pos('|',cutenzlist[j])+1,255))>=_init) and (strtoint(copy(cutenzlist[j],pos('|',cutenzlist[j])+1,50))<=_end) then
                    begin
          (*          p:=round((xr-2*30)/((fin-deb)/(strtoint(copy(cutenzlist[j],pos('|',cutenzlist[j])+1,50))-deb)));
                    if odd(compt) then
                       begin
                       image1.canvas.moveto(30+p,30);
                       image1.canvas.lineto(30+p,48);
                       if checkbox1.checked then
                          image1.canvas.TextOut(30+p,20,s);
                       end
                    else
                       begin
                       image1.canvas.moveto(30+p,70);
                       image1.canvas.lineto(30+p,53);
                       if checkbox1.checked then
                          image1.canvas.TextOut(20+p,75,s);
                       end; *)
                    //position coupure
                    s1:=copy(cutenzlist[j],pos('|',cutenzlist[j])+1,255);
                    while length(s1)<10 do
                       s1:=' '+s1;
                    if s1='          ' then
                       showmessage('Error');
                    s1:=s1+'|'+s;
                    bd.add(s1);
                    end;
          end;
       suite:
       end;
bd.sort;
frag:=0;

if nbands then
   begin
     frag:=0;
     for j:=0 to bd.count-1 do
         begin
         s1:=inttostr(strtoint(trim(copy(bd[j],1,10)))-frag);
         while length(s1)<10 do
            s1:=' '+s1;
         fraglist.items.add(s1);
         frag:=strtoint(trim(copy(bd[j],1,10)));
         end;
     if frmRestrEnzSelect.rb_lin.checked then
        begin
        s1:=inttostr(ls-frag);
        while length(s1)<10 do
              s1:=' '+s1;
        fraglist.items.add(s1);
        end
     else
        begin
        s1:=inttostr(ls-frag+strtoint(trim(fraglist.items[0])));
        while length(s1)<10 do
              s1:=' '+s1;
        fraglist.items[0]:=s1;
        end;
     //tri ordre dcroissant
     fraglist.sorted:=true;
     if fraglist.items.count>1 then
     for j:=0 to (fraglist.items.count div 2)-1 do
         begin
         s:=fraglist.items[j];
         fraglist.items[j]:=fraglist.items[fraglist.items.count-1-j];
         fraglist.items[fraglist.items.count-1-j]:=s;
         end;
     if frmRestrEnzSelect.rb_lin.checked then
        noc.text:=inttostr(fraglist.items.count-1)
     else
        noc.text:=inttostr(fraglist.items.count);
     end;
   end;
end;


procedure presentation_re_results;
var i,freq:cardinal;
    s,s1,s1mem:string[50];
begin
with frmRE do
begin
if enz_list.itemindex=1 then     //enz that do NOT cut
   begin
   rb_name.checked:=true;
   exit;
   end;
   re_site.clear;
   noc.clear;
   fraglist.clear;
   rresults.clear;
   s1mem:='';
   if rb_name.checked then
      if cutenzlist[0]<>'' then
         begin
         for i:=0 to cutenzlist.count-1 do
             begin
             //nom enzyme
             s:=copy(cutenzlist[i],1,pos('|',cutenzlist[i])-1);
             if s=s1mem then
                s1:=s1+', '+trim(copy(cutenzlist[i],pos('|',cutenzlist[i])+1,255))
             else
                s1:=trim(copy(cutenzlist[i],pos('|',cutenzlist[i])+1,255));

          rresults.items.add(s+': '+s1);
          s1mem:=s;
          end;
      i:=0;
      while i<rresults.items.count-1 do
         begin
         if copy(rresults.Items[i],1,pos(':',rresults.Items[i]))=copy(rresults.Items[i+1],1,pos(':',rresults.Items[i+1])) then
            rresults.items.delete(i)
         else
            inc(i);
         end;
      end;

if rb_position.checked then
   begin
   if cutenzlist[0]<>'' then
      for i:=0 to cutenzlist.count-1 do
          begin
          s:=trim(cutenzlist[i]);
          //nom enz
          s1:=copy(s,1,pos('|',s)-1)+':';
          //pos
          while length(s1)<15 do
                s1:=s1+' ';
          rresults.items.add(s1+trim(copy(s,pos('|',s)+1,255)));
          end;
   frmMain.quicksort(0,cutenzlist.count-1,16);
   end;

if rb_freq.checked then
   begin
   s:=trim(cutenzlist[0]);
   //nom enz
   s1mem:=copy(s,1,pos('|',s)-1);
   freq:=1;
   if cutenzlist[0]<>'' then
      for i:=0 to cutenzlist.count-1 do
          begin
          s:=trim(cutenzlist[i]);
          //nom enz
          s1:=copy(s,1,pos('|',s)-1);
          if (s1=s1mem) and (i<cutenzlist.count-1) then
             inc(freq)
          else
             begin
             s1mem:=s1mem+':';
             while length(s1mem)<15 do
                   s1mem:=s1mem+' ';
             rresults.items.add(s1mem+inttostr(freq));
             freq:=1;
             end;
          s1mem:=s1;
          end;
   frmMain.quicksort(0,rresults.items.count-1,16);
   end;

end; //with
end;


procedure TfrmRE.enz_listClick(Sender: TObject);
var i,j:cardinal;
begin
if enz_list.itemindex=0 then
   presentation_re_results;
if enz_list.itemindex=1 then
   with rresults do
   begin
   rb_name.checked:=true;
   clear;
   items.addstrings(selectedenz);
   i:=0;
   while i<items.count do
        begin
        if items[i]<>'' then
           items[i]:=copy(items[i],1,pos(' ',items[i])-1);
        for j:=0 to cutenzlist.count-1 do
            if items[i]=copy(cutenzlist[j],1,pos('|',cutenzlist[j])-1) then
               begin
               items.delete(i);
               dec(i);
               break;
               end;
         inc(i);
         end;
   end;
end;

procedure TfrmRE.rresultsClick(Sender: TObject);
begin
if enz_list.itemindex=0 then
   fragments;
end;

procedure TfrmRE.Button6Click(Sender: TObject);
var i:cardinal;

begin
if rresults.items.count>0 then
   begin
   for i:=0 to rresults.items.count-1 do
       rresults.checked[i]:=false;
   noc.Text:='';    
   fragments;
   end;
end;

procedure TfrmRE.rb_nameClick(Sender: TObject);
begin
presentation_re_results;
end;

procedure TfrmRE.btnCloseClick(Sender: TObject);
begin
close;
end;

end.





