{u_restenzselect.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_restrenzselect;

interface

uses shellapi,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TfrmRestrEnzSelect = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    avail_re: TEdit;
    select_all: TButton;
    select: TButton;
    deselect: TButton;
    deselect_all: TButton;
    ListBox2: TListBox;
    selected_re: TEdit;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    save_re_base: TButton;
    load_re_base: TButton;
    Button4: TButton;
    RadioGroup1: TRadioGroup;
    rb_lin: TRadioButton;
    rb_circ: TRadioButton;
    Button1: TButton;
    Button2: TButton;
    procedure select_allClick(Sender: TObject);
    procedure selectClick(Sender: TObject);
    procedure deselect_allClick(Sender: TObject);
    procedure save_re_baseClick(Sender: TObject);
    procedure load_re_baseClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmRestrEnzSelect: TfrmRestrEnzSelect;

implementation

uses u_annhyb;

{$R *.DFM}

procedure TfrmRestrEnzSelect.select_allClick(Sender: TObject);
begin
if sender=select_all then
   begin
   ListBox2.Items.AddStrings(ListBox1.Items);
   listbox1.clear;
   end
else
   begin
   ListBox1.Items.AddStrings(ListBox2.Items);
   listbox2.clear;
   end;

avail_re.text:=inttostr(listbox1.items.count);
selected_re.text:=inttostr(listbox2.items.count);
end;

procedure TfrmRestrEnzSelect.selectClick(Sender: TObject);
var i:cardinal;
begin
i:=0;

if sender=select then
   while i<listbox1.items.count do
      begin
      avail_re.text:=inttostr(i);
      if listbox1.selected[i] then
          begin
          listbox2.items.add(listbox1.items[i]);
          listbox1.items.delete(i);
          end
       else
          inc(i);
      end
else //sender=deselect
    while i<listbox2.items.count do
      begin
      if listbox2.selected[i] then
          begin
          listbox1.items.add(listbox2.items[i]);
          listbox2.items.delete(i);
          end
    else
       inc(i);
    end;
avail_re.text:=inttostr(listbox1.items.count);
selected_re.text:=inttostr(listbox2.items.count);
end;

procedure TfrmRestrEnzSelect.deselect_allClick(Sender: TObject);
begin
ListBox1.Items.AddStrings(ListBox2.Items);
listbox2.clear;
end;

procedure TfrmRestrEnzSelect.save_re_baseClick(Sender: TObject);
begin
if listbox2.items.count=0 then
   begin
   showmessage('Select restriction enzymes first!');
   exit;
   end;
if frmMain.savedialog1.execute then
   begin
   if fileexists(frmMain.savedialog1.filename) then
      if MessageDlg('This RE base already exists! Overwrite it?', mtWarning, [mbYes, mbNo], 0)=mrno then
         exit;
   listbox2.items.savetofile(frmMain.savedialog1.filename);
   end;
end;

procedure TfrmRestrEnzSelect.load_re_baseClick(Sender: TObject);
begin
if frmMain.od.execute then
   begin
   listbox2.items.clear;
   listbox2.items.loadfromfile(frmMain.od.filename);
   end;
end;

procedure TfrmRestrEnzSelect.Button4Click(Sender: TObject);
begin
selectedenz.addstrings(listbox2.items);
listbox1.clear;
listbox2.clear;
end;

procedure TfrmRestrEnzSelect.FormActivate(Sender: TObject);
var i:cardinal;
begin
flagiso:=false;
frmRestrEnzSelect.checkbox1.checked:=false;
frmRestrEnzSelect.listbox1.clear;
frmRestrEnzSelect.listbox2.clear;
flagselectedenz:=true;
for i:=0 to totenzlist.count-1 do
    if not flagiso then
       begin
       if totenzlist[i][21]=' ' then
          frmRestrEnzSelect.listbox1.items.add(totenzlist[i]);
       end
    else
        frmRestrEnzSelect.listbox1.items.add(totenzlist[i]);
frmRestrEnzSelect.avail_re.text:=inttostr(frmRestrEnzSelect.listbox1.items.count);
end;

procedure TfrmRestrEnzSelect.CheckBox1Click(Sender: TObject);
var i:cardinal;
begin
if checkbox1.checked then
   flagiso:=true
else
   flagiso:=false;
listbox1.clear;
listbox2.clear;
for i:=0 to totenzlist.count-1 do
    if not flagiso then
       begin
       if totenzlist[i][21]=' ' then
          listbox1.items.add(totenzlist[i]);
       end
    else
        listbox1.items.add(totenzlist[i]);
avail_re.text:=inttostr(listbox1.items.count);
end;

procedure TfrmRestrEnzSelect.Button2Click(Sender: TObject);
begin
ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\restriction.html'),Nil,Nil,SW_NORMAL);
end;

end.
