{unit9.pas - AnnHyb
 	Copyright (C) 1997-frmPreferences Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

Copyright (C) 1997-frmPreferences Olivier Friard

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_results;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,printers, Menus, RxRichEd, ToolWin, ComCtrls;

type
  TfrmResults = class(TForm)
    MainMenu1: TMainMenu;
    Results1: TMenuItem;
    Close1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    N1: TMenuItem;
    Selectall1: TMenuItem;
    Saveas1: TMenuItem;
    RxResults: TRxRichEdit;
    N2: TMenuItem;
    N3: TMenuItem;
    Print1: TMenuItem;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Selectall1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var frmResults: TfrmResults;
    flag_data_saved:boolean;

implementation

uses u_annhyb, u_options, u_confirmfile;

{$R *.dfm}

procedure TfrmResults.Button3Click(Sender: TObject);
begin
frmMain.savedialog1.filter:='';
frmMain.savedialog1.defaultext:='';
if frmMain.savedialog1.execute then
   begin
   if fileexists(frmMain.savedialog1.filename) then
      begin
      if messagedlg('This file already exists! Overwrite it?',mtConfirmation,[mbYes,mbCancel],0)=mrYes then
         rxresults.lines.savetofile(frmMain.savedialog1.filename);
      end
   else
      rxresults.lines.savetofile(frmMain.savedialog1.filename);
   end;
end;

procedure TfrmResults.Button2Click(Sender: TObject);
var ft:textfile;
begin
if frmMain.printdialog1.execute then
   begin
   printer.canvas.font.name:='Courier New';
   printer.canvas.font.size:=10;
   printer.canvas.font.style:=[];
   AssignPrn(ft);
   Rewrite(ft);
   writeln(ft,rxresults.text);
   system.closefile(ft);
   end;

end;

procedure TfrmResults.Button4Click(Sender: TObject);
begin
rxresults.selectall;
end;

procedure TfrmResults.Button5Click(Sender: TObject);
begin
rxresults.copytoclipboard;
end;

procedure TfrmResults.Selectall1Click(Sender: TObject);
begin
rxresults.selectall;
end;

procedure TfrmResults.Copy1Click(Sender: TObject);
begin
rxresults.copytoclipboard;
end;

procedure TfrmResults.Saveas1Click(Sender: TObject);
var fichier:textfile;
    i:integer;
begin
with frmMain do    { TODO 1 : vrifier fonction append results }
    begin
    savedialog1.filter:='';
    savedialog1.defaultext:='';
    savedialog1.filename:='';
    if savedialog1.execute then
        begin
        assignfile(fichier,savedialog1.filename);
        flag_data_saved:=true;
        if fileexists(savedialog1.filename) then
            begin
            frmConfirmFile.btAppend.visible:=true;
            frmConfirmFile.lbMessage.caption:='The file '+savedialog1.filename+' already exists!';

            frmConfirmFile.showmodal;
            if frmConfirmFile.modalresult=mrCancel then
               exit;
            if frmConfirmFile.modalresult=mrYes then
                rewrite(fichier);
            if frmConfirmFile.modalresult=mrNo then
                append(fichier);
            end
        else
            rewrite(fichier);
        for i:=0 to rxResults.lines.count-1 do
            writeln(fichier,rxResults.lines[i]);
        flush(fichier);
        closefile(fichier);
        end;


//                rxresults.lines.savetofile(savedialog1.filename);

    end;//with frmMain
end;

procedure TfrmResults.Close1Click(Sender: TObject);
begin
close;
end;

procedure TfrmResults.Print1Click(Sender: TObject);
var t:byte;
    i:integer;
    ft:textfile;
begin

with frmMain do
    begin
    PrintDialog1.Options:=[];
    if printdialog1.execute then
        for t:=1 to printdialog1.Copies do
            begin
            AssignPrn(ft);
            Rewrite(ft);
            printer.canvas.font.name:='Courier New';
            printer.canvas.font.size:=9;
            printer.canvas.font.style:=[];
            for i:=0 to rxResults.lines.count-1 do
                writeln(ft,rxResults.lines[i]);
            System.CloseFile(ft);
            end;
    end;



(*
if frmMain.printdialog1.execute then
   begin
   flag_data_saved:=true;
   rxResults.print(frmResults.caption);
   end;
*)
end;

procedure TfrmResults.FormShow(Sender: TObject);
begin
flag_data_saved:=false;
rxResults.setfocus;
rxResults.SelStart:=0;
end;

procedure TfrmResults.FormClose(Sender: TObject; var Action: TCloseAction);
begin
if frmPreferences.cb_AskBeforeClosingResults.Checked then
   if not flag_data_saved then
      if MessageDlg('Are you sure you want to close?',mtConfirmation,[mbYes,mbNo],0)=mrNo then
         action:=canone;
end;

end.
