{u_seqselect.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_seqselect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TfrmSeqSelect = class(TForm)
    lvSeqSelect: TListView;
    bt_OK: TButton;
    bt_cancel: TButton;
    bt_select: TButton;
    Button1: TButton;
    Button2: TButton;
    edKWSelect: TEdit;
    Label1: TLabel;
    procedure bt_selectClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure edKWSelectKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSeqSelect: TfrmSeqSelect;

implementation

{$R *.dfm}

procedure TfrmSeqSelect.bt_selectClick(Sender: TObject);
var i:integer;
begin
for i:=0 to lvSeqSelect.items.count-1 do
    if sender=bt_select then
       lvSeqSelect.items[i].checked:=true
    else
       lvSeqSelect.items[i].checked:=false;
end;

procedure TfrmSeqSelect.Button2Click(Sender: TObject);
var i:integer;
begin
for i:=0 to lvSeqSelect.items.count-1 do
    lvSeqSelect.items[i].checked:=not lvSeqSelect.items[i].checked;
end;

procedure TfrmSeqSelect.edKWSelectKeyPress(Sender: TObject; var Key: Char);
var i:integer;
begin
if (key=#13) and (edKWSelect.text<>'') then
    for i:=0 to lvSeqSelect.items.count-1 do
        begin
        if pos(ansiuppercase(edKWSelect.text),ansiuppercase(lvSeqSelect.items[i].caption))<>0 then
           lvSeqSelect.items[i].checked:=true;
        end;
end;

end.
