{u_strinsearch.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)
 
  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_stringsearch;

interface

uses shellapi,u_biotools,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmStringSearch = class(TForm)
    query: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    cbBothSenses: TCheckBox;
    Button4: TButton;
    procedure Button3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure queryKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var frmStringSearch: TfrmStringSearch;

implementation

uses u_options, u_annhyb;

{$R *.dfm}

procedure TfrmStringSearch.Button3Click(Sender: TObject);
begin
query.clear;
end;

procedure TfrmStringSearch.FormActivate(Sender: TObject);
begin
query.setfocus;
end;

procedure TfrmStringSearch.Button4Click(Sender: TObject);
begin
if caption='Quick search sub-sequence' then
   ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\quicksearchseq.html'),Nil,Nil,SW_NORMAL)
else
   ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'manual\alignseq.html'),Nil,Nil,SW_NORMAL);
end;

procedure TfrmStringSearch.queryKeyPress(Sender: TObject; var Key: Char);
begin
if (not (key in [#22,#3,#13,' ',#8,'(',')'])) and (not (upcase(key) in validbase)) then
    key:=#0
else if upcase(key) in validbase then
    begin
    if frmPreferences.cb_readseq.Checked then
       frmMain.PlaySound(program_dir+key+'.wav');
    end;
end;

end.
