unit u_translate;

interface
function trans(seqname:shortstring;sl:string;frame:shortstring;aa:byte;flag_include_nt:boolean):string;


implementation
uses sysutils,u_biotools,dialogs;

function trans(seqname:shortstring;sl:string;frame:shortstring;aa:byte;flag_include_nt:boolean):string;
var t,t1:integer;
    flagCodonFound:boolean;
    ff:byte;
    codon:string[3];
    tr:array[1..6] of string;
    r,s3,s2:string;

label end_translate;

begin
//3 cadres sens
for ff:=1 to 3 do
    begin
    t:=ff;
    tr[ff]:='';
    if pos(inttostr(ff),frame)=0 then
        continue;
    while t<=length(sl)-3+1 do
        begin
        codon:=sl[t]+sl[t+1]+sl[t+2];
        flagCodonFound:=false;
        for t1:=1 to 21 do
            if pos(codon,cg1[t1])<>0 then
                begin
                flagCodonFound:=true;
                if aa=3 then  //3 letters aa
                    tr[ff]:=tr[ff]+cg2[t1]
                else
                    tr[ff]:=tr[ff]+cg3[t1]+'  ';
                break;
                end;
        if not flagCodonFound then
           tr[ff]:=tr[ff]+' ? ';

        inc(t,3);
        end;
    end; //for f

//3 cadres antisens
for ff:=4 to 6 do
    begin
    t:=length(sl)+4-ff;
    tr[ff]:='';
    if pos(inttostr(ff),frame)=0 then
        continue;
    while t>=3 do
        begin
        codon:=rev_(sl[t])+rev_(sl[t-1])+rev_(sl[t-2]);
        flagCodonFound:=false;
        for t1:=1 to 21 do
            if pos(codon,cg1[t1])<>0 then
                begin
                flagCodonFound:=true;
                if aa=3 then  //3 letters aa
                   tr[ff]:=cg2[t1]+tr[ff]
                else
                   tr[ff]:='  '+cg3[t1]+tr[ff];
                break;
                end;
        if not flagCodonFound then
            tr[ff]:=' ? '+tr[ff];
        dec(t,3);
        end;
   end; //for f

//output
if (length(frame)=1) and (not flag_include_nt) then
    begin
    for ff:=1 to 6 do
        if tr[ff]<>'' then
            begin
            while tr[ff]<>'' do
                begin
                r:=r+copy(tr[ff],1,60)+crlf;
                delete(tr[ff],1,60);
                end;
            end;
    end
else
    begin
    //offset
    t1:=length(sl);
    if t1 mod 3=0 then
      begin
      tr[5]:='  '+tr[5];
      tr[6]:=' '+tr[6];
      end;
    if t1 mod 3=1 then
      begin
      tr[4]:=' '+tr[4];
      tr[6]:='  '+tr[6];
      end;
    if t1 mod 3=2 then
      begin
      tr[4]:='  '+tr[4];
      tr[5]:=' '+tr[5];
      end;
    t:=1;

    while sl<>'' do
        begin
        for ff:=1 to 3 do
            if pos(inttostr(ff),frame)<>0 then
                begin
                s3:=copy(tr[ff],1,60);
                delete(tr[ff],1,60);
                r:=r+'   '+inttostr(ff)+':     '+copy('  ',1,ff-1)+s3+crlf;
                end;

        r:=r+crlf;

        //nucleotide
        if flag_include_nt then
            begin
            //seq sense
            s3:=copy(sl,1,60);
            r:=r+'          '+s3+crlf;
            s2:=inttostr(t)+' ';
            while length(s2)<10 do
                s2:=' '+s2;

            //separator
            for t1:=1 to length(s3) do
                if t1 mod 10=0 then
                    s2:=s2+'+'
                else
                    s2:=s2+'-';
            r:=r+s2+crlf;

            //seq antisense
            s2:='';
            for t1:=1 to length(s3) do
                s2:=s2+rev_(s3[t1]);
            r:=r+'          '+s2+crlf+crlf;
            end;

        for ff:=4 to 6 do
            if pos(inttostr(ff),frame)<>0 then
                begin
                s3:=copy(tr[ff],1,60);
                delete(tr[ff],1,60);
                r:=r+'   '+inttostr(ff)+':     '+s3+crlf;
                end;

        r:=r+crlf+crlf;
        delete(sl,1,60);
        inc(t,60);
        end;
    end;
end_translate:
trans:=r;

end; //translate


end.
