{u_update.pas - AnnHyb
 	Copyright (C) 1997-2012 Olivier Friard
        (annhyb @ gmail.com)

  This file is part of AnnHyb.

AnnHyb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AnnHyb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with AnnHyb; see the file COPYING.TXT.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit u_update;

interface

uses shellapi,IdException,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP;

type
  TfrmUpdate = class(TForm)
    btClose: TButton;
    Label1: TLabel;
    btDownload: TButton;
    IdHTTP1: TIdHTTP;
    procedure btCloseClick(Sender: TObject);
    procedure btDownloadClick(Sender: TObject);
    procedure IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmUpdate: TfrmUpdate;

implementation

uses u_annhyb;

{$R *.dfm}

procedure TfrmUpdate.btCloseClick(Sender: TObject);
begin
close;
end;

procedure TfrmUpdate.btDownloadClick(Sender: TObject);
var st:tMemoryStream;
begin
if frmMain.flagWorkspaceChanged then
    begin
    if MessageDlg('Save project?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
        frmMain.mi_SaveProjectClick(frmMain.mi_SaveProject)
    else
        begin
        showmessage('AnnHyb will not be updated');
        close;
        exit;
        end;
    end;

btDownload.enabled:=false;
btClose.enabled:=false;

label1.caption:='Downloading new version of AnnHyb'+#13#10+'Please wait...';
application.ProcessMessages;
st:=tmemorystream.create;
try
    idhttp1.get(annhyb_site+'softwares/annhyb_setup.exe',st);
    label1.caption:='New version of AnnHyb downloaded';
    application.ProcessMessages;
    st.savetofile(ExtractFilePath(Application.ExeName)+'annhyb_setup.exe');
    ShellExecute(0,Nil,PChar(ExtractFilePath(Application.ExeName)+'annhyb_setup.exe'),Nil,Nil,SW_NORMAL);
    application.terminate;
except
//    on EIdSocketError do
         frmUpdate.label1.caption:='Check your internet connection!';
end; //try
btClose.enabled:=false;
st.free;
end;

procedure TfrmUpdate.IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
begin
application.ProcessMessages;
end;

end.
