#!/usr/bin/env python
"""Display the SeqFeatures produced by the parser.

This produces a ton of output so it is possible to hand check what is
produced by the parser with the original GenBank file to make sure
everything is being parsed and output properly.

Usage:
./check_output.py <GenBank file to parse>
"""
# standard library
import sys

# GenBank stuff to test
from Bio.PGML.GenBank import GenBank

if len(sys.argv) != 2:
    print "Usage ./check_output.py <GenBank file to parse>"
    sys.exit()

parser = GenBank.FeatureParser(debug_level = 0)

handle = open(sys.argv[1], 'r')

iterator = GenBank.Iterator(handle, parser)

cur_record = iterator.next()

while cur_record:
    print "***Record"
    print "Seq:", cur_record.seq
    print "Id:", cur_record.id
    print "Name:", cur_record.name
    print "Description", cur_record.description
    print "Annotations", cur_record.annotations
    print "Feaures"
    for feature in cur_record.features:
        print feature

    
    cur_record = iterator.next()

handle.close()
    


