#!/usr/bin/env python
"""Test the GenBank parser and make sure everything is working smoothly.
"""
# standard library
import os
import copy

# Biopython
from Bio import File

# GenBank stuff to test
from Bio.PGML.GenBank import GenBank

files_to_parse = [os.path.join(os.getcwd(), 'GenBank', 'cor6_6.gb')]
files_to_parse += [os.path.join(os.getcwd(), 'GenBank', 'arab1.gb')]

# parse the Arabidospsis genome
"""
base_dir = os.path.join(os.getcwd(), os.pardir, "cmp_info", "server")
files_to_parse = [os.path.join(base_dir, "chr1", "chr1.gb"),
                  os.path.join(base_dir, "chr2", "chr2.gb"),
                  os.path.join(base_dir, "chr3", "chr3.gb"),
                  os.path.join(base_dir, "chr4", "chr4.gb"),
                  os.path.join(base_dir, "chr5", "chr5.gb")]
"""

# parse the bioperl test files
# comment this out for now -- there are a bunch of junky records in here
# that no longer exist in GenBank -- do we really need to support those?
# files_to_parse += [os.path.join(os.getcwd(), 'GenBank', 'bioperl_test.gb')]

# parse the biojava test files
files_to_parse += [os.path.join(os.getcwd(), 'GenBank', 'biojava_test.gb')]

parser = GenBank.FeatureParser(debug_level = 0)
for file in files_to_parse:
    handle = open(file, 'r')
    iterator = GenBank.Iterator(handle, parser)

    cur_record = iterator.next()

    while cur_record:
        print "***Record"
        print "Seq:", cur_record.seq
        print "Id:", cur_record.id
        print "Name:", cur_record.name
        print "Description", cur_record.description
        print "Annotations", cur_record.annotations
        print "Feaures"
        for feature in cur_record.features:
            print feature

    
        cur_record = iterator.next()

    handle.close()
    


