/*

Copyright 2010 Brian Caffrey, Tom Williams, Mario Fares.


this file is part of Clusterfunc.

    Clusterfunc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Clusterfunc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Clusterfunc.  If not, see <http://www.gnu.org/licenses/>.


*/




#include"create.h"

int create_seq(int arg, TreeTemplate<Node>*& mytree, vector<string>& Tname, vector<string>& tseqs, unsigned int length)
{

	if(arg == 1)
	{
		cerr << "Error: Could not call Create" << endl;
		exit(0);
	}

	try {
		TreeTemplate<Node>* trantree;
		trantree = mytree;
		Alphabet * alphabet = new ProteicAlphabet(); 
		vector<TreeTemplate<Node> *> trees;
		vector<double> positions;
		trees.push_back(trantree);
		positions.push_back(0);
		positions.push_back(1);
		vector<Node *> nodes = trees[0]->getNodes();
		for(unsigned int i = 0; i < nodes.size(); i++)
		{
			if(nodes[i]->isLeaf())
				nodes[i]->setName(TextTools::toString(nodes[i]->getId()) + "_" + nodes[i]->getName());
			else
				nodes[i]->setBranchProperty("NodeId", String(TextTools::toString(nodes[i]->getId())));
		}
		Newick treeWriter;
		treeWriter.enableExtendedBootstrapProperty("NodeId");


		const ProteicAlphabet * alpha = dynamic_cast<const ProteicAlphabet *>(alphabet);
		SubstitutionModel * model = new JCprot(alpha); 
		FrequenciesSet* fSet = new FixedFrequenciesSet(model->getAlphabet(), model->getFrequencies());
		DiscreteDistribution * rDist = new ConstantDistribution(1.);
		NonHomogeneousSequenceSimulator * seqsim = new NonHomogeneousSequenceSimulator(model, rDist, trees[0]);
		SiteContainer * sites = seqsim->simulate(length);
		delete seqsim;

		Tname = sites->getSequencesNames();
		for(unsigned int i=0;i<Tname.size();++i){
			const Sequence* myseq = sites->getSequence(Tname[i]);
			tseqs.push_back(myseq->toString());
		}

//		delete fSet;
		delete model;
		delete sites;
		delete alphabet;
		delete rDist;
	}
	catch(exception & e)
	{
		cerr << e.what() << endl;
		exit(-1);
	}
	return (0);
}

