
/*

Copyright 2010 Brian Caffrey, Tom Williams, Mario Fares.


this file is part of Clusterfunc.

    Clusterfunc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Clusterfunc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Clusterfunc.  If not, see <http://www.gnu.org/licenses/>.


*/
#include<stdio.h>
#include<iostream>
#include<fstream>
#include<string.h>
#include<map>
#include<vector>
#include<math.h>
#include<gsl/gsl_randist.h>
#include<gsl/gsl_rng.h>
#include<gsl/gsl_cdf.h>



#include <NumCalc/AutoParameter.h>
#include <Seq/SiteTools.h>
#include <Seq/AlignedSequenceContainer.h>
#include <Seq/SequenceApplicationTools.h>

#include<Phyl/DistanceEstimation.h>
#include <Phyl/NonHomogeneousSequenceSimulator.h>
#include <Phyl/BioNJ.h>
#include <Phyl/PhylogeneticsApplicationTools.h>
#include <Phyl/SequenceSimulationTools.h>
#include <Phyl/SubstitutionModelSetTools.h>
#include <Phyl/Newick.h>

// From NumCalc:
#include <NumCalc/ConstantDistribution.h>
#include <NumCalc/DataTable.h>

// From Utils:
#include <Utils/ApplicationTools.h>
#include <Utils/AttributesTools.h>
//#include"stats.h"
#include"file_manip.h"
//#include "fd_tree.h"


using namespace bpp;


struct array{
	int fd;
	int total;
};

using namespace std;




class fd_matrix{
	public:
		vector< vector<int> > fd;
		vector< vector<int> > totals;
		vector<string> species;
		vector<string> tags;

};

class final_matrix{
	public:
		vector< vector<int> > values;
		vector<string> species;
		vector<string> tags;

};

void read_fd_matrix(const char* filename, fd_matrix& tempfd);
int getSpecieslocation(string& speciestemp, vector<string>& species);
int getTaglocation(string& Tagstemp, vector<string>& Tags);


void read_fd_matrix(const char* filename, fd_matrix& tempfd){

	fstream file1(filename);
	char buffer[10000];
	vector<string> tokens;
	int k=0;
	file1.getline(buffer, 10000);
	string temp(buffer);
	Tokenize(temp, tokens, "\t");
	for(int k=1;k<tokens.size();++k){
		tempfd.tags.push_back(tokens[k]);
		//	cerr << Tags[k-1] << "\t";
	}			
	vector<int> tempvec;
	tempvec.insert(tempvec.begin(), tokens.size()-1, 0);	
	while(file1.getline(buffer, 10000)){
		temp=buffer;
		tokens.clear();
		Tokenize(temp, tokens, "\t");
		tokens[0].erase(tokens[0].begin()+5, tokens[0].end());
		int species_loc=getSpecieslocation(tokens[0], tempfd.species);
		if(species_loc == -1){
		tempfd.species.push_back(tokens[0]);					
		tempfd.fd.push_back(tempvec);
		tempfd.totals.push_back(tempvec);
		for(int j=1;j<tokens.size();++j){
			vector<string> tok;
			Tokenize( tokens[j].c_str(), tok,  "/");

			tempfd.fd[k][j-1]=atoi(tok[0].c_str());
			tempfd.totals[k][j-1]=atoi(tok[1].c_str());

		}
		++k;
		}else{
			
		for(int j=1;j<tokens.size();++j){
			vector<string> tok;
			Tokenize(tokens[j].c_str(), tok,  "/");

			tempfd.fd[species_loc][j-1]+=atoi(tok[0].c_str());
			tempfd.totals[species_loc][j-1]+=atoi(tok[1].c_str());

		}
		}
	
	}
	file1.close();
}


int getSpecieslocation(string& speciestemp, vector<string>& species){

	for(int i=0;i<species.size();++i){
		if(speciestemp==species[i]){
			return i;
		}
	}
	return -1;
}


int getTaglocation(string& Tagstemp, vector<string>& Tags){

	for(int i=0;i<Tags.size();++i){
		if(Tags[i]==Tagstemp){
			return i;
		}
	}
	return -1;
}
