
/*

Copyright 2010 Brian Caffrey, Tom Williams, Mario Fares.


this file is part of Clusterfunc.

    Clusterfunc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Clusterfunc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Clusterfunc.  If not, see <http://www.gnu.org/licenses/>.


*/
#include"stats.h"
#include"merge.h"



int getTaglocation(string& Tagstemp, vector<string>& Tags);
int getSpecieslocation(string& speciestemp, vector<string>& species);
//void enrichment(vector< vector<int> > speciestotal, vector< vector<int> > fdtotal, vector<string> TagNames, vector<string> SpeciesNames);




int main(int argc, char *argv[]){


	if(argc!=2){
		cerr << "Error: You need to enter a number of matrices, each should be called matrix1.txt, matrix2.txt... and in this folder" << endl;
		exit(-1);
	}
	int total = atoi(argv[1]);


	fd_matrix total_matrix;
	for(int i=0;i<total;++i){

		//	cerr << "i=" << i << endl;
		char filename[100];
		sprintf(filename, "matrix%d.txt", i);
		//cerr << filename << endl;

		if(i==0){
			read_fd_matrix(filename, total_matrix);
		/*	for(int k=0;k<total_matrix.species.size();++k){
			cerr << "species[" << k << "]=" << total_matrix.species[k] << endl;
}
*/
		}else{
			fd_matrix temp_matrix;
			read_fd_matrix(filename, temp_matrix);
			for(int k=0;k<temp_matrix.species.size();++k){
			//cerr << "species[" << k << "]=" << temp_matrix.species[k] << endl;


				for(int j=0;j<temp_matrix.tags.size();++j){
				int specloc = getSpecieslocation(temp_matrix.species[k], total_matrix.species);
			//cerr << "specloc=" << specloc << endl;
					int tagloc = getTaglocation(temp_matrix.tags[j], total_matrix.tags);	

					if(specloc!=-1 && tagloc!=-1){
						total_matrix.fd[specloc][tagloc]+=temp_matrix.fd[k][j];
						total_matrix.totals[specloc][tagloc]+=temp_matrix.totals[k][j];

					}else if(tagloc == -1 && specloc !=-1){
						total_matrix.tags.push_back(temp_matrix.tags[j]);	
						for(int l=0;l<total_matrix.species.size();++l){
							total_matrix.totals[l].push_back(0);
							total_matrix.fd[l].push_back(0);
						}
						total_matrix.fd[specloc][total_matrix.tags.size()-1]+=temp_matrix.fd[k][j];
						total_matrix.totals[specloc][total_matrix.tags.size()-1]+=temp_matrix.totals[k][j];

					}else if(specloc == -1 && tagloc !=-1){
						total_matrix.species.push_back(temp_matrix.species[k]);
						vector<int> tempo(total_matrix.tags.size(), 0);
						total_matrix.fd.push_back(tempo);
						total_matrix.totals.push_back(tempo);

						total_matrix.fd[total_matrix.species.size()-1][tagloc]+=temp_matrix.fd[k][j];
						total_matrix.totals[total_matrix.species.size()-1][tagloc]+=temp_matrix.totals[k][j];

					}else if(specloc==-1 && tagloc ==-1){

						total_matrix.species.push_back(temp_matrix.species[k]);
						vector<int> tempo(total_matrix.tags.size(), 0);
						total_matrix.fd.push_back(tempo);
						total_matrix.totals.push_back(tempo);
						total_matrix.tags.push_back(temp_matrix.tags[j]);	
						for(int l=0;l<total_matrix.species.size();++l){
							total_matrix.totals[l].push_back(0);
							total_matrix.fd[l].push_back(0);
						}
						total_matrix.fd[total_matrix.species.size()-1][total_matrix.tags.size()-1]+=temp_matrix.fd[k][j];
						total_matrix.totals[total_matrix.species.size()-1][total_matrix.tags.size()-1]+=temp_matrix.totals[k][j];

					}

				}

			}

		}
	}



	vector<int> tag_enrichment;
	vector<int> species_enrichment;
	vector< vector<int> > species_tag_enrichment;
	Tag_enrichment(total_matrix.fd, total_matrix.totals, tag_enrichment);
	Species_enrichment(total_matrix.fd, total_matrix.totals, species_enrichment);
	Species_tag_enrichment(total_matrix.fd, total_matrix.totals, species_tag_enrichment);

	ofstream enrich;
	enrich.open("Enrichment.txt");
	enrich << "Tag Enrichment" << endl;

	for(int i=0;i<total_matrix.tags.size();++i){
		enrich << total_matrix.tags[i] << "\t";
		if(tag_enrichment[i]==-1){
			enrich << "Under Enriched" << endl;
		}else if(tag_enrichment[i]==0){
			enrich << "Not Enriched" << endl;
		}else if(tag_enrichment[i]==1){
			enrich << "Over Enriched" << endl;
		}
	}
	enrich << "Species Enrichment" << endl;

	for(int i=0;i<total_matrix.species.size();++i){

		enrich << total_matrix.species[i] << "\t";
		if(species_enrichment[i]==-1){
			enrich << "Under Enriched" << endl;
		}else if(species_enrichment[i]==0){
			enrich << "Not Enriched" << endl;
		}else if(species_enrichment[i]==1){
			enrich << "Over Enriched" << endl;
		}

	}	
	enrich.close();

	//MakeTree(total_matrix.species, species_tag_enrichment);


}

