/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Copyright (C) 1998 Redhat Software Inc. 
 * Authors: Jonathan Blandford <jrb@redhat.com>
 */
#include <config.h>
#include "callbacks.h"
#include "tree.h"
#include "corba-glue.h"
#include "workspace-manager.h"
#include "viewer.h"

extern GtkWidget *main_window;
extern GtkWidget *exit_dialog;
extern GtkWidget *notebook;
extern GtkWidget *create_exit_dialog();
extern GList *workspace_list;
static GtkWidget *about = NULL;

/* this is meant to be called with a foreach to make a list of all modified nodes. */
void
create_templist (node_data *data, GList **list)
{
        if (data->modified == TRUE)
                *list = (g_list_prepend (*list, data));
}
void
exit_callback(GtkWidget *widget, gpointer data) 
{
        GList* templist = NULL;
        
        if (exit_dialog)
                gnome_dialog_close (GNOME_DIALOG (exit_dialog));

        g_list_foreach (workspace_list, create_templist, &templist);

        if (!templist) {
                gtk_widget_destroy (main_window);
                browser_corba_gtk_main_quit();
                return;
        }                
        exit_dialog = create_exit_dialog(templist);
        gtk_widget_show(GTK_WIDGET(exit_dialog));
}
void
exit_dialog_ok_callback(GtkWidget *widget, gpointer data)
{
        gtk_widget_destroy (main_window);
        browser_corba_gtk_main_quit();
}
void
exit_dialog_cancel_callback(GtkWidget *widget, gpointer data)
{
        gnome_dialog_close (GNOME_DIALOG (exit_dialog));
        exit_dialog = NULL;
}
void
help_callback (GtkWidget *widget, gpointer data)
{
        gchar *tmp;
        tmp = gnome_help_file_find_file ("users-guide", "gcc.html");
        if (tmp) {
                gnome_help_goto(0, tmp);
                g_free(tmp);
        }
}
static void
delete_callback (GtkWidget *widget, gpointer data)
{
        about = NULL;
}
void
about_callback (GtkWidget *widget, gpointer data)
{
	gchar *authors[] = {
                "SooHaeng Yoo <yoo@theoalpha.korea.ac.kr>",
		NULL
	};

        if (about == NULL) {
                about = gnome_about_new(_("DND"), VERSION,
                                        "(C) 1999 the Free Software Foundation ",
                                        (const gchar **) authors,
					_("DND package is a GUI program "
                                        "for using Molecular Dynamics "),
                                        NULL);
                gtk_signal_connect (GTK_OBJECT (about), "destroy", delete_callback, NULL);
        }
        gtk_widget_show(about);
}
void
exit_row_callback(GtkWidget *widget, gint row, gint column, GdkEventButton * event, gpointer nulldata)
{
        node_data *data;

        
        if (event && event->type == GDK_2BUTTON_PRESS) {
                data = (node_data *) gtk_clist_get_row_data (GTK_CLIST (widget),row);
                gnome_dialog_close (GNOME_DIALOG (exit_dialog));
                exit_dialog = NULL;
                launch_workspace (data, TRUE);
        }
}

void
open_callback (GtkWidget *widget, gpointer data)
{
        viewer_new ();
}
