#include "corba-glue.h"
#include "workspace-manager.h"
#include <orb/orbit.h>
#include "gnome.h"
#include <libgnorba/gnorba.h>
#include <gdk/gdkx.h>
#include "viewer.h"
#include "drawer.h"
#include "molecule.h"

/* prototypes */
static void orb_add_connection (GIOPConnection * cnx);
static void orb_remove_connection (GIOPConnection * cnx);
void browser_corba_gtk_init (gint * argc, char **argv);
static void orb_handle_connection (GIOPConnection * cnx, gint source, GdkInputCondition cond);
int server_register_workspace (PortableServer_Servant servant,
			       CORBA_long id,
			       DND_workspace ws,
			       CORBA_Environment * env);
void server_state_changed (PortableServer_Servant servant, CORBA_long id, CORBA_boolean undoable, CORBA_Environment * ev);
void server_register_workspace_new (PortableServer_Servant servant,
				    const DND_workspace ws,
				    const CORBA_char * name,
				    const CORBA_long wsid,
				    CORBA_unsigned_long * xid,
				    CORBA_long * newid,
				    CORBA_Environment * ev);
void server_show_browser (PortableServer_Servant servant, CORBA_Environment * ev);
void server_put_molecule (PortableServer_Servant servant,
			  const CORBA_long mid,
			  CORBA_char *name,
			  CORBA_boolean is_add,
			  CORBA_Environment * ev);
void server_get_molecule (PortableServer_Servant servant,
			  const CORBA_long mid,
			  CORBA_Environment * ev);

extern gchar *init_ws;
extern GtkWidget *tree;
extern GtkWidget *main_window;
/* Variables */
CORBA_ORB orb = NULL;
CORBA_Environment ev;
DND_browser browser = NULL;

gchar *ior;
PortableServer_ServantBase__epv base_epv =
{
  NULL,
  NULL,
  NULL
};
POA_DND_browser__epv browser_epv =
{
  NULL,
  (gpointer) & server_register_workspace,
  (gpointer) & server_state_changed,
  (gpointer) & server_register_workspace_new,
  (gpointer) & server_show_browser,
  (gpointer) & server_put_molecule,
  (gpointer) & server_get_molecule
};

POA_DND_browser__vepv poa_browser_vepv =
{&base_epv, &browser_epv};
POA_DND_browser poa_browser_servant =
{NULL, &poa_browser_vepv};

static void
orb_add_connection (GIOPConnection * cnx)
{
  cnx->user_data = (gpointer) gtk_input_add_full (GIOP_CONNECTION_GET_FD (cnx),
				       GDK_INPUT_READ | GDK_INPUT_EXCEPTION,
				   (GdkInputFunction) orb_handle_connection,
						  NULL, cnx, NULL);
}

static void
orb_remove_connection (GIOPConnection * cnx)
{
  gtk_input_remove ((guint) cnx->user_data);
  cnx->user_data = (gpointer) - 1;
}
void
browser_corba_gtk_main_quit (void)
{
  CORBA_ORB_shutdown (orb, CORBA_FALSE, &ev);
  gtk_main_quit ();
}

static struct poptOption ws_options[] =
{
  {"workspace", '\0', POPT_ARG_STRING, &init_ws, 0, N_ ("workspace-command to be run."), N_ ("WORKSPACE")},
  {NULL, '\0', 0, NULL, 0}
};

void
browser_corba_gtk_init (gint * argc, char **argv)
{
  PortableServer_ObjectId objid =
  {0, sizeof ("browser_interface"), "browser_interface"};
  PortableServer_POA poa;
  GoadServerList *gsd_list = NULL;
  /*
     gsd_list = goad_server_list_get ();
   */
  CORBA_exception_init (&ev);

  orb = gnome_CORBA_init_with_popt_table ("dnd", VERSION, argc, argv, ws_options, 0, NULL, GNORBA_INIT_SERVER_FUNC, &ev);

  poa = CORBA_ORB_resolve_initial_references (orb, "RootPOA", &ev);
  POA_DND_browser__init (&poa_browser_servant, &ev);
  PortableServer_POAManager_activate (PortableServer_POA__get_the_POAManager (poa, &ev), &ev);

  PortableServer_POA_activate_object_with_id (poa,
					 &objid, &poa_browser_servant, &ev);
  browser = PortableServer_POA_servant_to_reference ((PortableServer_POA) orb->root_poa,
						 &poa_browser_servant, &ev);

  if (!browser)
    {
      g_error ("Unable to initialize CORBA.\naborting...\n");
      exit (1);
    }
  ior = CORBA_ORB_object_to_string (orb, browser, &ev);
  switch (goad_server_register (CORBA_OBJECT_NIL,
				browser,
				"browser",
				"server",
				&ev))
    {
    case -2:
      /* There is a dnd browser running; bring it forward and quit */
      browser = goad_server_activate_with_repo_id (NULL,
						   "IDL:DND/browser:1.0",
						   0, NULL);
      DND_browser_show_browser (browser, &ev);
      exit (0);
    case -1:
      g_warning ("There was trouble with the name server.\naborting...\n");
      exit (1);
    }
}

void
browser_corba_gtk_main (gint * argc, char **argv)
{
  if (!orb)
    browser_corba_gtk_init (argc, argv);
  gtk_main ();
}

static void
orb_handle_connection (GIOPConnection * cnx, gint source, GdkInputCondition cond)
{
  switch (cond)
    {
    case GDK_INPUT_EXCEPTION:
      giop_main_handle_connection_exception (cnx);
      break;
    default:
      giop_main_handle_connection (cnx);
    }
}
int
server_register_workspace (PortableServer_Servant servant,
			   CORBA_long id,
			   DND_workspace ws,
			   CORBA_Environment * env)
{
  node_data *nd = find_node_by_id (id);
  if (nd == NULL || nd->id == -1)
    {
      /* It's already been killed */
      return -1;
    }
  nd->workspace = ws;
  CORBA_Object_duplicate (ws, env);
  nd->state = WORKSPACE_ACTIVE;
  return 0;
}

void
server_put_molecule (PortableServer_Servant servant,
		     const CORBA_long mid,
		     CORBA_char *name,
		     CORBA_boolean is_add,
		     CORBA_Environment * env)
{
   Viewer *viewer = get_viewer_by_mid (mid);
   gchar * user_prefix;
   gchar fname[50];
   gint  nstr;
   FILE  * fd;

   user_prefix = gnome_util_home_file ("dnd.d");
   strcpy (fname, user_prefix);
   nstr = strlen (user_prefix);
   sprintf (fname+nstr, "/tempt%d", mid);

   fd = fopen (fname, "rb");
   
   g_print ("In Server Put Molecule \n");
   
   if (is_add)
     {
       if (viewer->mol == NULL)
	 {
	   viewer->mol = g_new0 (Molecule, 1);
	   read_molecule (fd, viewer->mol);
	   gtk_label_set_text (GTK_LABEL (viewer->label_name), name);
	 }
       else
	 {
	   Molecule *gmol = g_new0 (Molecule, 1);
	   read_molecule (fd, gmol);
	   viewer = viewer_new_with_molecule (gmol, name);
	   gtk_label_set_text (GTK_LABEL (viewer->label_name), name);
	   //  viewer_new_with_molecule (gmol, name);
	 }
       
       if (viewer->mol->pos_list != NULL)
	 display (viewer);
       else
	 g_message ("server_put_molecule : pos_list of molecule is NULL");
	 	   
     }
   else 
     {
       delete_display_lists (viewer);
       read_molecule (fd, viewer->mol);
       display (viewer);
     }

   gtk_widget_draw (GTK_WIDGET (viewer->glarea), NULL);

   fclose (fd);
   
  return;
}

void
server_get_molecule (PortableServer_Servant servant,
		     const CORBA_long mid,
		     CORBA_Environment * env)
{
  Viewer *viewer = get_viewer_by_mid (mid);
  gchar * user_prefix;
   gchar fname[50];
   gint  nstr;
   FILE  * fd;

   user_prefix = gnome_util_home_file ("dnd.d");
   strcpy (fname, user_prefix);
   nstr = strlen (user_prefix);
   sprintf (fname+nstr, "/tempt%d", mid);
   
   fd = fopen (fname, "wb");
   
   write_molecule (fd, viewer->mol);
   
   fclose (fd);
}


void
server_state_changed (PortableServer_Servant servant, CORBA_long id, CORBA_boolean undoable, CORBA_Environment * ev)
{
  node_data *nd = find_node_by_id (id);
  GdkColor col;
  col.red = 56000;
  col.green = 0;
  col.blue = 0;
  if (nd == NULL)
    {
      g_warning ("couldn't find node %d\n", id);
      g_warning ("this workspace will not function correctly...\n");
      return;
    }
  nd->modified = TRUE;
  /*  gtk_widget_set_sensitive (nd->try_button, TRUE);
  if (undoable)
    gtk_widget_set_sensitive (nd->revert_button, TRUE);
  */
  gtk_widget_set_sensitive (nd->ok_button, TRUE);

  gtk_ctree_node_set_foreground (nd->ctree, nd->node, &col);
}
static void
find_workspace (GtkCTree * ctree,
		GtkCTreeNode * node,
		gpointer list)
{
  node_data **data_pointer = (node_data **) (((GSList *) list)->data);
  node_data *nd = (node_data *) gtk_ctree_node_get_row_data (GTK_CTREE (ctree),
							     node);
  gchar *name = (gchar *) (((GSList *) list)->next->data);
  gint ws_id = (gint) (((GSList *) list)->next->next->data);
  gint i;

  if (*data_pointer != NULL)
    return;
  if (nd->gde->exec && nd->gde->exec[0]
      && !strcmp (nd->gde->exec[0], name))
    {
      if (ws_id != -1)
	{
	  for (i = 1; nd->gde->exec[i]; i++)
	    {
	      if (strstr (nd->gde->exec[i], "--ws-id="))
		{
		  if ((nd->gde->exec[i] + 9) &&
		      (atoi (nd->gde->exec[i] + 9) ==
		       ws_id))
		    {
		      *data_pointer = nd;
		    }
		}
	    }
	}
      else
	*data_pointer = nd;
    }
}
static void
show_self ()
{
  gint workspace;
  gint x, y, height, width;

  workspace = gnome_win_hints_get_current_workspace ();
  if (workspace != gnome_win_hints_get_workspace (main_window))
    gnome_win_hints_set_workspace (main_window, workspace);

  gdk_window_get_position (main_window->window, &x, &y);
  if (x > gdk_screen_width () || y > gdk_screen_height ())
    {
      gtk_widget_unmap (main_window);
      gtk_widget_map (main_window);
    }
  gdk_window_show (main_window->window);

}
void 
server_register_workspace_new (PortableServer_Servant servant,
			       const DND_workspace ws,
			       const CORBA_char * name,
			       const CORBA_long wsid,
			       CORBA_unsigned_long * xid,
			       CORBA_long * newid,
			       CORBA_Environment * ev)
{
  node_data *nd = NULL;
  GSList *ugly_list = NULL;

  ugly_list = g_slist_prepend (ugly_list, (gpointer) wsid);
  ugly_list = g_slist_prepend (ugly_list, (gpointer) name);
  ugly_list = g_slist_prepend (ugly_list, &nd);
  /* First thing we want to do is find the entry, if possible */
  gtk_ctree_post_recursive (GTK_CTREE (tree), NULL, find_workspace, ugly_list);
  if ((nd == NULL) || (nd->id != -1))
    {
      /* Abort, Abort */
      *xid = 0;
      *newid = -1;
      nd->state = WORKSPACE_INACTIVE;
      return;
    }
  nd->workspace = CORBA_Object_duplicate (ws, ev);
  launch_workspace (nd, FALSE);
  *xid = GDK_WINDOW_XWINDOW (nd->socket->window);
  *newid = nd->id;
  nd->state = WORKSPACE_ACTIVE;
  show_self ();
}
void
server_show_browser (PortableServer_Servant servant, CORBA_Environment * ev)
{
  show_self ();
}


