#include <gnome.h>
#include "dnd-color.h"
#include "dnd-utils.h"
/*
#include "dnd_radio.h"
*/

static struct 
{
  char *name;
  double r, g, b;
} _named_colors[] = {
  { "aliceblue",  0.941176, 0.972549, 1 },
  { "antiquewhite", 0.980392, 0.921569, 0.843137 },
  { "aquamarine", 0.498039, 1, 0.831373 },
  { "azure",  0.941176, 1, 1 },
  { "beige",  0.960784, 0.960784, 0.862745 },
  { "bisque",  1, 0.894118, 0.768627 },
  { "black", 0, 0, 0 },
  { "blanchedalmond",  1, 0.921569, 0.803922 },
  { "blue",  0, 0, 1 },
  { "blueviolet",  0.541176, 0.168627, 0.886275 },
  { "brown",  0.647059, 0.164706, 0.164706 },
  { "burlywood",  0.870588, 0.721569, 0.529412 },
  { "cadetblue",  0.372549, 0.619608, 0.627451 },
  { "chartreuse",  0.498039, 1, 0 },
  { "chocolate",  0.823529, 0.411765, 0.117647 },
  { "coral",  1, 0.498039, 0.313725 },
  { "cornflowerblue",  0.392157, 0.584314, 0.929412 },
  { "cornsilk",  1, 0.972549, 0.862745 },
  { "crimson",  0.862745, 0.0784314, 0.235294 },
  { "cyan",  0, 1, 1 },
  { "darkblue",  0, 0, 0.545098 },
  { "darkcyan",  0, 0.545098, 0.545098 },
  { "darkgoldenrod",  0.721569, 0.52549, 0.0431373 },
  { "darkgray",  0.662745, 0.662745, 0.662745 },
  { "darkgreen",  0, 0.392157, 0 },
  { "darkgrey",  0.662745, 0.662745, 0.662745 },
  { "darkkhaki",  0.741176, 0.717647, 0.419608 },
  { "darkmagenta",  0.545098, 0, 0.545098 },
  { "darkolivegreen",  0.333333, 0.419608, 0.184314 },
  { "darkorange",  1, 0.54902, 0 },
  { "darkorchid",  0.6, 0.196078, 0.8 },
  { "darkred",  0.545098, 0, 0 },
  { "darksalmon",  0.913725, 0.588235, 0.478431 },
  { "darkseagreen",  0.560784, 0.737255, 0.560784 },
  { "darkslateblue",  0.282353, 0.239216, 0.545098 },
  { "darkslategray",  0.184314, 0.309804, 0.309804 },
  { "darkslategrey",  0.184314, 0.309804, 0.309804 },
  { "darkturquoise",  0, 0.807843, 0.819608 },
  { "darkviolet",  0.580392, 0, 0.827451 },
  { "deeppink",  1, 0.0784314, 0.576471 },
  { "deepskyblue",  0, 0.74902, 1 },
  { "dimgray",  0.411765, 0.411765, 0.411765 },
  { "dimgrey",  0.411765, 0.411765, 0.411765 },
  { "dodgerblue",  0.117647, 0.564706, 1 },
  { "firebrick",  0.698039, 0.133333, 0.133333 },
  { "floralwhite",  1, 0.980392, 0.941176 },
  { "forestgreen",  0.133333, 0.545098, 0.133333 },
  { "gainsboro",  0.862745, 0.862745, 0.862745 },
  { "ghostwhite",  0.972549, 0.972549, 1 },
  { "gold",  1, 0.843137, 0 },
  { "goldenrod",  0.854902, 0.647059, 0.12549 },
  { "gray",  0.745098, 0.745098, 0.745098 },
  { "green",  0, 1, 0 },
  { "greenyellow",  0.678431, 1, 0.184314 },
  { "grey",  0.745098, 0.745098, 0.745098 },
  { "honeydew",  0.941176, 1, 0.941176 },
  { "hotpink",  1, 0.411765, 0.705882 },
  { "indianred",  0.803922, 0.360784, 0.360784 },
  { "indigo",  0.294118, 0, 0.509804 },
  { "ivory",  1, 1, 0.941176 },
  { "khaki",  0.941176, 0.901961, 0.54902 },
  { "lavender",  0.901961, 0.901961, 0.980392 },
  { "lavenderblush",  1, 0.941176, 0.960784 },
  { "lawngreen",  0.486275, 0.988235, 0 },
  { "lemonchiffon",  1, 0.980392, 0.803922 },
  { "lightblue",  0.678431, 0.847059, 0.901961 },
  { "lightcoral",  0.941176, 0.501961, 0.501961 },
  { "lightcyan",  0.878431, 1, 1 },
  { "lightgoldenrod",  0.933333, 0.866667, 0.509804 },
  { "lightgoldenrodyellow",  0.980392, 0.980392, 0.823529 },
  { "lightgray",  0.827451, 0.827451, 0.827451 },
  { "lightgreen",  0.564706, 0.933333, 0.564706 },
  { "lightgrey",  0.827451, 0.827451, 0.827451 },
  { "lightpink",  1, 0.713725, 0.756863 },
  { "lightsalmon",  1, 0.627451, 0.478431 },
  { "lightseagreen",  0.12549, 0.698039, 0.666667 },
  { "lightskyblue",  0.529412, 0.807843, 0.980392 },
  { "lightslateblue",  0.517647, 0.439216, 1 },
  { "lightslategray",  0.466667, 0.533333, 0.6 },
  { "lightslategrey",  0.466667, 0.533333, 0.6 },
  { "lightsteelblue",  0.690196, 0.768627, 0.870588 },
  { "lightyellow",  1, 1, 0.878431 },
  { "limegreen",  0.196078, 0.803922, 0.196078 },
  { "linen",  0.980392, 0.941176, 0.901961 },
  { "magenta",  1, 0, 1 },
  { "maroon",  0.690196, 0.188235, 0.376471 },
  { "mediumaquamarine",  0.4, 0.803922, 0.666667 },
  { "mediumblue",  0, 0, 0.803922 },
  { "mediumorchid",  0.729412, 0.333333, 0.827451 },
  { "mediumpurple",  0.576471, 0.439216, 0.858824 },
  { "mediumseagreen",  0.235294, 0.701961, 0.443137 },
  { "mediumslateblue",  0.482353, 0.407843, 0.933333 },
  { "mediumspringgreen",  0, 0.980392, 0.603922 },
  { "mediumturquoise",  0.282353, 0.819608, 0.8 },
  { "mediumvioletred",  0.780392, 0.0823529, 0.521569 },
  { "midnightblue",  0.0980392, 0.0980392, 0.439216 },
  { "mintcream",  0.960784, 1, 0.980392 },
  { "mistyrose",  1, 0.894118, 0.882353 },
  { "moccasin",  1, 0.894118, 0.709804 },
  { "navajowhite",  1, 0.870588, 0.678431 },
  { "navy",  0, 0, 0.501961 },
  { "navyblue",  0, 0, 0.501961 },
  { "oldlace",  0.992157, 0.960784, 0.901961 },
  { "olivedrab",  0.419608, 0.556863, 0.137255 },
  { "orange",  1, 0.647059, 0 },
  { "orangered",  1, 0.270588, 0 },
  { "orchid",  0.854902, 0.439216, 0.839216 },
  { "palegoldenrod",  0.933333, 0.909804, 0.666667 },
  { "palegreen",  0.596078, 0.984314, 0.596078 },
  { "paleturquoise",  0.686275, 0.933333, 0.933333 },
  { "palevioletred",  0.858824, 0.439216, 0.576471 },
  { "papayawhip",  1, 0.937255, 0.835294 },
  { "peachpuff",  1, 0.854902, 0.72549 },
  { "peru",  0.803922, 0.521569, 0.247059 },
  { "pink",  1, 0.752941, 0.796078 },
  { "plum",  0.866667, 0.627451, 0.866667 },
  { "powderblue",  0.690196, 0.878431, 0.901961 },
  { "purple",  0.627451, 0.12549, 0.941176 },
  { "red",  1, 0, 0 },
  { "rosybrown",  0.737255, 0.560784, 0.560784 },
  { "royalblue",  0.254902, 0.411765, 0.882353 },
  { "saddlebrown",  0.545098, 0.270588, 0.0745098 },
  { "salmon",  0.980392, 0.501961, 0.447059 },
  { "sandybrown",  0.956863, 0.643137, 0.376471 },
  { "seagreen",  0.180392, 0.545098, 0.341176 },
  { "seashell",  1, 0.960784, 0.933333 },
  { "sgibeet",  0.556863, 0.219608, 0.556863 },
  { "sgibrightgray",  0.772549, 0.756863, 0.666667 },
  { "sgibrightgrey",  0.772549, 0.756863, 0.666667 },
  { "sgichartreuse",  0.443137, 0.776471, 0.443137 },
  { "sgidarkgray",  0.333333, 0.333333, 0.333333 },
  { "sgidarkgrey",  0.333333, 0.333333, 0.333333 },
  { "sgilightblue",  0.490196, 0.619608, 0.752941 },
  { "sgilightgray",  0.666667, 0.666667, 0.666667 },
  { "sgilightgrey",  0.666667, 0.666667, 0.666667 },
  { "sgimediumgray",  0.517647, 0.517647, 0.517647 },
  { "sgimediumgrey",  0.517647, 0.517647, 0.517647 },
  { "sgiolivedrab",  0.556863, 0.556863, 0.219608 },
  { "sgisalmon",  0.776471, 0.443137, 0.443137 },
  { "sgislateblue",  0.443137, 0.443137, 0.776471 },
  { "sgiteal",  0.219608, 0.556863, 0.556863 },
  { "sgiverydarkgray",  0.156863, 0.156863, 0.156863 },
  { "sgiverydarkgrey",  0.156863, 0.156863, 0.156863 },
  { "sgiverylightgray",  0.839216, 0.839216, 0.839216 },
  { "sgiverylightgrey",  0.839216, 0.839216, 0.839216 },
  { "sienna",  0.627451, 0.321569, 0.176471 },
  { "skyblue",  0.529412, 0.807843, 0.921569 },
  { "slateblue",  0.415686, 0.352941, 0.803922 },
  { "slategray",  0.439216, 0.501961, 0.564706 },
  { "slategrey",  0.439216, 0.501961, 0.564706 },
  { "snow",  1, 0.980392, 0.980392 },
  { "springgreen",  0, 1, 0.498039 },
  { "steelblue",  0.27451, 0.509804, 0.705882 },
  { "tan",  0.823529, 0.705882, 0.54902 },
  { "thistle",  0.847059, 0.74902, 0.847059 },
  { "tomato",  1, 0.388235, 0.278431 },
  { "turquoise",  0.25098, 0.878431, 0.815686 },
  { "violet",  0.933333, 0.509804, 0.933333 },
  { "violetred",  0.815686, 0.12549, 0.564706 },
  { "wheat",  0.960784, 0.870588, 0.701961 },
  { "white",  1, 1, 1 },
  { "whitesmoke",  0.960784, 0.960784, 0.960784 },
  { "yellow",  1, 1, 0 },
  { "yellowgreen",  0.603922, 0.803922, 0.196078 }, 
  {NULL, 0, 0, 0},
};

#define COLOR_SHOW_WIDTH  25
#define COLOR_SHOW_HEIGHT 18

static void color_show_free (ColorShow *cs);
static void color_show_init (ColorShow *cs, char *color_name);

void
render (ColorShow *cs)
{
  GdkColor c;

  c.red   = (int) (cs->color->r * 65535.0 + 0.5);
  c.green = (int) (cs->color->g * 65535.0 + 0.5);
  c.blue  = (int) (cs->color->b * 65535.0 + 0.5);
  
  gdk_imlib_best_color_get (&c);
  gdk_gc_set_foreground (cs->gc, &c);
  gdk_draw_rectangle (cs->pixmap,
		      cs->gc,
		      TRUE,
		      0, 0,
		      COLOR_SHOW_WIDTH, COLOR_SHOW_HEIGHT);
 
}


static gint
expose_event (GtkWidget *widget, GdkEventExpose *event, gpointer data)
{
  ColorShow *cs;
  
  cs = data;

  gdk_draw_pixmap (widget->window,
		   cs->gc,
		   cs->pixmap,
		   event->area.x,
		   event->area.y,
		   event->area.x,
		   event->area.y,
		   event->area.width,
		   event->area.height);

  return FALSE;
}


GtkWidget *
dnd_color_selection_button (ColorShow *cs, char *color_name)
{
  GtkWidget *button;
  GtkWidget *alignment;
  GtkWidget *frame;
  
  button = gtk_button_new ();
  
  alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
  gtk_container_set_border_width (GTK_CONTAINER (alignment), 1);
  
  gtk_container_add (GTK_CONTAINER (button), alignment);
  gtk_widget_show (alignment);
  
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_container_add (GTK_CONTAINER (alignment), frame);
  gtk_widget_show (frame);
  
  color_show_init (cs, color_name);
    
  gtk_container_add (GTK_CONTAINER (frame), cs->da);
  gtk_widget_show (cs->da);
  /*
  render (cs);
  */
  return button;
}


gint
dnd_color_selection_dialog ( )
{
  GtkWidget *dialog;
  GtkWidget *scrolled_window;
  GtkWidget *vbox, *box;
  GSList    *group;
  NamedColor *nc = named_colors;
  gint       nbut;
  gint       ncolor;
  
  dialog = gnome_dialog_new (_("Select Color"),
			     GNOME_STOCK_BUTTON_OK,
			     GNOME_STOCK_BUTTON_CANCEL,
			     NULL);

  gtk_widget_set_usize (dialog, 250, 500);
  
  /*  
  gnome_dialog_set_parent (GNOME_DIALOG (dialog),
			   GTK_WINDOW (widget));
  */
  box = gtk_vbox_new (FALSE, 0);
  
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
     		                  GTK_POLICY_AUTOMATIC, 
                                  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), scrolled_window,
		      TRUE, TRUE, 0);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					 vbox);
  gtk_container_set_focus_vadjustment (GTK_CONTAINER (vbox),
				       gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolled_window)));

  gtk_widget_show (vbox);

  for (group = NULL; nc->name; nc++)
    {
      GtkWidget *item;
      GtkWidget *hbox;
      GtkWidget *frame;
      ColorShow *cs;
      
      hbox = gtk_hbox_new (FALSE, 0);
      item = gtk_radio_button_new_with_label (group, nc->name);
      group = gtk_radio_button_group (GTK_RADIO_BUTTON (item));
      gtk_box_pack_start (GTK_BOX (hbox), item, FALSE, TRUE, 5);
      /* -- create frame for show color --- */
      frame = gtk_frame_new (NULL);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
      gtk_box_pack_end (GTK_BOX (hbox), frame, FALSE, TRUE, 5);
      gtk_widget_show (frame);

      cs = g_new0 (ColorShow, 1);
      color_show_init (cs, nc->name);
      
      gtk_container_add (GTK_CONTAINER (frame), cs->da);
      gtk_widget_show (cs->da);
      
      gtk_box_pack_start_defaults (GTK_BOX (vbox), hbox);
      
    }
  
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), box,
		      TRUE, TRUE, 0);

  gtk_widget_show_all (box);
      
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  
  nbut = gnome_dialog_run (GNOME_DIALOG (dialog));
 
  if (nbut == 0)
    {
/*      ncolor = gtk_radio_group_get_selected (group); */
      /*      make_radio_notify_change (group, dialog); */
    }
  else
    ncolor = -1;
  
  gnome_dialog_close (GNOME_DIALOG (dialog));

  return ncolor;
  
}

  
gint
get_color_number (char *color_name)
{
  int i;
  int ret_val = -1;
  
  for (i = 0; named_colors[i].name; i++)
    {
      if (str_eq (color_name, named_colors[i].name))
	{
	  ret_val = i;
	  break;
	}
    }
  
  if (ret_val < 0)
    {
      g_error ("Fail to find Color %s \n", color_name);
      return 0;
    }
  
  return ret_val;
}

void
color_show_free (ColorShow *cs)
{
  g_return_if_fail (cs != NULL);
  
  if (cs->da)
    gtk_widget_destroy (cs->da);
  
  gdk_imlib_free_pixmap (cs->pixmap);
  gdk_imlib_destroy_image (cs->im);
  gdk_gc_destroy (cs->gc);
}


void
color_show_init (ColorShow *cs, char *color_name)
{
  gchar *buf;
  gint  num;
  
  g_return_if_fail (cs != NULL);
  g_return_if_fail (color_name != NULL);
  
  num   = get_color_number (color_name);

  gtk_widget_push_visual (gdk_rgb_get_visual ());
  gtk_widget_push_colormap (gdk_rgb_get_cmap ());

  cs->da = gtk_drawing_area_new ();

  gtk_widget_pop_colormap ();
  gtk_widget_pop_visual ();

  gtk_drawing_area_size (GTK_DRAWING_AREA (cs->da),
			 COLOR_SHOW_WIDTH, COLOR_SHOW_HEIGHT);
  gtk_signal_connect (GTK_OBJECT (cs->da), "expose_event",
		      (GtkSignalFunc) expose_event,
		      cs);
  buf = g_malloc0 (COLOR_SHOW_WIDTH * COLOR_SHOW_HEIGHT * \
		   3 * sizeof (guchar));
  cs->im = gdk_imlib_create_image_from_data (buf, NULL,
					     COLOR_SHOW_WIDTH,
					     COLOR_SHOW_HEIGHT);
  g_free (buf);

  gdk_imlib_render (cs->im, COLOR_SHOW_WIDTH, COLOR_SHOW_HEIGHT);
  cs->pixmap = gdk_imlib_copy_image (cs->im);
  cs->gc = gdk_gc_new (cs->pixmap);

  cs->color = named_colors[num].color;
  /*
  cs->g = named_colors[num].g;
  cs->b = named_colors[num].b;
  cs->a = 1.0;
  */
  render (cs);
  
}

void
color_init ()
{
  gint num = sizeof (_named_colors) / sizeof (_named_colors[0]);
  gint i;
  
  named_colors = g_new0 (NamedColor, num);
  
  for (i = 0; i < num; i++)
    {
      named_colors[i].name = g_strdup (_named_colors[i].name);
      named_colors[i].color = g_new0 (Color, 1);
      named_colors[i].color->r = _named_colors[i].r;
      named_colors[i].color->g = _named_colors[i].g;
      named_colors[i].color->b = _named_colors[i].b;
      named_colors[i].color->a = 1.0;
    }
}

      
void
color_info_init ()
{
  color_init ();
  
  color_info.c_color = get_color_number ("green");
  color_info.n_color = get_color_number ("blue");
  color_info.o_color = get_color_number ("red");
  color_info.h_color = get_color_number ("white");
  color_info.s_color = get_color_number ("yellow");
}
