#ifndef _DND_COLOR_H
#define _DND_COLOR_H


typedef struct _dnd_color_info ColorInfo;
typedef struct _dnd_color_show ColorShow;
typedef struct _dnd_color      Color;
typedef struct _dnd_named_color NamedColor;
typedef struct _dnd_color_data ColorData;

struct _dnd_color_info
{
  gint c_color;
  gint n_color;
  gint o_color;
  gint h_color;
  gint s_color;
  
  GSList *res_color;
  GSList *seg_color;
};

enum { COLOUR_RGB, COLOUR_GREY
};


struct _dnd_named_color {
  char *name;
  Color *color;
};


struct _dnd_color 
{
  double r, g, b, a;
};


struct _dnd_color_show
{
  GdkImlibImage *im;
  GdkPixmap     *pixmap;
  GdkGC         *gc;
  GtkWidget     *da;
  Color         *color;
};

NamedColor *named_colors; 
ColorInfo  color_info;


gint get_color_number (char *color_name);
void color_info_init ( );
gint dnd_color_selection_dialog ( );
void render (ColorShow *cs);
GtkWidget *dnd_color_selection_button (ColorShow *cs, char *color_name);


#endif
