#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "dnd-utils.h"

#ifndef whitespace
#define whitespace(c) (((c) == ' ') || ((c) == '\t'))
#endif

gboolean
dnd_read_line (FILE *fd, char *buf)
{
  int i = 0;
  int c;
  
  while (((c=fgetc(fd)) != EOF) && (c != '\n') )
    {
      if (c == '{')
	{
	  while ( ((c=fgetc (fd)) != EOF) && (c != '}') )
	    {
	    }
	  
	  if (c == EOF)
	    {
	      g_warning ("ABNORMAL EOF FOUND - buffer = **%s**", buf);
	      return FALSE;
	    }
	  
	  continue;
	}
      
      if ((i > 0) || !whitespace (c))
	{
	  buf[i] = c;
	  i++;
	}
    }
  
  buf[i] = '\0';
  
  if ((c==EOF) && (i != 0))
    g_warning ("ABNORMAL EOF FOUND - buffer=*%s*", buf);
  
  if (c == EOF)
    return FALSE;
  else
    return TRUE;
}


int
dnd_blank_string (char *buf)
{
  int i;
  int blank = 1;
  int len;
  
  len = strlen (buf);
  
  for (i = 0; i < len && blank; i++)
    {
      blank = isspace(buf[i]);
    }
  
  return blank;
}


gboolean
dnd_find_word (char *source, char *word)
{
  int i = 0;
  int word_length;
  int source_length;
  gboolean found = FALSE;
  
  word_length = strlen (word);
  source_length = strlen (source);
  
  while (!found && ((i+word_length) <= (source_length)))
    {
      found = (strncasecmp (source+i, word, word_length) == 0);
      
      i++;
    }
  
  return found;
}


int
dnd_index (char *source, char *word)
{
  int i = 0;
  int word_length;
  int source_length;
  gboolean found = FALSE;
  
  word_length = strlen (word);
  source_length = strlen (source);
  
  while (!found && ((i+word_length) <= (source_length)))
    {
      found = (strncasecmp (source+i, word, word_length) == 0);
      
      i++;
    }
  
  if (found)
    return (i-1);
  else
    return -1;
}



int
dnd_read_int (FILE *fd)
{
  int i;
  int c;
  char tmp_string[120];
  
  while ( ((c=fgetc(fd)) == '\n') || isspace(c))
    {
    }
  
  if (c==EOF)
    g_warning ("EOF ENCOUNTERED READING ... FROM PSF FILE");
  
  i = 0;
  
  while (!isspace(c))
    {
      if (!isdigit (c))
	g_warning ("ALPHA CHARCTER ENCOUNTERED WHILE READING ... FROM PSF FILE");
      
      tmp_string[i] = c;
      i++;
      
      c=fgetc(fd);
      
      if (c == EOF)
	g_warning ("EOF ENCOUNTERED READING ... FROM PSF FILE");
    }
  
  tmp_string[i] = '\0';
  
  return (atoi (tmp_string));
}


gboolean
str_eq (const char *str1, const char *str2)
{
  g_return_val_if_fail (str1 != NULL, FALSE);
  g_return_val_if_fail (str2 != NULL, FALSE);
    
  while (*str1)
    if (*str1++ != *str2++)
      return FALSE; 
  return TRUE;
}


gboolean
str_eqn (const char *str1, const char *str2, const int n)
{
  register int i;
  
  g_return_val_if_fail (str1 != NULL, FALSE);
  g_return_val_if_fail (str2 != NULL, FALSE);
  g_return_val_if_fail (n >= 0, FALSE);
  
  for (i = 0; i < n; i++)
    {
      if (*str1 == '\0')
	return (*str2 == '\0');
      if (*str1++ != *str2++)
	return FALSE; /* FALSE */
    }
  
  return TRUE; /* TRUE */
}


gboolean
str_eq_min (const char *str1, const char *str2)
{
  int eqm = FALSE;
  
  g_return_val_if_fail (str1 != NULL, FALSE);
  g_return_val_if_fail (str2 != NULL, FALSE);
  
  while (*str1 && *str2)
    {
      eqm = (*str1++ == *str2++);
      
      if (!eqm)
	return eqm;
    }
  
  return eqm;
}


char *
dnd_next_word (char *str, char *word)
{
  int len = 12;
  int i = 0;
  
  g_return_val_if_fail (str != NULL, 0);
  g_return_val_if_fail (word != NULL, 0);
    
  while (whitespace (*str))
    {
      str++;
    }
  
  while (!whitespace(*str) && (*str != '\0'))
    {
      if (i < len)
	{
	  word[i] = str[0];
	  i++;
	}
      str++;
    }
  
  word[i] = '\0';

  if (i == 0)
    return NULL;
  else
    return str;
}


  
void
dnd_die (char *str)
{
  g_warning (str);
  exit (1);
}
