#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include <gnome.h>
#include "dnd.h"
#include "viewer.h"
#include "drawer.h"

static void bonds (Viewer *viewer);
static void get_atom_colors (Viewer *viewer);

void
display (Viewer *viewer)
{
  
  g_return_if_fail (viewer != NULL);
  g_return_if_fail (viewer->mol != NULL);
  
  get_atom_colors (viewer);
  
  bonds (viewer);
}

void
display_label (Viewer *viewer,
	       vector3 *pos, char *label, unsigned int fontbase)
{
  g_return_if_fail (pos != NULL);
  g_return_if_fail (label != NULL);

  start_display_list (viewer, TRUE);

  glColor3f (1, 1, 0);

  glRasterPos3d (pos->x, pos->y, pos->z);
  glListBase (fontbase);
  glCallLists (strlen (label), GL_UNSIGNED_BYTE, label);
  
  glEndList ();
  
}


void
display_pick (Viewer *viewer)
{
  Molecule *mol;
  
  g_return_if_fail (viewer != NULL);
  g_return_if_fail (viewer->mol != NULL);
  
  mol = viewer->mol;
  
  if (viewer->render_mode == GL_SELECT)
    {
      gint i;
      GList *list;
      
      start_display_list (viewer, FALSE);
      
      glDisable (GL_LIGHTING);
      glShadeModel (GL_FLAT);

      for (i = 0, list = mol->pos_list; list; i++, list = list->next)
	{
	  vector3 *pos = (vector3 *) list->data;
      
	  glLoadName (i);
	  glBegin (GL_POINTS);
	  glVertex3d (pos->x, pos->y, pos->z);
	  glEnd();
	}
      
      glShadeModel (GL_SMOOTH);
      glEnable (GL_LIGHTING);
      glEndList ();
    }
  
}

static void
bonds (Viewer *viewer)
{
  vector3 *pos1, *pos2;
  GList *list;
  Bond *bond;
  Molecule *mol = viewer->mol;
  Color **atom_colors = viewer->atom_colors;
  
  start_display_list (viewer, FALSE);

  glDisable (GL_LIGHTING);
  glShadeModel (GL_FLAT);

  glLineWidth (1.5);
  
  for (list = mol->bond_list; list; list = list->next)
    {
      int i1, i2;
      vector3 pos;
      
      bond = (Bond*)list->data;

      i1 = bond->iatom1;
      i2 = bond->iatom2;

      pos1 = g_list_nth_data (mol->pos_list, i1);
      pos2 = g_list_nth_data (mol->pos_list, i2);
  
      v3_between (&pos, pos1, pos2, 0.5);

      glBegin (GL_LINES);

      glColor4d (atom_colors[i1]->r, atom_colors[i1]->g,
		 atom_colors[i1]->b, atom_colors[i1]->a);

      glVertex3d (pos1->x, pos1->y, pos1->z);
      glVertex3d (pos.x, pos.y, pos.z);    
      
      glColor4d (atom_colors[i2]->r, atom_colors[i2]->g,
		 atom_colors[i2]->b, atom_colors[i2]->a);

      glVertex3d (pos.x, pos.y, pos.z);
      glVertex3d (pos2->x, pos2->y, pos2->z);
    
      glEnd ();

    }
  
  glShadeModel (GL_SMOOTH);
  glEnable (GL_LIGHTING);
  glEndList ();
}

static void
get_atom_colors (Viewer * viewer)
{
  GList *ls;
  AtomInfo  *atom;
  int    i = 0;
  Color *cc, *nc, *oc, *hc, *sc;
  gint  natom;
  
  if (viewer->atom_colors != NULL)
    return;
  
  natom = g_list_length (viewer->mol->atom_list);
  
  viewer->atom_colors = g_new0 (Color *, natom);
  
  cc = named_colors[color_info.c_color].color;
  nc = named_colors[color_info.n_color].color;
  oc = named_colors[color_info.o_color].color;
  hc = named_colors[color_info.h_color].color;
  sc = named_colors[color_info.s_color].color;
  
  for (ls = viewer->mol->atom_list; ls; ls = ls->next)
    {
      atom = (AtomInfo *) ls->data;
      
      if (atom->name[0] == 'C')
	viewer->atom_colors[i] = cc;
      else if (atom->name[0] == 'N')
	viewer->atom_colors[i] = nc;
      else if (atom->name[0] == 'O')
	viewer->atom_colors[i] = oc;
      else if (atom->name[0] == 'H')
	viewer->atom_colors[i] = hc;
      else if (atom->name[0] == 'S')
	viewer->atom_colors[i] = sc;
      else
	{
	  g_error ("Out of Color ... ^^\n");
	  viewer->atom_colors[i] = named_colors[10].color;
	}
      i++;
    }
  
}

