#include "molecule.h"
#include <stdio.h>
#include <string.h>

#define write(fd,buf,num) fwrite(buf, num, 1, fd)
#define read(fd,buf,num) fread(buf, num, 1, fd)

void
write_molecule (FILE *fd, Molecule *mol)
{
  gint num;
  gint i;
  gint nstr;
  GList *list;
  gint is_null = FALSE;
  
  if (mol == NULL)
    {
      is_null = TRUE;
      write (fd, (char *)&is_null, sizeof (int));
      return;
    }
  
  write (fd, (char *)&is_null, sizeof (int));
  
  write (fd, (char *)&mol->type, sizeof (int));
  write (fd, (char *)&mol->model, sizeof (int));
  
  write (fd, (char *)&mol->box.x, sizeof (double));
  write (fd, (char *)&mol->box.y, sizeof (double));
  write (fd, (char *)&mol->box.z, sizeof (double));
  
  /* -- write Segment List --- */
  num = g_list_length (mol->seg_list);
  write (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = mol->seg_list; i < num; i++, list = list->next)
    {
      Segment *seg = (Segment *) list->data;
      
      nstr = strlen (seg->name);
      write (fd, (char *)& nstr, sizeof (int));
      write (fd, (char *) seg->name, sizeof (char)* nstr);
      write (fd, (char *)& seg->ires, sizeof (int));
    }
  
  /* -- write Residue List -- */
  num = g_list_length (mol->res_list);
  write (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = mol->res_list; i < num; i++, list = list->next)
    {
      Residue *res = (Residue *) list->data;
      nstr = strlen (res->name);
      write (fd, (char *)&nstr, sizeof (int));
      write (fd, (char *)res->name, sizeof (char) * nstr);
      nstr = strlen (res->type);
      write (fd, (char *)&nstr, sizeof (int));
      write (fd, (char *)res->type, sizeof (char) * nstr);
  
      /* [FIXME] */
      write (fd, (char *)&res->iatom, sizeof (int));
      
    }
  
  /* -- Write AtomList -- */
  
  num = g_list_length (mol->atom_list);
  write (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = mol->atom_list; i < num; i++, list = list->next)
    {
      AtomInfo *atom = (AtomInfo *)list->data;
      
      write (fd, (char *)&atom->iatom, sizeof (int));
      nstr = strlen (atom->name);
      write (fd, (char *)&nstr, sizeof (int));
      write (fd, (char *)atom->name, sizeof (char) * nstr);
      nstr = strlen (atom->type);
      write (fd, (char *)&nstr, sizeof (int));
      write (fd, (char *)atom->type, sizeof (char) * nstr);
  
      write (fd, (char *)&atom->mass, sizeof (double));
      write (fd, (char *)&atom->charge, sizeof (double));
      write (fd, (char *)&atom->bfactor, sizeof (double));
      write (fd, (char *)&atom->ires, sizeof (int));
      //      write (fd, (char *)&atom->is_move, sizeof (int));
    }
  
  /* write poslist */
  num = g_list_length (mol->pos_list);
  write (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = mol->pos_list; i < num; i++, list = list->next)
    {
      vector3 *pos = (vector3 *) list->data;
      
      write (fd, (char *) &pos->x, sizeof (double));
      write (fd, (char *) &pos->y, sizeof (double));
      write (fd, (char *) &pos->z, sizeof (double));
    }
  
  /* write BondList */

  num = g_list_length (mol->bond_list);
  write (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = mol->bond_list; i < num; i++, list = list->next)
    {
      Bond *bond = (Bond *)list->data;
      
      write (fd, (char *)&bond->iatom1, sizeof (int));
      write (fd, (char *)&bond->iatom2, sizeof (int));
    }
}


void
read_molecule (FILE *fd, Molecule *mol)
{
  gint num;
  gint i;
  gint nstr;
  GList *list;
  gint is_null;
  Residue *res;
  
  read (fd, (char *)&is_null, sizeof (int));
  
  if (is_null)
    {
      return;
    }
  
  read (fd, (char *)&mol->type, sizeof (int));
  read (fd, (char *)&mol->model, sizeof (int));

  read (fd, (char *)&mol->box.x, sizeof (double));
  read (fd, (char *)&mol->box.y, sizeof (double));
  read (fd, (char *)&mol->box.z, sizeof (double));
  
  /* -- read Segment List --- */
  read (fd, (char *)&num, sizeof (int));
  
  for (i = 0; i < num; i++)
    {
      Segment *seg = g_new0 (Segment, 1);
      read (fd, (char *)& nstr, sizeof (int));
      read (fd, (char *) seg->name, sizeof (char)* nstr);
      seg->name[nstr] = '\0';
      
      read (fd, (char *)& seg->ires, sizeof (int));
      mol->seg_list = g_list_append (mol->seg_list, seg);
    }
  
  /* -- read Residue List -- */
  read (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = NULL; i < num; i++)
    {
      res = g_new0 (Residue, 1);
      
      read (fd, (char *)&nstr, sizeof (int));
      read (fd, (char *)res->name, sizeof (char) * nstr);
      res->name[nstr] = '\0';
      
      read (fd, (char *)&nstr, sizeof (int));
      read (fd, (char *)res->type, sizeof (char) * nstr);
      res->type[nstr] = '\0';
      
      /* [FIXME] */
      read (fd, (char *)&res->iatom, sizeof (int));

      list = g_list_append (list, res);
      
      if (i == 0)
	mol->res_list = list;
      else
	list = list->next;
      
    }
  
  /* -- Read AtomList -- */
  
  read (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = NULL; i < num; i++)
    {
      AtomInfo *atom = g_new0 (AtomInfo, 1);
      
      read (fd, (char *)&atom->iatom, sizeof (int));
      
      read (fd, (char *)&nstr, sizeof (int));
      read (fd, (char *)atom->name, sizeof (char) * nstr);
      atom->name[nstr] = '\0';
      
      read (fd, (char *)&nstr, sizeof (int));
      read (fd, (char *)atom->type, sizeof (char) * nstr);
      atom->type[nstr] = '\0';
      
      read (fd, (char *)&atom->mass, sizeof (double));
      read (fd, (char *)&atom->charge, sizeof (double));
      read (fd, (char *)&atom->bfactor, sizeof (double));
      read (fd, (char *)&atom->ires, sizeof (int));
      //      read (fd, (char *)&atom->is_move, sizeof (int));
      
      list = g_list_append (list, atom);

      if (i == 0)
	mol->atom_list = list;
      else
	list = list->next;
	
    }
  
  /* read poslist */
  read (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = NULL; i < num; i++)
    {
      vector3 *pos = g_new0 (vector3, 1);
            
      read (fd, (char *) &pos->x, sizeof (double));
      read (fd, (char *) &pos->y, sizeof (double));
      read (fd, (char *) &pos->z, sizeof (double));

      list = g_list_append (list, pos);

      if (i == 0)
	mol->pos_list = list;
      else
	list = list->next;
    }
  
  /* read BondList */

  read (fd, (char *)&num, sizeof (int));
  
  for (i = 0, list = NULL; i < num; i++)
    {
      Bond *bond = g_new0 (Bond, 1);
            
      read (fd, (char *)&bond->iatom1, sizeof (int));
      read (fd, (char *)&bond->iatom2, sizeof (int));

      list = g_list_append (list, bond);

      if (i == 0)
	mol->bond_list = list;
      else
	list = list->next;
    }  
  
}


void
molecule_free (Molecule **gmol)
{
  Molecule *mol = *gmol;
  GList *list;
  
  if (mol == NULL)
    return;
  
  for (list = mol->seg_list; list; list = list->next)
    {
      Segment *seg = (Segment *)list->data;
      g_free (seg);
    }
  g_list_free (mol->seg_list);
  
  for (list = mol->res_list; list; list = list->next)
    {
      Residue *res = (Residue *) list->data;
      g_free (res);
    }
  g_list_free (mol->res_list);
  
  for (list = mol->atom_list; list; list = list->next)
    {
      AtomInfo *atom = (AtomInfo *) list->data;
      g_free (atom);
    }
  g_list_free (mol->atom_list);
  
   for (list = mol->pos_list; list; list = list->next)
    {
      vector3 *pos = (vector3 *) list->data;
      g_free (pos);
    }
   g_list_free (mol->atom_list);
   
  for (list = mol->bond_list; list; list = list->next)
    {
      Bond *bond = (Bond *) list->data;
      g_free (bond);
    }
  g_list_free (mol->bond_list);


  g_free (mol);
  mol = NULL;
 
  *gmol = mol;
  
}

 
