#ifndef DND_MOLECULE_H
#define DND_MOLECULE_H

#include "vector3.h"
#include <glib.h>
#include <stdio.h>

typedef struct _DMolecule Molecule;
typedef struct _DSegment  Segment;
typedef struct _DResidue  Residue;
typedef struct _DLattice  Lattice;
typedef struct _DAtom     AtomInfo;
typedef struct _vector3   Pos;
typedef struct _DBond     Bond;

#define RES_NAME_LENGTH 4
#define RES_TYPE_LENGTH 6

struct _DResidue
{
  char name[RES_NAME_LENGTH+1];
  char type[RES_TYPE_LENGTH+1];
  char chain;
  char code;
  int   iatom;
};

#define ATOM_NAME_LENGTH 4
#define ATOM_TYPE_LENGTH 4

struct _DAtom
{
  int     iatom;
  char name[ATOM_NAME_LENGTH+1];
  char type[ATOM_TYPE_LENGTH+1];
  double  mass;
  double  charge;
  int    element;
  double  bfactor;
  double  occupancy;
  int    ires;
};

struct _DBond
{
  int  iatom1;
  int  iatom2;
  double distance;
  double force;
};


struct _DSegment
{
  char name[5];
  int   ires;
};

struct _DMolecule
{
  int type;
  int model;
  vector3 box;
  GList *seg_list;
  GList *pos_list;
  GList *atom_list;
  GList *res_list;
  GList *bond_list;
};


void read_molecule (FILE *fd, Molecule *mol);
void write_molecule (FILE *fd, Molecule *mol);
void molecule_free (Molecule **mol);

#endif 
