#ifndef DND_VIEWER_H
#define DND_VIEWER_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <gtkgl/gtkglarea.h>
#include "dnd.h"
#include "dnd-color.h"
#include "molecule.h"

typedef enum {
  ROTATE_MODE,
  TRANSLATE_MODE,
  ZOOM_MODE,
  PICK_MODE
} MouseMode;

enum {
  PERSPECTIVE_MODE,
  ORTHO_MODE
};


typedef struct _viewer Viewer;

typedef void (*view_render_func) (Viewer *viewer);

struct _viewer
{
  GtkGLArea *glarea;
  GtkWidget *label_name;
  
  /* -- mesh info -- */
  guint16 width, height;
  double aspect;
  double mouse_x;
  double mouse_y;
  double scale;  
  double fovy;   /* angle in gulPerspective (GLdouble fovy, ...) */
  double slab;
  GLfloat trans_x, trans_y;
  GLfloat quat[4];
  double window;
  GLfloat xform[4][4];

  gint project_option;
  MouseMode mouse_option;
  gint render_mode;
    
  view_render_func draw;

  GSList *label_slist;
  GSList *display_slist;

  Molecule *mol;
  Color   **atom_colors;
  gint      mid;   /* Molecule ID */
  gboolean  is_drawed;
  
};

Viewer *viewer_new ();
Viewer * viewer_new_with_molecule (Molecule *mol, char *name);
void start_display_list (Viewer *viewer, gboolean is_label);
void delete_display_lists (Viewer *viewer);
gint get_current_mid ();
Viewer * get_viewer_by_mid (gint mid);

#endif
