#include <config.h>
#include "workspace-manager.h"
#include "callbacks.h"
#include "viewer.h"
#include <gnome.h>
#include <gdk/gdkx.h>

/* variables */
extern GtkWidget *container;
extern GtkWidget *notebook;
extern GtkWidget *splash_screen;
extern GtkWidget *hack_widget;
extern gchar *ior;
static gint current_page = 0;
static gint id = 0;
GList *workspace_list = NULL;
extern CORBA_Environment ev;


/* typedefs... */
typedef struct _workspace_entry workspace_entry;
struct _workspace_entry
  {
    GtkWidget *socket;
    CORBA_Object *cco;
    gboolean alive;
  };
typedef struct _timer_entry timer_entry;
struct _timer_entry
  {
    /* we don't use nd->socket; b/c it can change, and we want one per timer_entry */
    GtkWidget *socket;
    gint count;
    guint timer_id;
  };
/* prototypes */
void try_button_callback (GtkWidget * widget, gpointer data);
void revert_button_callback (GtkWidget * widget, gpointer data);
void ok_button_callback (GtkWidget * widget, gpointer data);
void cancel_button_callback (GtkWidget * widget, gpointer data);
void help_button_callback (GtkWidget * widget, gpointer data);
void close_workspace (gboolean show_splash, gpointer data);
static void exec_workspace (node_data * data);
static void shutdown_workspace (node_data * nd);
static void workspace_close_callback (GtkWidget * widget, gpointer data);
static void workspace_close_callback2 (GtkWidget * widget, gpointer data);
node_data *
find_node_by_id (gint id)
{
  GList *test;

  for (test = workspace_list; test; test = test->next)
    if (((node_data *) test->data)->id == id)
      return (node_data *) test->data;
  return NULL;

}
static void
exec_workspace (node_data * data)
{
  gchar *temp;
  gint i, mid;
  gchar *argv[5];
  GList *list;

  mid = get_current_mid ();
  
  
  /* is the silly thing a multi-workspace */
  for (i = 1; data->gde->exec[i]; i++)
    {
      if (strstr (data->gde->exec[i], "--ws-id="))
	{
	  for (list = workspace_list; list; list = list->next)
	    {
	      if (strcmp (((node_data *) list->data)->gde->exec[0], data->gde->exec[0]) == 0)
		{
		  /* do multi-workspace stuff... */
		  data->workspace = CORBA_Object_duplicate (((node_data *) list->data)->workspace, &ev);
		  workspace_list = g_list_prepend (workspace_list, data);
                  
		  DND_workspace_new_multi_workspace (data->workspace,
					     ((node_data *) list->data)->id,
						     data->id,
				  GDK_WINDOW_XWINDOW (data->socket->window),
					      atoi (data->gde->exec[i] + 9),
						     mid,
						     &ev);
		  data->state = WORKSPACE_ACTIVE;
		  return;
		}
	    }
	}
    }


  /* set up the arguments for the workspace */
  temp = g_malloc (sizeof (char[11]));
  sprintf (temp, "--id=");
  sprintf (temp + 5, "%d", data->id);
  argv[0] = temp;

  temp = g_malloc (sizeof (char[17]));
  sprintf (temp, "--xid=");
  sprintf (temp + 6, "%d", GDK_WINDOW_XWINDOW (data->socket->window));
  argv[1] = temp;

  temp = g_malloc (sizeof (char[17]));
  sprintf (temp, "--mid=");
  sprintf (temp + 6, "%d", mid);
  argv[2] = temp;

  temp = g_new0 (char, strlen (ior) + 7);
  sprintf (temp, "--ior=");
  sprintf (temp + 6, "%s", ior);
  argv[3] = temp;

  argv[4] = NULL;

  /*argv[3] = "--gtk-module=gle"; */
  workspace_list = g_list_prepend (workspace_list, data);
/*        g_print ("\ngdb %s\nb main\nr %s %s\n", data->gde->exec[0], argv[0], argv[1]); */

  gnome_desktop_entry_launch_with_args (data->gde, 4, argv);
  data->state = WORKSPACE_UNREGISTERED;
  g_free (argv[0]);
  g_free (argv[1]);
  g_free (argv[2]);

}
void
launch_workspace (node_data * data, gboolean exec_new)
{
  GtkWidget *vbox;
  GtkWidget *separator;
  GtkWidget *bbox;
  GtkWidget *frame;
  GList *temp;
  gint page;
  gboolean show_splash = TRUE;

  /* If the page has not been changed, nuke it, or tell it to hide itself */
  if ((current_page > 0) && (data->gde->exec_length))
    {
      page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
      for (temp = workspace_list; temp; temp = temp->next)
	if (temp->data && ((node_data *) temp->data)->notetab_id == page)
	  {
	    if (((node_data *) temp->data)->id == data->id)
	      {
		return;
	      }
	    else if (((node_data *) temp->data)->modified == FALSE)
	      {
		show_splash = FALSE;
		if (((node_data *) temp->data)->workspace)
		  {
		    DND_workspace_cancel (((node_data *) temp->data)->workspace,
					  ((node_data *) temp->data)->id,
					  &ev);
		    ((node_data *) temp->data)->workspace = NULL;
		  }
		close_workspace (show_splash, (node_data *) temp->data);
	      }
	    else
	      {
		DND_workspace_page_hidden (((node_data *) temp->data)->workspace,
					   ((node_data *) temp->data)->id,
					   &ev);
	      }
	    break;
	  }
    }
  /* set up the notebook if needed */
  /* This workspace has not been started yet.  We need to do that. */
  if ((data->id == -1) && (data->gde->exec_length))
    {
      if (notebook == NULL)
	{
	  notebook = gtk_notebook_new ();
	  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), FALSE);
	  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
	  /* show we only want to remove the splashscreen if it's showing */
	  if (show_splash)
	    {
	      gtk_widget_ref (splash_screen);
	      gtk_container_remove (GTK_CONTAINER (container), splash_screen);
	    }
	  gtk_container_add (GTK_CONTAINER (container), notebook);
	  gtk_widget_show (notebook);
	}

      vbox = gtk_vbox_new (FALSE, 0);
      data->socket = gtk_socket_new ();
      gtk_signal_connect (GTK_OBJECT (data->socket), "destroy", workspace_close_callback, data);
      separator = gtk_hseparator_new ();
      bbox = gtk_hbutton_box_new ();
      gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_SPREAD);
      gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 5);
      gtk_button_box_set_child_size (GTK_BUTTON_BOX (bbox), 5, -1);
      gtk_container_set_border_width (GTK_CONTAINER (bbox), 5);
      /*
      data->try_button = gtk_button_new_with_label (_ ("Try"));
      gtk_widget_set_sensitive (data->try_button, FALSE);
      gtk_container_add (GTK_CONTAINER (bbox), data->try_button);
      gtk_signal_connect (GTK_OBJECT (data->try_button), "clicked", GTK_SIGNAL_FUNC (try_button_callback), data);

      data->revert_button = gtk_button_new_with_label (_ ("Revert"));
      gtk_widget_set_sensitive (data->revert_button, FALSE);
      gtk_container_add (GTK_CONTAINER (bbox), data->revert_button);
      gtk_signal_connect (GTK_OBJECT (data->revert_button), "clicked", GTK_SIGNAL_FUNC (revert_button_callback), data);
      */
      data->ok_button = gtk_button_new_with_label (_ ("OK"));
      gtk_widget_set_sensitive (data->ok_button, FALSE);
      gtk_container_add (GTK_CONTAINER (bbox), data->ok_button);
      gtk_signal_connect (GTK_OBJECT (data->ok_button), "clicked", GTK_SIGNAL_FUNC (ok_button_callback), data);

      data->cancel_button = gtk_button_new_with_label (_ ("Cancel"));
      gtk_container_add (GTK_CONTAINER (bbox), data->cancel_button);
      gtk_signal_connect (GTK_OBJECT (data->cancel_button), "clicked", GTK_SIGNAL_FUNC (cancel_button_callback), data);
      data->help_button = gtk_button_new_with_label (_ ("Help"));
      gtk_container_add (GTK_CONTAINER (bbox), data->help_button);
      gtk_signal_connect (GTK_OBJECT (data->help_button), "clicked", GTK_SIGNAL_FUNC (help_button_callback), data);

      /* put it all together */
      frame = gtk_frame_new (NULL);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);
      gtk_container_set_border_width (GTK_CONTAINER (frame), GNOME_PAD_SMALL);
      gtk_container_add (GTK_CONTAINER (frame), data->socket);
      gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
      gtk_box_pack_end (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (vbox), separator, FALSE, FALSE, GNOME_PAD_SMALL);

      /* this is in case we ever go back to tabs:
       * We want to keep tabs on this so we can change the text. */
      data->label = gtk_label_new (data->gde->name);
      gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, data->label);
      gtk_widget_show_all (vbox);
      data->notetab_id = current_page++;
      data->id = id++;

      if (exec_new)
	{
	  exec_workspace (data);
	}
      else
	{
	  workspace_list = g_list_prepend (workspace_list, data);
	  gtk_ctree_select (data->ctree, data->node);
	}
    }
  if (data->notetab_id != -1)
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), data->notetab_id);
      if (data->workspace && exec_new)
	{
	  DND_workspace_page_shown (data->workspace,
				    data->id,
				    &ev);
	}
      gtk_ctree_select (data->ctree, data->node);
    }
}


void 
try_button_callback (GtkWidget * widget, gpointer data)
{
  node_data *nd = (node_data *) data;
  if (!nd->workspace)
    return;
  //  gtk_widget_set_sensitive (nd->try_button, FALSE);
  DND_workspace_try (nd->workspace, nd->id, &ev);
}
void 
revert_button_callback (GtkWidget * widget, gpointer data)
{
  node_data *nd = (node_data *) data;
  if (!nd->workspace)
    return;
  DND_workspace_revert (nd->workspace, nd->id, &ev);
  //  gtk_widget_set_sensitive (nd->try_button, FALSE);
  //  gtk_widget_set_sensitive (nd->revert_button, FALSE);
}
void 
ok_button_callback (GtkWidget * widget, gpointer data)
{
  GtkStyle *style;
  node_data *nd = (node_data *) data;
  style = gtk_widget_get_style (GTK_WIDGET (nd->ctree));

  if (nd->workspace)
    DND_workspace_ok (nd->workspace, nd->id, &ev);
  close_workspace (TRUE, data);
  gtk_ctree_node_set_foreground (nd->ctree, nd->node, &style->fg[GTK_STATE_NORMAL]);
}
void 
cancel_button_callback (GtkWidget * widget, gpointer data)
{
  GtkStyle *style;
  node_data *nd = (node_data *) data;
  style = gtk_widget_get_style (GTK_WIDGET (nd->ctree));

  if (nd->workspace)
    DND_workspace_cancel (nd->workspace, nd->id, &ev);
  close_workspace (TRUE, data);
  gtk_ctree_node_set_foreground (nd->ctree, nd->node, &style->fg[GTK_STATE_NORMAL]);
}
static void
workspace_close_callback (GtkWidget * widget, gpointer data)
{
  /* This function tries to clean up correctly. */
  /* If a workspace dies, it will (try to) shut it down gracefully... */
  /* It assumes that the workspace was not reparented already */
  node_data *nd = (node_data *) data;
  GtkStyle *style;

  if (nd->socket != NULL)
    {
      nd->socket = NULL;
      close_workspace (TRUE, nd);
      nd->state = WORKSPACE_INACTIVE;
      style = gtk_widget_get_style (GTK_WIDGET (nd->ctree));
      gtk_ctree_node_set_foreground (nd->ctree, nd->node, &style->fg[GTK_STATE_NORMAL]);
    }
}
static void
workspace_close_callback2 (GtkWidget * widget, gpointer data)
{
  /* This function tries to clean up correctly as well. */
  /* it has less to clean up though. */
  /* it needs to stop the timer callback. */
  timer_entry *te = (timer_entry *) data;
  if (te->timer_id)
    gtk_timeout_remove (te->timer_id);
  g_free (te);
}
static gint
timer_callback (gpointer data)
{
  timer_entry *te = (timer_entry *) data;

  /* I don't know if this can happen, but just to be absolutely
   * safe, we test it. */
  if ((GTK_SOCKET (te->socket)->plug_window != NULL)
      || te->count == 0)
    {
      gtk_widget_destroy (te->socket);
      te->timer_id = 0;
      /* workspace_close_callback2 will handle freeing te */
      return 0;
    }
  te->count--;
  return 1;
}
static void
queue_socket_destruction (node_data * nd)
{
  timer_entry *te;

  te = g_new (timer_entry, 1);
  te->socket = nd->socket;
  te->count = 15;
  te->timer_id = gtk_timeout_add (2000, timer_callback, te);
  gtk_widget_reparent (nd->socket, hack_widget);
  gtk_signal_disconnect_by_data (GTK_OBJECT (nd->socket),
				 nd);
  gtk_signal_connect (GTK_OBJECT (nd->socket), "destroy", workspace_close_callback2, te);
}
static void
shutdown_workspace (node_data * nd)
{
  GList *temp;

  if (nd->state == WORKSPACE_ACTIVE &&
      nd->socket && GTK_SOCKET (nd->socket)->plug_window == NULL)
    {
      /* Uh oh... We are shutting down a workspace that hasn't realized
       * yet.  We need to reparent the socket; hide it, and, when it's
       * realized, have it go away. */
      /* To do this, we reparent the socket and hide it.
       * When the plug dies, so goes the socket */
      queue_socket_destruction (nd);
    }
  nd->socket = NULL;
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), nd->notetab_id);
  nd->id = -1;
  nd->modified = FALSE;
  nd->state = WORKSPACE_INACTIVE;
  workspace_list = g_list_remove (workspace_list, nd);
  if (nd->workspace)
    {
      CORBA_Object_release (nd->workspace, &ev);
      nd->workspace = NULL;
    }
  for (temp = workspace_list; temp; temp = temp->next)
    if (((node_data *) temp->data)->notetab_id > nd->notetab_id)
      ((node_data *) temp->data)->notetab_id -= 1;

  nd->notetab_id = -1;
}
/* If show_splash is true, then that means that we want to handle whatever is underneath
 * (ie. putting the splashscreen back, changing the selected node etc. )
 * Otherwise we ignore what's underneath (ie. we're about to launch another one.) */
void
close_workspace (gboolean show_splash, gpointer data)
{
  node_data *nd = (node_data *) data;
  GList *temp;

  shutdown_workspace (nd);
  if (--current_page == 0)
    {
      gtk_container_remove (GTK_CONTAINER (container), notebook);
      notebook = NULL;
      if (show_splash)
	{
	  /* if we are only temporarily removing it, we don't show a splash. */
	  gtk_container_add (GTK_CONTAINER (container), splash_screen);
	  gtk_widget_unref (splash_screen);
	}
    }
  else if (show_splash)
    {
      /* we need to find the current page, and highlight it. */
      gint page;

      page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
      for (temp = workspace_list; temp; temp = temp->next)
	if (((node_data *) temp->data)->notetab_id == page)
	  {
	    GtkCTreeNode *ctnode;
	    gtk_ctree_select (((node_data *) temp->data)->ctree,
			      ((node_data *) temp->data)->node);
	    for (ctnode = ((node_data *) temp->data)->node;
		 ctnode; ctnode = GTK_CTREE_ROW (ctnode)->parent)
	      {
		gtk_ctree_expand (((node_data *) temp->data)->ctree,
				  ((node_data *) temp->data)->node);
	      }
	    DND_workspace_page_shown (((node_data *) temp->data)->workspace,
				      ((node_data *) temp->data)->id,
				      &ev);

	  }
    }
}
void 
help_button_callback (GtkWidget * widget, gpointer data)
{
  node_data *nd = (node_data *) data;
  DND_workspace_help (nd->workspace, nd->id, &ev);
}
