/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
#include "workspace-widget-libs.h"
#include <libgnorba/gnorba.h>
#include <orb/orbit.h>

static CORBA_ORB orb;
static CORBA_Environment ev;
static DND_workspace workspace = NULL;
static DND_browser browser;
static gchar* cc_ior = NULL;
static gint id = -1;
static guint xid = 0;
static gint mid = -1;
static gint wsid = -1;
static GList *id_list = NULL;
static gint ws_session_init = 0;
static gint ws_ignore = 0;
/* structs */
typedef struct _keyval keyval;
struct _keyval
{
        gint wsid;
        guint32 xid;
        gint id;
        gint mid;
};

/* prototypes... */
static void orb_add_connection(GIOPConnection *cnx);
static void orb_remove_connection(GIOPConnection *cnx);
static void orb_handle_connection(GIOPConnection *cnx, gint source, GdkInputCondition cond);
static void server_try (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_revert (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_ok (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_cancel (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_help (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_new_multi_workspace(DND_workspace _obj, CORBA_long id, CORBA_long newid, CORBA_unsigned_long newxid, CORBA_long newwsid, CORBA_long newmid, CORBA_Environment * ev);
static void server_page_hidden (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
static void server_page_shown (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev);
extern void _workspace_widget_server_try(gint id);
extern void _workspace_widget_server_revert(gint id);
extern void _workspace_widget_server_ok(gint id);
extern void _workspace_widget_server_cancel(gint id);
extern void _workspace_widget_server_help(gint id);
extern void _workspace_widget_server_new_multi_workspace(gint id, gint wsid);
extern void _workspace_widget_server_page_hidden(gint id);
extern void _workspace_widget_server_page_shown(gint id);

static struct poptOption ws_options[] = {
        {"id", '\0', POPT_ARG_INT, &id, 0, N_("id of the workspace -- assigned by the DND browser"), "ID"},
        {"ws-id", '\0', POPT_ARG_INT, &wsid, 0, N_("Multi-workspace id."), "WSID"},
        {"xid", '\0', POPT_ARG_INT, &xid, 0, N_("X ID of the socket it's plugged into"), "XID"},
        {"mid", '\0', POPT_ARG_INT, &mid, 0, N_("ID of the Molecule it's plugged into"), "MID"},
        {"ior", '\0', POPT_ARG_STRING, &cc_ior, 0, N_("IOR of the DND browser"), "IOR"},
        {"init-session-settings", '\0', POPT_ARG_NONE, &ws_session_init, 0, N_("Initialize session settings"), NULL},
        {"ignore", '\0', POPT_ARG_NONE, &ws_ignore, 0, N_("Ignore default action.  Used for custom init-session cases"), NULL},
        {NULL, '\0', 0, NULL, 0}
};


/* ORB stuff... */
PortableServer_ServantBase__epv base_epv = {
        NULL,
        NULL,
        NULL
};
POA_DND_workspace__epv workspace_epv = 
{  
        NULL,
        (gpointer)&server_try, 
        (gpointer)&server_revert,
        (gpointer)&server_ok,
        (gpointer)&server_cancel,
        (gpointer)&server_help,
        (gpointer)&server_new_multi_workspace,
        (gpointer)&server_page_hidden,
        (gpointer)&server_page_shown
};
POA_DND_workspace__vepv poa_workspace_vepv = { &base_epv, &workspace_epv };
POA_DND_workspace poa_workspace_servant = { NULL, &poa_workspace_vepv };

static void
orb_add_connection(GIOPConnection *cnx)
{
         cnx->user_data = (gpointer)gtk_input_add_full(GIOP_CONNECTION_GET_FD(cnx),
                                                       GDK_INPUT_READ|GDK_INPUT_EXCEPTION,
                                                       (GdkInputFunction)orb_handle_connection,
                                                       NULL, cnx, NULL);
}

static void
orb_remove_connection(GIOPConnection *cnx)
{
        gtk_input_remove((guint)cnx->user_data);
        cnx->user_data = (gpointer)-1;
}
static void
orb_handle_connection(GIOPConnection *cnx, gint source, GdkInputCondition cond)
{
        switch(cond) {
        case GDK_INPUT_EXCEPTION:
                giop_main_handle_connection_exception(cnx);
                break;
        default:
                giop_main_handle_connection(cnx);
        }
}

static void
server_try (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_try (id);
}
static void
server_revert (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_revert (id);
}
static void
server_ok (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_ok (id);
}
static void
server_cancel (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_cancel (id);
}
static void
server_help (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_help (id);
}
static void
server_page_hidden (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_page_hidden (id);
}
static void
server_page_shown (PortableServer_Servant servant, CORBA_long id, CORBA_Environment * ev)
{
        _workspace_widget_server_page_shown (id);
}
static void
server_new_multi_workspace(DND_workspace _obj, CORBA_long id,
                           CORBA_long newid, CORBA_unsigned_long newxid,
                           CORBA_long newwsid, CORBA_long newmid,
                           CORBA_Environment * ev)
{
        GList *temp;
        keyval *nkv;
        for (temp = id_list; temp; temp = temp->next)
                if (((keyval *)temp->data)->wsid == wsid) {
                        ((keyval *)temp->data)->xid = xid;
                        ((keyval *)temp->data)->id = newid;
                        ((keyval *)temp->data)->mid = newmid;
                        _workspace_widget_server_new_multi_workspace (id, wsid);
                        return;
                };
        nkv = g_malloc (sizeof (nkv));
        nkv->wsid = newwsid;
        nkv->id = newid;
        nkv->xid = newxid;
        nkv->mid = newmid;
        id_list = g_list_prepend (id_list, nkv);
        _workspace_widget_server_new_multi_workspace (id, newwsid);
}

/* public methods... */
void
workspace_corba_gtk_main (void)
{
        if (!orb) {
                g_warning ("Corba must be initialized before gtk_main can be called\n");
                exit (1);
        }
        gtk_main();
}
void
workspace_corba_gtk_main_quit (void)
{
        CORBA_Object_release (browser, &ev);
        CORBA_ORB_shutdown(orb, CORBA_FALSE, &ev);
        gtk_main_quit();
}
void
workspace_corba_state_changed (gint id, gboolean undoable)
{
        DND_browser_state_changed(browser, id, undoable, &ev);
}
guint32
get_xid (gint cid)
{
        GList *temp;
        if ((cid == -1) || (cid == wsid))
                return xid;

        for (temp = id_list; temp; temp = temp->next)
                if (((keyval *)temp->data)->wsid == cid)
                        return ((keyval *)temp->data)->xid;
        g_warning ("received an unknown cid: %d\n", cid);
        return 0;
}
gint get_ccid (gint cid)
{
        GList *temp;
        if ((cid == -1) || (cid == wsid)) {
                return id;
        }
        for (temp = id_list; temp; temp = temp->next)
                if (((keyval *)temp->data)->wsid == cid) {
                        return ((keyval *)temp->data)->id;
                }
        g_warning ("received an unknown cid: %d\n", cid);
        return id;
}

gint session_initialization_requested_p(void)
{
        return ws_session_init;
}

gint session_ignore_requested_p(void)
{
        return ws_ignore;
}

gint get_wsid ()
{
        return wsid;
}

gint get_mid ()
{
        return mid;
}

void *workspace_widget_corba_init(const char *app_id,
                               const char *app_version,
                               int *argc, char **argv,
                               struct poptOption *options,
                               unsigned int flags,
                               poptContext *return_ctx)
{
        GoadServerList *gsdlist = NULL;
        PortableServer_ObjectId objid = {0, sizeof("workspace_interface"), "workspace_interface"};
        PortableServer_POA poa;
        guint tempxid;
        gint tempid;
        gchar *name;

        CORBA_exception_init(&ev);

        gnomelib_register_popt_table(ws_options, "workspace options");

        orb = gnome_CORBA_init_with_popt_table (app_id, app_version,
                                                argc, argv, options, flags,
                                                return_ctx, GNORBA_INIT_SERVER_FUNC, &ev);
        /* hmmm... will we ever want to init with CORBA at some point? */
        if(ws_session_init)
                return NULL;

        /* sanity check */
        if (!orb) {
                g_warning ("unable to connect to the server.\nexitting...\n");
                exit (1);
        }

        /* setup CORBA fully */
        POA_DND_workspace__init(&poa_workspace_servant, &ev);
        poa = CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
        PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(poa, &ev), &ev);

        PortableServer_POA_activate_object_with_id(poa, 
                                                   &objid, &poa_workspace_servant, &ev);
        workspace = PortableServer_POA_servant_to_reference((PortableServer_POA)orb->root_poa, 
                                                      &poa_workspace_servant, &ev);
        if (!workspace) {
                g_warning ("We cannot connect to a browser\nexitting...\n");
                exit (1);
        }
        ORBit_custom_run_setup(orb, &ev);

        /*
        browser = goad_server_activate_with_repo_id (NULL,
                                                     "IDL:DND/browser:1.0",
                                                     0, NULL);
        */
        /* now we get the DND browser. */
        browser = CORBA_ORB_string_to_object(orb, cc_ior, &ev);
       
        if (! browser) {
                g_warning ("Unable reach the dnd.\nExiting...");
                exit (1);
        }
        g_print ("find DND_browser \n");
        
        if ((xid == 0) || (id == -1)) {
                name = strrchr (argv[0], '/');
                if (name)
                        name++;
                else
                        name = argv[0];
                DND_browser_register_workspace_new(browser,
                                                          workspace,
                                                          name,
                                                          wsid,
                                                          &xid,
                                                          &id,
                                                          &ev);
                /* if it's still 0, then the control-center doesn't wan't us */
                /* In theory, we should clean up after ourselves at this point */
                /* but I need to think a bit more about it. */
                /* Is there any time that we'd want to stay alive w/ CORBA and */
                /* not be a workspace??? */
                if ((xid == 0) || (id == -1))
                        return NULL;

        }
        
        if (DND_browser_register_workspace(browser, id, workspace, &ev) == -1)
                return NULL;
        g_print ("It was fine \n");
        
        /* we need to get the error value from gnome_CORBA_init */
        return (gpointer) orb;
}

void
get_molecule (Molecule **gmol)
{
        gchar * user_prefix;
        gchar fname[50];
        gint  nstr;
        FILE  * fd;
        Molecule *mol;
        
        DND_browser_get_molecule (browser, mid, &ev);

        user_prefix = gnome_util_home_file ("dnd.d");
        strcpy (fname, user_prefix);
        nstr = strlen (user_prefix);
        sprintf (fname+nstr, "/tempt%d", mid);

        mol = g_new0 (Molecule, 1);
        
        fd = fopen (fname, "rb");
        read_molecule (fd, mol);
        fclose (fd);
        *gmol = mol;
        
}

        
void
put_molecule (Molecule *mol, char *ffname, gboolean is_add)
{
           gchar * user_prefix;
           gchar fname[50];
           gint  nstr;
           FILE  * fd;
           
           g_return_if_fail (mol != NULL);
           
           g_print ("I'm in put_molecule \n");
           
           user_prefix = gnome_util_home_file ("dnd.d");
           strcpy (fname, user_prefix);
           nstr = strlen (user_prefix);
           sprintf (fname+nstr, "/tempt%d", mid);
   
           fd = fopen (fname, "wb");
           write_molecule (fd, mol);
           fclose (fd);
           
           DND_browser_put_molecule (browser, mid, ffname, is_add, &ev);
           g_print ("Finish put_molecule \n");
           
}

