/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
#include <gnome.h>
#include <orb/orbit.h>
#include "workspace-widget.h"
#include "workspace-widget-libs.h"
#include "dnd.h"

/* variables */
static GtkPlugClass *parent_class;
static GList *workspace_list = NULL;

enum {
        /*	TRY_SIGNAL,
                REVERT_SIGNAL, */
	OK_SIGNAL,
        CANCEL_SIGNAL,
        HELP_SIGNAL,
        NEW_MULTI_WORKSPACE,
        PAGE_HIDDEN_SIGNAL,
        PAGE_SHOWN_SIGNAL,
        LAST_SIGNAL
};
static int workspace_widget_signals[LAST_SIGNAL] = {0,0,0,0};

/* prototypes */ 
static void workspace_widget_class_init	(WorkspaceWidgetClass *klass);
static void workspace_widget_init		(WorkspaceWidget      *applet_widget);
static GtkWidget *get_widget_by_id(gint id);
void _workspace_widget_server_try(gint id);
void _workspace_widget_server_revert(gint id);
void _workspace_widget_server_ok(gint id);
void _workspace_widget_server_cancel(gint id);
void _workspace_widget_server_help(gint id);
void _workspace_widget_server_new_multi_workspace(gint id, gint wsid);
void _workspace_widget_server_page_hidden(gint id);
void _workspace_widget_server_page_shown(gint id);


/* administrative calls */
guint
workspace_widget_get_type (void)
{
        static guint workspace_widget_type = 0;
        
        if (!workspace_widget_type) {
                GtkTypeInfo workspace_widget_info = {
                        "WorkspaceWidget",
                        sizeof (WorkspaceWidget),
                        sizeof (WorkspaceWidgetClass),
                        (GtkClassInitFunc) workspace_widget_class_init,
                        (GtkObjectInitFunc) workspace_widget_init,
                        (GtkArgSetFunc) NULL,
                        (GtkArgGetFunc) NULL,
                };
                
                workspace_widget_type = gtk_type_unique (gtk_plug_get_type (),
                                                              &workspace_widget_info);
        }
        
        return workspace_widget_type;
}
static void
workspace_close_callback (GtkWidget *workspace)
{
        GList *temp;
        for (temp = workspace_list; temp; temp=temp->next)
                if (WORKSPACE_WIDGET (temp->data) == WORKSPACE_WIDGET (workspace)) {
                        workspace_list = g_list_remove_link (workspace_list, temp);
                        if (workspace_list == NULL) {
                                workspace_corba_gtk_main_quit ();
                        }
                }
}
static void
workspace_widget_class_init (WorkspaceWidgetClass *klass)
{
        GtkObjectClass *object_class;
	object_class = (GtkObjectClass*) klass;
	parent_class = gtk_type_class (gtk_plug_get_type ());
        /*
	workspace_widget_signals[TRY_SIGNAL] =
		gtk_signal_new("try",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 try),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);
	workspace_widget_signals[REVERT_SIGNAL] =
		gtk_signal_new("revert",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 revert),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0); */
  	workspace_widget_signals[OK_SIGNAL] =
		gtk_signal_new("ok",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 ok),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);
  	workspace_widget_signals[CANCEL_SIGNAL] =
		gtk_signal_new("cancel",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 cancel),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);
  	workspace_widget_signals[HELP_SIGNAL] =
		gtk_signal_new("help",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 help),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);
	workspace_widget_signals[NEW_MULTI_WORKSPACE] =
		gtk_signal_new("new_multi_workspace",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 new_multi_workspace),
                               gtk_marshal_NONE__POINTER,
                               GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  	workspace_widget_signals[PAGE_HIDDEN_SIGNAL] =
		gtk_signal_new("page_hidden",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 page_hidden),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);
  	workspace_widget_signals[PAGE_SHOWN_SIGNAL] =
		gtk_signal_new("page_shown",
			       GTK_RUN_LAST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(WorkspaceWidgetClass,
			       			 page_shown),
                               gtk_marshal_NONE__NONE,
                               GTK_TYPE_NONE, 0);

        gtk_object_class_add_signals (object_class, workspace_widget_signals, LAST_SIGNAL);
        /*
        klass->try = NULL;
        klass->revert = NULL; */
        klass->ok = NULL;
        klass->new_multi_workspace = NULL;
}
static void
workspace_widget_init (WorkspaceWidget *widget)
{
        workspace_list = g_list_prepend (workspace_list, widget);
        gtk_signal_connect (GTK_OBJECT (widget), "destroy",
                            (GtkSignalFunc) workspace_close_callback, NULL);
        widget->changed = FALSE;
}
GtkWidget *
workspace_widget_new ()
{
        WorkspaceWidget * retval;

        retval = WORKSPACE_WIDGET (gtk_type_new (workspace_widget_get_type()));
        /* we should set this: */
        retval->wsid = get_wsid ();

        retval->browser_id = get_ccid (retval->wsid);
        retval->mid = get_mid ();
        
        gtk_plug_construct (GTK_PLUG (retval), get_xid (retval->wsid));

        return GTK_WIDGET (retval);
}
GtkWidget *
workspace_widget_multi_new (gint wsid)
{
        WorkspaceWidget * retval;

        retval = WORKSPACE_WIDGET (gtk_type_new (workspace_widget_get_type()));
        retval->wsid = wsid;
        retval->browser_id = get_ccid (retval->wsid);
        retval->mid = get_mid ();
        
        gtk_plug_construct (GTK_PLUG (retval), get_xid (retval->wsid));
        
        return GTK_WIDGET (retval);
}
void
workspace_widget_state_changed(WorkspaceWidget *ws, gboolean undoable)
{
        g_print ("in workspace_widget_state_changed\n");
        if (ws->changed == FALSE) {
                g_print ("\tchanging state\n");
                workspace_corba_state_changed (ws->browser_id, undoable);
                ws->changed = TRUE;
        }
}
/* non widget calls */
void
workspace_gtk_main (void)
{
        workspace_corba_gtk_main();
}
gint
gnome_workspace_init (const char *app_id, const char *app_version,
                    int argc, char **argv, struct poptOption *options,
                    unsigned int flags, poptContext *return_ctx)
{
        gpointer orbptr;

        orbptr =
                workspace_widget_corba_init (app_id, app_version, &argc,
                                           argv, options, flags, return_ctx);

        if(orbptr)
                return 0;
        else if (session_initialization_requested_p ())
                return 1;
        else if (session_ignore_requested_p ())
                return 2;
        else
                return -1;
}

/* internal calls */
void
_workspace_widget_server_try(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        WORKSPACE_WIDGET (workspace)->changed = FALSE;
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"try");
}
void
_workspace_widget_server_revert(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        WORKSPACE_WIDGET (workspace)->changed = FALSE;
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"revert");
}
void
_workspace_widget_server_ok(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"ok");
}
void
_workspace_widget_server_cancel(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"cancel");
}
void
_workspace_widget_server_help(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"help");
}
void
_workspace_widget_server_new_multi_workspace(gint id, gint wsid)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"new_multi_workspace", workspace_widget_multi_new (wsid));
}
void
_workspace_widget_server_page_hidden(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"page_hidden");
}
void
_workspace_widget_server_page_shown(gint id)
{
        GtkWidget *workspace = get_widget_by_id (id);
        gtk_signal_emit_by_name(GTK_OBJECT (workspace) ,"page_shown");
}
static GtkWidget *
get_widget_by_id(gint id)
{
        GList *temp;
        for (temp = workspace_list; temp; temp=temp->next) 
                if (WORKSPACE_WIDGET (temp->data)->browser_id == id)
                        return GTK_WIDGET (temp->data);
        return NULL;
}
