/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
#ifndef __WORKSPACE_WIDGET_H__
#define __WORKSPACE_WIDGET_H__

#include <gtk/gtk.h>
#include <gnome.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define WORKSPACE_WIDGET(obj)          GTK_CHECK_CAST (obj, workspace_widget_get_type (), WorkspaceWidget)
#define WORKSPACE_WIDGET_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, control_center_widget_get_type (), ControlCenterWidgetClass)
#define IS_WORKSPACE_WIDGET(obj)       GTK_CHECK_TYPE (obj, workspace_widget_get_type ())

typedef struct _WorkspaceWidget		        WorkspaceWidget;
typedef struct _WorkspaceWidgetClass		WorkspaceWidgetClass;

struct _WorkspaceWidget
{
	GtkPlug			window;
	int			browser_id;
        int			wsid;
        gboolean 		changed;
        guint32			xid;
        gint                    mid; /* Molecule ID */
};

struct _WorkspaceWidgetClass
{
	GtkPlugClass 		parent_class;

        //   void (* try) 		(WorkspaceWidget *workspace);
        // void (* revert) 	(WorkspaceWidget *workspace);
        void (* ok) 		(WorkspaceWidget *workspace);
        void (* cancel)		(WorkspaceWidget *workspace);
        void (* help) 		(WorkspaceWidget *workspace);
        void (* new_multi_workspace) 	(WorkspaceWidget *workspace);
        void (* page_hidden)	(WorkspaceWidget *workspace);
        void (* page_shown)	(WorkspaceWidget *workspace);
};

guint           workspace_widget_get_type       	(void);
GtkWidget*      workspace_widget_new            	();
GtkWidget*      workspace_widget_multi_new       	(gint wsid);

        

void		workspace_gtk_main  		(void);
/* returns 0 upon successful initialization.
   returns 1 if --init-session-settings was passed on the cmdline
   returns 2 if --ignore was passed on the cmdline
   returns -1 upon error
*/
gint gnome_workspace_init (const char *app_id, const char *app_version,
                         int argc, char **argv, struct poptOption *options,
                         unsigned int flags, poptContext *return_ctx);
void 		workspace_widget_state_changed 	(WorkspaceWidget *ws, gboolean undoable);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __WORKSPACE_WIDGET_H__ */
