#include <gnome.h>
#include "workspace-widget.h"
#include "workspace-widget-libs.h"
#include "md.h"
#include "md-gui.h"

GSList *group = NULL;
GtkWidget *psf_entry = NULL, *pos_entry = NULL;

int  gtk_radio_menu_group_get_selected (GSList *radio_group);

enum {
  DND_PDB_FORMAT,
  DND_CRD_FORMAT,
  DND_NONE_FORMAT
};

static struct
{
  gchar *name;
  gint  file_format;
} format_item [] =
{
  { "PDB", DND_PDB_FORMAT},
  { "CRD", DND_CRD_FORMAT},
  { NULL, DND_NONE_FORMAT}
};

GtkWidget *
file_loader_workspace ()
{
  GtkWidget *vbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *omenu,* menu;
  gint i;
  
  vbox = gtk_vbox_new (FALSE, GNOME_PAD);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
  
  table = gtk_table_new (3, 2, FALSE);

  if (psf_entry == NULL)
    psf_entry = gtk_entry_new ();
  if (pos_entry == NULL)
    pos_entry = gtk_entry_new ();

  label = gtk_label_new ("PSF ");
  button = gtk_button_new_with_label ("Browse...");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (file_open_sel), psf_entry);
  gtk_table_attach (GTK_TABLE (table), label,  0, 1, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), psf_entry, 1, 2, 0, 1,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);

  omenu = gtk_option_menu_new ();
  menu       = gtk_menu_new ();

  for (group = NULL, i = 0; format_item[i].name; i++)
    {
      GtkWidget *menu_item;
      menu_item = gtk_radio_menu_item_new_with_label (group,
                                                      format_item[i].name);
      group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (menu_item));
      gtk_menu_append (GTK_MENU (menu), menu_item);
      gtk_widget_show (menu_item);
    }

  gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (omenu), 0);

  button = gtk_button_new_with_label ("Browse...");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (file_open_sel), pos_entry);
  gtk_table_attach (GTK_TABLE (table), omenu,  0, 1, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), pos_entry, 1, 2, 1, 2,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  
  return vbox;
  
}


void
file_loader_ok ()
{
  char *psf_name, *pos_name;
  Molecule *mol;
  gboolean ok = FALSE;
  char *fname;
  gint ig;
  
  psf_name = gtk_entry_get_text (GTK_ENTRY (psf_entry));
  pos_name = gtk_entry_get_text (GTK_ENTRY (pos_entry));
  
  g_print ("%s \n %s \n", psf_name, pos_name);
  
  mol = g_new0 (Molecule, 1);
    
  ok = read_psf (&mol, psf_name);

  g_print ("After read_psf , Boolean %d \n", ok);
  
  if (!ok)
    return;

  ig = gtk_radio_menu_group_get_selected (group);
  
  switch (format_item[ig].file_format)
    {
    case DND_PDB_FORMAT:
      ok = read_pdb (&mol, pos_name);
      break;
      
    case DND_CRD_FORMAT:
      ok = read_crd (&mol, pos_name);
      break;
    }
  
  g_print ("After read_pdb , Boolean %d \n", ok);

  fname = g_strdup ("Test");

  put_molecule (mol, fname, TRUE);

  gtk_main_quit ();
  
}


int
gtk_radio_menu_group_get_selected (GSList *radio_group)
{
  GSList *l;
  int i, c;

  g_return_val_if_fail (radio_group != NULL, 0);

  c = g_slist_length (radio_group);

  for (i = 0, l = radio_group; l; l = l->next, i++)
    {
      GtkRadioMenuItem *menu_item = l->data;
      
      if (GTK_CHECK_MENU_ITEM (menu_item)->active)
	return c - i - 1;
    }
  
  return 0;

}
