#include <gnome.h>
#include <sys/stat.h>
#include "workspace-widget.h"
#include "workspace-widget-libs.h"
#include "md-gui.h"

static void
set_ok (GtkWidget *widget, gboolean *dialog_result)
{
  *dialog_result = TRUE;
  gtk_main_quit ();
}


void 
file_open_sel (GtkWidget *widget, gpointer gdata)
{
  GtkFileSelection *fsel;
  gboolean accepted;
  static char *file_name = NULL;
  struct stat sb;
  
  accepted = FALSE;

  fsel = (GtkFileSelection *)gtk_file_selection_new ("Choose a file" );
  gtk_window_set_modal (GTK_WINDOW (fsel), TRUE);

  if (file_name != NULL && (stat (file_name, &sb) != -1))
    {
      if (S_ISDIR (sb.st_mode))
	{
	  char *nfile = g_new0 (char, strlen (file_name) + 3);
	  sprintf(nfile, "%s/.", file_name);
	  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fsel),
					   nfile);
	  g_free (nfile);
	}
      else
	{
	  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fsel),
					   file_name);
	}
      
    }
  
  gtk_signal_connect (GTK_OBJECT (fsel->ok_button ),
		      "clicked", GTK_SIGNAL_FUNC (set_ok), &accepted);
  
  gtk_signal_connect_object (GTK_OBJECT (fsel->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  
  gtk_window_set_position (GTK_WINDOW (fsel), GTK_WIN_POS_MOUSE);

  /* Run the dialog */
  gtk_widget_show (GTK_WIDGET (fsel));
  gtk_grab_add (GTK_WIDGET (fsel));
  gtk_main ();

  if (accepted)
    {
      gtk_entry_set_text (GTK_ENTRY (gdata),
			  gtk_file_selection_get_filename (fsel));

      if (file_name != NULL)
	g_free (file_name);
      
      file_name = g_strdup (gtk_file_selection_get_filename (fsel));
      
      workspace_widget_state_changed(WORKSPACE_WIDGET(workspace), TRUE);
    }
  
  gtk_widget_destroy (GTK_WIDGET (fsel));

}
