#include <gnome.h>
#include "workspace-widget.h"
#include "workspace-widget-libs.h"
#include "md-gui.h"
#include "md.h"

GtkWidget *rtf_entry, *prm_entry;
GtkWidget *box_x_entry;
GtkWidget *box_y_entry;
GtkWidget *box_z_entry;
GtkWidget *temp_entry;
static Molecule  *mol = NULL;


GtkWidget *
md_runner_workspace ()
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label, *button;
  char     tmp_str[20];
  
  mol = NULL;
  
  get_molecule (&mol);
  
  if (mol == NULL)
    {
      g_message ("md_workspace : Molecule is NULL");
      return NULL;
    }
  else
    {
      g_message (" md_workspace :"
		 "segment number : %d ", g_list_length (mol->seg_list));
      g_message (" md_workspace :"
		 "atom    number : %d ", g_list_length (mol->atom_list));
    }

  vbox = gtk_vbox_new (FALSE, GNOME_PAD);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD_SMALL);

  frame = gtk_frame_new (_("Input Data"));
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  
  table = gtk_table_new (3, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), GNOME_PAD_SMALL);
  gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
  gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_widget_show (table);

  label = gtk_label_new ("RTF :");
  rtf_entry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (rtf_entry), "/usr/local/share/dnd/top.inp");
  
  button = gtk_button_new_with_label ("Browse...");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (file_open_sel), rtf_entry);

  gtk_table_attach (GTK_TABLE (table), label,  0, 1, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), rtf_entry, 1, 2, 0, 1,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);

  label = gtk_label_new ("PARA:");
  prm_entry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (prm_entry), "/usr/local/share/dnd/par.inp");
  button = gtk_button_new_with_label ("Browse...");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (file_open_sel), prm_entry);

  gtk_table_attach (GTK_TABLE (table), label,  0, 1, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), prm_entry, 1, 2, 1, 2,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  
  /* --- TEMP --- */
  hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
  gtk_box_pack_start(GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new (_("Temperature :"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  temp_entry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (temp_entry), "300");
  gtk_box_pack_start (GTK_BOX (hbox), temp_entry, TRUE, TRUE, 0);
  gtk_widget_show(temp_entry);

  label = gtk_label_new (" T   ");
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  /* Box Size */
  frame = gtk_frame_new (_("Box Size"));
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  
  table = gtk_table_new (3, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), GNOME_PAD_SMALL);
  gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
  gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_widget_show (table);

  label = gtk_label_new ("BOX_X");
  gtk_table_attach (GTK_TABLE (table), label,  0, 1, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  label = gtk_label_new ("BOX_Y");
  gtk_table_attach (GTK_TABLE (table), label,  1, 2, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  label = gtk_label_new ("BOX_Z");
  gtk_table_attach (GTK_TABLE (table), label,  2, 3, 0, 1,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  
  box_x_entry = gtk_entry_new ();
  sprintf (tmp_str, "%f", mol->box.x);
  gtk_entry_set_text (GTK_ENTRY (box_x_entry), tmp_str);
  
  box_y_entry = gtk_entry_new ();
  sprintf (tmp_str, "%f", mol->box.y);
  gtk_entry_set_text (GTK_ENTRY (box_y_entry), tmp_str);

  box_z_entry = gtk_entry_new ();
  sprintf (tmp_str, "%f", mol->box.z);
  gtk_entry_set_text (GTK_ENTRY (box_z_entry), tmp_str);

  gtk_table_attach (GTK_TABLE (table), box_x_entry, 0, 1, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), box_y_entry, 1, 2, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);
  gtk_table_attach (GTK_TABLE (table), box_z_entry, 2, 3, 1, 2,
		    GTK_FILL|GTK_SHRINK, GTK_FILL|GTK_SHRINK, 0, 0);


  /* -- Run -- Cancel -- */
  hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
  gtk_box_pack_start(GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label ("Run");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (md_runner_ok), prm_entry);

  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);


  return vbox;
  
}


void
md_runner_ok ()
{
  char *rtf_fname, *prm_fname;
  char *buf;
  char *control_fname;
  FILE *control_file;
  double temp;

  rtf_fname = gtk_entry_get_text (GTK_ENTRY (rtf_entry));
  prm_fname = gtk_entry_get_text (GTK_ENTRY (prm_entry));
  
  buf = gtk_entry_get_text (GTK_ENTRY (temp_entry));
  sscanf (buf, "%lf", &temp);

  buf = gtk_entry_get_text (GTK_ENTRY (box_x_entry));
  sscanf (buf, "%lf", &mol->box.x);
  
  buf = gtk_entry_get_text (GTK_ENTRY (box_y_entry));
  sscanf (buf, "%lf", &mol->box.y);
  
  buf = gtk_entry_get_text (GTK_ENTRY (box_z_entry));
  sscanf (buf, "%lf", &mol->box.z);

  g_message (" rtf file name : %s ", rtf_fname);
  g_message (" prm file name : %s ", prm_fname);
  g_message (" temp : %f ", temp);
  
  control_fname = g_strdup ("md-control.inp");
  
  control_file = fopen (control_fname, "wt");
  
  fprintf (control_file, "rtf-fname=%s \n", rtf_fname);
  fprintf (control_file, "prm-fname=%s \n", prm_fname);
  fprintf (control_file, "temperature=%f \n", temp);
  fprintf (control_file, "box-x=%f \n", mol->box.x);
  fprintf (control_file, "box-y=%f \n", mol->box.y);
  fprintf (control_file, "box-z=%f \n", mol->box.z);
  
  fclose (control_file);
  
  g_free (rtf_fname);
  g_free (prm_fname);
  g_free (buf);
  
  md_main (mol, control_fname);
 
}
