#include <gnome.h>
#include "workspace-widget.h"
#include "workspace-widget-libs.h"
#include "md-gui.h"


static void
md_workspace_ok ()
{
  switch (WORKSPACE_WIDGET (workspace)->wsid)
    {
    case 0: /* File Loader */
      file_loader_ok ();
      break;
    case 1: /* Builder */
      // builder_ok ();
      break;
    case 2:
      md_runner_ok ();
      break;
    }
  
}

void
workspace_setup (GtkWidget *old, GtkWidget *ws)
{
  GtkWidget *main_box;
  
  workspace = ws;
  
  gtk_signal_connect (GTK_OBJECT (ws), "new_multi_workspace",
		      GTK_SIGNAL_FUNC (workspace_setup), NULL);
  gtk_widget_set_usize (ws, 200, 275);

  switch (WORKSPACE_WIDGET (ws)->wsid)
    {
    default:
    case -1:
    case 0 : /* File Loader */
      main_box = file_loader_workspace ();
      break;
    case 1 : /* Builder */
      //      main_box = builder_workspace ();
      break;
    case 2 :  /* MD workspace */
      main_box = md_runner_workspace ();
      break;
    }
  
  gtk_container_add (GTK_CONTAINER (ws), main_box);
  gtk_widget_show_all (ws);
  
  gtk_signal_connect (GTK_OBJECT (ws), "ok",
		      GTK_SIGNAL_FUNC (md_workspace_ok), NULL);
  
}


