#ifndef _DND_DEFS_H
#define _DND_DEFS_H

#define ALPHAMIN	1e-7
/* Fundamental constants '_' denotes MKS units.  SHOULD NEVER BE ALTERED      */
#ifdef OLDCONSTS
#define	_kB		1.380662e-23     /*  (J/K = (kg * (m/s)^2)/K) */
#define _kcal		4184.0           /* 1 kcal = 4184 J */ 
#define	_EPS0		8.85418782e-12
#define	_ELCHG		1.6021892e-19
#define ECSTR           "1.6021892e-19"
#define	_ROOT_4_PI_EPS	1.0548222865e-5
#define AVOGAD		6.022045e23
#define AMU		1.6605655e-27    /*  (Kg) */
#define AMUSTR          "1.6605655e-27"
#define RTAMU           4.0745e-14		/*sqrt(amu) */
#else
/* Values from CODATA 1986 */
#define	_kB		1.380658e-23
#define _kcal		4184.0
#define	_EPS0		8.854187817e-12
#define	_ELCHG		1.60217733e-19
#define ECSTR           "1.60217733e-19"
#define	_ROOT_4_PI_EPS	1.05482230112e-05
#define AVOGAD		6.0221367e23
#define AMU		1.6605402e-27
#define AMUSTR          "1.6605402e-27"
#define RTAMU           4.07497263794495e-14	/*sqrt(amu) */
#endif
#define RGAS		(AVOGAD*_kB)
/* Program units relative to MKS units ONLY M, L, T, Q UNIT SHOULD BE CHANGED */
#define MUNIT		AMU			/* atomic mass units  */
#define	LUNIT		1.0e-10			/* Angstrom	      */
#define	TUNIT		1.0e-12			/* Picosecond	      */
#define	EUNIT		(MUNIT * (LUNIT/TUNIT) * (LUNIT/TUNIT))
#define	QUNIT		/*sqrt(EUNIT*LUNIT)*/ (RTAMU*1.e-3*_ROOT_4_PI_EPS)
#define MUNIT_N		"amu"
#define LUNIT_N		"A"
#define RLUNIT_N	"A(-1)"
#define	TUNIT_N		"ps"
#define	IUNIT_N		"amuA**2"
#define DIPUNIT_N	"Prog units"
/* Constants in program units				  */
#define	kB		(_kB / EUNIT)
#define EPS0		(0.25 / PI)
/* Output conversion units */
#define	CONV_E		(0.001*AVOGAD*EUNIT)		/* kJ/mol     */
#define	CONV_T		(kB / CONV_E)			/* kB / E unit*/
#define	CONV_P		(MUNIT/(LUNIT*TUNIT*TUNIT)/1.0e6) /* MPa      */
#define	CONV_V		CONV_E
#define	CONV_F		(MUNIT*LUNIT/(TUNIT*TUNIT)*sqrt(AVOGAD)) /* N/mol   */
#define	CONV_N		(CONV_F*LUNIT)				/* Nm/mol   */
#define	CONV_D		(QUNIT*LUNIT*4.8e10/_ELCHG)
#define CONV_Q		(QUNIT/_ELCHG)
#define CONV_TM		0.01
#define	CONV_E_N	"kJ/mol"
#define	CONV_T_N	"K"
#define	CONV_P_N	"MPa"
#define	CONV_F_N	"N**2/mol"
#define	CONV_N_N	"(Nm)**2/mol"
#define	CONV_D_N	"D"
#define CONV_Q_N	"Qe"
#define CONV_TM_N	"kJ/mol*ps**2"


#endif /* _DND_DEFS_H */
