#include <math.h>
#include <glib.h>
#include "md.h"
#include "cell.h"
#include "param.h"

extern VerletList *verlet_list;  /* from cell.c */


void
force (gboolean need_verlet_list_init)
{
  int i, j, iv;
  double drx, dry, drz;
  double r2, r2i, r6i;
  /* [FIXME] */
  double  r_cutsq = (5.0 * 5.0);
  FILE *fd;
  
  
  if (need_verlet_list_init)
    {
      verlet_list_new ();
    }
  
  for (i = 0; i < natoms; i++)
    {
      fr[i].x = 0.0;
      fr[i].y = 0.0;
      fr[i].z = 0.0;
    }
  
  Upot = 0.0;
  press = 0.0;

  fd = fopen ("verlet_test", "wt");
  
  for (i = 0; i < natoms - 1; i++)
    {
      for (iv = 0; iv < verlet_list[i].n; iv++)
	{
	  j = verlet_list[i].list[iv];
	  
	  drx = r[i]->x - r[j]->x;
	  dry = r[i]->y - r[j]->y;
	  drz = r[i]->z - r[j]->z;
	
	  if (drx > hbox_x)
	    drx -= control.box_x;
	  else if (drx < -hbox_x)
	    drx += control.box_x;
		  
	  if (dry > hbox_y)
	    dry -= control.box_y;
	  else if (dry < -hbox_y)
	    dry += control.box_y;

	  if (drz > hbox_z)
	    drz -= control.box_z;
	  else if (drz < -hbox_z)
	    drz += control.box_z;

	  r2 = drx * drx + dry * dry + drz * drz;
	
	  if (r2 < r_cutsq)
	    {
	      double ff;
	      int    ivt, jvt;
	      
	      r2i = 1.0/r2;
	      r6i = r2i * r2i * r2i;
	      
	      ivt = vdw_type[i];
	      jvt = vdw_type[j];
	      
	      Upot += (4.0 * r6i * (A[ivt][jvt] * r6i - 0.5 *B[ivt][jvt]) - e_cut);
	      ff = 48.0 * r6i * (A[ivt][jvt] * r6i - 0.25 * B[ivt][jvt]);
	      press += ff;
	      ff *= r2i;

	      fprintf (fd, " %5d %5d Upot = %f \n", i, j, Upot);
	      
	      fr[i].x += ff * drx;
	      fr[i].y += ff * dry;
	      fr[i].z += ff * drz;
	    
	      fr[j].x -= ff * drx;
	      fr[j].y -= ff * dry;
	      fr[j].z -= ff * drz;
	    }
	  if (Upot > 10)
	    {
	      g_print ("In Force : Error ...\n");
	      exit (1);
	    }
	  
	}
    }
  
  fclose (fd);
  
  press /= (3.0 * control.box_x * control.box_y * control.box_z);
  
}
