

void
force_inner (System *system, ForceInfo *force_i)
{
  Cell       *cell;
  CellLinked *linked_i, *linked_j;
  GList      *list, *nlist;    /* cell_list, neighbor_cell_list */
  GList      *list_i, *list_j;
  double      sig_ij, sig_i, sig_j;
  double      eps_ij, eps_i, eps_j;
  double      r_ij, r_2, r_6, r_12;
  vector3     *force;
  gint        atom_i, atom_j;
  
  force = force_i->force;
  
  for (list = system->cell_list; list; list = list->next)
    {
      cell = list->data;
      
      for (list_i = cell->linked_list; list_i; list_i = list_i->next)
	{
	  double force_ij;
	  
	  linked_i = list_i->data;
	  
	  sig_i = linked_i->atom->nonb->sig;
	  eps_i = linked_i->atom->nonb->eps;
	  atom_i = linked_i->atom->natom;
	  
	  for (list_j = list_i->next; list_j; list_j = list_j->next)
	    {
	      linked_j = list_j->data;
	      
	      sig_j = linked_j->atom->nonb->sig;
	      eps_j = linked_j->atom->nonb->eps;
	      atom_j = linked_j->atom->natom;
	      
	      sig_ij = 0.5 * (sig_i + sig_j);
	      eps_ij = sqrt (eps_i * eps_j);
	      
	      r_ij = v3_distance (linked_i->pos, linked_j->pos);
	      
	      r_2 = (sig_ij * sig_ij) / (r_ij * r_ij);
	      r_6 = r_2 * r_2 * r_2;
	      r_12 = r_6 * r_6;
	      
	      pot_ene += 4. * eps_ij * (r_12 - r_6);
	      
	      force_ij = 24. * eps_ij * r_ij * (r_12 - r_6);
	      force[atom_j] += force_ij;
	      force[atom_i] -= force_ij;
	      
	    }
	  
	}
    }

  
  for (list = system->cell_pair_list; list; list = list->next)
    {
      CellPair *cell_pair = list->data;
      Cell    *cell1 = cell_pair->cell1;
      Cell    *cell2 = cell_pair->cell2;
      gboolean is_mirror = cell_pair->is_mirror;
      
      for (list_i = cell1->linked_list; list_i; list_i = list_i->next)
	{
	  linked_i = list_i->data;

	  sig_i = linked_i->atom->nonb->sig;
	  eps_i = linked_i->atom->nonb->eps;   
	  atom_i = linked_i->atom->natom;
	  
	  for (list_j = cell2->linked_list; list_j ; list_j = list_j->next)
	    {
	      double force_ij;
	      
	      linked_j = list_j->data;
	      
	      sig_j = linked_j->atom->nonb->sig;
	      eps_j = linked_j->atom->nonb->eps;
	      atom_j = linked_j->atom->natom;
	      
	      sig_ij = 0.5 * (sig_i + sig_j);
	      eps_ij = sqrt (eps_i * eps_j);
	      
	      r_ij = v3_distance (linked_i->pos, linked_j->pos);
	      
	      r_2 = (sig_ij * sig_ij) / (r_ij * r_ij);
	      r_6 = r_2 * r_2 * r_2;
	      r_12 = r_6 * r_6;
	      
	      pot_ene += 4. * eps_ij * (r_12 - r_6);  

	      force_ij = 24. * eps_ij * r_ij * (r_12 - r_6);
	      force[atom_j] += force_ij;
	      force[atom_i] -= force_ij;
	    }
	}
      
    }
}



void
force_calc (MDData *data)
{
  Control *control;
  System  *system;
  double subcell;
  int    nx, ny, nz;
  int    ncell;
  
  cell_init (data);
  
  force_inner (data->system, data->force_info);
    
}

