#include <math.h>
#include "md.h"

#define  im  1771875L
#define  ia  2416L
#define  ic  374441L

static unsigned long jran = 1;
void    smdrand(unsigned long seed)
{
  jran = seed;
}


double  mdrand()
{
  jran = (jran*ia + ic) % im;
  return (double)jran/(double)im;
}


/*
  gauss_rand. Return a random variable from a gaussian distribution with uni 
  variance.  After Press, Plannery, Teulkolsk & Vetterling p202.             
*/
double
gauss_rand ()
{
  static int            set = 1;
  static double gset;
  double                v1, v2, r, fac;
  
  if(set)
    {
      do
        {
          v1 = 2.0*mdrand()-1.0;  v2 = 2.0*mdrand() - 1.0;
          r = v1*v1 + v2*v2;
        } while(r > 1.0);
      fac = sqrt(-2.0 * log(r) / r);
      gset = v1 * fac;
      set = 0;
      return(v2*fac);
    }
  else
    {
      set = 1;
      return(gset);
    }
}


