#include <math.h>
#include <glib.h>
#include "md.h"

static void 
verlet_velocity ();
static void
verlet_original ();

static double dt = -1;
static double dt_2 = -1;
static double dt2 = -1;
static double dt2_2 = -1;

inline void 
check_mirror (vector3 *rr)
{
  if (rr->x > hbox_x)
    rr->x -= control.box_x;
  else if (rr->x < -hbox_x)
    rr->x += control.box_x;

  if (rr->y > hbox_y)
    rr->y -= control.box_y;
  else if (rr->y < -hbox_y)
    rr->y += control.box_y;

  if (rr->z > hbox_z)
    rr->z -= control.box_z;
  else if (rr->y < -hbox_z)
    rr->z += control.box_z;
}


void
integrate (int step, vector3 *imp)
{
  double scale;
  /*  static vector3 *rn = NULL; */
  int i;
  
  if (ro == NULL)
      ro = g_new0 (vector3, natoms);

  if (dt < 0)
    {
      dt = control.step;
      dt_2 = 0.5 * dt;
      dt2 = dt * dt;
      dt2_2 = dt * dt_2;
    }

  verlet_velocity ();
  
  if ((step+1) % 10)
    {
      g_print (" Upot = %f \n", Upot);
    }
  
}


static void
verlet_original ()
{
  vector3 rn;
  double i2dt = 0.5 / dt; /* 1 / (2 * dt) */
  gint i;
  
  Ukin = 0.0;
  
  for (i = 0; i < natoms; i++)
    {
      rn.x = 2.0 * r[i]->x - ro[i].x + acc[i].x * dt2;
      rn.y = 2.0 * r[i]->y - ro[i].y + acc[i].y * dt2;
      rn.z = 2.0 * r[i]->z - ro[i].z + acc[i].z * dt2;
      
      vel[i].x = (rn.x - ro[i].x) * i2dt;
      vel[i].y = (rn.y - ro[i].y) * i2dt;
      vel[i].z = (rn.z - ro[i].z) * i2dt;
  
      Ukin += (vel[i].x * vel[i].x +
	       vel[i].y * vel[i].y + vel[i].z * vel[i].z);

      v3_eq (&ro[i], r[i]);
      v3_eq (r[i], &rn);
      
      //      check_mirror (r[i]);
      
    }
  
}

static void
verlet_velocity ()
{
  gboolean need_verlet_list_init = TRUE;
  gint i;
  
  for (i = 0; i < natoms; i++)
    {
      v3_eq (&ro[i], r[i]);
      
      r[i]->x += (vel[i].x * dt + acc[i].x * dt2_2);
      r[i]->y += (vel[i].x * dt + acc[i].y * dt2_2);
      r[i]->z += (vel[i].x * dt + acc[i].z * dt2_2);
      
      vel[i].x += dt_2 * acc[i].x;
      vel[i].y += dt_2 * acc[i].y;
      vel[i].z += dt_2 * acc[i].z;
    }


  rattle (ro, dt);

  /* Calculate Force and Energy */
  force (need_verlet_list_init);
  
  for (i = 0; i < natoms; i++)
    {
      acc[i].x = -fr[i].x / mass[i];
      acc[i].y = -fr[i].y / mass[i];
      acc[i].z = -fr[i].z / mass[i];
      
      vel[i].x += dt_2 * acc[i].x;
      vel[i].y += dt_2 * acc[i].y;
      vel[i].z += dt_2 * acc[i].z;
    }
  
  /* rattle2() */

  Ukin = 0.0;
  
  for (i = 0; i < natoms; i++)
    {
      Ukin += (vel[i].x * vel[i].x +
	       vel[i].y * vel[i].y + vel[i].z * vel[i].z);

      // check_mirror (r[i]);
    }
  
  Ukin *= 0.5;
  g_print ("Ukin = %f \n", Ukin);
  
}
