#include <stdio.h>
#include <glib.h>
#include "md.h"

extern gboolean read_psf (Molecule **gmol, char *fname);
extern gboolean read_pdb (Molecule **gmol, char *fname);

int
main (int argc, char **argv)
{
  Molecule *mol;
  gboolean ok;

  if (argc == 1)
    {
      g_print ("Usague : [Command] [PSF] [PDB] [CONTROL] \n");
      return 1;
    }
  
  mol = g_new0 (Molecule, 1);
  
  ok = read_psf (&mol, argv[1]);
  
  if (!ok)
    return 1;
  
  ok = read_crd (&mol, argv[2]);
  
  md_main (mol, argv[3]);
  
  return 0;
  
}
