#ifndef DND_MD_H
#define DND_MD_H

#include "vector3.h"
#include "molecule.h"


#define L_name 132

typedef struct _control MD_Control;
typedef struct _rattle  MD_Rattle;


struct _control
{
  char  title[L_name];
  int   nsteps;
  double   step;
  char  rtf_fname[L_name];
  char  prm_fname[L_name];
  double temp;
  double box_x;
  double box_y;
  double box_z;
};

struct _rattle
{
  int ia1; /* atom number */
  int ia2; /* atom number */
  double dist; /* distance */
};



MD_Control control;

/* Simple case */

double hbox_x, hbox_y, hbox_z;

double tstep, tstep2, i2tstep;
double r_cutsq, e_cut, press;
int   natoms, ninit, nstep;
MD_Rattle *rat;
int   nrat;

vector3 **r;   /* positions */
vector3 *ro;  /* old position */
vector3 *fr;
vector3 *vel; /* velocities */
vector3 *acc;
vector3 *m;
double  *mass;
double  *charge;
double  *vdw_type;

double Ukin, Upot, Utot;

int  md_main (Molecule *mol, char *control_fname);
gboolean md_read_control (char *fname);
gboolean md_init (Molecule *mol);
double gauss_rand ();
void   smdrand (unsigned long seed);
void force (gboolean need_verlet_list_init);
void md_loop ();
void integrate (int step, vector3 *imp);
void verlet_list_new ();   /* cell.c */

gboolean read_pdb (Molecule **gmol, char *fname);
gboolean read_crd (Molecule **gmol, char *fname);
gboolean read_psf (Molecule **gmol, char *fname);

#ifdef _MD__
/* Not Simple */
GSList * command_slist;

#endif


#endif
